/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.core.subscribers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.subscribers.ComparisonCriteria;
import org.eclipse.team.core.subscribers.ITeamResourceChangeListener;
import org.eclipse.team.core.subscribers.SyncInfo;
import org.eclipse.team.core.subscribers.TeamDelta;
import org.eclipse.team.core.sync.IRemoteResource;

public abstract class TeamSubscriber {
    private List listeners = new ArrayList(1);

    public abstract String getDescription();

    public abstract boolean isSupervised(IResource var1) throws TeamException;

    public abstract IResource[] members(IResource var1) throws TeamException;

    public abstract IResource[] roots();

    public abstract IRemoteResource getRemoteResource(IResource var1) throws TeamException;

    public abstract SyncInfo getSyncInfo(IResource var1, IProgressMonitor var2) throws TeamException;

    public abstract void refresh(IResource[] var1, int var2, IProgressMonitor var3) throws TeamException;

    public abstract ComparisonCriteria[] getComparisonCriterias();

    public abstract ComparisonCriteria getCurrentComparisonCriteria();

    public abstract void setCurrentComparisonCriteria(String var1) throws TeamException;

    public abstract boolean isThreeWay();

    public void addListener(ITeamResourceChangeListener listener) {
        List list = this.listeners;
        synchronized (list) {
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
        }
    }

    public void removeListener(ITeamResourceChangeListener listener) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    protected void fireTeamResourceChange(final TeamDelta[] deltas) {
        ITeamResourceChangeListener[] allListeners;
        List list = this.listeners;
        synchronized (list) {
            allListeners = this.listeners.toArray(new ITeamResourceChangeListener[this.listeners.size()]);
        }
        int i = 0;
        while (i < allListeners.length) {
            final ITeamResourceChangeListener listener = allListeners[i];
            Platform.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable exception) {
                }

                public void run() throws Exception {
                    listener.teamResourceChanged(deltas);
                }
            });
            ++i;
        }
    }

    public SyncInfo[] getAllOutOfSync(IResource[] resources, int depth, IProgressMonitor monitor) throws TeamException {
        return null;
    }
}

