/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.core.subscribers;

import org.eclipse.core.resources.IResource;
import org.eclipse.team.core.subscribers.TeamSubscriber;

public class TeamDelta {
    public static final int NO_CHANGE = 0;
    public static final int SYNC_CHANGED = 1;
    public static final int PROVIDER_CONFIGURED = 2;
    public static final int PROVIDER_DECONFIGURED = 4;
    private TeamSubscriber subscriber;
    private int flags;
    private IResource resource;

    public TeamDelta(TeamSubscriber subscriber, int flags, IResource resource) {
        this.subscriber = subscriber;
        this.flags = flags;
        this.resource = resource;
    }

    public int getFlags() {
        return this.flags;
    }

    public IResource getResource() {
        return this.resource;
    }

    public TeamSubscriber getSubscriber() {
        return this.subscriber;
    }

    public static TeamDelta[] asSyncChangedDeltas(TeamSubscriber subscriber, IResource[] resources) {
        TeamDelta[] deltas = new TeamDelta[resources.length];
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            deltas[i] = new TeamDelta(subscriber, 1, resource);
            ++i;
        }
        return deltas;
    }
}

