/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.core.subscribers;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.subscribers.ComparisonCriteria;
import org.eclipse.team.core.subscribers.TeamSubscriber;
import org.eclipse.team.core.sync.IRemoteResource;
import org.eclipse.team.internal.core.Assert;
import org.eclipse.team.internal.core.Policy;

public class SyncInfo
implements IAdaptable {
    public static final int IN_SYNC = 0;
    public static final int ADDITION = 1;
    public static final int DELETION = 2;
    public static final int CHANGE = 3;
    public static final int CHANGE_MASK = 3;
    public static final int OUTGOING = 4;
    public static final int INCOMING = 8;
    public static final int CONFLICTING = 12;
    public static final int DIRECTION_MASK = 12;
    public static final int PSEUDO_CONFLICT = 16;
    public static final int AUTOMERGE_CONFLICT = 32;
    public static final int MANUAL_CONFLICT = 64;
    private IResource local;
    private IRemoteResource base;
    private IRemoteResource remote;
    private TeamSubscriber subscriber;
    private int syncKind;
    static /* synthetic */ Class class$0;

    public SyncInfo(IResource local, IRemoteResource base, IRemoteResource remote, TeamSubscriber subscriber, IProgressMonitor monitor) throws TeamException {
        this.local = local;
        this.base = base;
        this.remote = remote;
        this.subscriber = subscriber;
        this.syncKind = this.calculateKind(monitor);
    }

    public IResource getLocal() {
        return this.local;
    }

    public String getLocalContentIdentifier() {
        return null;
    }

    public IRemoteResource getBase() {
        return this.base;
    }

    public IRemoteResource getRemote() {
        return this.remote;
    }

    public TeamSubscriber getSubscriber() {
        return this.subscriber;
    }

    public int getKind() {
        return this.syncKind;
    }

    public static boolean isInSync(int kind) {
        return kind == 0;
    }

    public static int getDirection(int kind) {
        return kind & 0xC;
    }

    public static int getChange(int kind) {
        return kind & 3;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof SyncInfo) {
            return this.equalNodes(this, (SyncInfo)other);
        }
        return false;
    }

    private boolean equalNodes(SyncInfo node1, SyncInfo node2) {
        if (node1 == null || node2 == null) {
            return false;
        }
        IResource local1 = null;
        if (node1.getLocal() != null) {
            local1 = node1.getLocal();
        }
        IResource local2 = null;
        if (node2.getLocal() != null) {
            local2 = node2.getLocal();
        }
        if (!this.equalObjects(local1, local2)) {
            return false;
        }
        IRemoteResource base1 = null;
        if (node1.getBase() != null) {
            base1 = node1.getBase();
        }
        IRemoteResource base2 = null;
        if (node2.getBase() != null) {
            base2 = node2.getBase();
        }
        if (!this.equalObjects(base1, base2)) {
            return false;
        }
        IRemoteResource remote1 = null;
        if (node1.getRemote() != null) {
            remote1 = node1.getRemote();
        }
        IRemoteResource remote2 = null;
        if (node2.getRemote() != null) {
            remote2 = node2.getRemote();
        }
        return this.equalObjects(remote1, remote2);
    }

    private boolean equalObjects(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[Lorg.eclipse.core.resources.IResource;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz) {
            return this.getLocal();
        }
        return null;
    }

    public String toString() {
        return String.valueOf(this.getLocal().getName()) + " " + SyncInfo.kindToString(this.getKind());
    }

    public static String kindToString(int kind) {
        String label = "";
        if (kind == 0) {
            label = Policy.bind("RemoteSyncElement.insync");
        } else {
            switch (kind & 0xC) {
                case 12: {
                    label = Policy.bind("RemoteSyncElement.conflicting");
                    break;
                }
                case 4: {
                    label = Policy.bind("RemoteSyncElement.outgoing");
                    break;
                }
                case 8: {
                    label = Policy.bind("RemoteSyncElement.incoming");
                }
            }
            switch (kind & 3) {
                case 3: {
                    label = Policy.bind("concatStrings", label, Policy.bind("RemoteSyncElement.change"));
                    break;
                }
                case 1: {
                    label = Policy.bind("concatStrings", label, Policy.bind("RemoteSyncElement.addition"));
                    break;
                }
                case 2: {
                    label = Policy.bind("concatStrings", label, Policy.bind("RemoteSyncElement.deletion"));
                }
            }
            if ((kind & 0x40) != 0) {
                label = Policy.bind("concatStrings", label, Policy.bind("RemoteSyncElement.manual"));
            }
            if ((kind & 0x20) != 0) {
                label = Policy.bind("concatStrings", label, Policy.bind("RemoteSyncElement.auto"));
            }
        }
        return Policy.bind("RemoteSyncElement.delimit", label);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int calculateKind(IProgressMonitor progress) throws TeamException {
        progress = Policy.monitorFor(progress);
        int description = 0;
        ComparisonCriteria criteria = this.subscriber.getCurrentComparisonCriteria();
        boolean localExists = this.local.exists();
        if (this.subscriber.isThreeWay()) {
            if (this.base == null) {
                if (this.remote == null) {
                    if (localExists) return 5;
                    return 0;
                }
                if (!localExists) {
                    return 9;
                }
                description = 13;
                try {
                    progress.beginTask(null, 60);
                    if (criteria.compare(this.local, this.remote, Policy.subMonitorFor(progress, 30))) {
                        description |= 0x10;
                    }
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    progress.done();
                    throw throwable;
                }
                {
                    Object var5_8 = null;
                    progress.done();
                    return description;
                }
            }
            if (!localExists) {
                if (this.remote == null) {
                    return 30;
                }
                if (!criteria.compare(this.base, this.remote, progress)) return 15;
                return 6;
            }
            if (this.remote == null) {
                if (!criteria.compare(this.local, this.base, progress)) return 15;
                return 10;
            }
            progress.beginTask(null, 90);
            boolean ay = criteria.compare(this.local, this.base, Policy.subMonitorFor(progress, 30));
            boolean am = criteria.compare(this.base, this.remote, Policy.subMonitorFor(progress, 30));
            if (!ay || !am) {
                if (ay && !am) {
                    description = 11;
                } else if (!ay && am) {
                    description = 7;
                } else if (!criteria.compare(this.local, this.remote, Policy.subMonitorFor(progress, 30))) {
                    description = 15;
                }
            }
            progress.done();
            return description;
        }
        if (this.remote == null) {
            if (localExists) return 2;
            Assert.isTrue(false);
            return description;
        }
        if (!localExists) {
            return 1;
        }
        if (criteria.compare(this.local, this.remote, Policy.subMonitorFor(progress, 30))) return description;
        return 3;
    }
}

