/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.core.subscribers;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ISynchronizer;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.subscribers.RemoteSynchronizer;
import org.eclipse.team.internal.core.Assert;

public abstract class RemoteBytesSynchronizer
extends RemoteSynchronizer {
    private static final byte[] NO_REMOTE = new byte[0];
    protected QualifiedName syncName;

    public RemoteBytesSynchronizer(QualifiedName name) {
        this.syncName = name;
        this.getSynchronizer().add(this.syncName);
    }

    public void dispose() {
        this.getSynchronizer().remove(this.getSyncName());
    }

    protected ISynchronizer getSynchronizer() {
        return ResourcesPlugin.getWorkspace().getSynchronizer();
    }

    protected QualifiedName getSyncName() {
        return this.syncName;
    }

    public byte[] getSyncBytes(IResource resource) throws TeamException {
        byte[] syncBytes = this.internalGetSyncBytes(resource);
        if (syncBytes != null && this.equals(syncBytes, NO_REMOTE)) {
            return null;
        }
        return syncBytes;
    }

    private byte[] internalGetSyncBytes(IResource resource) throws TeamException {
        try {
            return this.getSynchronizer().getSyncInfo(this.getSyncName(), resource);
        }
        catch (CoreException e) {
            throw TeamException.asTeamException(e);
        }
    }

    public boolean setSyncBytes(IResource resource, byte[] bytes) throws TeamException {
        Assert.isNotNull(bytes);
        byte[] oldBytes = this.internalGetSyncBytes(resource);
        if (oldBytes != null && this.equals(oldBytes, bytes)) {
            return false;
        }
        try {
            this.getSynchronizer().setSyncInfo(this.getSyncName(), resource, bytes);
            return true;
        }
        catch (CoreException e) {
            throw TeamException.asTeamException(e);
        }
    }

    public boolean removeSyncBytes(IResource resource, int depth) throws TeamException {
        if (resource.exists() || resource.isPhantom()) {
            try {
                if (depth != 0 || this.internalGetSyncBytes(resource) != null) {
                    this.getSynchronizer().flushSyncInfo(this.getSyncName(), resource, depth);
                    return true;
                }
            }
            catch (CoreException e) {
                throw TeamException.asTeamException(e);
            }
        }
        return false;
    }

    public boolean isRemoteKnown(IResource resource) throws TeamException {
        return this.internalGetSyncBytes(resource) != null;
    }

    protected boolean setRemoteDoesNotExist(IResource resource) throws TeamException {
        return this.setSyncBytes(resource, NO_REMOTE);
    }

    private boolean equals(byte[] syncBytes, byte[] oldBytes) {
        if (syncBytes.length != oldBytes.length) {
            return false;
        }
        int i = 0;
        while (i < oldBytes.length) {
            if (oldBytes[i] != syncBytes[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean hasRemote(IResource resource) throws TeamException {
        return this.getSyncBytes(resource) != null;
    }
}

