/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.core.subscribers;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.TeamException;

public abstract class ComparisonCriteria {
    private ComparisonCriteria[] preConditions;

    public ComparisonCriteria() {
    }

    public ComparisonCriteria(ComparisonCriteria[] preConditions) {
        this.preConditions = preConditions;
    }

    public abstract String getName();

    public abstract String getId();

    public abstract boolean compare(Object var1, Object var2, IProgressMonitor var3) throws TeamException;

    protected ComparisonCriteria[] getPreConditions() {
        return this.preConditions;
    }

    protected boolean checkPreConditions(Object e1, Object e2, IProgressMonitor monitor) throws TeamException {
        int i = 0;
        while (i < this.preConditions.length) {
            ComparisonCriteria cc = this.preConditions[i];
            if (cc.compare(e1, e2, monitor)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean usesFileContents() {
        return false;
    }
}

