/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.core.subscribers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.core.ExceptionCollector;
import org.eclipse.team.internal.core.Policy;

public abstract class BackgroundEventHandler {
    private List awaitingProcessing = new ArrayList();
    private Job eventHandlerJob;
    private boolean shutdown;
    private ExceptionCollector errors = new ExceptionCollector(this.getErrorsTitle(), "org.eclipse.team.core", 4, null);
    private long processingEventsDuration = 0L;
    private long DISPATCH_DELAY = 1500L;
    private long WAIT_DELAY = 1000L;

    protected BackgroundEventHandler() {
        this.createEventHandlingJob();
        this.schedule();
    }

    protected void createEventHandlingJob() {
        this.eventHandlerJob = new Job(this.getName()){

            public IStatus run(IProgressMonitor monitor) {
                return BackgroundEventHandler.this.processEvents(monitor);
            }

            public boolean shouldRun() {
                return !BackgroundEventHandler.this.isQueueEmpty();
            }

            public boolean shouldSchedule() {
                return !BackgroundEventHandler.this.isQueueEmpty();
            }
        };
        this.eventHandlerJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                BackgroundEventHandler.this.jobDone(event);
            }
        });
        this.eventHandlerJob.setPriority(20);
    }

    protected void jobDone(IJobChangeEvent event) {
        if (this.isShutdown()) {
            BackgroundEventHandler backgroundEventHandler = this;
            synchronized (backgroundEventHandler) {
                this.awaitingProcessing.clear();
            }
        } else if (!this.isQueueEmpty()) {
            this.schedule();
        }
    }

    protected void schedule() {
        this.eventHandlerJob.schedule();
    }

    public abstract String getName();

    protected abstract String getErrorsTitle();

    public void shutdown() {
        this.shutdown = true;
        this.eventHandlerJob.cancel();
    }

    public boolean isShutdown() {
        return this.shutdown;
    }

    protected synchronized void queueEvent(Event event) {
        if (Policy.DEBUG_BACKGROUND_EVENTS) {
            System.out.println("Event queued on " + this.getName() + ":" + event.toString());
        }
        this.awaitingProcessing.add(event);
        if (!this.isShutdown() && this.eventHandlerJob != null) {
            if (this.eventHandlerJob.getState() == 0) {
                this.schedule();
            } else {
                this.notify();
            }
        }
    }

    private synchronized Event nextElement() {
        if (this.isShutdown() || this.isQueueEmpty()) {
            return null;
        }
        return (Event)this.awaitingProcessing.remove(0);
    }

    protected synchronized boolean isQueueEmpty() {
        return this.awaitingProcessing.isEmpty();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected IStatus processEvents(IProgressMonitor monitor) {
        this.errors.clear();
        try {
            Event event;
            monitor.beginTask(null, 100);
            IProgressMonitor subMonitor = Policy.infiniteSubMonitorFor(monitor, 90);
            subMonitor.beginTask(null, 1024);
            this.processingEventsDuration = System.currentTimeMillis();
            while ((event = this.nextElement()) != null && !this.isShutdown()) {
                try {
                    this.processEvent(event, subMonitor);
                    if (Policy.DEBUG_BACKGROUND_EVENTS) {
                        System.out.println("Event processed on " + this.getName() + ":" + event.toString());
                    }
                    if (!this.isReadyForDispath()) continue;
                    this.dispatchEvents();
                    this.processingEventsDuration = System.currentTimeMillis();
                }
                catch (CoreException e) {
                    this.handleException(e);
                }
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        monitor.done();
        return this.errors.getStatus();
    }

    protected abstract void dispatchEvents() throws TeamException;

    private boolean isReadyForDispath() {
        long duration = System.currentTimeMillis() - this.processingEventsDuration;
        if (duration >= this.DISPATCH_DELAY) {
            return true;
        }
        BackgroundEventHandler backgroundEventHandler = this;
        synchronized (backgroundEventHandler) {
            block7: {
                if (this.isQueueEmpty()) break block7;
                return false;
            }
            try {
                this.wait(this.WAIT_DELAY);
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.isQueueEmpty();
    }

    protected void handleException(CoreException e) {
        this.errors.handleException((Exception)((Object)e));
    }

    protected abstract void processEvent(Event var1, IProgressMonitor var2) throws CoreException;

    public Job getEventHandlerJob() {
        return this.eventHandlerJob;
    }

    public static class Event {
        IResource resource;
        int type;
        int depth;

        public Event(IResource resource, int type, int depth) {
            this.resource = resource;
            this.type = type;
            this.depth = depth;
        }

        public int getDepth() {
            return this.depth;
        }

        public IResource getResource() {
            return this.resource;
        }

        public int getType() {
            return this.type;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append("resource: ");
            buffer.append(this.resource.getFullPath());
            buffer.append(" type: ");
            buffer.append(this.getTypeString());
            buffer.append(" depth: ");
            buffer.append(this.getDepthString());
            return buffer.toString();
        }

        protected String getDepthString() {
            switch (this.depth) {
                case 0: {
                    return "DEPTH_ZERO";
                }
                case 1: {
                    return "DEPTH_ONE";
                }
                case 2: {
                    return "DEPTH_INFINITE";
                }
            }
            return "INVALID";
        }

        protected String getTypeString() {
            return String.valueOf(this.type);
        }
    }
}

