/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.core;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.team.core.IFileTypeInfo;
import org.eclipse.team.core.IIgnoreInfo;
import org.eclipse.team.core.IProjectSetSerializer;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.core.Policy;
import org.eclipse.team.internal.core.StringMatcher;
import org.eclipse.team.internal.core.TeamPlugin;

public final class Team {
    public static final String PREF_TEAM_IGNORES = "ignore_files";
    public static final String PREF_TEAM_TYPES = "file_types";
    public static final String PREF_TEAM_SEPARATOR = "\n";
    public static final Status OK_STATUS = new Status(0, "org.eclipse.team.core", 0, Policy.bind("ok"), null);
    public static final int UNKNOWN = 0;
    public static final int TEXT = 1;
    public static final int BINARY = 2;
    private static SortedMap globalTypes;
    private static SortedMap pluginTypes;
    private static SortedMap globalIgnore;
    private static SortedMap pluginIgnore;
    private static StringMatcher[] ignoreMatchers;

    public static int getType(IStorage storage) {
        String extension = Team.getFileExtension(storage.getName());
        if (extension == null) {
            return 0;
        }
        SortedMap table = Team.getFileTypeTable();
        Integer integer = (Integer)table.get(extension);
        if (integer == null) {
            return 0;
        }
        return integer;
    }

    public static boolean isIgnoredHint(IResource resource) {
        if (resource.isDerived()) {
            return true;
        }
        return Team.matchesEnabledIgnore(resource);
    }

    public static boolean isIgnoredHint(IFile file) {
        if (file.isDerived()) {
            return true;
        }
        return Team.matchesEnabledIgnore((IResource)file);
    }

    private static boolean matchesEnabledIgnore(IResource resource) {
        StringMatcher[] matchers = Team.getStringMatchers();
        int i = 0;
        while (i < matchers.length) {
            if (matchers[i].match(resource.getName())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isIgnored(IFile file) {
        return Team.matchesEnabledIgnore((IResource)file);
    }

    private static IFileTypeInfo[] getFileTypeInfo(SortedMap map) {
        ArrayList<FileTypeInfo> result = new ArrayList<FileTypeInfo>();
        Iterator e = map.keySet().iterator();
        while (e.hasNext()) {
            String string = (String)e.next();
            int type = (Integer)map.get(string);
            result.add(new FileTypeInfo(string, type));
        }
        return result.toArray(new IFileTypeInfo[result.size()]);
    }

    public static IFileTypeInfo[] getAllTypes() {
        return Team.getFileTypeInfo(Team.getFileTypeTable());
    }

    public static synchronized IIgnoreInfo[] getAllIgnores() {
        if (globalIgnore == null) {
            globalIgnore = new TreeMap();
            pluginIgnore = new TreeMap();
            ignoreMatchers = null;
            try {
                Team.readIgnoreState();
            }
            catch (TeamException e) {
                TeamPlugin.log(4, Policy.bind("Team.Error_loading_ignore_state_from_disk_1"), (Throwable)((Object)e));
            }
            Team.initializePluginIgnores(pluginIgnore, globalIgnore);
        }
        IIgnoreInfo[] result = Team.getIgnoreInfo(globalIgnore);
        return result;
    }

    private static IIgnoreInfo[] getIgnoreInfo(Map gIgnore) {
        IIgnoreInfo[] result = new IIgnoreInfo[gIgnore.size()];
        Iterator e = gIgnore.keySet().iterator();
        int i = 0;
        while (e.hasNext()) {
            String pattern = (String)e.next();
            boolean enabled = (Boolean)gIgnore.get(pattern);
            result[i++] = new IIgnoreInfo(pattern, enabled){
                private String p;
                private boolean e;
                {
                    this.p = string;
                    this.e = bl;
                }

                public String getPattern() {
                    return this.p;
                }

                public boolean getEnabled() {
                    return this.e;
                }
            };
        }
        return result;
    }

    private static synchronized StringMatcher[] getStringMatchers() {
        if (ignoreMatchers == null) {
            IIgnoreInfo[] ignorePatterns = Team.getAllIgnores();
            Vector<StringMatcher> matchers = new Vector<StringMatcher>(ignorePatterns.length);
            int i = 0;
            while (i < ignorePatterns.length) {
                if (ignorePatterns[i].getEnabled()) {
                    matchers.add(new StringMatcher(ignorePatterns[i].getPattern(), true, false));
                }
                ++i;
            }
            ignoreMatchers = new StringMatcher[matchers.size()];
            matchers.copyInto(ignoreMatchers);
        }
        return ignoreMatchers;
    }

    private static synchronized SortedMap getFileTypeTable() {
        if (globalTypes == null) {
            Team.loadTextState();
        }
        return globalTypes;
    }

    public static void setAllTypes(String[] extensions, int[] types) {
        if (pluginTypes == null) {
            Team.loadTextState();
        }
        globalTypes = new TreeMap();
        int i = 0;
        while (i < extensions.length) {
            globalTypes.put(extensions[i], new Integer(types[i]));
            ++i;
        }
        StringBuffer buf = new StringBuffer();
        Iterator e = globalTypes.keySet().iterator();
        while (e.hasNext()) {
            boolean isCustom;
            String extension = (String)e.next();
            boolean bl = isCustom = !pluginTypes.containsKey(extension) || !((Integer)pluginTypes.get(extension)).equals(pluginTypes.get(extension));
            if (!isCustom) continue;
            buf.append(extension);
            buf.append(PREF_TEAM_SEPARATOR);
            Integer type = (Integer)globalTypes.get(extension);
            buf.append(type);
            buf.append(PREF_TEAM_SEPARATOR);
        }
        TeamPlugin.getPlugin().getPluginPreferences().setValue(PREF_TEAM_TYPES, buf.toString());
    }

    public static void setAllIgnores(String[] patterns, boolean[] enabled) {
        globalIgnore = new TreeMap();
        ignoreMatchers = null;
        int i = 0;
        while (i < patterns.length) {
            globalIgnore.put(patterns[i], new Boolean(enabled[i]));
            ++i;
        }
        StringBuffer buf = new StringBuffer();
        Iterator e = globalIgnore.keySet().iterator();
        while (e.hasNext()) {
            boolean isCustom;
            String pattern = (String)e.next();
            boolean bl = isCustom = !pluginIgnore.containsKey(pattern) || !((Boolean)pluginIgnore.get(pattern)).equals(globalIgnore.get(pattern));
            if (!isCustom) continue;
            buf.append(pattern);
            buf.append(PREF_TEAM_SEPARATOR);
            boolean en = (Boolean)globalIgnore.get(pattern);
            buf.append(en);
            buf.append(PREF_TEAM_SEPARATOR);
        }
        TeamPlugin.getPlugin().getPluginPreferences().setValue(PREF_TEAM_IGNORES, buf.toString());
    }

    public static void removeNatureFromProject(IProject proj, String natureId, IProgressMonitor monitor) throws TeamException {
        try {
            IProjectDescription description = proj.getDescription();
            String[] prevNatures = description.getNatureIds();
            ArrayList<String> newNatures = new ArrayList<String>(Arrays.asList(prevNatures));
            newNatures.remove(natureId);
            description.setNatureIds(newNatures.toArray(new String[newNatures.size()]));
            proj.setDescription(description, monitor);
        }
        catch (CoreException e) {
            throw Team.wrapException(Policy.bind("manager.errorRemovingNature", proj.getName(), natureId), e);
        }
    }

    public static void addNatureToProject(IProject proj, String natureId, IProgressMonitor monitor) throws TeamException {
        try {
            IProjectDescription description = proj.getDescription();
            String[] prevNatures = description.getNatureIds();
            String[] newNatures = new String[prevNatures.length + 1];
            System.arraycopy(prevNatures, 0, newNatures, 0, prevNatures.length);
            newNatures[prevNatures.length] = natureId;
            description.setNatureIds(newNatures);
            proj.setDescription(description, monitor);
        }
        catch (CoreException e) {
            throw Team.wrapException(Policy.bind("manager.errorSettingNature", proj.getName(), natureId), e);
        }
    }

    private static void initializePluginPatterns(Map pTypes, Map fTypes) {
        IExtensionPoint extension;
        TeamPlugin plugin = TeamPlugin.getPlugin();
        if (plugin != null && (extension = plugin.getDescriptor().getExtensionPoint("fileTypes")) != null) {
            IExtension[] extensions = extension.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    String ext = configElements[j].getAttribute("extension");
                    if (ext != null) {
                        String type = configElements[j].getAttribute("type");
                        if (!fTypes.containsKey(ext)) {
                            if (type.equals("text")) {
                                pTypes.put(ext, new Integer(1));
                                fTypes.put(ext, new Integer(1));
                            } else if (type.equals("binary")) {
                                fTypes.put(ext, new Integer(2));
                                pTypes.put(ext, new Integer(2));
                            }
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    private static void readTextState(DataInputStream dis) throws IOException {
        int extensionCount = 0;
        try {
            extensionCount = dis.readInt();
        }
        catch (EOFException eOFException) {
            return;
        }
        int i = 0;
        while (i < extensionCount) {
            String extension = dis.readUTF();
            int type = dis.readInt();
            globalTypes.put(extension, new Integer(type));
            ++i;
        }
    }

    private static void loadTextState() {
        globalTypes = new TreeMap();
        boolean old = Team.loadBackwardCompatibleTextState();
        if (!old) {
            Team.loadTextPreferences();
        }
        pluginTypes = new TreeMap();
        Team.initializePluginPatterns(pluginTypes, globalTypes);
        if (old) {
            TeamPlugin.getPlugin().savePluginPreferences();
        }
    }

    private static void loadTextPreferences() {
        Preferences pref = TeamPlugin.getPlugin().getPluginPreferences();
        if (!pref.contains(PREF_TEAM_TYPES)) {
            return;
        }
        String prefTypes = pref.getString(PREF_TEAM_TYPES);
        StringTokenizer tok = new StringTokenizer(prefTypes, PREF_TEAM_SEPARATOR);
        try {
            while (true) {
                String extension;
                if ((extension = tok.nextToken()).length() == 0) {
                    return;
                }
                String integer = tok.nextToken();
                globalTypes.put(extension, Integer.valueOf(integer));
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean loadBackwardCompatibleTextState() {
        String STATE_FILE = ".fileTypes";
        IPath pluginStateLocation = TeamPlugin.getPlugin().getStateLocation().append(STATE_FILE);
        File f = pluginStateLocation.toFile();
        if (!f.exists()) {
            return false;
        }
        try {
            DataInputStream dis = new DataInputStream(new FileInputStream(f));
            try {
                Team.readTextState(dis);
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                dis.close();
                throw throwable;
            }
            {
                Object var4_7 = null;
                dis.close();
            }
        }
        catch (IOException ex) {
            TeamPlugin.log(4, ex.getMessage(), ex);
            return false;
        }
        f.delete();
        return true;
    }

    private static void initializePluginIgnores(SortedMap pIgnore, SortedMap gIgnore) {
        IExtensionPoint extension;
        TeamPlugin plugin = TeamPlugin.getPlugin();
        if (plugin != null && (extension = plugin.getDescriptor().getExtensionPoint("ignore")) != null) {
            IExtension[] extensions = extension.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    String pattern = configElements[j].getAttribute("pattern");
                    if (pattern != null) {
                        String selected = configElements[j].getAttribute("enabled");
                        if (selected == null) {
                            selected = configElements[j].getAttribute("selected");
                        }
                        boolean enabled = selected != null && selected.equalsIgnoreCase("true");
                        pIgnore.put(pattern, new Boolean(enabled));
                        if (!gIgnore.containsKey(pattern)) {
                            gIgnore.put(pattern, new Boolean(enabled));
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    private static void readIgnoreState() throws TeamException {
        if (Team.readBackwardCompatibleIgnoreState()) {
            return;
        }
        Preferences pref = TeamPlugin.getPlugin().getPluginPreferences();
        if (!pref.contains(PREF_TEAM_IGNORES)) {
            return;
        }
        String prefIgnores = pref.getString(PREF_TEAM_IGNORES);
        StringTokenizer tok = new StringTokenizer(prefIgnores, PREF_TEAM_SEPARATOR);
        try {
            while (true) {
                String pattern;
                if ((pattern = tok.nextToken()).length() == 0) {
                    return;
                }
                String enabled = tok.nextToken();
                globalIgnore.put(pattern, new Boolean(enabled));
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean readBackwardCompatibleIgnoreState() throws TeamException {
        String GLOBALIGNORE_FILE = ".globalIgnores";
        IPath pluginStateLocation = TeamPlugin.getPlugin().getStateLocation().append(GLOBALIGNORE_FILE);
        File f = pluginStateLocation.toFile();
        if (!f.exists()) {
            return false;
        }
        try {
            DataInputStream dis = new DataInputStream(new FileInputStream(f));
            try {
                int ignoreCount = 0;
                try {
                    ignoreCount = dis.readInt();
                }
                catch (EOFException eOFException) {
                    Object var8_6 = null;
                    dis.close();
                    return false;
                }
                int i = 0;
                while (i < ignoreCount) {
                    String pattern = dis.readUTF();
                    boolean enabled = dis.readBoolean();
                    globalIgnore.put(pattern, new Boolean(enabled));
                    ++i;
                }
            }
            catch (Throwable throwable) {
                Object var8_7 = null;
                dis.close();
                throw throwable;
            }
            {
                Object var8_8 = null;
            }
            dis.close();
            f.delete();
            return true;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return true;
        }
        catch (IOException ex) {
            throw new TeamException((IStatus)new Status(4, "org.eclipse.team.core", 0, Policy.bind("Team.readError"), (Throwable)ex));
        }
    }

    public static void startup() throws CoreException {
        ResourcesPlugin.getWorkspace().addResourceChangeListener(new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                IResourceDelta[] projectDeltas = event.getDelta().getAffectedChildren();
                int i = 0;
                while (i < projectDeltas.length) {
                    RepositoryProvider provider;
                    IResourceDelta delta = projectDeltas[i];
                    IResource resource = delta.getResource();
                    if (delta.getKind() == 1 && (delta.getFlags() & 0x1000) != 0 && RepositoryProvider.isShared(resource.getProject()) && (provider = RepositoryProvider.getProvider(resource.getProject())) != null && !provider.getProject().equals((Object)resource.getProject())) {
                        provider.setProject(resource.getProject());
                    }
                    ++i;
                }
            }
        }, 1);
    }

    public static void shutdown() {
        TeamPlugin.getPlugin().savePluginPreferences();
    }

    public static IProjectSetSerializer getProjectSetSerializer(String id) {
        IExtensionPoint extension;
        TeamPlugin plugin = TeamPlugin.getPlugin();
        if (plugin != null && (extension = plugin.getDescriptor().getExtensionPoint("projectSets")) != null) {
            IExtension[] extensions = extension.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    String extensionId = configElements[j].getAttribute("id");
                    if (extensionId != null && extensionId.equals(id)) {
                        try {
                            return (IProjectSetSerializer)configElements[j].createExecutableExtension("class");
                        }
                        catch (CoreException e) {
                            TeamPlugin.log(e);
                            return null;
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
        return null;
    }

    private static TeamException wrapException(String message, CoreException e) {
        MultiStatus status = new MultiStatus("org.eclipse.team.core", 0, message, (Throwable)e);
        status.merge(e.getStatus());
        return new TeamException((IStatus)status);
    }

    private static String getFileExtension(String name) {
        if (name == null) {
            return null;
        }
        int index = name.lastIndexOf(46);
        if (index == -1) {
            return null;
        }
        if (index == name.length() - 1) {
            return "";
        }
        return name.substring(index + 1);
    }

    public static IIgnoreInfo[] getDefaultIgnores() {
        TreeMap gIgnore = new TreeMap();
        TreeMap pIgnore = new TreeMap();
        Team.initializePluginIgnores(pIgnore, gIgnore);
        return Team.getIgnoreInfo(gIgnore);
    }

    public static IFileTypeInfo[] getDefaultTypes() {
        TreeMap gTypes = new TreeMap();
        TreeMap pTypes = new TreeMap();
        Team.initializePluginPatterns(pTypes, gTypes);
        return Team.getFileTypeInfo(gTypes);
    }

    private static class FileTypeInfo
    implements IFileTypeInfo {
        private String extension;
        private int type;

        public FileTypeInfo(String extension, int type) {
            this.extension = extension;
            this.type = type;
        }

        public String getExtension() {
            return this.extension;
        }

        public int getType() {
            return this.type;
        }
    }
}

