/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.core;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IFileModificationValidator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IProjectNatureDescriptor;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.team.IMoveDeleteHook;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ILock;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.team.core.Team;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.core.Policy;
import org.eclipse.team.internal.core.TeamPlugin;
import org.eclipse.team.internal.core.simpleAccess.SimpleAccessOperations;

public abstract class RepositoryProvider
implements IProjectNature {
    private static final String TEAM_SETID = "org.eclipse.team.repository-provider";
    private static final QualifiedName PROVIDER_PROP_KEY = new QualifiedName("org.eclipse.team.core", "repository");
    private static final List AllProviderTypeIds = RepositoryProvider.initializeAllProviderTypes();
    private IProject project;
    private static final ILock mappingLock = Platform.getJobManager().newLock();

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void map(IProject project, String id) throws TeamException {
        block16: {
            try {
                try {
                    Platform.getJobManager().beginRule((ISchedulingRule)project, null);
                    try {
                        RepositoryProvider.mappingLock.acquire();
                        existingProvider = null;
                        if (project.getPersistentProperty(RepositoryProvider.PROVIDER_PROP_KEY) != null) {
                            existingProvider = RepositoryProvider.getProvider(project);
                        }
                        if (existingProvider == null) ** GOTO lbl25
                        if (existingProvider.getID().equals(id)) {
                            var6_4 = null;
                        }
                        ** GOTO lbl-1000
                    }
                    catch (Throwable var7_13) {
                        var6_5 = null;
                        RepositoryProvider.mappingLock.release();
                        throw var7_13;
                    }
                    RepositoryProvider.mappingLock.release();
                    var8_7 = null;
                    break block16;
lbl-1000:
                    // 1 sources

                    {
                        RepositoryProvider.unmap(project);
lbl25:
                        // 2 sources

                        provider = RepositoryProvider.mapNewProvider(project, id);
                        try {
                            project.setPersistentProperty(RepositoryProvider.PROVIDER_PROP_KEY, id);
                        }
                        catch (CoreException outer) {
                            try {
                                project.setSessionProperty(RepositoryProvider.PROVIDER_PROP_KEY, null);
                                throw outer;
                            }
                            catch (CoreException inner) {
                                TeamPlugin.log(4, Policy.bind("RepositoryProvider.couldNotClearAfterError", project.getName(), id), inner);
                            }
                            throw outer;
                        }
                        provider.configure();
                        project.touch(null);
                    }
                    {
                        var6_6 = null;
                        RepositoryProvider.mappingLock.release();
                        ** GOTO lbl-1000
                    }
                }
                catch (CoreException e) {
                    throw TeamPlugin.wrapException(e);
                }
            }
            catch (Throwable var9_14) {
                var8_8 = null;
                Platform.getJobManager().endRule((ISchedulingRule)project);
                throw var9_14;
            }
        }
        Platform.getJobManager().endRule((ISchedulingRule)project);
        return;
lbl-1000:
        // 1 sources

        {
            var8_9 = null;
        }
        Platform.getJobManager().endRule((ISchedulingRule)project);
    }

    private static RepositoryProvider mapNewProvider(IProject project, String id) throws TeamException {
        RepositoryProvider provider = RepositoryProvider.newProvider(id);
        if (provider == null) {
            throw new TeamException(Policy.bind("RepositoryProvider.couldNotInstantiateProvider", project.getName(), id));
        }
        if (!provider.canHandleLinkedResources()) {
            try {
                IResource[] members = project.members();
                int i = 0;
                while (i < members.length) {
                    IResource resource = members[i];
                    if (resource.isLinked()) {
                        throw new TeamException((IStatus)new Status(4, "org.eclipse.team.core", 378, Policy.bind("RepositoryProvider.linkedResourcesExist", project.getName(), id), null));
                    }
                    ++i;
                }
            }
            catch (CoreException e) {
                throw TeamPlugin.wrapException(e);
            }
        }
        try {
            project.setSessionProperty(PROVIDER_PROP_KEY, (Object)provider);
            provider.setProject(project);
        }
        catch (CoreException e) {
            throw TeamPlugin.wrapException(e);
        }
        return provider;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static RepositoryProvider mapExistingProvider(IProject project, String id) throws TeamException {
        RepositoryProvider repositoryProvider;
        block8: {
            RepositoryProvider repositoryProvider2;
            block7: {
                RepositoryProvider repositoryProvider3;
                block5: {
                    try {
                        block6: {
                            mappingLock.acquire();
                            try {
                                String currentId = project.getPersistentProperty(PROVIDER_PROP_KEY);
                                if (currentId == null) {
                                    repositoryProvider3 = null;
                                    Object var3_7 = null;
                                    break block5;
                                }
                                if (currentId.equals(id)) break block6;
                                repositoryProvider2 = RepositoryProvider.lookupProviderProp(project);
                                break block7;
                            }
                            catch (CoreException e) {
                                throw TeamPlugin.wrapException(e);
                            }
                        }
                        repositoryProvider = RepositoryProvider.mapNewProvider(project, id);
                        break block8;
                    }
                    catch (Throwable throwable) {
                        Object var3_10 = null;
                        mappingLock.release();
                        throw throwable;
                    }
                }
                mappingLock.release();
                return repositoryProvider3;
            }
            Object var3_8 = null;
            mappingLock.release();
            return repositoryProvider2;
        }
        Object var3_9 = null;
        mappingLock.release();
        return repositoryProvider;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void unmap(IProject project) throws TeamException {
        try {
            try {
                Platform.getJobManager().beginRule((ISchedulingRule)project, null);
                try {
                    mappingLock.acquire();
                    String id = project.getPersistentProperty(PROVIDER_PROP_KEY);
                    if (id == null) {
                        throw new TeamException(Policy.bind("RepositoryProvider.No_Provider_Registered", project.getName()));
                    }
                    RepositoryProvider provider = RepositoryProvider.getProvider(project);
                    if (provider == null) {
                        TeamPlugin.log(4, Policy.bind("RepositoryProvider.couldNotInstantiateProvider", project.getName(), id), null);
                    }
                    if (provider != null) {
                        provider.deconfigure();
                    }
                    project.setSessionProperty(PROVIDER_PROP_KEY, null);
                    project.setPersistentProperty(PROVIDER_PROP_KEY, null);
                    if (provider != null) {
                        provider.deconfigured();
                    }
                    project.touch(null);
                }
                catch (Throwable throwable) {
                    Object var3_5 = null;
                    mappingLock.release();
                    throw throwable;
                }
                {
                    Object var3_6 = null;
                    mappingLock.release();
                }
            }
            catch (CoreException e) {
                throw TeamPlugin.wrapException(e);
            }
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            Platform.getJobManager().endRule((ISchedulingRule)project);
            throw throwable;
        }
        {
            Object var5_9 = null;
        }
        Platform.getJobManager().endRule((ISchedulingRule)project);
    }

    private static RepositoryProvider lookupProviderProp(IProject project) throws CoreException {
        return (RepositoryProvider)project.getSessionProperty(PROVIDER_PROP_KEY);
    }

    public abstract void configureProject() throws CoreException;

    public final void configure() throws CoreException {
        try {
            this.configureProject();
        }
        catch (CoreException e) {
            try {
                RepositoryProvider.unmap(this.getProject());
            }
            catch (TeamException e2) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.team.core", 0, String.valueOf(Policy.bind("RepositoryProvider_Error_removing_nature_from_project___1")) + this.getID(), (Throwable)((Object)e2)));
            }
            throw e;
        }
    }

    protected void deconfigured() {
    }

    public abstract String getID();

    public IFileModificationValidator getFileModificationValidator() {
        return null;
    }

    public IMoveDeleteHook getMoveDeleteHook() {
        return null;
    }

    public String toString() {
        return Policy.bind("RepositoryProvider.toString", this.getProject().getName(), this.getID());
    }

    public static final String[] getAllProviderTypeIds() {
        IProjectNatureDescriptor[] desc = ResourcesPlugin.getWorkspace().getNatureDescriptors();
        HashSet<String> teamSet = new HashSet<String>();
        teamSet.addAll(AllProviderTypeIds);
        int i = 0;
        while (i < desc.length) {
            String[] setIds = desc[i].getNatureSetIds();
            int j = 0;
            while (j < setIds.length) {
                if (setIds[j].equals(TEAM_SETID)) {
                    teamSet.add(desc[i].getNatureId());
                }
                ++j;
            }
            ++i;
        }
        return teamSet.toArray(new String[teamSet.size()]);
    }

    public static final RepositoryProvider getProvider(IProject project) {
        block9: {
            try {
                if (project.isAccessible()) {
                    RepositoryProvider provider = RepositoryProvider.lookupProviderProp(project);
                    if (provider != null) {
                        return provider;
                    }
                    String id = project.getPersistentProperty(PROVIDER_PROP_KEY);
                    if (id != null) {
                        return RepositoryProvider.mapExistingProvider(project, id);
                    }
                    IProjectDescription projectDesc = project.getDescription();
                    String[] natureIds = projectDesc.getNatureIds();
                    IWorkspace workspace = ResourcesPlugin.getWorkspace();
                    int i = 0;
                    while (i < natureIds.length) {
                        IProjectNatureDescriptor desc = workspace.getNatureDescriptor(natureIds[i]);
                        if (desc != null) {
                            String[] setIds = desc.getNatureSetIds();
                            int j = 0;
                            while (j < setIds.length) {
                                if (setIds[j].equals(TEAM_SETID)) {
                                    return RepositoryProvider.getProvider(project, natureIds[i]);
                                }
                                ++j;
                            }
                        }
                        ++i;
                    }
                }
            }
            catch (CoreException e) {
                if (RepositoryProvider.isAcceptableException(e)) break block9;
                TeamPlugin.log(e);
            }
        }
        return null;
    }

    private static boolean isAcceptableException(CoreException e) {
        return e.getStatus().getCode() == 368;
    }

    public static final RepositoryProvider getProvider(IProject project, String id) {
        block9: {
            try {
                if (project.isAccessible()) {
                    String existingID = project.getPersistentProperty(PROVIDER_PROP_KEY);
                    if (id.equals(existingID)) {
                        RepositoryProvider provider = RepositoryProvider.lookupProviderProp(project);
                        if (provider != null) {
                            return provider;
                        }
                        RepositoryProvider newProvider = RepositoryProvider.mapExistingProvider(project, id);
                        if (newProvider != null && newProvider.getID().equals(id)) {
                            return newProvider;
                        }
                        return null;
                    }
                    IProjectNatureDescriptor desc = ResourcesPlugin.getWorkspace().getNatureDescriptor(id);
                    if (desc == null) {
                        return null;
                    }
                    String[] setIds = desc.getNatureSetIds();
                    int i = 0;
                    while (i < setIds.length) {
                        if (setIds[i].equals(TEAM_SETID)) {
                            return (RepositoryProvider)project.getNature(id);
                        }
                        ++i;
                    }
                }
            }
            catch (CoreException e) {
                if (RepositoryProvider.isAcceptableException(e)) break block9;
                TeamPlugin.log(e);
            }
        }
        return null;
    }

    public static boolean isShared(IProject project) {
        if (!project.isAccessible()) {
            return false;
        }
        try {
            if (RepositoryProvider.lookupProviderProp(project) != null) {
                return true;
            }
            return project.getPersistentProperty(PROVIDER_PROP_KEY) != null;
        }
        catch (CoreException e) {
            TeamPlugin.log(e);
            return false;
        }
    }

    public SimpleAccessOperations getSimpleAccess() {
        return null;
    }

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    private static List initializeAllProviderTypes() {
        IExtensionPoint extension;
        ArrayList<String> allIDs = new ArrayList<String>();
        TeamPlugin plugin = TeamPlugin.getPlugin();
        if (plugin != null && (extension = plugin.getDescriptor().getExtensionPoint("repository")) != null) {
            IExtension[] extensions = extension.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    String extensionId = configElements[j].getAttribute("id");
                    allIDs.add(extensionId);
                    ++j;
                }
                ++i;
            }
        }
        return allIDs;
    }

    private static RepositoryProvider newProvider(String id) {
        IExtensionPoint extension;
        TeamPlugin plugin = TeamPlugin.getPlugin();
        if (plugin != null && (extension = plugin.getDescriptor().getExtensionPoint("repository")) != null) {
            IExtension[] extensions = extension.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    String extensionId = configElements[j].getAttribute("id");
                    if (extensionId != null && extensionId.equals(id)) {
                        try {
                            return (RepositoryProvider)configElements[j].createExecutableExtension("class");
                        }
                        catch (CoreException e) {
                            TeamPlugin.log(e);
                        }
                        catch (ClassCastException e) {
                            String className = configElements[j].getAttribute("class");
                            TeamPlugin.log(4, Policy.bind("RepositoryProvider.invalidClass", id, className), e);
                        }
                        return null;
                    }
                    ++j;
                }
                ++i;
            }
        }
        return null;
    }

    public static void convertNatureToProperty(IProject project, boolean removeNature) throws TeamException {
        RepositoryProvider provider = RepositoryProvider.getProvider(project);
        if (provider == null) {
            return;
        }
        String providerId = provider.getID();
        RepositoryProvider.map(project, providerId);
        if (removeNature) {
            Team.removeNatureFromProject(project, providerId, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    public IStatus validateCreateLink(IResource resource, int updateFlags, IPath location) {
        if (this.canHandleLinkedResources()) {
            return Team.OK_STATUS;
        }
        return new Status(4, "org.eclipse.team.core", 378, Policy.bind("RepositoryProvider.linkedResourcesNotSupported", this.getProject().getName(), this.getID()), null);
    }

    public boolean canHandleLinkedResources() {
        return false;
    }
}

