/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.stats;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.eclipse.core.runtime.adaptor.EclipseAdaptor;
import org.eclipse.osgi.framework.adaptor.IBundleStats;
import org.eclipse.osgi.framework.stats.BundleStats;
import org.eclipse.osgi.framework.stats.ClassStats;
import org.eclipse.osgi.framework.stats.ClassloaderStats;

public class StatsManager
implements IBundleStats {
    private static Map plugins = new HashMap(20);
    private static Stack activationStack = new Stack();
    private static boolean booting = true;
    private static StatsManager defaultInstance;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public static StatsManager getDefault() {
        if (defaultInstance == null) {
            defaultInstance = new StatsManager();
        }
        return defaultInstance;
    }

    public void startActivation(String bundle) {
        BundleStats plugin = StatsManager.findPlugin(bundle);
        plugin.setTimestamp(System.currentTimeMillis());
        plugin.setActivationOrder(plugins.size());
        if (activationStack.size() != 0) {
            BundleStats activatedBy = (BundleStats)activationStack.peek();
            activatedBy.activated(plugin);
            plugin.setActivatedBy(activatedBy);
        }
        activationStack.push(plugin);
        EclipseAdaptor.TRACE_BUNDLES = true;
        if (true) {
            this.traceActivate(bundle, plugin);
        }
    }

    public void endActivation(String pluginId) {
        BundleStats plugin = (BundleStats)activationStack.pop();
        plugin.endActivation();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void traceActivate(String id, BundleStats plugin) {
        try {
            PrintWriter output = new PrintWriter(new FileOutputStream(ClassloaderStats.traceFile.getAbsolutePath(), true));
            try {
                long startPosition = ClassloaderStats.traceFile.length();
                output.println("Activating plugin: " + id);
                output.println("Plugin activation stack:");
                int i = activationStack.size() - 1;
                while (true) {
                    if (i < 0) break;
                    output.println("\t" + ((BundleStats)activationStack.get(i)).getPluginId());
                    --i;
                }
                output.println("Class loading stack:");
                Stack classStack = ClassloaderStats.getClassStack();
                int i2 = classStack.size() - 1;
                while (true) {
                    block7: {
                        if (i2 >= 0) break block7;
                        output.println("Stack trace:");
                        new Throwable().printStackTrace(output);
                        plugin.setTraceStart(startPosition);
                        break;
                    }
                    output.println("\t" + ((ClassStats)classStack.get(i2)).getClassName());
                    --i2;
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                output.close();
                plugin.setTraceEnd(ClassloaderStats.traceFile.length());
                throw throwable;
            }
            {
                Object var8_11 = null;
                output.close();
                plugin.setTraceEnd(ClassloaderStats.traceFile.length());
                return;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static BundleStats findPlugin(String id) {
        BundleStats result = (BundleStats)plugins.get(id);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[Lorg.eclipse.osgi.framework.stats.BundleStats;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ClassLoader cl = clazz.getClassLoader();
        System.out.println(cl);
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("[Lorg.eclipse.osgi.framework.stats.StatsManager;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        System.out.println(clazz2.getClassLoader());
        try {
            if (result == null) {
                result = new BundleStats(id);
                plugins.put(id, result);
            }
        }
        catch (IllegalAccessError e) {
            e.printStackTrace();
        }
        return result;
    }

    public BundleStats[] getPlugins() {
        return plugins.values().toArray(new BundleStats[plugins.size()]);
    }

    public BundleStats getPlugin(String id) {
        return (BundleStats)plugins.get(id);
    }
}

