/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.stats;

import java.util.ArrayList;
import org.eclipse.osgi.framework.stats.ClassloaderStats;

public class ClassStats {
    private String className;
    private ClassloaderStats classloader;
    private int loadOrder = -1;
    private long timestamp;
    private long timeLoading;
    private long timeLoadingOthers = 0L;
    private ClassStats loadedBy = null;
    private ArrayList loaded = new ArrayList(2);
    private boolean duringStartup;
    private long traceStart = -1L;
    private long traceEnd = -1L;
    private static boolean booting = true;

    public static void setBooting(boolean value) {
        booting = value;
    }

    public ClassStats(String name, ClassloaderStats classloader) {
        this.className = name;
        this.timestamp = System.currentTimeMillis();
        this.duringStartup = booting;
        this.classloader = classloader;
    }

    public void setLoadOrder(int order) {
        this.loadOrder = order;
    }

    public void loadingDone() {
        this.timeLoading = System.currentTimeMillis() - this.timestamp;
    }

    public long getTimeLoading() {
        return this.timeLoading;
    }

    public long getLocalTimeLoading() {
        return this.timeLoading - this.timeLoadingOthers;
    }

    public void addTimeLoadingOthers(long time) {
        this.timeLoadingOthers += time;
    }

    public long getTraceStart() {
        return this.traceStart;
    }

    public long getTraceEnd() {
        return this.traceEnd;
    }

    public void setTraceStart(long position) {
        this.traceStart = position;
    }

    public void setTraceEnd(long position) {
        this.traceEnd = position;
    }

    public void loaded(ClassStats child) {
        this.loaded.add(child);
    }

    public void setLoadedBy(ClassStats parent) {
        this.loadedBy = parent;
    }

    public ClassStats getLoadedBy() {
        return this.loadedBy;
    }

    public ArrayList getLoadedClasses() {
        return this.loaded;
    }

    public String getClassName() {
        return this.className;
    }

    public boolean isStartupClass() {
        return this.duringStartup;
    }

    public ClassloaderStats getClassloader() {
        return this.classloader;
    }

    public int getLoadOrder() {
        return this.loadOrder;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void toBaseClass() {
        this.duringStartup = true;
        this.loadOrder = -2;
    }
}

