/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.stats;

import java.util.ArrayList;
import org.eclipse.core.runtime.adaptor.EclipseAdaptor;
import org.eclipse.osgi.framework.stats.ClassloaderStats;

public class BundleStats {
    public String pluginId;
    public int activationOrder;
    private long timestamp;
    private boolean duringStartup;
    private long startupTime;
    private long startupMethodTime;
    private long traceStart = -1L;
    private long traceEnd = -1L;
    private ArrayList pluginsActivated = new ArrayList(3);
    private BundleStats activatedBy = null;

    public BundleStats(String pluginId) {
        this.pluginId = pluginId;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public int getActivationOrder() {
        return this.activationOrder;
    }

    protected void activated(BundleStats plugin) {
        this.pluginsActivated.add(plugin);
    }

    public BundleStats getActivatedBy() {
        return this.activatedBy;
    }

    public String getPluginId() {
        return this.pluginId;
    }

    public long getStartupTime() {
        return this.startupTime;
    }

    public long getStartupMethodTime() {
        return this.startupMethodTime;
    }

    public boolean isStartupPlugin() {
        return this.duringStartup;
    }

    public int getClassLoadCount() {
        if (!EclipseAdaptor.MONITOR_CLASSES) {
            return 0;
        }
        ClassloaderStats loader = ClassloaderStats.getLoader(this.pluginId);
        return loader == null ? 0 : loader.getClassLoadCount();
    }

    public long getClassLoadTime() {
        if (!EclipseAdaptor.MONITOR_CLASSES) {
            return 0L;
        }
        ClassloaderStats loader = ClassloaderStats.getLoader(this.pluginId);
        return loader == null ? 0L : loader.getClassLoadTime();
    }

    public ArrayList getPluginsActivated() {
        return this.pluginsActivated;
    }

    public long getTraceStart() {
        return this.traceStart;
    }

    public long getTraceEnd() {
        return this.traceEnd;
    }

    protected void setTimestamp(long value) {
        this.timestamp = value;
    }

    protected void setActivationOrder(int value) {
        this.activationOrder = value;
    }

    protected void setTraceStart(long time) {
        this.traceStart = time;
    }

    protected static void setBooting(boolean boot) {
    }

    protected void endActivation() {
        this.startupTime = System.currentTimeMillis() - this.timestamp;
    }

    protected void setTraceEnd(long position) {
        this.traceEnd = position;
    }

    protected void setActivatedBy(BundleStats value) {
        this.activatedBy = value;
    }
}

