/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.adaptor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.adaptor.IModel;
import org.eclipse.core.runtime.adaptor.IPluginInfo;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class PluginParser
extends DefaultHandler
implements IModel {
    private PluginInfo manifestInfo = new PluginInfo();
    private BundleContext context;
    String locationName = null;
    Stack stateStack = new Stack();
    Stack objectStack = new Stack();
    Locator locator = null;
    private static final int IGNORED_ELEMENT_STATE = 0;
    private static final int INITIAL_STATE = 1;
    private static final int PLUGIN_STATE = 2;
    private static final int PLUGIN_RUNTIME_STATE = 3;
    private static final int PLUGIN_REQUIRES_STATE = 4;
    private static final int PLUGIN_EXTENSION_POINT_STATE = 5;
    private static final int PLUGIN_EXTENSION_STATE = 6;
    private static final int RUNTIME_LIBRARY_STATE = 7;
    private static final int LIBRARY_EXPORT_STATE = 8;
    private static final int LIBRARY_PACKAGES_STATE = 12;
    private static final int PLUGIN_REQUIRES_IMPORT_STATE = 9;
    private static final int CONFIGURATION_ELEMENT_STATE = 10;
    private static final int FRAGMENT_STATE = 11;
    private ServiceReference parserReference;

    public PluginParser(BundleContext context) {
        this.context = context;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void endDocument() {
    }

    public void endElement(String uri, String elementName, String qName) {
        switch ((Integer)this.stateStack.peek()) {
            case 0: {
                this.stateStack.pop();
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 11: {
                break;
            }
            case 3: {
                if (!elementName.equals("runtime")) break;
                this.stateStack.pop();
                break;
            }
            case 4: {
                if (!elementName.equals("requires")) break;
                this.stateStack.pop();
                this.objectStack.pop();
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                if (!elementName.equals("library")) break;
                String curLibrary = (String)this.objectStack.pop();
                Vector exportsVector = (Vector)this.objectStack.pop();
                if (this.manifestInfo.libraries == null) {
                    this.manifestInfo.libraries = new HashMap(3);
                    this.manifestInfo.libraryPaths = new ArrayList(3);
                }
                this.manifestInfo.libraries.put(curLibrary, exportsVector);
                this.manifestInfo.libraryPaths.add(curLibrary);
                this.stateStack.pop();
                break;
            }
            case 8: {
                if (!elementName.equals("export")) break;
                this.stateStack.pop();
                break;
            }
            case 9: {
                if (!elementName.equals("import")) break;
                this.stateStack.pop();
                break;
            }
        }
    }

    public void error(SAXParseException ex) {
        this.logStatus(ex);
    }

    public void fatalError(SAXParseException ex) throws SAXException {
        this.logStatus(ex);
        throw ex;
    }

    public void handleExtensionPointState(String elementName, Attributes attributes) {
        this.stateStack.push(new Integer(0));
    }

    public void handleExtensionState(String elementName, Attributes attributes) {
        this.stateStack.push(new Integer(10));
    }

    public void handleInitialState(String elementName, Attributes attributes) {
        if (elementName.equals("plugin")) {
            this.stateStack.push(new Integer(2));
            this.parsePluginAttributes(attributes);
        } else if (elementName.equals("fragment")) {
            this.stateStack.push(new Integer(11));
            this.parseFragmentAttributes(attributes);
        } else {
            this.stateStack.push(new Integer(0));
        }
    }

    public void handleLibraryExportState(String elementName, Attributes attributes) {
        this.stateStack.push(new Integer(0));
    }

    public void handleLibraryState(String elementName, Attributes attributes) {
        if (elementName.equals("export")) {
            this.stateStack.push(new Integer(8));
            String currentLib = (String)this.objectStack.peek();
            if (attributes == null) {
                return;
            }
            String maskValue = attributes.getValue("", "name");
            this.objectStack.pop();
            Vector exportMask = (Vector)this.objectStack.peek();
            this.objectStack.push(currentLib);
            if (maskValue != null) {
                StringTokenizer tok = new StringTokenizer(maskValue, ",");
                while (tok.hasMoreTokens()) {
                    String value = tok.nextToken();
                    if (exportMask.contains(maskValue)) continue;
                    exportMask.addElement(value);
                }
            }
            return;
        }
        this.stateStack.push(new Integer(0));
    }

    public void handlePluginState(String elementName, Attributes attributes) {
        if (elementName.equals("runtime")) {
            Object whatIsIt = this.objectStack.peek();
            if (whatIsIt instanceof PluginInfo && ((PluginInfo)this.objectStack.peek()).libraries != null) {
                this.stateStack.push(new Integer(0));
                return;
            }
            this.stateStack.push(new Integer(3));
            return;
        }
        if (elementName.equals("requires")) {
            this.stateStack.push(new Integer(4));
            this.objectStack.push(new Vector());
            this.parseRequiresAttributes(attributes);
            return;
        }
        if (elementName.equals("extension-point")) {
            this.stateStack.push(new Integer(5));
            return;
        }
        if (elementName.equals("extension")) {
            this.stateStack.push(new Integer(6));
            return;
        }
        this.stateStack.push(new Integer(0));
    }

    public void handleRequiresImportState(String elementName, Attributes attributes) {
        this.stateStack.push(new Integer(0));
    }

    public void handleRequiresState(String elementName, Attributes attributes) {
        if (elementName.equals("import")) {
            this.parsePluginRequiresImport(attributes);
            return;
        }
        this.stateStack.push(new Integer(0));
    }

    public void handleRuntimeState(String elementName, Attributes attributes) {
        if (elementName.equals("library")) {
            this.stateStack.push(new Integer(7));
            this.parseLibraryAttributes(attributes);
            return;
        }
        this.stateStack.push(new Integer(0));
    }

    private void logStatus(SAXParseException ex) {
        String name = ex.getSystemId();
        if (name == null) {
            name = this.locationName;
        }
        if ((name = name == null ? "" : name.substring(1 + name.lastIndexOf("/"))).equals("")) {
            // empty if block
        }
    }

    public synchronized PluginInfo parsePlugin(String in) throws Exception {
        SAXParserFactory factory = this.acquireXMLParsing();
        if (factory == null) {
            return null;
        }
        try {
            factory.setNamespaceAware(true);
            factory.setFeature("http://xml.org/sax/features/string-interning", true);
            factory.setValidating(false);
            factory.newSAXParser().parse(in, (DefaultHandler)this);
            PluginInfo pluginInfo = this.manifestInfo;
            Object var3_4 = null;
            this.releaseXMLParsing();
            return pluginInfo;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.releaseXMLParsing();
            throw throwable;
        }
    }

    private SAXParserFactory acquireXMLParsing() {
        this.parserReference = this.context.getServiceReference("javax.xml.parsers.SAXParserFactory");
        if (this.parserReference == null) {
            return null;
        }
        return (SAXParserFactory)this.context.getService(this.parserReference);
    }

    private void releaseXMLParsing() {
        if (this.parserReference != null) {
            this.context.ungetService(this.parserReference);
        }
    }

    public void parseFragmentAttributes(Attributes attributes) {
        this.objectStack.push(this.manifestInfo);
        int len = attributes.getLength();
        int i = 0;
        while (i < len) {
            String attrName = attributes.getLocalName(i);
            String attrValue = attributes.getValue(i).trim();
            if (attrName.equals("id")) {
                this.manifestInfo.pluginId = attrValue;
            } else if (attrName.equals("name")) {
                this.manifestInfo.pluginName = attrValue;
            } else if (attrName.equals("version")) {
                this.manifestInfo.version = attrValue;
            } else if (attrName.equals("provider-name")) {
                this.manifestInfo.vendor = attrValue;
            } else if (attrName.equals("plugin-id")) {
                this.manifestInfo.masterPluginId = attrValue;
            } else if (attrName.equals("plugin-version")) {
                this.manifestInfo.masterVersion = attrValue;
            }
            ++i;
        }
    }

    public void parseLibraryAttributes(Attributes attributes) {
        this.objectStack.push(new Vector());
        String current = attributes.getValue("", "name");
        this.objectStack.push(current);
    }

    public void parsePluginAttributes(Attributes attributes) {
        this.objectStack.push(this.manifestInfo);
        int len = attributes.getLength();
        int i = 0;
        while (i < len) {
            String attrName = attributes.getLocalName(i);
            String attrValue = attributes.getValue(i).trim();
            if (attrName.equals("id")) {
                this.manifestInfo.pluginId = attrValue;
            } else if (attrName.equals("name")) {
                this.manifestInfo.pluginName = attrValue;
            } else if (attrName.equals("version")) {
                this.manifestInfo.version = attrValue;
            } else if (attrName.equals("vendor-name") || attrName.equals("provider-name")) {
                this.manifestInfo.vendor = attrValue;
            } else if (attrName.equals("class")) {
                this.manifestInfo.pluginClass = attrValue;
            }
            ++i;
        }
    }

    public void parsePluginRequiresImport(Attributes attributes) {
        String plugin;
        if (this.manifestInfo.requires == null) {
            this.manifestInfo.requires = new ArrayList();
            if (!this.manifestInfo.pluginId.equals("org.eclipse.core.runtime")) {
                this.manifestInfo.requires.add("org.eclipse.core.runtime");
            }
        }
        if ((plugin = attributes.getValue("", "plugin")) == null) {
            return;
        }
        if (plugin.equals("org.eclipse.core.boot") || plugin.equals("org.eclipse.core.runtime")) {
            return;
        }
        String version = attributes.getValue("", "version");
        String optional = attributes.getValue("", "optional");
        String export = attributes.getValue("", "export");
        String match = attributes.getValue("", "match");
        String modImport = plugin;
        if (version != null) {
            modImport = String.valueOf(modImport) + "; bundle-version=" + version;
        }
        if (export != null) {
            modImport = String.valueOf(modImport) + "; provide-packages=" + export;
        }
        if (optional != null) {
            modImport = String.valueOf(modImport) + ";optional=true";
        }
        if (match != null) {
            modImport = String.valueOf(modImport) + ";version-match=";
            if (match.equalsIgnoreCase("perfect")) {
                modImport = String.valueOf(modImport) + "perfect";
            } else if (match.equalsIgnoreCase("equivalent")) {
                modImport = String.valueOf(modImport) + "equivalent";
            } else if (match.equalsIgnoreCase("compatible")) {
                modImport = String.valueOf(modImport) + "compatible";
            } else if (match.equalsIgnoreCase("greaterOrEqual")) {
                modImport = String.valueOf(modImport) + "greaterthan-or-equal";
            }
        }
        this.manifestInfo.requires.add(modImport);
    }

    public void parseRequiresAttributes(Attributes attributes) {
    }

    static String replace(String s, String from, String to) {
        String str = s;
        int fromLen = from.length();
        int toLen = to.length();
        int ix = str.indexOf(from);
        while (ix != -1) {
            str = String.valueOf(str.substring(0, ix)) + to + str.substring(ix + fromLen);
            ix = str.indexOf(from, ix + toLen);
        }
        return str;
    }

    public void startDocument() {
        this.stateStack.push(new Integer(1));
    }

    public void startElement(String uri, String elementName, String qName, Attributes attributes) {
        switch ((Integer)this.stateStack.peek()) {
            case 1: {
                this.handleInitialState(elementName, attributes);
                break;
            }
            case 2: 
            case 11: {
                this.handlePluginState(elementName, attributes);
                break;
            }
            case 3: {
                this.handleRuntimeState(elementName, attributes);
                break;
            }
            case 4: {
                this.handleRequiresState(elementName, attributes);
                break;
            }
            case 5: {
                this.handleExtensionPointState(elementName, attributes);
                break;
            }
            case 6: 
            case 10: {
                this.handleExtensionState(elementName, attributes);
                break;
            }
            case 7: {
                this.handleLibraryState(elementName, attributes);
                break;
            }
            case 8: {
                this.handleLibraryExportState(elementName, attributes);
                break;
            }
            case 9: {
                this.handleRequiresImportState(elementName, attributes);
                break;
            }
            default: {
                this.stateStack.push(new Integer(0));
            }
        }
    }

    public void warning(SAXParseException ex) {
        this.logStatus(ex);
    }

    private void internalError(String message) {
    }

    public void processingInstruction(String target, String data) throws SAXException {
        if (target.equalsIgnoreCase("eclipse")) {
            this.manifestInfo.schemaVersion = "3.0";
            StringTokenizer tokenizer = new StringTokenizer(data, "=\"");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if (!token.equalsIgnoreCase("version")) continue;
                if (!tokenizer.hasMoreTokens()) break;
                this.manifestInfo.schemaVersion = tokenizer.nextToken();
                break;
            }
        }
    }

    public class PluginInfo
    implements IPluginInfo {
        private String schemaVersion;
        private String pluginId;
        private String version;
        private String vendor;
        private ArrayList libraryPaths;
        private Map libraries;
        private ArrayList requires;
        private String pluginClass;
        private String masterPluginId;
        private String masterVersion;
        private Set filters;
        private String pluginName;

        public boolean isFragment() {
            return this.masterPluginId != null;
        }

        public String toString() {
            return "plugin-id: " + this.pluginId + "  version: " + this.version + " libraries: " + this.libraries + " class:" + this.pluginClass + " master: " + this.masterPluginId + " master-version: " + this.masterVersion + " requires: " + this.requires;
        }

        public Map getLibraries() {
            if (this.libraries == null) {
                return new HashMap(0);
            }
            return this.libraries;
        }

        public String[] getRequires() {
            if (this.requires == null) {
                return new String[]{"org.eclipse.core.runtime.compatibility"};
            }
            if (this.schemaVersion == null) {
                int i = 0;
                while (i < this.requires.size()) {
                    if ("org.eclipse.ui".equals(this.requires.get(i))) {
                        this.requires.add(i + 1, "org.eclipse.ui.workbench.texteditor;optional=true");
                        this.requires.add(i + 1, "org.eclipse.jface.text;optional=true");
                        this.requires.add(i + 1, "org.eclipse.ui.editors;optional=true");
                        this.requires.add(i + 1, "org.eclipse.ui.views;optional=true");
                        this.requires.add(i + 1, "org.eclipse.ui.ide;optional=true");
                    } else if ("org.eclipse.help".equals(this.requires.get(i))) {
                        this.requires.add(i + 1, "org.eclipse.help.base;optional=true");
                    }
                    ++i;
                }
            }
            if (!this.requires.contains("org.eclipse.core.runtime.compatibility")) {
                this.requires.add("org.eclipse.core.runtime.compatibility");
            }
            String[] requireBundles = new String[this.requires.size()];
            this.requires.toArray(requireBundles);
            return requireBundles;
        }

        public String getMasterId() {
            return this.masterPluginId;
        }

        public String getMasterVersion() {
            return this.masterVersion;
        }

        public String getPluginClass() {
            return this.pluginClass;
        }

        public String getUniqueId() {
            return this.pluginId;
        }

        public String getVersion() {
            return this.version;
        }

        public Set getPackageFilters() {
            return this.filters;
        }

        public String[] getLibrariesName() {
            if (this.libraryPaths == null) {
                return new String[0];
            }
            return this.libraryPaths.toArray(new String[this.libraryPaths.size()]);
        }

        public String getPluginName() {
            return this.pluginName;
        }

        public String getProviderName() {
            return this.vendor;
        }
    }
}

