/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.adaptor;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.eclipse.core.runtime.adaptor.IPluginInfo;
import org.eclipse.core.runtime.adaptor.PluginParser;
import org.eclipse.osgi.service.pluginconversion.PluginConverter;
import org.osgi.framework.BundleContext;
import org.xml.sax.SAXParseException;

public class PluginConverterImpl
implements PluginConverter {
    private static PluginConverterImpl instance;
    private static final String[] ARCH_LIST;
    private static final String FRAGMENT_MANIFEST = "fragment.xml";
    private static final String GENERATED_FROM = "Generated-from";
    private static final String LEGACY = "Legacy";
    private static final String[] OS_LIST;
    private static final String PI_RUNTIME = "org.eclipse.core.runtime";
    private static final String PLUGIN = "Plugin-Class";
    private static final String PLUGIN_MANIFEST = "plugin.xml";
    private static final String[] WS_LIST;
    private BundleContext context;
    protected String devPathSpec;
    private PrintWriter out;
    private IPluginInfo pluginInfo;
    private File pluginManifestLocation;

    static {
        ARCH_LIST = new String[]{"PA_RISC", "ppc", "sparc", "x86"};
        OS_LIST = new String[]{"aix", "hpux", "linux", "macosx", "qnx", "solaris", "win32"};
        WS_LIST = new String[]{"carbon", "gtk", "motif", "photon", "win32"};
    }

    public static PluginConverterImpl getDefault() {
        return instance;
    }

    PluginConverterImpl(BundleContext context) {
        this.context = context;
        this.devPathSpec = System.getProperty("osgi.dev");
        instance = this;
    }

    private void closeFile() {
        this.out.close();
    }

    public File convertManifest(File pluginBaseLocation) {
        this.pluginManifestLocation = this.findPluginManifest(pluginBaseLocation);
        if (this.pluginManifestLocation == null) {
            return null;
        }
        this.pluginInfo = this.parsePluginInfo(this.pluginManifestLocation);
        if (this.pluginInfo == null) {
            return null;
        }
        String cacheLocation = (String)System.getProperties().get("osgi.manifest.cache");
        File bundleManifestLocation = new File(cacheLocation, String.valueOf(this.pluginInfo.getUniqueId()) + '_' + this.pluginInfo.getVersion() + ".MF");
        this.generate(bundleManifestLocation);
        return bundleManifestLocation;
    }

    public boolean convertManifest(File pluginBaseLocation, File bundleManifestLocation) {
        this.pluginManifestLocation = this.findPluginManifest(pluginBaseLocation);
        if (this.pluginManifestLocation == null) {
            return false;
        }
        this.pluginInfo = this.parsePluginInfo(this.pluginManifestLocation);
        if (this.pluginInfo == null) {
            return false;
        }
        this.generate(bundleManifestLocation);
        return true;
    }

    private Set filterExport(Collection exportToFilter, Collection filter) {
        if (filter == null || filter.contains("*")) {
            return (Set)exportToFilter;
        }
        HashSet<String> filteredExport = new HashSet<String>(exportToFilter.size());
        Iterator iter = exportToFilter.iterator();
        while (iter.hasNext()) {
            String anExport = (String)iter.next();
            Iterator iter2 = filter.iterator();
            while (iter2.hasNext()) {
                String aFilter = (String)iter2.next();
                if (!anExport.startsWith(aFilter)) continue;
                filteredExport.add(anExport);
            }
        }
        return filteredExport;
    }

    private ArrayList findOSJars(File pluginRoot, String path, boolean filter) {
        path = path.substring(4);
        ArrayList<String> found = new ArrayList<String>(0);
        int i = 0;
        while (i < OS_LIST.length) {
            String searchedPath = "os/" + OS_LIST[i] + "/" + path;
            if (new File(pluginRoot, searchedPath).exists()) {
                found.add(String.valueOf(searchedPath) + (filter ? ";(os=" + WS_LIST[i] + ")" : ""));
            }
            int j = 0;
            while (j < ARCH_LIST.length) {
                searchedPath = "os/" + OS_LIST[i] + "/" + ARCH_LIST[j] + "/" + path;
                if (new File(pluginRoot, searchedPath).exists()) {
                    found.add(String.valueOf(searchedPath) + (filter ? ";(& (os=" + WS_LIST[i] + ") (arch=" + ARCH_LIST[j] + ")" : ""));
                }
                ++j;
            }
            ++i;
        }
        return found;
    }

    private File findPluginManifest(File baseLocation) {
        File pluginManifestLocation = new File(baseLocation, PLUGIN_MANIFEST);
        if (pluginManifestLocation.isFile()) {
            return pluginManifestLocation;
        }
        pluginManifestLocation = new File(baseLocation, FRAGMENT_MANIFEST);
        if (pluginManifestLocation.isFile()) {
            return pluginManifestLocation;
        }
        return null;
    }

    private ArrayList findWSJars(File pluginRoot, String path, boolean filter) {
        path = path.substring(4);
        ArrayList<String> found = new ArrayList<String>(0);
        int i = 0;
        while (i < WS_LIST.length) {
            String searchedPath = "ws/" + WS_LIST[i] + path;
            if (new File(pluginRoot, searchedPath).exists()) {
                found.add(String.valueOf(searchedPath) + (filter ? ";(ws=" + WS_LIST[i] + ")" : ""));
            }
            ++i;
        }
        return found;
    }

    protected void generate(File generationLocation) {
        if (this.upToDate(generationLocation, this.pluginManifestLocation)) {
            return;
        }
        this.openFile(generationLocation);
        this.generateTimestamp();
        this.generateHeaders();
        this.generateClasspath();
        this.generateLegacy();
        this.generateActivator();
        this.generatePluginClass();
        this.generateProvidePackage();
        this.generateImports();
        this.generateRequireBundle();
        this.closeFile();
    }

    private void generateActivator() {
        if (!this.pluginInfo.isFragment()) {
            this.writeEntry("Bundle-Activator", "org.eclipse.core.internal.compatibility.PluginActivator");
        }
    }

    private void generateClasspath() {
        String[] libraries = this.pluginInfo.getLibrariesName();
        this.writeEntry("Bundle-ClassPath", libraries);
    }

    private void generateHeaders() {
        this.writeEntry("Bundle-Name", this.pluginInfo.getPluginName());
        this.writeEntry("Bundle-Version", this.pluginInfo.getVersion());
        this.writeEntry("Bundle-GlobalName", this.pluginInfo.getUniqueId());
        this.writeEntry("Bundle-Vendor", this.pluginInfo.getProviderName());
    }

    private void generateImports() {
    }

    private void generateLegacy() {
        this.writeEntry(LEGACY, "true");
    }

    private void generatePluginClass() {
        this.writeEntry(PLUGIN, this.pluginInfo.getPluginClass());
    }

    private void generateProvidePackage() {
        StringBuffer providePackage = new StringBuffer();
        Set exports = this.getExports();
        if (exports != null) {
            Iterator iter = exports.iterator();
            boolean firstPkg = true;
            while (iter.hasNext()) {
                String pkg = (String)iter.next();
                if (firstPkg) {
                    providePackage.append("\n ");
                    firstPkg = false;
                } else {
                    providePackage.append(",\n ");
                }
                providePackage.append(pkg);
            }
            this.writeEntry("Provide-Package", providePackage.toString());
        }
        if (this.pluginInfo.isFragment()) {
            StringBuffer hostBundle = new StringBuffer();
            hostBundle.append(this.pluginInfo.getMasterId()).append("; ");
            hostBundle.append("bundle-version").append("=");
            hostBundle.append(this.pluginInfo.getMasterVersion());
            this.writeEntry("Host-Bundle", hostBundle.toString());
        }
    }

    private void generateRequireBundle() {
        String[] requiredBundles = this.pluginInfo.getRequires();
        if (requiredBundles == null && !this.pluginInfo.getUniqueId().equals(PI_RUNTIME)) {
            requiredBundles = new String[]{PI_RUNTIME};
        }
        this.writeEntry("Require-Bundle", requiredBundles);
    }

    private void generateTimestamp() {
        this.out.println("Generated-from: " + this.pluginManifestLocation.lastModified());
    }

    private Set getExports() {
        Map libs = this.pluginInfo.getLibraries();
        if (libs == null) {
            return null;
        }
        String[] devClassPath = null;
        if (this.devPathSpec != null) {
            Vector<String> tokens = new Vector<String>(6);
            StringTokenizer t = new StringTokenizer(this.devPathSpec, ",");
            while (t.hasMoreTokens()) {
                String token = t.nextToken();
                if (token.equals("")) continue;
                tokens.addElement(token);
            }
            devClassPath = new String[tokens.size()];
            tokens.toArray(devClassPath);
        }
        ArrayList<String> starExport = new ArrayList<String>(1);
        starExport.add("*");
        if (devClassPath != null) {
            int i = 0;
            while (i < devClassPath.length) {
                libs.put(devClassPath[i], starExport);
                ++i;
            }
        }
        HashSet result = new HashSet(7);
        Set libEntries = libs.entrySet();
        Iterator iter = libEntries.iterator();
        while (iter.hasNext()) {
            Set exports;
            block9: {
                List filter;
                Map.Entry element;
                block7: {
                    File libraryLocation;
                    block8: {
                        element = iter.next();
                        filter = (List)element.getValue();
                        if (filter.size() == 0) continue;
                        libraryLocation = new File(this.pluginManifestLocation.getParent(), (String)element.getKey());
                        exports = null;
                        if (!libraryLocation.exists()) break block7;
                        if (!libraryLocation.isFile()) break block8;
                        exports = this.filterExport(this.getExportsFromJAR(libraryLocation), filter);
                        break block9;
                    }
                    if (!libraryLocation.isDirectory()) break block9;
                    exports = this.filterExport(this.getExportsFromDir(libraryLocation), filter);
                    break block9;
                }
                ArrayList expandedLibs = this.getLibrariesExpandingVariables((String)element.getKey(), false);
                exports = new HashSet();
                Iterator iterator = expandedLibs.iterator();
                while (iterator.hasNext()) {
                    String libName = (String)iterator.next();
                    File libFile = new File(this.pluginManifestLocation, libName);
                    if (!libFile.isFile()) continue;
                    exports.addAll(this.filterExport(this.getExportsFromJAR(libFile), filter));
                }
            }
            if (exports == null) continue;
            result.addAll(exports);
        }
        return result;
    }

    private Set getExportsFromDir(File location) {
        return this.getExportsFromDir(location, "");
    }

    private Set getExportsFromDir(File location, String packageName) {
        String prefix = packageName.length() > 0 ? String.valueOf(packageName) + '.' : "";
        File[] files = location.listFiles();
        HashSet<String> exportedPaths = new HashSet<String>();
        boolean containsFile = false;
        int i = 0;
        while (i < files.length) {
            if (!this.isValidPackageName(files[i].getName())) break;
            if (files[i].isDirectory()) {
                exportedPaths.addAll(this.getExportsFromDir(files[i], String.valueOf(prefix) + files[i].getName()));
            } else {
                containsFile = true;
            }
            ++i;
        }
        if (containsFile && packageName.length() > 0) {
            exportedPaths.add(packageName);
        }
        return exportedPaths;
    }

    private Set getExportsFromJAR(File jarFile) {
        HashSet<String> names = new HashSet<String>();
        JarFile file = null;
        try {
            file = new JarFile(jarFile);
        }
        catch (IOException iOException) {
            System.err.println("Ignore " + jarFile);
            return names;
        }
        Enumeration<JarEntry> enumeration = file.entries();
        while (enumeration.hasMoreElements()) {
            JarEntry entry = enumeration.nextElement();
            String name = entry.getName();
            if (!this.isValidPackageName(name)) break;
            int lastSlash = name.lastIndexOf("/");
            if (lastSlash == -1 || lastSlash == name.length() - 1 || name.lastIndexOf(32) != -1) continue;
            names.add(name.substring(0, lastSlash).replace('/', '.'));
        }
        return names;
    }

    private ArrayList getLibrariesExpandingVariables(String libraryPath, boolean filter) {
        String var = this.hasPrefix(libraryPath);
        if (var == null) {
            ArrayList<String> returnValue = new ArrayList<String>(1);
            returnValue.add(libraryPath);
            return returnValue;
        }
        if (var.equals("ws")) {
            return this.findWSJars(this.pluginManifestLocation.getParentFile(), libraryPath, filter);
        }
        if (var.equals("os")) {
            return this.findOSJars(this.pluginManifestLocation, libraryPath, filter);
        }
        return new ArrayList(0);
    }

    private String hasPrefix(String libPath) {
        if (libPath.startsWith("$ws$")) {
            return "ws";
        }
        if (libPath.startsWith("$os$")) {
            return "os";
        }
        if (libPath.startsWith("$nl$")) {
            return "nl";
        }
        return null;
    }

    private boolean isValidPackageName(String name) {
        return name.indexOf(32) <= 0 && !name.equalsIgnoreCase("meta-inf");
    }

    private void openFile(File generationLocation) {
        try {
            generationLocation.getParentFile().mkdirs();
            generationLocation.createNewFile();
        }
        catch (IOException iOException) {
            System.err.println("error creating directory writing manifest for " + this.pluginInfo.getUniqueId());
            return;
        }
        BufferedOutputStream outputFile = null;
        try {
            outputFile = new BufferedOutputStream(new FileOutputStream(generationLocation));
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("error writing manifest for " + this.pluginInfo.getUniqueId());
            return;
        }
        this.out = new PrintWriter(outputFile);
    }

    private IPluginInfo parsePluginInfo(File pluginManifestLocation) {
        try {
            return new PluginParser(this.context).parsePlugin(pluginManifestLocation.toString());
        }
        catch (SAXParseException se) {
            se.printStackTrace();
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * Exception decompiling
     */
    private boolean upToDate(File generationLocation, File pluginLocation) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 79->82)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void writeEntry(String key, Collection value) {
        if (value == null || value.size() == 0) {
            return;
        }
        if (value.size() == 1) {
            this.out.println(String.valueOf(key) + ": " + value.iterator().next());
            return;
        }
        key = String.valueOf(key) + ": ";
        this.out.println(key);
        this.out.print(' ');
        boolean first = true;
        Iterator i = value.iterator();
        while (i.hasNext()) {
            if (first) {
                first = false;
            } else {
                this.out.println(',');
                this.out.print(' ');
            }
            this.out.print(i.next());
        }
        this.out.println();
    }

    private void writeEntry(String key, String value) {
        if (value != null && value.length() > 0) {
            this.out.println(String.valueOf(key) + ": " + value);
        }
    }

    private void writeEntry(String key, String[] value) {
        if (value == null || value.length == 0) {
            return;
        }
        if (value.length == 1) {
            this.out.println(String.valueOf(key) + ": " + value[0]);
            return;
        }
        key = String.valueOf(key) + ": ";
        this.out.println(key);
        this.out.print(' ');
        boolean first = true;
        int i = 0;
        while (i < value.length) {
            if (first) {
                first = false;
            } else {
                this.out.println(',');
                this.out.print(' ');
            }
            this.out.print(value[i]);
            ++i;
        }
        this.out.println();
    }
}

