/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.adaptor;

import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class EnvironmentInfo
implements org.eclipse.osgi.service.environment.EnvironmentInfo {
    private static EnvironmentInfo singleton;
    private static String nl;
    private static String os;
    private static String ws;
    private static String arch;
    static String[] allArgs;
    static String[] frameworkArgs;
    static String[] appArgs;
    private static final String INTERNAL_OS_SUNOS = "SunOS";
    private static final String INTERNAL_ARCH_I386 = "i386";

    private EnvironmentInfo() {
        this.setupSystemContext();
    }

    public static EnvironmentInfo getDefault() {
        if (singleton == null) {
            singleton = new EnvironmentInfo();
        }
        return singleton;
    }

    public boolean inDevelopmentMode() {
        return System.getProperty("osgi.dev") != null;
    }

    public boolean inDebugMode() {
        return System.getProperty("osgi.debug") != null;
    }

    public String[] getAllArgs() {
        return allArgs;
    }

    public String[] getFrameworkArgs() {
        return frameworkArgs;
    }

    public String[] getApplicationArgs() {
        return appArgs;
    }

    public String getOSArch() {
        return arch;
    }

    public String getNL() {
        return nl;
    }

    public String getOS() {
        return os;
    }

    public String getWS() {
        return ws;
    }

    private void setupSystemContext() {
        String name;
        nl = System.getProperty("osgi.nl");
        if (nl != null) {
            StringTokenizer tokenizer = new StringTokenizer(nl, "_");
            int segments = tokenizer.countTokens();
            try {
                switch (segments) {
                    case 2: {
                        Locale userLocale = new Locale(tokenizer.nextToken(), tokenizer.nextToken());
                        Locale.setDefault(userLocale);
                        break;
                    }
                    case 3: {
                        Locale userLocale = new Locale(tokenizer.nextToken(), tokenizer.nextToken(), tokenizer.nextToken());
                        Locale.setDefault(userLocale);
                    }
                }
            }
            catch (NoSuchElementException noSuchElementException) {}
        }
        nl = Locale.getDefault().toString();
        System.getProperties().put("osgi.nl", nl);
        os = System.getProperty("osgi.os");
        if (os == null) {
            name = System.getProperty("os.name");
            if (name.regionMatches(true, 0, "win32", 0, 3)) {
                os = "win32";
            }
            if (os == null) {
                os = name.equalsIgnoreCase(INTERNAL_OS_SUNOS) ? "solaris" : "unknown";
            }
        }
        System.getProperties().put("osgi.os", os);
        ws = System.getProperty("osgi.ws");
        if (ws == null) {
            ws = os.equals("win32") ? "win32" : (os.equals("linux") ? "motif" : (os.equals("macosx") ? "carbon" : (os.equals("hpux") ? "motif" : (os.equals("aix") ? "motif" : (os.equals("solaris") ? "motif" : "unknown")))));
        }
        System.getProperties().put("osgi.ws", ws);
        arch = System.getProperty("osgi.arch");
        if (arch == null) {
            name = System.getProperty("os.arch");
            arch = name.equalsIgnoreCase(INTERNAL_ARCH_I386) ? "x86" : name;
        }
        System.getProperties().put("osgi.arch", arch);
    }
}

