/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.adaptor;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.core.runtime.adaptor.EnvironmentInfo;
import org.eclipse.core.runtime.adaptor.Semaphore;
import org.eclipse.osgi.framework.adaptor.FrameworkAdaptor;
import org.eclipse.osgi.framework.internal.core.OSGi;
import org.eclipse.osgi.framework.tracker.ServiceTracker;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.startlevel.StartLevel;

public class EclipseStarter {
    private static BundleContext context;
    private static String dataLocation;
    private static String configLocation;
    public static boolean DEBUG;
    private static final String CONSOLE = "-console";
    private static final String ARG_DEBUG = "-debug";
    private static final String DEV = "-dev";
    private static final String WS = "-ws";
    private static final String OS = "-os";
    private static final String ARCH = "-arch";
    private static final String NL = "-nl";
    private static final String CONFIGURATION = "-configuration";
    private static final String DATA = "-data";
    public static final String INSTALL_LOCATION = "osgi.installLocation";
    private static final String ECLIPSE = "eclipse";
    private static final String PRODUCT_SITE_MARKER = ".eclipseproduct";
    private static final String PRODUCT_SITE_ID = "id";
    private static final String PRODUCT_SITE_VERSION = "version";
    protected static String adaptorClassName;
    protected static final String consoleClassName = "org.eclipse.osgi.framework.internal.core.FrameworkConsole";
    private static final String CONSOLE_NAME = "OSGi Console";
    private static String consolePort;
    private static boolean console;
    private static ServiceTracker applicationTracker;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;

    static {
        dataLocation = null;
        configLocation = null;
        DEBUG = false;
        adaptorClassName = "org.eclipse.core.runtime.adaptor.EclipseAdaptor";
        consolePort = "";
        console = false;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object run(String[] args, Runnable endSplashHandler) throws Exception {
        EclipseStarter.processCommandLine(args);
        EclipseStarter.setInstanceLocation();
        EclipseStarter.setConfigurationLocation();
        EclipseStarter.loadConfigurationInfo();
        EclipseStarter.loadDefaultProperties();
        FrameworkAdaptor adaptor = EclipseStarter.createAdaptor();
        OSGi osgi = new OSGi(adaptor);
        if (osgi == null) {
            throw new IllegalStateException("OSGi framework could not be started");
        }
        osgi.launch();
        try {
            if (console) {
                EclipseStarter.startConsole(osgi, new String[0]);
            }
            context = osgi.getBundleContext();
            EclipseStarter.publishSplashScreen(endSplashHandler);
            if (EclipseStarter.loadBundles() != null) {
                EclipseStarter.setStartLevel(6);
                EclipseStarter.initializeApplicationTracker();
                Runnable application = (Runnable)applicationTracker.getService();
                applicationTracker.close();
                if (application == null) {
                    throw new IllegalStateException("Unable to acquire application service");
                }
                application.run();
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            EclipseStarter.stopSystemBundle();
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        EclipseStarter.stopSystemBundle();
        String exitCode = System.getProperty("eclipse.exitcode");
        if (exitCode == null) {
            System.exit(0);
        }
        try {
            System.exit(Integer.parseInt(exitCode));
            return null;
        }
        catch (NumberFormatException numberFormatException) {
            System.exit(13);
        }
        return null;
    }

    private static void publishSplashScreen(Runnable endSplashHandler) {
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("name", "splashscreen");
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[Ljava.lang.Runnable;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        context.registerService(clazz.getName(), (Object)endSplashHandler, properties);
    }

    private static String searchForBundle(String name, String parent) throws MalformedURLException {
        Object result;
        URL url = null;
        File fileLocation = null;
        boolean reference = false;
        try {
            url = new URL(name);
        }
        catch (MalformedURLException malformedURLException) {
            fileLocation = new File(parent, name);
            url = new URL("reference:file:" + parent + "/" + name);
            reference = true;
        }
        if (!reference) {
            URL baseURL = url;
            if (url.getProtocol().equals("reference")) {
                reference = true;
                baseURL = new URL(url.getFile());
            }
            if (!(fileLocation = new File(baseURL.getFile())).isAbsolute()) {
                fileLocation = new File(parent, fileLocation.toString());
            }
        }
        if (reference) {
            result = EclipseStarter.searchFor(fileLocation.getName(), fileLocation.getParentFile().getAbsolutePath());
            if (result != null) {
                url = new URL("reference", null, "file:" + (String)result);
            } else {
                return null;
            }
        }
        try {
            result = url.openConnection();
            ((URLConnection)result).connect();
            return url.toExternalForm();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static String[] loadBundles() {
        long startTime = System.currentTimeMillis();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("[Lorg.osgi.service.startlevel.StartLevel;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ServiceReference reference = context.getServiceReference(clazz.getName());
        StartLevel start = null;
        if (reference != null) {
            start = (StartLevel)context.getService(reference);
        }
        String[] bundles = EclipseStarter.getArrayFromList(System.getProperty("osgi.bundles"));
        String syspath = EclipseStarter.getSysPath();
        Vector<Bundle> installed = new Vector<Bundle>();
        Vector<String> ignored = new Vector<String>();
        int i = 0;
        while (i < bundles.length) {
            String name = bundles[i];
            if (name != null) {
                try {
                    String location;
                    int level = -1;
                    int index = name.indexOf(64);
                    if (index >= 0) {
                        String levelString = name.substring(index + 1, name.length());
                        level = Integer.parseInt(levelString);
                        name = name.substring(0, index);
                    }
                    if ((location = EclipseStarter.searchForBundle(name, syspath)) != null && !EclipseStarter.isInstalled(location)) {
                        Bundle bundle = context.installBundle(location);
                        if (level >= 0 && start != null) {
                            start.setBundleStartLevel(bundle, level);
                        }
                        installed.addElement(bundle);
                    } else {
                        ignored.addElement(name);
                    }
                }
                catch (Exception ex) {
                    System.err.println("Cannot install/find: " + name);
                    ex.printStackTrace();
                    ignored.addElement(name);
                    return null;
                }
            }
            ++i;
        }
        EclipseStarter.refreshPackages(installed.toArray(new Bundle[installed.size()]));
        Enumeration e = installed.elements();
        while (e.hasMoreElements()) {
            Bundle bundle = (Bundle)e.nextElement();
            try {
                bundle.start();
            }
            catch (BundleException ex) {
                System.out.println("Error starting " + bundle.getLocation());
                ex.printStackTrace();
            }
        }
        context.ungetService(reference);
        if (DEBUG) {
            System.out.println("Time loadBundles in the framework: " + (System.currentTimeMillis() - startTime));
        }
        return ignored.toArray(new String[ignored.size()]);
    }

    private static void refreshPackages(Bundle[] bundles) {
        if (bundles.length == 0) {
            return;
        }
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("[Lorg.osgi.service.packageadmin.PackageAdmin;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ServiceReference packageAdminRef = context.getServiceReference(clazz.getName());
        PackageAdmin packageAdmin = null;
        if (packageAdminRef != null && (packageAdmin = (PackageAdmin)context.getService(packageAdminRef)) == null) {
            return;
        }
        final Semaphore semaphore = new Semaphore(0);
        FrameworkListener listener = new FrameworkListener(){

            public void frameworkEvent(FrameworkEvent event) {
                if (event.getType() == 4) {
                    semaphore.release();
                }
            }
        };
        context.addFrameworkListener(listener);
        packageAdmin.refreshPackages(bundles);
        semaphore.acquire();
        context.removeFrameworkListener(listener);
        context.ungetService(packageAdminRef);
    }

    private static void startConsole(OSGi osgi, String[] consoleArgs) {
        try {
            Object[] parameters;
            Class[] parameterTypes;
            Class<?> consoleClass = Class.forName(consoleClassName);
            if (consolePort.length() == 0) {
                Class[] classArray = new Class[2];
                Class<?> clazz = class$3;
                if (clazz == null) {
                    try {
                        clazz = class$3 = Class.forName("[Lorg.eclipse.osgi.framework.internal.core.OSGi;").getComponentType();
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[0] = clazz;
                Class<?> clazz2 = class$4;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$4 = Class.forName("[Ljava.lang.String;");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[1] = clazz2;
                parameterTypes = classArray;
                parameters = new Object[]{osgi, consoleArgs};
            } else {
                Class[] classArray = new Class[3];
                Class<?> clazz = class$3;
                if (clazz == null) {
                    try {
                        clazz = class$3 = Class.forName("[Lorg.eclipse.osgi.framework.internal.core.OSGi;").getComponentType();
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[0] = clazz;
                classArray[1] = Integer.TYPE;
                Class<?> clazz3 = class$4;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$4 = Class.forName("[Ljava.lang.String;");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[2] = clazz3;
                parameterTypes = classArray;
                parameters = new Object[]{osgi, new Integer(consolePort), consoleArgs};
            }
            Constructor<?> constructor = consoleClass.getConstructor(parameterTypes);
            Object console = constructor.newInstance(parameters);
            Thread t = new Thread((Runnable)console, CONSOLE_NAME);
            t.start();
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println("Invalid console port: " + consolePort);
        }
        catch (Exception exception) {
            System.out.println("Failed to find/start: OSGi Console");
        }
    }

    private static FrameworkAdaptor createAdaptor() throws Exception {
        Class<?> adaptorClass = Class.forName(adaptorClassName);
        Class[] classArray = new Class[1];
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("[Ljava.lang.String;");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class[] constructorArgs = classArray;
        Constructor<?> constructor = adaptorClass.getConstructor(constructorArgs);
        return (FrameworkAdaptor)constructor.newInstance(new Object[]{new String[0]});
    }

    private static String[] processCommandLine(String[] args) throws Exception {
        EnvironmentInfo.allArgs = args;
        int[] configArgs = new int[100];
        configArgs[0] = -1;
        int configArgIndex = 0;
        int i = 0;
        while (i < args.length) {
            boolean found = false;
            if (args[i].equalsIgnoreCase(DEV) && (i + 1 == args.length || i + 1 < args.length && args[i + 1].startsWith("-"))) {
                System.getProperties().put("osgi.dev", "");
                found = true;
            } else if (args[i].equalsIgnoreCase(CONSOLE) && (i + 1 == args.length || i + 1 < args.length && args[i + 1].startsWith("-"))) {
                console = true;
                found = true;
            } else if (found) {
                configArgs[configArgIndex++] = i;
            } else if (i != args.length - 1 && !args[i + 1].startsWith("-")) {
                String arg = args[++i];
                if (args[i - 1].equalsIgnoreCase(CONSOLE)) {
                    console = true;
                    consolePort = arg;
                    found = true;
                } else if (args[i - 1].equalsIgnoreCase(CONFIGURATION)) {
                    configLocation = arg;
                } else if (args[i - 1].equalsIgnoreCase(DEV)) {
                    System.getProperties().put("osgi.dev", arg);
                    found = true;
                } else if (args[i - 1].equalsIgnoreCase(DATA)) {
                    dataLocation = arg;
                } else if (args[i - 1].equalsIgnoreCase(ARG_DEBUG)) {
                    System.getProperties().put("osgi.debug", arg);
                    DEBUG = true;
                    found = true;
                } else {
                    if (args[i - 1].equalsIgnoreCase(WS)) {
                        found = true;
                        System.getProperties().put("osgi.ws", arg);
                    }
                    if (args[i - 1].equalsIgnoreCase(OS)) {
                        found = true;
                        System.getProperties().put("osgi.os", arg);
                    }
                    if (args[i - 1].equalsIgnoreCase(ARCH)) {
                        found = true;
                        System.getProperties().put("osgi.arch", arg);
                    }
                    if (args[i - 1].equalsIgnoreCase(NL)) {
                        found = true;
                        System.getProperties().put("osgi.nl", arg);
                    }
                    if (found) {
                        configArgs[configArgIndex++] = i - 1;
                        configArgs[configArgIndex++] = i;
                    }
                }
            }
            ++i;
        }
        if (configArgIndex == 0) {
            EnvironmentInfo.frameworkArgs = new String[0];
            EnvironmentInfo.appArgs = args;
            return args;
        }
        EnvironmentInfo.appArgs = new String[args.length - configArgIndex];
        EnvironmentInfo.frameworkArgs = new String[configArgIndex];
        configArgIndex = 0;
        int j = 0;
        int k = 0;
        int i2 = 0;
        while (i2 < args.length) {
            if (i2 == configArgs[configArgIndex]) {
                EnvironmentInfo.frameworkArgs[k++] = args[i2];
                ++configArgIndex;
            } else {
                EnvironmentInfo.appArgs[j++] = args[i2];
            }
            ++i2;
        }
        return EnvironmentInfo.appArgs;
    }

    private static String[] getArrayFromList(String prop) {
        if (prop == null || prop.trim().equals("")) {
            return new String[0];
        }
        Vector<String> list = new Vector<String>();
        StringTokenizer tokens = new StringTokenizer(prop, ",");
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken().trim();
            if (token.equals("")) continue;
            list.addElement(token);
        }
        return list.isEmpty() ? new String[]{} : list.toArray(new String[list.size()]);
    }

    protected static String getSysPath() {
        URL url;
        String result = System.getProperty("osgi.syspath");
        if (result != null) {
            return result;
        }
        Class<?> clazz = class$6;
        if (clazz == null) {
            try {
                clazz = class$6 = Class.forName("[Lorg.eclipse.core.runtime.adaptor.EclipseStarter;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((result = (url = clazz.getProtectionDomain().getCodeSource().getLocation()).getFile()).endsWith("/")) {
            result = result.substring(0, result.length() - 1);
        }
        result = result.substring(0, result.lastIndexOf(47));
        if (Character.isUpperCase((result = result.substring(0, result.lastIndexOf(47))).charAt(0))) {
            char[] chars = result.toCharArray();
            chars[0] = Character.toLowerCase(chars[0]);
            result = new String(chars);
        }
        return result;
    }

    private static void setInstanceLocation() {
        File result = null;
        String location = System.getProperty("osgi.instance.area");
        if (location == null) {
            result = dataLocation == null ? new File(System.getProperty("user.dir"), "workspace") : new File(dataLocation);
            result = new File(result, ".metadata/bundles");
        } else {
            result = new File(location);
        }
        System.getProperties().put("osgi.instance.area", result.getAbsolutePath());
        System.getProperties().put("org.eclipse.osgi.framework.defaultadaptor.bundledir", result.getAbsolutePath());
    }

    private static void setConfigurationLocation() {
        String location = System.getProperty("osgi.configuration.area");
        if (location != null) {
            configLocation = location;
            if (System.getProperty("osgi.manifest.cache") == null) {
                System.getProperties().put("osgi.manifest.cache", String.valueOf(configLocation) + "/manifests");
            }
            return;
        }
        if (configLocation == null) {
            configLocation = String.valueOf(EclipseStarter.getDefaultConfigurationLocation()) + "/.config";
        } else {
            try {
                configLocation = new URL(configLocation).getFile();
            }
            catch (MalformedURLException malformedURLException) {}
            configLocation = configLocation.replace('\\', '/');
            int index = configLocation.lastIndexOf(47);
            if (configLocation.endsWith(".cfg") || configLocation.endsWith("/")) {
                configLocation = configLocation.substring(0, index);
            }
        }
        System.getProperties().put("osgi.configuration.area", configLocation);
        if (System.getProperty("osgi.manifest.cache") == null) {
            System.getProperties().put("osgi.manifest.cache", String.valueOf(configLocation) + "/manifests");
        }
    }

    private static boolean isInstalled(String location) {
        Bundle[] installed = context.getBundles();
        int i = 0;
        while (i < installed.length) {
            Bundle bundle = installed[i];
            if (location.equalsIgnoreCase(bundle.getLocation())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static String getDefaultConfigurationLocation() {
        String installProperty = System.getProperty(INSTALL_LOCATION);
        URL installURL = null;
        try {
            installURL = new URL(installProperty);
        }
        catch (MalformedURLException malformedURLException) {}
        File installDir = new File(installURL.getFile());
        if ("file".equals(installURL.getProtocol()) && installDir.canWrite()) {
            return installDir.getAbsolutePath();
        }
        String appName = ".eclipse";
        File eclipseProduct = new File(installDir, PRODUCT_SITE_MARKER);
        if (eclipseProduct.exists()) {
            Properties props = new Properties();
            try {
                String appVersion;
                props.load(new FileInputStream(eclipseProduct));
                String appId = props.getProperty(PRODUCT_SITE_ID);
                if (appId == null || appId.trim().length() == 0) {
                    appId = ECLIPSE;
                }
                if ((appVersion = props.getProperty(PRODUCT_SITE_VERSION)) == null || appVersion.trim().length() == 0) {
                    appVersion = "";
                }
                appName = String.valueOf(appName) + File.separator + appId + "_" + appVersion;
            }
            catch (IOException iOException) {}
        }
        String userHome = System.getProperty("user.home");
        File configDir = new File(userHome, appName);
        configDir.mkdirs();
        return configDir.getAbsolutePath();
    }

    private static void initializeApplicationTracker() {
        Filter filter = null;
        try {
            filter = context.createFilter("(&(objectClass=java.lang.Runnable)(eclipse.application=*))");
        }
        catch (InvalidSyntaxException invalidSyntaxException) {}
        applicationTracker = new ServiceTracker(context, filter, null);
        applicationTracker.open();
    }

    private static void loadConfigurationInfo() {
        String configArea = System.getProperty("osgi.configuration.area");
        if (configArea == null) {
            return;
        }
        File location = new File(configArea, "config.ini");
        EclipseStarter.mergeProperties(System.getProperties(), EclipseStarter.loadProperties(location));
    }

    private static void loadDefaultProperties() {
        URL codeLocation;
        Class<?> clazz = class$6;
        if (clazz == null) {
            try {
                clazz = class$6 = Class.forName("[Lorg.eclipse.core.runtime.adaptor.EclipseStarter;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((codeLocation = clazz.getProtectionDomain().getCodeSource().getLocation()) == null) {
            return;
        }
        String frameworkLocation = codeLocation.getFile();
        File location = new File(new File(frameworkLocation).getParentFile(), "eclipse.properties");
        EclipseStarter.mergeProperties(System.getProperties(), EclipseStarter.loadProperties(location));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Properties loadProperties(File location) {
        Properties result = new Properties();
        try {
            FileInputStream in = new FileInputStream(location);
            try {
                result.load(in);
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                ((InputStream)in).close();
                throw throwable;
            }
            {
                Object var3_6 = null;
                ((InputStream)in).close();
                return result;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            return result;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    private static void mergeProperties(Properties destination, Properties source) {
        Enumeration<Object> e = source.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = source.getProperty(key);
            if (destination.getProperty(key) != null) continue;
            destination.put(key, value);
        }
    }

    private static void stopSystemBundle() throws BundleException {
        Bundle systemBundle = context.getBundle(0L);
        if (systemBundle.getState() == 32) {
            final Semaphore semaphore = new Semaphore(0);
            FrameworkListener listener = new FrameworkListener(){

                public void frameworkEvent(FrameworkEvent event) {
                    if (event.getType() == 8) {
                        semaphore.release();
                    }
                }
            };
            context.addFrameworkListener(listener);
            systemBundle.stop();
            semaphore.acquire();
            context.removeFrameworkListener(listener);
        }
    }

    private static void setStartLevel(final int value) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("[Lorg.osgi.service.startlevel.StartLevel;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ServiceTracker tracker = new ServiceTracker(context, clazz.getName(), null);
        tracker.open();
        final StartLevel startLevel = (StartLevel)tracker.getService();
        final Semaphore semaphore = new Semaphore(0);
        FrameworkListener listener = new FrameworkListener(){

            public void frameworkEvent(FrameworkEvent event) {
                if (event.getType() == 8 && startLevel.getStartLevel() == value) {
                    semaphore.release();
                }
            }
        };
        context.addFrameworkListener(listener);
        startLevel.setStartLevel(value);
        semaphore.acquire();
        context.removeFrameworkListener(listener);
        tracker.close();
    }

    private static String searchFor(final String target, String start) {
        FileFilter filter = new FileFilter(){

            public boolean accept(File candidate) {
                return candidate.isDirectory() && (candidate.getName().equals(target) || candidate.getName().startsWith(String.valueOf(target) + "_"));
            }
        };
        File[] candidates = new File(start).listFiles(filter);
        if (candidates == null) {
            return null;
        }
        String result = null;
        Object[] maxVersion = null;
        int i = 0;
        while (i < candidates.length) {
            String name = candidates[i].getName();
            String version = "";
            int index = name.indexOf(95);
            if (index != -1) {
                version = name.substring(index + 1);
            }
            Object[] currentVersion = EclipseStarter.getVersionElements(version);
            if (maxVersion == null) {
                result = candidates[i].getAbsolutePath();
                maxVersion = currentVersion;
            } else if (EclipseStarter.compareVersion(maxVersion, currentVersion) < 0) {
                result = candidates[i].getAbsolutePath();
                maxVersion = currentVersion;
            }
            ++i;
        }
        if (result == null) {
            return null;
        }
        return String.valueOf(result.replace(File.separatorChar, '/')) + "/";
    }

    private static Object[] getVersionElements(String version) {
        Object[] result = new Object[]{new Integer(0), new Integer(0), new Integer(0), ""};
        StringTokenizer t = new StringTokenizer(version, ".");
        int i = 0;
        while (t.hasMoreTokens() && i < 4) {
            String token = t.nextToken();
            if (i < 3) {
                try {
                    result[i++] = new Integer(token);
                    continue;
                }
                catch (Exception exception) {
                    break;
                }
            }
            result[i++] = token;
        }
        return result;
    }

    private static int compareVersion(Object[] left, Object[] right) {
        int result = ((Integer)left[0]).compareTo((Integer)right[0]);
        if (result != 0) {
            return result;
        }
        result = ((Integer)left[1]).compareTo((Integer)right[1]);
        if (result != 0) {
            return result;
        }
        result = ((Integer)left[2]).compareTo((Integer)right[2]);
        if (result != 0) {
            return result;
        }
        return ((String)left[3]).compareTo((String)right[3]);
    }
}

