/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.adaptor;

import java.net.URL;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import org.eclipse.core.runtime.adaptor.EclipseAdaptor;
import org.eclipse.osgi.framework.adaptor.BundleData;
import org.eclipse.osgi.framework.adaptor.ClassLoaderDelegate;
import org.eclipse.osgi.framework.internal.core.Msg;
import org.eclipse.osgi.framework.internal.defaultadaptor.DefaultBundleData;
import org.eclipse.osgi.framework.internal.defaultadaptor.DefaultClassLoader;
import org.eclipse.osgi.framework.stats.ClassloaderStats;
import org.eclipse.osgi.framework.stats.ResourceBundleStats;
import org.osgi.framework.BundleException;

public class EclipseClassLoader
extends DefaultClassLoader {
    private static String[] NL_JAR_VARIANTS = EclipseClassLoader.buildNLJarVariants(System.getProperties().getProperty("osgi.nl"));
    private boolean autoActivate = true;

    public EclipseClassLoader(ClassLoaderDelegate delegate, ProtectionDomain domain, String[] classpath, BundleData bundledata) {
        super(delegate, domain, classpath, (DefaultBundleData)bundledata);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Class findLocalClass(String name) throws ClassNotFoundException {
        Class clazz;
        if (EclipseAdaptor.MONITOR_CLASSES) {
            ClassloaderStats.startLoadingClass(this.getClassloaderId(), name);
        }
        boolean found = true;
        try {
            try {
                if (this.autoActivate) {
                    int state = this.hostdata.getBundle().getState();
                    if (state != 8 && state != 32) {
                        try {
                            this.hostdata.getBundle().start();
                        }
                        catch (BundleException bundleException) {}
                    }
                    this.autoActivate = false;
                }
                clazz = super.findLocalClass(name);
                Object var4_6 = null;
                if (!EclipseAdaptor.MONITOR_CLASSES) return clazz;
            }
            catch (ClassNotFoundException e) {
                found = false;
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            if (!EclipseAdaptor.MONITOR_CLASSES) throw throwable;
            ClassloaderStats.endLoadingClass(this.getClassloaderId(), name, found);
            throw throwable;
        }
        ClassloaderStats.endLoadingClass(this.getClassloaderId(), name, found);
        return clazz;
    }

    private String getClassloaderId() {
        return this.hostdata.getBundle().getGlobalName();
    }

    public URL getResouce(String name) {
        URL result = super.getResource(name);
        if (EclipseAdaptor.MONITOR_RESOURCE_BUNDLES && result != null && name.endsWith(".properties")) {
            ClassloaderStats.loadedBundle(this.getClassloaderId(), new ResourceBundleStats(this.getClassloaderId(), name, result));
        }
        return result;
    }

    protected void findClassPathEntry(ArrayList result, String entry, DefaultBundleData bundledata, ProtectionDomain domain) {
        String var = this.hasPrefix(entry);
        if (var == null) {
            super.findClassPathEntry(result, entry, bundledata, domain);
            return;
        }
        if (var.equals("ws")) {
            super.findClassPathEntry(result, "ws/" + System.getProperties().getProperty("osgi.ws") + "/" + entry.substring(4), bundledata, domain);
            return;
        }
        if (var.equals("os")) {
            super.findClassPathEntry(result, "os/" + System.getProperties().getProperty("osgi.os") + "/" + entry.substring(4), bundledata, domain);
            return;
        }
        if (var.equals("nl")) {
            entry = entry.substring(4);
            int i = 0;
            while (i < NL_JAR_VARIANTS.length) {
                if (this.addClassPathEntry(result, "nl/" + NL_JAR_VARIANTS[i] + "/" + entry, bundledata, domain)) {
                    return;
                }
                ++i;
            }
            BundleException be = new BundleException(Msg.formatter.getString("BUNDLE_CLASSPATH_ENTRY_NOT_FOUND_EXCEPTION", (Object)entry));
            bundledata.getAdaptor().getEventPublisher().publishFrameworkEvent(2, bundledata.getBundle(), (Throwable)be);
        }
    }

    private static String[] buildNLJarVariants(String nl) {
        ArrayList<String> result = new ArrayList<String>();
        nl = nl.replace('_', '/');
        while (nl.length() > 0) {
            result.add("nl/" + nl + "/");
            int i = nl.lastIndexOf(47);
            String string = nl = i < 0 ? "" : nl.substring(0, i);
        }
        result.add("");
        return result.toArray(new String[result.size()]);
    }

    private String hasPrefix(String libPath) {
        if (libPath.startsWith("$ws$")) {
            return "ws";
        }
        if (libPath.startsWith("$os$")) {
            return "os";
        }
        if (libPath.startsWith("$nl$")) {
            return "nl";
        }
        return null;
    }
}

