/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.adaptor;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Dictionary;
import org.eclipse.core.runtime.adaptor.CachedManifest;
import org.eclipse.core.runtime.adaptor.EclipseAdaptor;
import org.eclipse.core.runtime.adaptor.EnvironmentInfo;
import org.eclipse.core.runtime.adaptor.PluginConverterImpl;
import org.eclipse.osgi.framework.adaptor.Version;
import org.eclipse.osgi.framework.internal.defaultadaptor.AdaptorMsg;
import org.eclipse.osgi.framework.internal.defaultadaptor.BundleFile;
import org.eclipse.osgi.framework.internal.defaultadaptor.DefaultAdaptor;
import org.eclipse.osgi.framework.internal.defaultadaptor.DefaultBundleData;
import org.eclipse.osgi.framework.util.Headers;
import org.osgi.framework.BundleException;

public class EclipseBundleData
extends DefaultBundleData {
    private URL base;
    private static String[] libraryVariants = null;
    public static final String PROTOCOL = "platform";
    public static final String FILE = "file";
    protected String isLegacy = null;
    protected String pluginClass = null;

    private static String[] buildLibraryVariants() {
        ArrayList<String> result = new ArrayList<String>();
        EnvironmentInfo info = EnvironmentInfo.getDefault();
        result.add("ws/" + info.getWS() + "/");
        result.add("os/" + info.getOS() + "/" + info.getOSArch() + "/");
        result.add("os/" + info.getOS() + "/");
        String nl = info.getNL();
        nl = nl.replace('_', '/');
        while (nl.length() > 0) {
            result.add("nl/" + nl + "/");
            int i = nl.lastIndexOf(47);
            String string = nl = i < 0 ? "" : nl.substring(0, i);
        }
        result.add("");
        return result.toArray(new String[result.size()]);
    }

    public EclipseBundleData(DefaultAdaptor adaptor) throws IOException {
        super(adaptor);
    }

    public void initializeNewBundle(long id, String location, InputStream in) throws IOException {
        this.id = id;
        this.location = location;
        this.name = this.adaptor.mapLocationToName(location);
        this.reference = false;
        this.dir = new File(((EclipseAdaptor)this.adaptor).getBundleRootDir(), String.valueOf(id));
        this.dirData = new File(this.dir, ((EclipseAdaptor)this.adaptor).getDataDirName());
        this.dirGeneration = new File(this.dir, String.valueOf(this.generation));
        this.file = new File(this.dirGeneration, this.name);
        this.setStartLevel(this.adaptor.getInitialBundleStartLevel());
        if (!this.getGenerationDir().exists()) {
            throw new IOException(AdaptorMsg.formatter.getString("ADAPTOR_DIRECTORY_CREATE_EXCEPTION", (Object)this.dirGeneration.getPath()));
        }
        DefaultAdaptor.readFile((InputStream)in, (File)this.file);
        this.bundleFile = BundleFile.createBundleFile((File)this.file, (DefaultBundleData)this);
        this.loadFromManifest();
        this.initializeBase(location);
    }

    public void initializeReferencedBundle(long id, String location, String name) throws IOException {
        this.id = id;
        this.location = location;
        this.name = name;
        this.reference = true;
        this.dir = new File(((EclipseAdaptor)this.adaptor).getBundleRootDir(), String.valueOf(id));
        this.dirData = new File(this.dir, ((EclipseAdaptor)this.adaptor).getDataDirName());
        this.dirGeneration = new File(this.dir, String.valueOf(this.generation));
        this.file = new File(name);
        this.setStartLevel(this.adaptor.getInitialBundleStartLevel());
        this.bundleFile = BundleFile.createBundleFile((File)this.file, (DefaultBundleData)this);
        this.loadFromManifest();
        this.initializeBase(location);
    }

    public void initializeExistingBundle(String directory) throws IOException {
        this.id = Long.parseLong(directory);
        this.dir = new File(((EclipseAdaptor)this.adaptor).getBundleRootDir(), String.valueOf(this.id));
        this.dirData = new File(this.dir, ((EclipseAdaptor)this.adaptor).getDataDirName());
        this.dirGeneration = new File(this.dir, String.valueOf(this.generation));
        this.file = this.reference ? new File(this.name) : new File(this.dirGeneration, this.name);
        this.bundleFile = BundleFile.createBundleFile((File)this.file, (DefaultBundleData)this);
        this.initializeBase(this.location);
    }

    void initialize() throws IOException {
        this.initializeBase(this.location);
        this.dir = new File(((EclipseAdaptor)this.adaptor).getBundleRootDir(), Long.toString(this.id));
        File delete = new File(this.dir, ".delete");
        if (delete.exists()) {
            throw new NumberFormatException();
        }
        this.dirData = new File(this.dir, ((EclipseAdaptor)this.adaptor).getDataDirName());
        this.dirGeneration = new File(this.dir, String.valueOf(this.generation));
        this.file = this.reference ? new File(this.name) : new File(this.dirGeneration, this.name);
        this.bundleFile = BundleFile.createBundleFile((File)this.file, (DefaultBundleData)this);
    }

    private void initializeBase(String location) throws IOException {
        if (!location.endsWith("/")) {
            location = String.valueOf(location) + "/";
        }
        try {
            this.base = new URL(location);
            if (this.base.getProtocol().equals("reference")) {
                this.base = new URL(this.base.getFile());
            }
        }
        catch (MalformedURLException malformedURLException) {
            this.base = null;
        }
    }

    public String findLibrary(String libName) {
        URL foundPath;
        URL[] searchList;
        String result = super.findLibrary(libName);
        if (result != null) {
            return result;
        }
        if (libraryVariants == null) {
            libraryVariants = EclipseBundleData.buildLibraryVariants();
        }
        if (libName.length() == 0) {
            return null;
        }
        if (libName.charAt(0) == '/' || libName.charAt(0) == '\\') {
            libName = libName.substring(1);
        }
        libName = System.mapLibraryName(libName);
        if (this.base == null) {
            return null;
        }
        String libFileName = null;
        if (this.base.getProtocol().equals(FILE)) {
            URL foundPath2 = this.searchVariants(new URL[]{this.base}, libraryVariants, libName);
            if (foundPath2 != null) {
                libFileName = foundPath2.getFile();
            }
        } else if (this.base.getProtocol().equals(PROTOCOL) && (searchList = this.getSearchURLs(this.base)) != null && searchList.length != 0 && (foundPath = this.searchVariants(searchList, libraryVariants, libName)) != null) {
            libFileName = foundPath.getFile();
        }
        if (libFileName == null) {
            return null;
        }
        return new File(libFileName).getAbsolutePath();
    }

    private URL searchVariants(URL[] basePaths, String[] variants, String path) {
        int i = 0;
        while (i < variants.length) {
            int j = 0;
            while (j < basePaths.length) {
                String fileName = String.valueOf(basePaths[j].getFile()) + variants[i] + path;
                File file = new File(fileName);
                if (file.exists()) {
                    try {
                        return new URL("file:" + fileName);
                    }
                    catch (MalformedURLException malformedURLException) {}
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    private URL[] getSearchURLs(URL target) {
        return new URL[]{target};
    }

    public synchronized Dictionary getManifest() {
        try {
            return this.getManifest(false);
        }
        catch (BundleException bundleException) {
            return null;
        }
    }

    public synchronized Dictionary getManifest(boolean first) throws BundleException {
        if (this.manifest == null) {
            this.manifest = first ? this.loadManifest() : new CachedManifest(this);
        }
        return this.manifest;
    }

    public synchronized Dictionary loadManifest() throws BundleException {
        URL url = this.getEntry("META-INF/MANIFEST.MF");
        if (url != null) {
            return this.loadManifestFrom(url);
        }
        Dictionary result = this.generateManifest();
        if (result == null) {
            throw new BundleException("Manifest not found: " + this.getLocation());
        }
        return result;
    }

    private Dictionary generateManifest() throws BundleException {
        PluginConverterImpl converter = PluginConverterImpl.getDefault();
        File location = converter.convertManifest(this.file);
        if (location == null) {
            return null;
        }
        try {
            return this.loadManifestFrom(location.toURL());
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    private Dictionary loadManifestFrom(URL manifestURL) throws BundleException {
        try {
            return Headers.parseManifest((InputStream)manifestURL.openStream());
        }
        catch (IOException e) {
            throw new BundleException("Error reading manifest: " + this.getLocation(), (Throwable)e);
        }
    }

    public void save() {
    }

    protected void loadMetaData() {
    }

    protected void loadFromMetaData() {
    }

    protected void loadFromManifest() throws IOException {
        try {
            this.getManifest(true);
        }
        catch (BundleException bundleException) {
            throw new IOException("Unable to properly read manifest for: " + this.location);
        }
        super.loadFromManifest();
        this.pluginClass = (String)this.manifest.get("Plugin-Class");
        this.isLegacy = (String)this.manifest.get("Legacy");
    }

    public String isLegacy() {
        return this.isLegacy;
    }

    public void setLegacy(String value) {
        this.isLegacy = value;
    }

    public String getPluginClass() {
        return this.pluginClass;
    }

    public void setPluginClass(String value) {
        this.pluginClass = value;
    }

    public void setLocation(String value) {
        this.location = value;
    }

    public void setName(String value) {
        this.name = value;
    }

    public void setUniqueId(String value) {
        this.uniqueId = value;
    }

    public void setVersion(Version value) {
        this.version = value;
    }

    public void setActivator(String value) {
        this.activator = value;
    }

    public void setClassPath(String value) {
        this.classpath = value;
    }

    public void setFragment(boolean value) {
        this.isFragment = value;
    }

    public void setExecutionEnvironment(String value) {
        this.executionEnvironment = value;
    }

    public void setDynamicImports(String value) {
        this.dynamicImports = value;
    }
}

