/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.adaptor;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.adaptor.EclipseBundleData;
import org.eclipse.core.runtime.adaptor.EclipseElementFactory;
import org.eclipse.core.runtime.adaptor.EclipseStarter;
import org.eclipse.core.runtime.adaptor.EnvironmentInfo;
import org.eclipse.core.runtime.adaptor.PluginConverterImpl;
import org.eclipse.osgi.framework.adaptor.BundleData;
import org.eclipse.osgi.framework.adaptor.IBundleStats;
import org.eclipse.osgi.framework.adaptor.Version;
import org.eclipse.osgi.framework.adaptor.core.AbstractFrameworkAdaptor;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.debug.DebugOptions;
import org.eclipse.osgi.framework.internal.defaultadaptor.AdaptorElementFactory;
import org.eclipse.osgi.framework.internal.defaultadaptor.DefaultAdaptor;
import org.eclipse.osgi.framework.internal.defaultadaptor.DefaultBundleData;
import org.eclipse.osgi.framework.stats.StatsManager;
import org.eclipse.osgi.internal.resolver.StateImpl;
import org.eclipse.osgi.internal.resolver.StateManager;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.StateObjectFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;

public class EclipseAdaptor
extends DefaultAdaptor {
    public static boolean MONITOR_CLASSES = false;
    public static boolean MONITOR_RESOURCE_BUNDLES = false;
    public static String TRACE_FILENAME = "runtime.traces";
    public static String TRACE_FILTERS = "trace.properties";
    public static boolean TRACE_CLASSES = false;
    public static boolean TRACE_BUNDLES = false;
    private static final String RUNTIME_ADAPTOR = "org.eclipse.core.runtime.adaptor";
    private static final String OPTION_MONITOR_CLASSES = "org.eclipse.core.runtime.adaptor/monitor/classes";
    private static final String OPTION_MONITOR_RESOURCEBUNDLES = "org.eclipse.core.runtime.adaptor/monitor/resourcebundles";
    private static final String OPTION_TRACE_BUNDLES = "org.eclipse.core.runtime.adaptor/trace/bundleActivation";
    private static final String OPTION_TRACE_CLASSES = "org.eclipse.core.runtime.adaptor/trace/classLoading";
    private static final String OPTION_TRACE_FILENAME = "org.eclipse.core.runtime.adaptor/trace/filename";
    private static final String OPTION_TRACE_FILTERS = "org.eclipse.core.runtime.adaptor/trace/filters";
    private static final String OPTION_STATE_READER = "org.eclipse.core.runtime.adaptor/state/reader";
    private static final String OPTION_RESOLVER = "org.eclipse.core.runtime.adaptor/resolver/timing";
    private static final String OPTION_RESOLVER_READER = "org.eclipse.core.runtime.adaptor/resolver/reader/timing";
    public static final byte BUNDLEDATA_VERSION = 3;
    public static final byte NULL = 0;
    public static final byte OBJECT = 1;
    private int startLevel = 1;
    private long timeStamp = 0L;
    private String installURL = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public EclipseAdaptor(String[] args) {
        super(args);
        this.setDebugOptions();
    }

    protected StateManager createStateManager() {
        this.readHeaders();
        this.checkLocationAndReinitialize();
        this.stateManager = new StateManager(this.getStateBaseLocation(), this.timeStamp);
        StateImpl systemState = this.stateManager.getSystemState();
        if (systemState != null) {
            return this.stateManager;
        }
        systemState = this.stateManager.createSystemState();
        Vector installedBundles = this.getInstalledBundles();
        if (installedBundles == null) {
            return this.stateManager;
        }
        StateObjectFactory factory = this.stateManager.getFactory();
        Iterator iter = installedBundles.iterator();
        while (iter.hasNext()) {
            BundleData toAdd = (BundleData)iter.next();
            try {
                Dictionary manifest = toAdd.getManifest();
                BundleDescription newDescription = factory.createBundleDescription(manifest, toAdd.getLocation(), toAdd.getBundleID());
                systemState.addBundle(newDescription);
            }
            catch (BundleException bundleException) {}
        }
        systemState.setTimeStamp(this.timeStamp);
        systemState.resolve();
        return this.stateManager;
    }

    private void checkLocationAndReinitialize() {
        if (this.timeStamp == 0L) {
            this.installURL = EclipseStarter.getSysPath();
            return;
        }
        if (!EclipseStarter.getSysPath().equals(this.installURL)) {
            this.getMetaDataLocation().delete();
            this.getMetaDataFile().delete();
            this.installURL = EclipseStarter.getSysPath();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readHeaders() {
        File metadata = this.getMetaDataLocation();
        if (!metadata.isFile()) {
            return;
        }
        try {
            DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream(metadata)));
            try {
                if (in.readByte() == 3) {
                    this.timeStamp = in.readLong();
                    this.installURL = in.readUTF();
                    this.startLevel = in.readInt();
                    this.nextId = in.readInt();
                }
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                in.close();
                throw throwable;
            }
            {
                Object var3_6 = null;
                in.close();
                return;
            }
        }
        catch (IOException e) {
            if (!Debug.DEBUG_GENERAL) return;
            Debug.println((String)("Error reading framework metadata: " + e.getMessage()));
            Debug.printStackTrace((Throwable)e);
        }
    }

    public AdaptorElementFactory getElementFactory() {
        if (this.elementFactory == null) {
            this.elementFactory = new EclipseElementFactory();
        }
        return this.elementFactory;
    }

    public void frameworkStart(BundleContext context) throws BundleException {
        super.frameworkStart(context);
        Bundle bundle = context.getBundle();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[Lorg.eclipse.osgi.service.environment.EnvironmentInfo;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.register(clazz.getName(), EnvironmentInfo.getDefault(), bundle);
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("[Lorg.eclipse.osgi.service.resolver.PlatformAdmin;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.register(clazz2.getName(), this.stateManager, bundle);
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("[Lorg.eclipse.osgi.service.pluginconversion.PluginConverter;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.register(clazz3.getName(), new PluginConverterImpl(context), bundle);
        this.registerEndorsedXMLParser();
    }

    private void setDebugOptions() {
        DebugOptions options = DebugOptions.getDefault();
        if (options == null) {
            return;
        }
        MONITOR_CLASSES = options.getBooleanOption(OPTION_MONITOR_CLASSES, false);
        MONITOR_RESOURCE_BUNDLES = options.getBooleanOption(OPTION_MONITOR_RESOURCEBUNDLES, false);
        TRACE_CLASSES = options.getBooleanOption(OPTION_TRACE_CLASSES, false);
        TRACE_BUNDLES = options.getBooleanOption(OPTION_TRACE_BUNDLES, false);
        TRACE_FILENAME = options.getOption(OPTION_TRACE_FILENAME);
        TRACE_FILTERS = options.getOption(OPTION_TRACE_FILTERS);
        StateManager.DEBUG_READER = options.getBooleanOption(OPTION_RESOLVER_READER, false);
        StateImpl.DEBUG_RESOLVER = options.getBooleanOption(OPTION_RESOLVER, false);
    }

    private void registerEndorsedXMLParser() {
        if (!EclipseAdaptor.is14VMorGreater()) {
            return;
        }
        new ParsingService();
    }

    private static boolean is14VMorGreater() {
        int minor;
        int major;
        String vmVersionString = System.getProperty("java.version");
        StringTokenizer tokenizer = new StringTokenizer(vmVersionString, ".");
        if (tokenizer.hasMoreTokens() && (major = Integer.parseInt(tokenizer.nextToken())) > 1) {
            return true;
        }
        return tokenizer.hasMoreTokens() && (minor = Integer.parseInt(tokenizer.nextToken())) > 3;
    }

    public void frameworkStop(BundleContext context) throws BundleException {
        this.saveMetaData();
        super.frameworkStop(context);
        if (DebugOptions.getDefault() != null) {
            System.out.println("Time spent in registry parsing: " + DebugOptions.getDefault().getOption("org.eclipse.core.runtime/registry/parsing/timing/value"));
            System.out.println("Time spent in package admin resolve: " + DebugOptions.getDefault().getOption("debug.packageadmin/timing/value"));
            System.out.println("Time spent resolving the dependency system: " + DebugOptions.getDefault().getOption("org.eclipse.core.runtime.adaptor/resolver/timing/value"));
        }
    }

    private File getMetaDataLocation() {
        String configArea = System.getProperty("osgi.configuration.area");
        return new File(configArea, ".bundledata");
    }

    public Vector getInstalledBundles() {
        File metadata = this.getMetaDataLocation();
        if (!metadata.isFile()) {
            return null;
        }
        try {
            Vector<EclipseBundleData> vector;
            DataInputStream in;
            block14: {
                in = new DataInputStream(new BufferedInputStream(new FileInputStream(metadata)));
                if (in.readByte() == 3) break block14;
                Vector vector2 = null;
                Object var9_6 = null;
                in.close();
                return vector2;
            }
            try {
                in.readLong();
                in.readUTF();
                in.readInt();
                in.readLong();
                int bundleCount = in.readInt();
                Vector<EclipseBundleData> result = new Vector<EclipseBundleData>(bundleCount);
                int i = 0;
                while (i < bundleCount) {
                    block15: {
                        try {
                            try {
                                long id = in.readLong();
                                if (id != 0L) {
                                    EclipseBundleData data = (EclipseBundleData)this.getElementFactory().getBundleData((DefaultAdaptor)this);
                                    this.loadMetaDataFor(data, in);
                                    data.initializeExistingBundle(Long.toString(id));
                                    if (Debug.DEBUG_GENERAL) {
                                        Debug.println((String)("BundleData created: " + (Object)((Object)data)));
                                    }
                                    result.addElement(data);
                                }
                            }
                            catch (NumberFormatException numberFormatException) {}
                        }
                        catch (IOException e) {
                            this.timeStamp = System.currentTimeMillis();
                            if (!Debug.DEBUG_GENERAL) break block15;
                            Debug.println((String)("Error reading framework metadata: " + e.getMessage()));
                            Debug.printStackTrace((Throwable)e);
                        }
                    }
                    ++i;
                }
                vector = result;
                Object var9_7 = null;
            }
            catch (Throwable throwable) {
                Object var9_8 = null;
                in.close();
                throw throwable;
            }
            in.close();
            return vector;
        }
        catch (IOException e) {
            if (Debug.DEBUG_GENERAL) {
                Debug.println((String)("Error reading framework metadata: " + e.getMessage()));
                Debug.printStackTrace((Throwable)e);
            }
            return null;
        }
    }

    protected void loadMetaDataFor(EclipseBundleData data, DataInputStream in) throws IOException {
        byte flag = in.readByte();
        if (flag == 0) {
            return;
        }
        data.setLocation(this.readString(in, false));
        data.setName(this.readString(in, false));
        data.setUniqueId(this.readString(in, false));
        data.setVersion(new Version(this.readString(in, false)));
        data.setActivator(this.readString(in, false));
        data.setPluginClass(this.readString(in, false));
        data.setLegacy(this.readString(in, false));
        data.setClassPath(this.readString(in, false));
        data.setNativeCodePath(this.readString(in, false));
        data.setExecutionEnvironment(this.readString(in, false));
        data.setDynamicImports(this.readString(in, false));
        data.setGeneration(in.readInt());
        data.setStartLevel(in.readInt());
        data.setStatus(in.readInt());
        data.setReference(in.readBoolean());
        data.setFragment(in.readBoolean());
    }

    protected void saveMetaDataFor(BundleData data, DataOutputStream out) throws IOException {
        if (data.getBundleID() == 0L || !(data instanceof DefaultBundleData)) {
            out.writeByte(0);
            return;
        }
        EclipseBundleData bundleData = (EclipseBundleData)data;
        out.writeByte(1);
        this.writeStringOrNull(out, bundleData.getLocation());
        this.writeStringOrNull(out, bundleData.getName());
        this.writeStringOrNull(out, bundleData.getUniqueId());
        this.writeStringOrNull(out, bundleData.getVersion().toString());
        this.writeStringOrNull(out, bundleData.getActivator());
        this.writeStringOrNull(out, bundleData.getPluginClass());
        this.writeStringOrNull(out, bundleData.isLegacy());
        this.writeStringOrNull(out, bundleData.getClassPath());
        this.writeStringOrNull(out, bundleData.getNativeCodePath());
        this.writeStringOrNull(out, bundleData.getExecutionEnvironment());
        this.writeStringOrNull(out, bundleData.getDynamicImports());
        out.writeInt(bundleData.getGeneration());
        out.writeInt(bundleData.getStartLevel());
        out.writeInt(bundleData.getStatus());
        out.writeBoolean(bundleData.isReference());
        out.writeBoolean(bundleData.isFragment());
    }

    private String readString(DataInputStream in, boolean intern) throws IOException {
        byte type = in.readByte();
        if (type == 0) {
            return null;
        }
        if (intern) {
            return in.readUTF().intern();
        }
        return in.readUTF();
    }

    private void writeStringOrNull(DataOutputStream out, String string) throws IOException {
        if (string == null) {
            out.writeByte(0);
        } else {
            out.writeByte(1);
            out.writeUTF(string);
        }
    }

    BundleContext getContext() {
        return this.context;
    }

    public File getBundleRootDir() {
        super.getBundleDir();
        return this.bundleRootDir;
    }

    public String getDataDirName() {
        return this.dataDirName;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveMetaData() {
        File metadata = this.getMetaDataLocation();
        if (this.timeStamp == this.stateManager.getSystemState().getTimeStamp() && metadata.isFile()) {
            return;
        }
        try {
            DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(metadata)));
            try {
                out.write(3);
                out.writeLong(this.stateManager.getSystemState().getTimeStamp());
                out.writeUTF(this.installURL);
                out.writeInt(this.startLevel);
                out.writeLong(this.nextId);
                Bundle[] bundles = this.context.getBundles();
                out.writeInt(bundles.length);
                int i = 0;
                while (i < bundles.length) {
                    long id = bundles[i].getBundleId();
                    out.writeLong(id);
                    if (id != 0L) {
                        BundleData data = ((org.eclipse.osgi.framework.internal.core.Bundle)bundles[i]).getBundleData();
                        this.saveMetaDataFor(data, out);
                    }
                    ++i;
                }
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                out.close();
                throw throwable;
            }
            {
                Object var8_10 = null;
                out.close();
                return;
            }
        }
        catch (IOException e) {
            if (!Debug.DEBUG_GENERAL) return;
            Debug.println((String)("Error writing framework metadata: " + e.getMessage()));
            Debug.printStackTrace((Throwable)e);
        }
    }

    public int getStartLevel() {
        return this.startLevel;
    }

    public void setStartLevel(int value) {
        this.startLevel = value;
    }

    public IBundleStats getBundleStats() {
        return StatsManager.getDefault();
    }

    protected File getStateBaseLocation() {
        return new File(System.getProperty("osgi.configuration.area"));
    }

    protected File getMetaDataFile() {
        File configAreaDirectory = this.getStateBaseLocation();
        if (!configAreaDirectory.exists()) {
            configAreaDirectory.mkdirs();
        }
        return new File(configAreaDirectory, ".framework");
    }

    private class ParsingService
    implements ServiceFactory {
        public static final String SAXFACTORYNAME = "javax.xml.parsers.SAXParserFactory";

        public Object getService(Bundle bundle, ServiceRegistration registration) {
            return SAXParserFactory.newInstance();
        }

        public void ungetService(Bundle bundle, ServiceRegistration registration, Object service) {
        }

        public ParsingService() {
            ((AbstractFrameworkAdaptor)EclipseAdaptor.this).context.registerService(SAXFACTORYNAME, (Object)this, new Hashtable());
        }
    }
}

