/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.adaptor;

import java.util.Dictionary;
import java.util.Enumeration;
import org.eclipse.core.runtime.adaptor.EclipseBundleData;
import org.eclipse.osgi.framework.adaptor.Version;
import org.osgi.framework.BundleException;

public class CachedManifest
extends Dictionary {
    Dictionary manifest = null;
    EclipseBundleData bundledata;

    public CachedManifest(EclipseBundleData bundledata) {
        this.bundledata = bundledata;
    }

    protected Dictionary getManifest() {
        if (this.manifest == null) {
            try {
                this.manifest = this.bundledata.loadManifest();
            }
            catch (BundleException bundleException) {
                return null;
            }
        }
        return this.manifest;
    }

    public int size() {
        return this.getManifest().size();
    }

    public boolean isEmpty() {
        return false;
    }

    public Enumeration elements() {
        return this.getManifest().elements();
    }

    public Enumeration keys() {
        return this.getManifest().keys();
    }

    public Object get(Object key) {
        if ("Bundle-Version".equalsIgnoreCase((String)key)) {
            Version result = this.bundledata.getVersion();
            return result == null ? null : result.toString();
        }
        if ("plugin-class".equalsIgnoreCase((String)key)) {
            return this.bundledata.getPluginClass();
        }
        if ("legacy".equalsIgnoreCase((String)key)) {
            return this.bundledata.isLegacy();
        }
        return this.getManifest().get(key);
    }

    public Object remove(Object key) {
        return this.getManifest().remove(key);
    }

    public Object put(Object key, Object value) {
        return this.getManifest().put(key, value);
    }
}

