/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core;

import java.io.File;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.compilers.DefaultCompilerAdapter;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.util.JavaEnvUtils;
import org.eclipse.jdt.internal.antadapter.AntAdapterMessages;

public class JDTCompilerAdapter
extends DefaultCompilerAdapter {
    private static String compilerClass = "org.eclipse.jdt.internal.compiler.batch.Main";
    String logFileName;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public boolean execute() throws BuildException {
        this.attributes.log(AntAdapterMessages.getString("ant.jdtadapter.info.usingJDTCompiler"), 3);
        Commandline cmd = this.setupJavacCommand();
        try {
            Class<?> c = Class.forName(compilerClass);
            Class[] classArray = new Class[3];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("[Ljava.io.PrintWriter;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz;
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("[Ljava.io.PrintWriter;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[1] = clazz2;
            classArray[2] = Boolean.TYPE;
            Constructor<?> batchCompilerConstructor = c.getConstructor(classArray);
            Object batchCompilerInstance = batchCompilerConstructor.newInstance(new PrintWriter(System.out), new PrintWriter(System.err), new Boolean(true));
            Class[] classArray2 = new Class[1];
            Class<?> clazz3 = class$1;
            if (clazz3 == null) {
                try {
                    clazz3 = class$1 = Class.forName("[Ljava.lang.String;");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray2[0] = clazz3;
            Method compile = c.getMethod("compile", classArray2);
            Object result = compile.invoke(batchCompilerInstance, new Object[]{cmd.getArguments()});
            boolean resultValue = (Boolean)result;
            if (!resultValue && this.verbose) {
                System.out.println(AntAdapterMessages.getString("ant.jdtadapter.error.compilationFailed", this.logFileName));
            }
            return resultValue;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new BuildException(AntAdapterMessages.getString("ant.jdtadapter.error.cannotFindJDTCompiler"));
        }
        catch (Exception ex) {
            throw new BuildException((Throwable)ex);
        }
    }

    protected Commandline setupJavacCommand() throws BuildException {
        String source;
        String memoryParameterPrefix;
        Commandline cmd = new Commandline();
        cmd.createArgument().setValue("-noExit");
        if (this.bootclasspath != null && this.bootclasspath.size() != 0) {
            cmd.createArgument().setValue("-bootclasspath");
            cmd.createArgument().setPath(this.bootclasspath);
        } else {
            this.includeJavaRuntime = true;
        }
        Path classpath = new Path(this.project);
        this.addExtdirs(this.extdirs, classpath);
        classpath.append(this.getCompileClasspath());
        Path sourcepath = null;
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("[Lorg.apache.tools.ant.taskdefs.Javac;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> javacClass = clazz;
        Method getSourcepathMethod = null;
        try {
            getSourcepathMethod = javacClass.getMethod("getSourcepath", null);
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        Path compileSourcePath = null;
        if (getSourcepathMethod != null) {
            try {
                compileSourcePath = (Path)getSourcepathMethod.invoke((Object)this.attributes, null);
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {}
        }
        sourcepath = compileSourcePath != null ? compileSourcePath : this.src;
        classpath.append(sourcepath);
        cmd.createArgument().setValue("-classpath");
        cmd.createArgument().setPath(classpath);
        String string = memoryParameterPrefix = JavaEnvUtils.getJavaVersion().equals("1.1") ? "-J-" : "-J-X";
        if (this.memoryInitialSize != null) {
            if (!this.attributes.isForkedJavac()) {
                this.attributes.log(AntAdapterMessages.getString("ant.jdtadapter.info.ignoringMemoryInitialSize"), 1);
            } else {
                cmd.createArgument().setValue(String.valueOf(memoryParameterPrefix) + "ms" + this.memoryInitialSize);
            }
        }
        if (this.memoryMaximumSize != null) {
            if (!this.attributes.isForkedJavac()) {
                this.attributes.log(AntAdapterMessages.getString("ant.jdtadapter.info.ignoringMemoryMaximumSize"), 1);
            } else {
                cmd.createArgument().setValue(String.valueOf(memoryParameterPrefix) + "mx" + this.memoryMaximumSize);
            }
        }
        if (this.debug) {
            Method getDebugLevelMethod = null;
            try {
                getDebugLevelMethod = javacClass.getMethod("getDebugLevel", null);
            }
            catch (NoSuchMethodException noSuchMethodException) {}
            String debugLevel = null;
            if (getDebugLevelMethod != null) {
                try {
                    debugLevel = (String)getDebugLevelMethod.invoke((Object)this.attributes, null);
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {}
            }
            if (debugLevel != null) {
                if (debugLevel.length() == 0) {
                    cmd.createArgument().setValue("-g:none");
                } else {
                    cmd.createArgument().setValue("-g:" + debugLevel);
                }
            } else {
                cmd.createArgument().setValue("-g");
            }
        } else {
            cmd.createArgument().setValue("-g:none");
        }
        Method getCurrentCompilerArgsMethod = null;
        try {
            getCurrentCompilerArgsMethod = javacClass.getMethod("getCurrentCompilerArgs", null);
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        String[] compilerArgs = null;
        if (getCurrentCompilerArgsMethod != null) {
            try {
                compilerArgs = (String[])getCurrentCompilerArgsMethod.invoke((Object)this.attributes, null);
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {}
        }
        if (compilerArgs == null) {
            if (this.attributes.getNowarn()) {
                if (this.deprecation) {
                    cmd.createArgument().setValue("-warn:allDeprecation");
                } else {
                    cmd.createArgument().setValue("-nowarn");
                }
            } else if (this.deprecation) {
                cmd.createArgument().setValue("-warn:allDeprecation,constructorName,packageDefaultMethod,maskedCatchBlocks,unusedImports,staticReceiver");
            } else {
                cmd.createArgument().setValue("-warn:constructorName,packageDefaultMethod,maskedCatchBlocks,unusedImports,staticReceiver");
            }
        } else {
            if (this.attributes.getNowarn()) {
                if (this.deprecation) {
                    cmd.createArgument().setValue("-warn:allDeprecation");
                } else {
                    cmd.createArgument().setValue("-nowarn");
                }
            } else if (this.deprecation) {
                cmd.createArgument().setValue("-warn:allDeprecation");
            } else if (compilerArgs.length == 0) {
                cmd.createArgument().setValue("-warn:constructorName,packageDefaultMethod,maskedCatchBlocks,unusedImports,staticReceiver");
            }
            if (compilerArgs.length != 0) {
                cmd.addArguments(compilerArgs);
            }
        }
        if (this.destDir != null) {
            cmd.createArgument().setValue("-d");
            cmd.createArgument().setFile(this.destDir.getAbsoluteFile());
        }
        if (this.target != null) {
            cmd.createArgument().setValue("-target");
            cmd.createArgument().setValue(this.target);
        }
        if (this.verbose) {
            cmd.createArgument().setValue("-verbose");
            cmd.createArgument().setValue("-log");
            this.logFileName = String.valueOf(this.destDir.getAbsolutePath()) + ".log";
            cmd.createArgument().setValue(this.logFileName);
        }
        if (!this.attributes.getFailonerror()) {
            cmd.createArgument().setValue("-proceedOnError");
        }
        if ((source = this.attributes.getSource()) != null) {
            cmd.createArgument().setValue("-source");
            cmd.createArgument().setValue(source);
        }
        if (JavaEnvUtils.getJavaVersion().equals("1.4")) {
            if (this.target != null && this.target.equals("1.1")) {
                cmd.createArgument().setValue("-1.3");
            } else {
                cmd.createArgument().setValue("-1.4");
            }
        } else {
            cmd.createArgument().setValue("-1.3");
        }
        if (this.encoding != null) {
            cmd.createArgument().setValue("-encoding");
            cmd.createArgument().setValue(this.encoding);
        }
        this.logAndAddFilesToCompile(cmd);
        return cmd;
    }

    private void addExtdirs(Path extDirs, Path classpath) {
        if (extDirs == null) {
            String extProp = System.getProperty("java.ext.dirs");
            if (extProp != null) {
                extDirs = new Path(classpath.getProject(), extProp);
            } else {
                return;
            }
        }
        String[] dirs = extDirs.list();
        int i = 0;
        while (i < dirs.length) {
            File dir = classpath.getProject().resolveFile(dirs[i]);
            if (dir.exists() && dir.isDirectory()) {
                FileSet fs = new FileSet();
                fs.setDir(dir);
                fs.setIncludes("*");
                classpath.addFileset(fs);
            }
            ++i;
        }
    }
}

