/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.formatter.impl;

import org.eclipse.jdt.internal.compiler.parser.TerminalTokens;

public class SplitLine
implements TerminalTokens {
    public int[] operators;
    public String[] substrings;
    public int[] startSubstringsIndexes;

    public SplitLine(int[] operators, String[] substrings) {
        this(operators, substrings, null);
    }

    public SplitLine(int[] operators, String[] substrings, int[] startIndexes) {
        this.operators = operators;
        this.substrings = substrings;
        this.startSubstringsIndexes = startIndexes;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        int i = 0;
        int max = this.substrings.length;
        while (i < max) {
            int currentOperator = this.operators[i];
            String currentString = this.substrings[i];
            boolean placeOperatorAhead = currentOperator != 30 && currentOperator != 23;
            boolean placeOperatorBehind = currentOperator == 30 || currentOperator == 23;
            String operatorString = null;
            switch (currentOperator) {
                case 91: {
                    operatorString = "extends";
                    break;
                }
                case 103: {
                    operatorString = "implements";
                    break;
                }
                case 104: {
                    operatorString = "throws";
                    break;
                }
                case 23: {
                    operatorString = ";";
                    break;
                }
                case 30: {
                    operatorString = ",";
                    break;
                }
                case 90: {
                    operatorString = "=";
                    break;
                }
                case 25: {
                    operatorString = "&&";
                    break;
                }
                case 24: {
                    operatorString = "||";
                    break;
                }
                case 26: {
                    operatorString = "?";
                    break;
                }
                case 53: {
                    operatorString = ":";
                    break;
                }
                case 18: {
                    operatorString = "==";
                    break;
                }
                case 19: {
                    operatorString = "!=";
                    break;
                }
                case 17: {
                    operatorString = "<";
                    break;
                }
                case 14: {
                    operatorString = "<=";
                    break;
                }
                case 16: {
                    operatorString = ">";
                    break;
                }
                case 15: {
                    operatorString = ">=";
                    break;
                }
                case 13: {
                    operatorString = "instanceof";
                    break;
                }
                case 1: {
                    operatorString = "+";
                    break;
                }
                case 2: {
                    operatorString = "-";
                    break;
                }
                case 4: {
                    operatorString = "*";
                    break;
                }
                case 6: {
                    operatorString = "/";
                    break;
                }
                case 5: {
                    operatorString = "%";
                    break;
                }
                case 11: {
                    operatorString = "<<";
                    break;
                }
                case 9: {
                    operatorString = ">>";
                    break;
                }
                case 10: {
                    operatorString = ">>>";
                    break;
                }
                case 20: {
                    operatorString = "&";
                    break;
                }
                case 22: {
                    operatorString = "|";
                    break;
                }
                case 21: {
                    operatorString = "^";
                    break;
                }
                case 94: {
                    operatorString = "*=";
                    break;
                }
                case 95: {
                    operatorString = "/=";
                    break;
                }
                case 99: {
                    operatorString = "%=";
                    break;
                }
                case 92: {
                    operatorString = "+=";
                    break;
                }
                case 93: {
                    operatorString = "-=";
                    break;
                }
                case 100: {
                    operatorString = "<<=";
                    break;
                }
                case 101: {
                    operatorString = ">>=";
                    break;
                }
                case 102: {
                    operatorString = ">>>=";
                    break;
                }
                case 96: {
                    operatorString = "&=";
                    break;
                }
                case 98: {
                    operatorString = "^=";
                    break;
                }
                case 97: {
                    operatorString = "|=";
                    break;
                }
                case 3: {
                    operatorString = ".";
                    break;
                }
                default: {
                    operatorString = "";
                }
            }
            if (placeOperatorAhead) {
                result.append(operatorString);
            }
            result.append(currentString);
            if (placeOperatorBehind) {
                result.append(operatorString);
            }
            result.append('\n');
            ++i;
        }
        return "";
    }
}

