/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.formatter;

import java.util.Arrays;
import java.util.Map;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.internal.compiler.parser.Scanner;
import org.eclipse.jdt.internal.formatter.AbortFormatting;
import org.eclipse.jdt.internal.formatter.CodeFormatterVisitor;
import org.eclipse.jdt.internal.formatter.DefaultCodeFormatterOptions;
import org.eclipse.jdt.internal.formatter.Location;
import org.eclipse.jdt.internal.formatter.OptimizedReplaceEdit;
import org.eclipse.jdt.internal.formatter.align.Alignment;
import org.eclipse.jdt.internal.formatter.align.AlignmentException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class Scribe {
    private static final int INITIAL_SIZE = 100;
    private boolean checkLineWrapping;
    public int column;
    public Alignment currentAlignment;
    public int currentToken;
    public int editsIndex;
    private OptimizedReplaceEdit[] edits;
    private char fillingSpace;
    public CodeFormatterVisitor formatter;
    public int indentationLevel;
    public int lastNumberOfNewLines;
    public int line;
    private String lineSeparator;
    public Alignment memberAlignment;
    public boolean needSpace = false;
    public int pageWidth;
    public Scanner scanner;
    public int scannerEndPosition;
    public int tabSize;
    private int textRegionEnd;
    private int textRegionStart;
    public boolean useTab;

    Scribe(CodeFormatterVisitor formatter, Map settings, int offset, int length) {
        Object assertModeSetting;
        this.scanner = settings != null ? ((assertModeSetting = settings.get("org.eclipse.jdt.core.compiler.source")) == null ? new Scanner(true, true, false, "1.4".equals(assertModeSetting) ? 0x300000L : 0x2F0000L, null, null) : new Scanner(true, true, false, 0x2F0000L, null, null)) : new Scanner(true, true, false, 0x2F0000L, null, null);
        this.formatter = formatter;
        this.pageWidth = formatter.preferences.page_width;
        this.tabSize = formatter.preferences.tab_size;
        this.useTab = formatter.preferences.use_tab;
        this.fillingSpace = formatter.preferences.filling_space;
        this.setLineSeparatorAndIdentationLevel(formatter.preferences);
        this.textRegionStart = offset;
        this.textRegionEnd = offset + length - 1;
        this.reset();
    }

    private final void addDeleteEdit(int start, int end) {
        if (this.textRegionStart <= start && end <= this.textRegionEnd) {
            if (this.edits.length == this.editsIndex) {
                this.resize();
            }
            this.addOptimizedReplaceEdit(start, end - start + 1, "");
        }
    }

    private final void addInsertEdit(int insertPosition, String insertedString) {
        if (this.textRegionStart <= insertPosition && insertPosition <= this.textRegionEnd) {
            if (this.edits.length == this.editsIndex) {
                this.resize();
            }
            this.addOptimizedReplaceEdit(insertPosition, 0, insertedString);
        }
    }

    private final void addOptimizedReplaceEdit(int offset, int length, String replacement) {
        if (this.editsIndex > 0) {
            OptimizedReplaceEdit previous = this.edits[this.editsIndex - 1];
            int previousOffset = previous.offset;
            int previousLength = previous.length;
            int endOffsetOfPreviousEdit = previousOffset + previousLength;
            int replacementLength = replacement.length();
            String previousReplacement = previous.replacement;
            int previousReplacementLength = previousReplacement.length();
            if (previousOffset == offset && previousLength == length && (replacementLength == 0 || previousReplacementLength == 0)) {
                if (this.currentAlignment != null) {
                    Location location = this.currentAlignment.location;
                    if (location.editsIndex == this.editsIndex) {
                        --location.editsIndex;
                        location.textEdit = previous;
                    }
                }
                --this.editsIndex;
                return;
            }
            if (endOffsetOfPreviousEdit == offset) {
                if (length != 0) {
                    if (replacementLength != 0) {
                        this.edits[this.editsIndex - 1] = new OptimizedReplaceEdit(previousOffset, previousLength + length, String.valueOf(previousReplacement) + replacement);
                    } else if (previousLength + length == previousReplacementLength) {
                        boolean canBeRemoved = true;
                        int i = previousOffset;
                        while (i < previousOffset + previousReplacementLength) {
                            if (this.scanner.source[i] != previousReplacement.charAt(i - previousOffset)) {
                                this.edits[this.editsIndex - 1] = new OptimizedReplaceEdit(previousOffset, previousReplacementLength, previousReplacement);
                                canBeRemoved = false;
                                break;
                            }
                            ++i;
                        }
                        if (canBeRemoved) {
                            if (this.currentAlignment != null) {
                                Location location = this.currentAlignment.location;
                                if (location.editsIndex == this.editsIndex) {
                                    --location.editsIndex;
                                    location.textEdit = previous;
                                }
                            }
                            --this.editsIndex;
                        }
                    } else {
                        this.edits[this.editsIndex - 1] = new OptimizedReplaceEdit(previousOffset, previousLength + length, previousReplacement);
                    }
                } else if (replacementLength != 0) {
                    this.edits[this.editsIndex - 1] = new OptimizedReplaceEdit(previousOffset, previousLength, String.valueOf(previousReplacement) + replacement);
                }
            } else {
                this.edits[this.editsIndex++] = new OptimizedReplaceEdit(offset, length, replacement);
            }
        } else {
            this.edits[this.editsIndex++] = new OptimizedReplaceEdit(offset, length, replacement);
        }
    }

    private final void addReplaceEdit(int start, int end, String replacement) {
        if (this.textRegionStart <= start && end <= this.textRegionEnd) {
            if (this.edits.length == this.editsIndex) {
                this.resize();
            }
            this.addOptimizedReplaceEdit(start, end - start + 1, replacement);
        }
    }

    public void alignFragment(Alignment alignment, int fragmentIndex) {
        alignment.fragmentIndex = fragmentIndex;
        alignment.checkColumn();
        alignment.performFragmentEffect();
    }

    public Alignment createAlignment(String name, int mode, int count, int sourceRestart) {
        return this.createAlignment(name, mode, 2, count, sourceRestart);
    }

    public Alignment createAlignment(String name, int mode, int count, int sourceRestart, boolean adjust) {
        return this.createAlignment(name, mode, 2, count, sourceRestart, adjust);
    }

    public Alignment createAlignment(String name, int mode, int count, int sourceRestart, int continuationIndent, boolean adjust) {
        return this.createAlignment(name, mode, 2, count, sourceRestart, continuationIndent, adjust);
    }

    public Alignment createAlignment(String name, int mode, int tieBreakRule, int count, int sourceRestart) {
        return this.createAlignment(name, mode, tieBreakRule, count, sourceRestart, this.formatter.preferences.continuation_indentation, false);
    }

    public Alignment createAlignment(String name, int mode, int tieBreakRule, int count, int sourceRestart, int continuationIndent, boolean adjust) {
        Alignment alignment = new Alignment(name, mode, tieBreakRule, this, count, sourceRestart, continuationIndent);
        if (adjust && this.memberAlignment != null) {
            Alignment current = this.memberAlignment;
            while (current.enclosing != null) {
                current = current.enclosing;
            }
            if (current.mode != 0) {
                int indentSize = this.useTab ? 1 : this.tabSize;
                switch (current.chunkKind) {
                    case 2: 
                    case 3: {
                        alignment.breakIndentationLevel = (mode & 4) != 0 ? this.indentationLevel + indentSize : this.indentationLevel + continuationIndent * indentSize;
                        alignment.update();
                        break;
                    }
                    case 1: {
                        alignment.breakIndentationLevel = (mode & 4) != 0 ? current.originalIndentationLevel + indentSize : current.originalIndentationLevel + continuationIndent * indentSize;
                        alignment.update();
                    }
                }
            }
        }
        return alignment;
    }

    public Alignment createMemberAlignment(String name, int mode, int count, int sourceRestart) {
        Alignment mAlignment = this.createAlignment(name, mode, 2, count, sourceRestart);
        mAlignment.breakIndentationLevel = this.indentationLevel;
        return mAlignment;
    }

    public void enterAlignment(Alignment alignment) {
        alignment.enclosing = this.currentAlignment;
        this.currentAlignment = alignment;
    }

    public void enterMemberAlignment(Alignment alignment) {
        alignment.enclosing = this.memberAlignment;
        this.memberAlignment = alignment;
    }

    public void exitAlignment(Alignment alignment, boolean discardAlignment) {
        Alignment current = this.currentAlignment;
        while (current != null) {
            if (current == alignment) break;
            current = current.enclosing;
        }
        if (current == null) {
            throw new AbortFormatting("could not find matching alignment: " + alignment);
        }
        this.indentationLevel = alignment.location.outputIndentationLevel;
        if (discardAlignment) {
            this.currentAlignment = alignment.enclosing;
        }
    }

    public void exitMemberAlignment(Alignment alignment) {
        Alignment current = this.memberAlignment;
        while (current != null) {
            if (current == alignment) break;
            current = current.enclosing;
        }
        if (current == null) {
            throw new AbortFormatting("could not find matching alignment: " + alignment);
        }
        this.indentationLevel = current.location.outputIndentationLevel;
        this.memberAlignment = current.enclosing;
    }

    public Alignment getAlignment(String name) {
        if (this.currentAlignment != null) {
            return this.currentAlignment.getAlignment(name);
        }
        return null;
    }

    public int getColumnIndentationLevel() {
        if (this.useTab) {
            return (this.column - 1) / this.tabSize;
        }
        return this.column - 1;
    }

    public int getIndentationLevel(int someColumn) {
        if (someColumn == 1) {
            return this.indentationLevel;
        }
        if (this.useTab) {
            return (someColumn - 1) / this.tabSize;
        }
        return someColumn - 1;
    }

    public OptimizedReplaceEdit getLastEdit() {
        if (this.editsIndex > 0) {
            return this.edits[this.editsIndex - 1];
        }
        return null;
    }

    Alignment getMemberAlignment() {
        return this.memberAlignment;
    }

    public int getNextIndentationLevel(int someColumn) {
        if (someColumn == 1) {
            return this.indentationLevel;
        }
        if (this.useTab) {
            int rem = (someColumn - 1) % this.tabSize;
            return rem == 0 ? (someColumn - 1) / this.tabSize : (someColumn - 1) / this.tabSize + 1;
        }
        return someColumn - 1;
    }

    public TextEdit getRootEdit() {
        MultiTextEdit edit = null;
        edit = this.textRegionStart < 0 ? new MultiTextEdit(0, this.textRegionEnd + 1) : new MultiTextEdit(this.textRegionStart, this.textRegionEnd - this.textRegionStart + 1);
        int i = 0;
        int max = this.editsIndex;
        while (i < max) {
            OptimizedReplaceEdit currentEdit = this.edits[i];
            if (this.isValidEdit(currentEdit)) {
                edit.addChild((TextEdit)new ReplaceEdit(currentEdit.offset, currentEdit.length, currentEdit.replacement));
            }
            ++i;
        }
        this.edits = null;
        return edit;
    }

    public void handleLineTooLong() {
        int relativeDepth = 0;
        int outerMostDepth = -1;
        Alignment targetAlignment = this.currentAlignment;
        while (targetAlignment != null) {
            if (targetAlignment.tieBreakRule == 1 && targetAlignment.couldBreak()) {
                outerMostDepth = relativeDepth;
            }
            targetAlignment = targetAlignment.enclosing;
            ++relativeDepth;
        }
        if (outerMostDepth >= 0) {
            throw new AlignmentException(1, outerMostDepth);
        }
        relativeDepth = 0;
        targetAlignment = this.currentAlignment;
        while (targetAlignment != null) {
            if (targetAlignment.couldBreak()) {
                throw new AlignmentException(1, relativeDepth);
            }
            targetAlignment = targetAlignment.enclosing;
            ++relativeDepth;
        }
    }

    public void indent() {
        this.indentationLevel = this.useTab ? ++this.indentationLevel : (this.indentationLevel += this.tabSize);
    }

    public void initializeScanner(char[] compilationUnitSource) {
        this.scanner.setSource(compilationUnitSource);
        this.scannerEndPosition = compilationUnitSource.length;
        this.scanner.resetTo(0, this.scannerEndPosition);
        if (this.textRegionEnd == -1) {
            this.textRegionEnd = this.scannerEndPosition;
        }
        this.edits = new OptimizedReplaceEdit[100];
    }

    private boolean isValidEdit(OptimizedReplaceEdit edit) {
        int editLength = edit.length;
        int editReplacementLength = edit.replacement.length();
        int editOffset = edit.offset;
        if (editLength != 0 && editReplacementLength != 0 && editLength == editReplacementLength) {
            int i = editOffset;
            int max = editOffset + editLength;
            while (i < max) {
                if (this.scanner.source[i] != edit.replacement.charAt(i - editOffset)) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        return true;
    }

    private void preserveEmptyLines(int count, int insertPosition) {
        if (count > 0) {
            if (this.formatter.preferences.preserve_user_linebreaks) {
                this.printEmptyLines(count, insertPosition);
            } else if (this.formatter.preferences.number_of_empty_lines_to_preserve != 0) {
                int linesToPreserve = Math.min(count, this.formatter.preferences.number_of_empty_lines_to_preserve);
                this.printEmptyLines(linesToPreserve, insertPosition);
            } else {
                this.printNewLine(insertPosition);
            }
        }
    }

    private void print(char[] s, boolean considerSpaceIfAny) {
        if (this.checkLineWrapping && s.length + this.column > this.pageWidth) {
            this.handleLineTooLong();
        }
        this.lastNumberOfNewLines = 0;
        this.printIndentationIfNecessary();
        if (considerSpaceIfAny) {
            this.space(this.scanner.getCurrentTokenStartPosition());
        }
        this.column += s.length;
        this.needSpace = true;
    }

    private void printBlockComment(char[] s, boolean isJavadoc) {
        int currentCharacter;
        int currentTokenStartPosition = this.scanner.getCurrentTokenStartPosition();
        int currentTokenEndPosition = this.scanner.getCurrentTokenEndPosition() + 1;
        this.scanner.resetTo(currentTokenStartPosition, currentTokenEndPosition - 1);
        boolean isNewLine = false;
        int start = currentTokenStartPosition;
        int nextCharacterStart = currentTokenStartPosition;
        this.printIndentationIfNecessary();
        int previousStart = currentTokenStartPosition;
        while (nextCharacterStart <= currentTokenEndPosition && (currentCharacter = this.scanner.getNextChar()) != -1) {
            nextCharacterStart = this.scanner.currentPosition;
            switch (currentCharacter) {
                case 13: {
                    start = previousStart;
                    isNewLine = true;
                    if (!this.scanner.getNextChar('\n')) break;
                    currentCharacter = 10;
                    nextCharacterStart = this.scanner.currentPosition;
                    break;
                }
                case 10: {
                    start = previousStart;
                    isNewLine = true;
                    break;
                }
                default: {
                    if (isNewLine) {
                        if (Character.isWhitespace((char)currentCharacter)) {
                            int previousStartPosition = this.scanner.currentPosition;
                            while (currentCharacter != -1 && currentCharacter != 13 && currentCharacter != 10 && Character.isWhitespace((char)currentCharacter)) {
                                previousStart = nextCharacterStart;
                                previousStartPosition = this.scanner.currentPosition;
                                currentCharacter = this.scanner.getNextChar();
                                nextCharacterStart = this.scanner.currentPosition;
                            }
                            if (currentCharacter == 13 || currentCharacter == 10) {
                                nextCharacterStart = previousStartPosition;
                            }
                        }
                        this.column = 1;
                        ++this.line;
                        StringBuffer buffer = new StringBuffer();
                        buffer.append(this.lineSeparator);
                        this.printIndentationIfNecessary(buffer);
                        buffer.append(this.fillingSpace);
                        this.addReplaceEdit(start, previousStart - 1, String.valueOf(buffer));
                    } else {
                        this.column += nextCharacterStart - previousStart;
                    }
                    isNewLine = false;
                }
            }
            previousStart = nextCharacterStart;
            this.scanner.currentPosition = nextCharacterStart;
        }
        this.lastNumberOfNewLines = 0;
        this.needSpace = false;
        this.scanner.resetTo(currentTokenEndPosition, this.scannerEndPosition - 1);
        if (isJavadoc) {
            this.printNewLine();
        }
    }

    public void printComment() {
        try {
            int currentTokenStartPosition = this.scanner.currentPosition;
            boolean hasComment = false;
            boolean hasLineComment = false;
            boolean hasWhitespace = false;
            int count = 0;
            while ((this.currentToken = this.scanner.getNextToken()) != 54) {
                switch (this.currentToken) {
                    case 1000: {
                        char[] whiteSpaces = this.scanner.getCurrentTokenSource();
                        count = 0;
                        int i = 0;
                        int max = whiteSpaces.length;
                        while (i < max) {
                            switch (whiteSpaces[i]) {
                                case '\r': {
                                    if (i + 1 < max && whiteSpaces[i + 1] == '\n') {
                                        ++i;
                                    }
                                    ++count;
                                    break;
                                }
                                case '\n': {
                                    ++count;
                                }
                            }
                            ++i;
                        }
                        if (count == 0) {
                            hasWhitespace = true;
                            this.addDeleteEdit(this.scanner.getCurrentTokenStartPosition(), this.scanner.getCurrentTokenEndPosition());
                        } else if (hasComment) {
                            if (count == 1) {
                                this.printNewLine(this.scanner.getCurrentTokenStartPosition());
                            } else {
                                this.preserveEmptyLines(count - 1, this.scanner.getCurrentTokenStartPosition());
                            }
                            this.addDeleteEdit(this.scanner.getCurrentTokenStartPosition(), this.scanner.getCurrentTokenEndPosition());
                        } else if (hasLineComment) {
                            this.preserveEmptyLines(count, this.scanner.getCurrentTokenStartPosition());
                            this.addDeleteEdit(this.scanner.getCurrentTokenStartPosition(), this.scanner.getCurrentTokenEndPosition());
                        } else if (this.formatter.preferences.preserve_user_linebreaks) {
                            this.addDeleteEdit(this.scanner.getCurrentTokenStartPosition(), this.scanner.getCurrentTokenEndPosition());
                            if (count == 1) {
                                this.printNewLine(this.scanner.getCurrentTokenEndPosition() + 1);
                            }
                        } else if (count != 0 && this.formatter.preferences.number_of_empty_lines_to_preserve != 0) {
                            this.addDeleteEdit(this.scanner.getCurrentTokenStartPosition(), this.scanner.getCurrentTokenEndPosition());
                            this.preserveEmptyLines(count - 1, this.scanner.getCurrentTokenEndPosition() + 1);
                        } else {
                            this.addDeleteEdit(this.scanner.getCurrentTokenStartPosition(), this.scanner.getCurrentTokenEndPosition());
                        }
                        currentTokenStartPosition = this.scanner.currentPosition;
                        break;
                    }
                    case 1001: {
                        if (count >= 1) {
                            if (count > 1) {
                                this.preserveEmptyLines(count - 1, this.scanner.getCurrentTokenStartPosition());
                            } else if (count == 1 || this.formatter.preferences.preserve_user_linebreaks) {
                                this.printNewLine(this.scanner.getCurrentTokenStartPosition());
                            }
                        } else if (hasWhitespace) {
                            this.space(this.scanner.getCurrentTokenStartPosition());
                        }
                        hasWhitespace = false;
                        this.printCommentLine(this.scanner.getRawTokenSource());
                        currentTokenStartPosition = this.scanner.currentPosition;
                        hasLineComment = true;
                        count = 0;
                        break;
                    }
                    case 1002: {
                        if (count >= 1) {
                            if (count > 1) {
                                this.preserveEmptyLines(count - 1, this.scanner.getCurrentTokenStartPosition());
                            } else if (count == 1 && this.formatter.preferences.preserve_user_linebreaks) {
                                this.printNewLine(this.scanner.getCurrentTokenStartPosition());
                            }
                        } else if (hasWhitespace) {
                            this.space(this.scanner.getCurrentTokenStartPosition());
                        }
                        hasWhitespace = false;
                        this.printBlockComment(this.scanner.getRawTokenSource(), false);
                        currentTokenStartPosition = this.scanner.currentPosition;
                        hasLineComment = false;
                        hasComment = true;
                        count = 0;
                        break;
                    }
                    case 1003: {
                        if (count >= 1) {
                            if (count > 1) {
                                this.preserveEmptyLines(count - 1, this.scanner.getCurrentTokenStartPosition());
                            } else if (count == 1 && this.formatter.preferences.preserve_user_linebreaks) {
                                this.printNewLine(this.scanner.getCurrentTokenStartPosition());
                            }
                        } else if (hasWhitespace) {
                            this.space(this.scanner.getCurrentTokenStartPosition());
                        }
                        hasWhitespace = false;
                        this.printBlockComment(this.scanner.getRawTokenSource(), true);
                        currentTokenStartPosition = this.scanner.currentPosition;
                        hasLineComment = false;
                        hasComment = true;
                        count = 0;
                        break;
                    }
                    default: {
                        this.scanner.resetTo(currentTokenStartPosition, this.scannerEndPosition - 1);
                        return;
                    }
                }
            }
        }
        catch (InvalidInputException e) {
            throw new AbortFormatting(e);
        }
    }

    private void printCommentLine(char[] s) {
        int currentCharacter;
        int currentTokenStartPosition = this.scanner.getCurrentTokenStartPosition();
        int currentTokenEndPosition = this.scanner.getCurrentTokenEndPosition() + 1;
        this.scanner.resetTo(currentTokenStartPosition, currentTokenEndPosition - 1);
        int start = currentTokenStartPosition;
        int nextCharacterStart = currentTokenStartPosition;
        this.printIndentationIfNecessary();
        int previousStart = currentTokenStartPosition;
        block4: while (nextCharacterStart <= currentTokenEndPosition && (currentCharacter = this.scanner.getNextChar()) != -1) {
            nextCharacterStart = this.scanner.currentPosition;
            switch (currentCharacter) {
                case 13: {
                    start = previousStart;
                    break block4;
                }
                case 10: {
                    start = previousStart;
                    break block4;
                }
                default: {
                    previousStart = nextCharacterStart;
                }
            }
        }
        if (start != currentTokenStartPosition) {
            this.addReplaceEdit(start, currentTokenEndPosition - 1, this.lineSeparator);
        }
        ++this.line;
        this.column = 1;
        this.needSpace = false;
        this.lastNumberOfNewLines = 1;
        if (this.currentAlignment != null) {
            this.indentationLevel = this.memberAlignment != null ? (this.currentAlignment.location.inputOffset > this.memberAlignment.location.inputOffset ? Math.max(this.indentationLevel, this.currentAlignment.breakIndentationLevel) : Math.max(this.indentationLevel, this.memberAlignment.breakIndentationLevel)) : Math.max(this.indentationLevel, this.currentAlignment.breakIndentationLevel);
        }
        this.scanner.resetTo(currentTokenEndPosition, this.scannerEndPosition - 1);
    }

    public void printEmptyLines(int linesNumber) {
        this.printEmptyLines(linesNumber, this.scanner.getCurrentTokenEndPosition() + 1);
    }

    public void printEmptyLines(int linesNumber, int insertPosition) {
        StringBuffer buffer = new StringBuffer();
        if (this.lastNumberOfNewLines == 0) {
            ++linesNumber;
            int i = 0;
            while (i < linesNumber) {
                buffer.append(this.lineSeparator);
                ++i;
            }
            this.lastNumberOfNewLines += linesNumber;
            this.line += linesNumber;
            this.column = 1;
            this.needSpace = false;
        } else if (this.lastNumberOfNewLines == 1) {
            int i = 0;
            while (i < linesNumber) {
                buffer.append(this.lineSeparator);
                ++i;
            }
            this.lastNumberOfNewLines += linesNumber;
            this.line += linesNumber;
            this.column = 1;
            this.needSpace = false;
        } else {
            if (this.lastNumberOfNewLines - 1 >= linesNumber) {
                return;
            }
            int realNewLineNumber = linesNumber - this.lastNumberOfNewLines + 1;
            int i = 0;
            while (i < realNewLineNumber) {
                buffer.append(this.lineSeparator);
                ++i;
            }
            this.lastNumberOfNewLines += realNewLineNumber;
            this.line += realNewLineNumber;
            this.column = 1;
            this.needSpace = false;
        }
        this.addInsertEdit(insertPosition, buffer.toString());
    }

    private void printIndentationIfNecessary() {
        int indentationColumn = (this.useTab ? this.indentationLevel * this.tabSize : this.indentationLevel) + 1;
        if (this.column < indentationColumn) {
            StringBuffer buffer = new StringBuffer();
            int i = this.getColumnIndentationLevel();
            int max = this.indentationLevel;
            while (i < max) {
                if (this.useTab) {
                    this.tab(buffer);
                } else {
                    ++this.column;
                    buffer.append(this.fillingSpace);
                    this.needSpace = false;
                }
                ++i;
            }
            this.addInsertEdit(this.scanner.getCurrentTokenStartPosition(), buffer.toString());
        }
    }

    private void printIndentationIfNecessary(StringBuffer buffer) {
        int indentationColumn = (this.useTab ? this.indentationLevel * this.tabSize : this.indentationLevel) + 1;
        if (this.column < indentationColumn) {
            int i = this.getColumnIndentationLevel();
            int max = this.indentationLevel;
            while (i < max) {
                if (this.useTab) {
                    this.tab(buffer);
                } else {
                    ++this.column;
                    buffer.append(this.fillingSpace);
                    this.needSpace = false;
                }
                ++i;
            }
        }
    }

    public void printModifiers() {
        this.printComment();
        try {
            boolean isFirstModifier = true;
            int currentTokenStartPosition = this.scanner.currentPosition;
            boolean hasComment = false;
            while ((this.currentToken = this.scanner.getNextToken()) != 54) {
                switch (this.currentToken) {
                    case 55: 
                    case 57: 
                    case 60: 
                    case 61: 
                    case 62: 
                    case 63: 
                    case 64: 
                    case 65: 
                    case 67: 
                    case 68: {
                        this.print(this.scanner.getRawTokenSource(), !isFirstModifier);
                        isFirstModifier = false;
                        currentTokenStartPosition = this.scanner.getCurrentTokenStartPosition();
                        break;
                    }
                    case 1002: {
                        this.printBlockComment(this.scanner.getRawTokenSource(), false);
                        currentTokenStartPosition = this.scanner.currentPosition;
                        hasComment = true;
                        break;
                    }
                    case 1003: {
                        this.printBlockComment(this.scanner.getRawTokenSource(), true);
                        currentTokenStartPosition = this.scanner.currentPosition;
                        hasComment = true;
                        break;
                    }
                    case 1001: {
                        this.printCommentLine(this.scanner.getRawTokenSource());
                        currentTokenStartPosition = this.scanner.currentPosition;
                        break;
                    }
                    case 1000: {
                        this.addDeleteEdit(this.scanner.getCurrentTokenStartPosition(), this.scanner.getCurrentTokenEndPosition());
                        int count = 0;
                        char[] whiteSpaces = this.scanner.getCurrentTokenSource();
                        int i = 0;
                        int max = whiteSpaces.length;
                        while (i < max) {
                            switch (whiteSpaces[i]) {
                                case '\r': {
                                    if (i + 1 < max && whiteSpaces[i + 1] == '\n') {
                                        ++i;
                                    }
                                    ++count;
                                    break;
                                }
                                case '\n': {
                                    ++count;
                                }
                            }
                            ++i;
                        }
                        if (count >= 1 && hasComment) {
                            this.printNewLine();
                        }
                        currentTokenStartPosition = this.scanner.currentPosition;
                        hasComment = false;
                        break;
                    }
                    default: {
                        this.scanner.resetTo(currentTokenStartPosition, this.scannerEndPosition - 1);
                        return;
                    }
                }
            }
        }
        catch (InvalidInputException e) {
            throw new AbortFormatting(e);
        }
    }

    public void printNewLine() {
        if (this.lastNumberOfNewLines >= 1) {
            this.column = 1;
            return;
        }
        this.addInsertEdit(this.scanner.getCurrentTokenEndPosition() + 1, this.lineSeparator);
        ++this.line;
        this.lastNumberOfNewLines = 1;
        this.column = 1;
        this.needSpace = false;
    }

    public void printNewLine(int inserPosition) {
        if (this.lastNumberOfNewLines >= 1) {
            this.column = 1;
            return;
        }
        this.addInsertEdit(inserPosition, this.lineSeparator);
        ++this.line;
        this.lastNumberOfNewLines = 1;
        this.column = 1;
        this.needSpace = false;
    }

    public void printNextToken(int expectedTokenType) {
        this.printNextToken(expectedTokenType, false);
    }

    public void printNextToken(int expectedTokenType, boolean considerSpaceIfAny) {
        this.printComment();
        try {
            this.currentToken = this.scanner.getNextToken();
            char[] currentTokenSource = this.scanner.getRawTokenSource();
            if (expectedTokenType != this.currentToken) {
                throw new AbortFormatting("unexpected token type, expecting:" + expectedTokenType + ", actual:" + this.currentToken);
            }
            this.print(currentTokenSource, considerSpaceIfAny);
        }
        catch (InvalidInputException e) {
            throw new AbortFormatting(e);
        }
    }

    public void printNextToken(int expectedTokenType, boolean considerSpaceIfAny, boolean considerNewLineAfterComment) {
        this.printComment();
        try {
            this.currentToken = this.scanner.getNextToken();
            char[] currentTokenSource = this.scanner.getRawTokenSource();
            if (expectedTokenType != this.currentToken) {
                throw new AbortFormatting("unexpected token type, expecting:" + expectedTokenType + ", actual:" + this.currentToken);
            }
            this.print(currentTokenSource, considerSpaceIfAny);
        }
        catch (InvalidInputException e) {
            throw new AbortFormatting(e);
        }
    }

    public void printNextToken(int[] expectedTokenTypes) {
        this.printComment();
        try {
            this.currentToken = this.scanner.getNextToken();
            char[] currentTokenSource = this.scanner.getRawTokenSource();
            if (Arrays.binarySearch(expectedTokenTypes, this.currentToken) < 0) {
                StringBuffer expectations = new StringBuffer(5);
                int i = 0;
                while (i < expectedTokenTypes.length) {
                    if (i > 0) {
                        expectations.append(',');
                    }
                    expectations.append(expectedTokenTypes[i]);
                    ++i;
                }
                throw new AbortFormatting("unexpected token type, expecting:[" + expectations.toString() + "], actual:" + this.currentToken);
            }
            this.print(currentTokenSource, false);
        }
        catch (InvalidInputException e) {
            throw new AbortFormatting(e);
        }
    }

    public void printNextToken(int[] expectedTokenTypes, boolean considerSpaceIfAny, boolean considerNewLineAfterComment) {
        this.printComment();
        try {
            this.currentToken = this.scanner.getNextToken();
            char[] currentTokenSource = this.scanner.getRawTokenSource();
            if (Arrays.binarySearch(expectedTokenTypes, this.currentToken) < 0) {
                StringBuffer expectations = new StringBuffer(5);
                int i = 0;
                while (i < expectedTokenTypes.length) {
                    if (i > 0) {
                        expectations.append(',');
                    }
                    expectations.append(expectedTokenTypes[i]);
                    ++i;
                }
                throw new AbortFormatting("unexpected token type, expecting:[" + expectations.toString() + "], actual:" + this.currentToken);
            }
            this.print(currentTokenSource, considerSpaceIfAny);
        }
        catch (InvalidInputException e) {
            throw new AbortFormatting(e);
        }
    }

    public void printQualifiedReference(int sourceEnd) {
        try {
            do {
                this.printComment();
                this.currentToken = this.scanner.getNextToken();
                switch (this.currentToken) {
                    case 54: {
                        return;
                    }
                    case 1000: {
                        this.addDeleteEdit(this.scanner.getCurrentTokenStartPosition(), this.scanner.getCurrentTokenEndPosition());
                        break;
                    }
                    default: {
                        this.print(this.scanner.getRawTokenSource(), false);
                    }
                }
            } while (this.scanner.currentPosition < sourceEnd);
        }
        catch (InvalidInputException e) {
            throw new AbortFormatting(e);
        }
    }

    private void printRule(StringBuffer stringBuffer) {
        int i = 0;
        while (i < this.pageWidth) {
            if (i % this.tabSize == 0) {
                stringBuffer.append('+');
            } else {
                stringBuffer.append('-');
            }
            ++i;
        }
        stringBuffer.append(this.lineSeparator);
        i = 0;
        while (i < this.pageWidth / this.tabSize) {
            stringBuffer.append(i);
            stringBuffer.append('\t');
            ++i;
        }
    }

    public void printTrailingComment() {
        try {
            int currentTokenStartPosition = this.scanner.currentPosition;
            boolean hasWhitespaces = false;
            boolean hasComment = false;
            boolean hasLineComment = false;
            while ((this.currentToken = this.scanner.getNextToken()) != 54) {
                switch (this.currentToken) {
                    case 1000: {
                        int count = 0;
                        char[] whiteSpaces = this.scanner.getCurrentTokenSource();
                        int i = 0;
                        int max = whiteSpaces.length;
                        while (i < max) {
                            switch (whiteSpaces[i]) {
                                case '\r': {
                                    if (i + 1 < max && whiteSpaces[i + 1] == '\n') {
                                        ++i;
                                    }
                                    ++count;
                                    break;
                                }
                                case '\n': {
                                    ++count;
                                }
                            }
                            ++i;
                        }
                        if (hasLineComment) {
                            if (count >= 1) {
                                currentTokenStartPosition = this.scanner.getCurrentTokenStartPosition();
                                this.preserveEmptyLines(count, currentTokenStartPosition);
                                this.addDeleteEdit(currentTokenStartPosition, this.scanner.getCurrentTokenEndPosition());
                                this.scanner.resetTo(this.scanner.currentPosition, this.scannerEndPosition - 1);
                                return;
                            }
                            this.scanner.resetTo(currentTokenStartPosition, this.scannerEndPosition - 1);
                            return;
                        }
                        if (count >= 1) {
                            if (hasComment) {
                                this.printNewLine(this.scanner.getCurrentTokenStartPosition());
                            }
                            this.scanner.resetTo(currentTokenStartPosition, this.scannerEndPosition - 1);
                            return;
                        }
                        hasWhitespaces = true;
                        currentTokenStartPosition = this.scanner.currentPosition;
                        this.addDeleteEdit(this.scanner.getCurrentTokenStartPosition(), this.scanner.getCurrentTokenEndPosition());
                        break;
                    }
                    case 1001: {
                        if (hasWhitespaces) {
                            this.space(this.scanner.getCurrentTokenStartPosition());
                        }
                        this.printCommentLine(this.scanner.getRawTokenSource());
                        currentTokenStartPosition = this.scanner.currentPosition;
                        hasLineComment = true;
                        break;
                    }
                    case 1002: {
                        if (hasWhitespaces) {
                            this.space(this.scanner.getCurrentTokenStartPosition());
                        }
                        this.printBlockComment(this.scanner.getRawTokenSource(), false);
                        currentTokenStartPosition = this.scanner.currentPosition;
                        hasComment = true;
                        break;
                    }
                    default: {
                        this.scanner.resetTo(currentTokenStartPosition, this.scannerEndPosition - 1);
                        return;
                    }
                }
            }
        }
        catch (InvalidInputException e) {
            throw new AbortFormatting(e);
        }
    }

    void redoAlignment(AlignmentException e) {
        if (e.relativeDepth > 0) {
            --e.relativeDepth;
            this.currentAlignment = this.currentAlignment.enclosing;
            throw e;
        }
        this.resetAt(this.currentAlignment.location);
        this.scanner.resetTo(this.currentAlignment.location.inputOffset, this.scanner.eofPosition);
        this.currentAlignment.chunkKind = 0;
        this.formatter.lastLocalDeclarationSourceStart = -1;
    }

    void redoMemberAlignment(AlignmentException e) {
        this.resetAt(this.memberAlignment.location);
        this.scanner.resetTo(this.memberAlignment.location.inputOffset, this.scanner.eofPosition);
        this.memberAlignment.chunkKind = 0;
        this.formatter.lastLocalDeclarationSourceStart = -1;
    }

    public void reset() {
        this.checkLineWrapping = true;
        this.line = 0;
        this.column = 1;
        this.editsIndex = 0;
    }

    private void resetAt(Location location) {
        this.line = location.outputLine;
        this.column = location.outputColumn;
        this.indentationLevel = location.outputIndentationLevel;
        this.lastNumberOfNewLines = location.lastNumberOfNewLines;
        this.needSpace = location.needSpace;
        this.editsIndex = location.editsIndex;
        if (this.editsIndex > 0) {
            this.edits[this.editsIndex - 1] = location.textEdit;
        }
    }

    private void resize() {
        this.edits = new OptimizedReplaceEdit[this.editsIndex * 2];
        System.arraycopy(this.edits, 0, this.edits, 0, this.editsIndex);
    }

    public void setLineSeparatorAndIdentationLevel(DefaultCodeFormatterOptions preferences) {
        this.lineSeparator = preferences.line_separator;
        this.indentationLevel = this.useTab ? preferences.initial_indentation_level : preferences.initial_indentation_level * this.tabSize;
    }

    public void space() {
        if (!this.needSpace) {
            return;
        }
        this.lastNumberOfNewLines = 0;
        this.addInsertEdit(this.scanner.getCurrentTokenEndPosition() + 1, " ");
        ++this.column;
        this.needSpace = false;
    }

    private void space(int insertPosition) {
        if (!this.needSpace) {
            return;
        }
        this.lastNumberOfNewLines = 0;
        this.addInsertEdit(insertPosition, " ");
        ++this.column;
        this.needSpace = false;
    }

    private void tab(StringBuffer buffer) {
        this.lastNumberOfNewLines = 0;
        int complement = this.tabSize - (this.column - 1) % this.tabSize;
        if (this.useTab) {
            buffer.append('\t');
        } else {
            int i = 0;
            while (i < complement) {
                buffer.append(this.fillingSpace);
                ++i;
            }
        }
        this.column += complement;
        this.needSpace = false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(page witdh = " + this.pageWidth + ") - (useTab = " + this.useTab + ") - (tabSize = " + this.tabSize + ")").append(this.lineSeparator).append("(line = " + this.line + ") - (column = " + this.column + ") - (identationLevel = " + this.indentationLevel + ")").append(this.lineSeparator).append("(needSpace = " + this.needSpace + ") - (lastNumberOfNewLines = " + this.lastNumberOfNewLines + ") - (checkLineWrapping = " + this.checkLineWrapping + ")").append(this.lineSeparator).append("==================================================================================").append(this.lineSeparator);
        this.printRule(stringBuffer);
        return stringBuffer.toString();
    }

    public void unIndent() {
        this.indentationLevel = this.useTab ? --this.indentationLevel : (this.indentationLevel -= this.tabSize);
    }
}

