/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.formatter;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.core.formatter.DefaultCodeFormatterConstants;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.AND_AND_Expression;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.AllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.ArrayAllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.ArrayInitializer;
import org.eclipse.jdt.internal.compiler.ast.ArrayQualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.ArrayReference;
import org.eclipse.jdt.internal.compiler.ast.ArrayTypeReference;
import org.eclipse.jdt.internal.compiler.ast.AssertStatement;
import org.eclipse.jdt.internal.compiler.ast.Assignment;
import org.eclipse.jdt.internal.compiler.ast.BinaryExpression;
import org.eclipse.jdt.internal.compiler.ast.Block;
import org.eclipse.jdt.internal.compiler.ast.BreakStatement;
import org.eclipse.jdt.internal.compiler.ast.CaseStatement;
import org.eclipse.jdt.internal.compiler.ast.CastExpression;
import org.eclipse.jdt.internal.compiler.ast.CharLiteral;
import org.eclipse.jdt.internal.compiler.ast.ClassLiteralAccess;
import org.eclipse.jdt.internal.compiler.ast.Clinit;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.CompoundAssignment;
import org.eclipse.jdt.internal.compiler.ast.ConditionalExpression;
import org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ContinueStatement;
import org.eclipse.jdt.internal.compiler.ast.DoStatement;
import org.eclipse.jdt.internal.compiler.ast.DoubleLiteral;
import org.eclipse.jdt.internal.compiler.ast.EmptyStatement;
import org.eclipse.jdt.internal.compiler.ast.EqualExpression;
import org.eclipse.jdt.internal.compiler.ast.ExplicitConstructorCall;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.FalseLiteral;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.FieldReference;
import org.eclipse.jdt.internal.compiler.ast.FloatLiteral;
import org.eclipse.jdt.internal.compiler.ast.ForStatement;
import org.eclipse.jdt.internal.compiler.ast.IfStatement;
import org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.eclipse.jdt.internal.compiler.ast.Initializer;
import org.eclipse.jdt.internal.compiler.ast.InstanceOfExpression;
import org.eclipse.jdt.internal.compiler.ast.IntLiteral;
import org.eclipse.jdt.internal.compiler.ast.LabeledStatement;
import org.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.jdt.internal.compiler.ast.LongLiteral;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.NullLiteral;
import org.eclipse.jdt.internal.compiler.ast.OR_OR_Expression;
import org.eclipse.jdt.internal.compiler.ast.PostfixExpression;
import org.eclipse.jdt.internal.compiler.ast.PrefixExpression;
import org.eclipse.jdt.internal.compiler.ast.QualifiedAllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.QualifiedNameReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedSuperReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedThisReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.ReturnStatement;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.SingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.StringLiteral;
import org.eclipse.jdt.internal.compiler.ast.SuperReference;
import org.eclipse.jdt.internal.compiler.ast.SwitchStatement;
import org.eclipse.jdt.internal.compiler.ast.SynchronizedStatement;
import org.eclipse.jdt.internal.compiler.ast.ThisReference;
import org.eclipse.jdt.internal.compiler.ast.ThrowStatement;
import org.eclipse.jdt.internal.compiler.ast.TrueLiteral;
import org.eclipse.jdt.internal.compiler.ast.TryStatement;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.ast.UnaryExpression;
import org.eclipse.jdt.internal.compiler.ast.WhileStatement;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.parser.Scanner;
import org.eclipse.jdt.internal.formatter.AbortFormatting;
import org.eclipse.jdt.internal.formatter.BinaryExpressionFragmentBuilder;
import org.eclipse.jdt.internal.formatter.CascadingMethodInvocationFragmentBuilder;
import org.eclipse.jdt.internal.formatter.DefaultCodeFormatterOptions;
import org.eclipse.jdt.internal.formatter.Scribe;
import org.eclipse.jdt.internal.formatter.align.Alignment;
import org.eclipse.jdt.internal.formatter.align.AlignmentException;
import org.eclipse.text.edits.TextEdit;

public class CodeFormatterVisitor
extends ASTVisitor {
    public static boolean DEBUG = false;
    private static final int NO_MODIFIERS = 0;
    private static final int[] SINGLETYPEREFERENCE_EXPECTEDTOKENS = new int[]{28, 31, 32, 33, 34, 35, 36, 37, 38, 39};
    private int chunkKind;
    public int lastLocalDeclarationSourceStart;
    private Scanner localScanner;
    public DefaultCodeFormatterOptions preferences;
    public Scribe scribe;

    public CodeFormatterVisitor() {
        this(new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getJavaConventionsSettings()), JavaCore.getDefaultOptions(), 0, -1);
    }

    public CodeFormatterVisitor(DefaultCodeFormatterOptions preferences, Map settings, int offset, int length) {
        Object assertModeSetting;
        this.localScanner = settings != null ? ((assertModeSetting = settings.get("org.eclipse.jdt.core.compiler.source")) == null ? new Scanner(true, false, false, "1.4".equals(assertModeSetting) ? 0x300000L : 0x2F0000L, null, null) : new Scanner(true, false, false, 0x2F0000L, null, null)) : new Scanner(true, false, false, 0x2F0000L, null, null);
        this.preferences = preferences;
        this.scribe = new Scribe(this, settings, offset, length);
    }

    public void acceptProblem(IProblem problem) {
        super.acceptProblem(problem);
    }

    private BinaryExpressionFragmentBuilder buildFragments(BinaryExpression binaryExpression, BlockScope scope) {
        BinaryExpressionFragmentBuilder builder = new BinaryExpressionFragmentBuilder();
        switch ((binaryExpression.bits & 0xFC0) >> 6) {
            case 15: {
                binaryExpression.left.traverse(builder, scope);
                builder.operatorsList.add(new Integer(4));
                binaryExpression.right.traverse(builder, scope);
                break;
            }
            case 14: {
                binaryExpression.left.traverse(builder, scope);
                builder.operatorsList.add(new Integer(1));
                binaryExpression.right.traverse(builder, scope);
                break;
            }
            case 9: {
                binaryExpression.left.traverse(builder, scope);
                builder.operatorsList.add(new Integer(6));
                binaryExpression.right.traverse(builder, scope);
                break;
            }
            case 16: {
                binaryExpression.left.traverse(builder, scope);
                builder.operatorsList.add(new Integer(5));
                binaryExpression.right.traverse(builder, scope);
                break;
            }
            case 8: {
                binaryExpression.left.traverse(builder, scope);
                builder.operatorsList.add(new Integer(21));
                binaryExpression.right.traverse(builder, scope);
                break;
            }
            case 13: {
                binaryExpression.left.traverse(builder, scope);
                builder.operatorsList.add(new Integer(2));
                binaryExpression.right.traverse(builder, scope);
                break;
            }
            case 3: {
                binaryExpression.left.traverse(builder, scope);
                builder.operatorsList.add(new Integer(22));
                binaryExpression.right.traverse(builder, scope);
                break;
            }
            case 2: {
                binaryExpression.left.traverse(builder, scope);
                builder.operatorsList.add(new Integer(20));
                binaryExpression.right.traverse(builder, scope);
                break;
            }
            case 0: {
                binaryExpression.left.traverse(builder, scope);
                builder.operatorsList.add(new Integer(25));
                binaryExpression.right.traverse(builder, scope);
                break;
            }
            case 1: {
                binaryExpression.left.traverse(builder, scope);
                builder.operatorsList.add(new Integer(24));
                binaryExpression.right.traverse(builder, scope);
            }
        }
        return builder;
    }

    private CascadingMethodInvocationFragmentBuilder buildFragments(MessageSend messageSend, BlockScope scope) {
        CascadingMethodInvocationFragmentBuilder builder = new CascadingMethodInvocationFragmentBuilder();
        messageSend.traverse(builder, scope);
        return builder;
    }

    public boolean checkChunkStart(int kind) {
        if (this.chunkKind != kind) {
            this.chunkKind = kind;
            return true;
        }
        return false;
    }

    private ASTNode[] computeMergedMemberDeclarations(TypeDeclaration typeDeclaration) {
        int fieldIndex = 0;
        int fieldCount = typeDeclaration.fields == null ? 0 : typeDeclaration.fields.length;
        FieldDeclaration field = fieldCount == 0 ? null : typeDeclaration.fields[fieldIndex];
        int fieldStart = field == null ? Integer.MAX_VALUE : field.declarationSourceStart;
        int methodIndex = 0;
        int methodCount = typeDeclaration.methods == null ? 0 : typeDeclaration.methods.length;
        AbstractMethodDeclaration method = methodCount == 0 ? null : typeDeclaration.methods[methodIndex];
        int methodStart = method == null ? Integer.MAX_VALUE : method.declarationSourceStart;
        int typeIndex = 0;
        int typeCount = typeDeclaration.memberTypes == null ? 0 : typeDeclaration.memberTypes.length;
        TypeDeclaration type = typeCount == 0 ? null : typeDeclaration.memberTypes[typeIndex];
        int typeStart = type == null ? Integer.MAX_VALUE : type.declarationSourceStart;
        int memberLength = fieldCount + methodCount + typeCount;
        ASTNode[] members = new ASTNode[memberLength];
        if (memberLength != 0) {
            int index = 0;
            int previousFieldStart = -1;
            do {
                if (fieldStart < methodStart && fieldStart < typeStart) {
                    if (fieldStart == previousFieldStart) {
                        ASTNode previousMember = members[index - 1];
                        if (previousMember instanceof MultiFieldDeclaration) {
                            MultiFieldDeclaration multiField = (MultiFieldDeclaration)previousMember;
                            int length = multiField.declarations.length;
                            multiField.declarations = new FieldDeclaration[length + 1];
                            System.arraycopy(multiField.declarations, 0, multiField.declarations, 0, length);
                            multiField.declarations[length] = field;
                        } else {
                            members[index - 1] = new MultiFieldDeclaration(new FieldDeclaration[]{(FieldDeclaration)previousMember, field});
                        }
                    } else {
                        members[index++] = field;
                    }
                    previousFieldStart = fieldStart;
                    if (++fieldIndex < fieldCount) {
                        field = typeDeclaration.fields[fieldIndex];
                        fieldStart = field.declarationSourceStart;
                        continue;
                    }
                    fieldStart = Integer.MAX_VALUE;
                    continue;
                }
                if (methodStart < fieldStart && methodStart < typeStart) {
                    if (!method.isDefaultConstructor() && !method.isClinit()) {
                        members[index++] = method;
                    }
                    if (++methodIndex < methodCount) {
                        method = typeDeclaration.methods[methodIndex];
                        methodStart = method.declarationSourceStart;
                        continue;
                    }
                    methodStart = Integer.MAX_VALUE;
                    continue;
                }
                members[index++] = type;
                if (++typeIndex < typeCount) {
                    type = typeDeclaration.memberTypes[typeIndex];
                    typeStart = type.declarationSourceStart;
                    continue;
                }
                typeStart = Integer.MAX_VALUE;
            } while (fieldIndex < fieldCount || typeIndex < typeCount || methodIndex < methodCount);
            if (members.length != index) {
                ASTNode[] aSTNodeArray = members;
                members = new ASTNode[index];
                System.arraycopy(aSTNodeArray, 0, members, 0, index);
            }
        }
        return members;
    }

    private ASTNode[] computeMergedMemberDeclarations(ASTNode[] nodes) {
        ArrayList<ASTNode> mergedNodes = new ArrayList<ASTNode>();
        int i = 0;
        int max = nodes.length;
        while (i < max) {
            ASTNode currentNode = nodes[i];
            if (currentNode instanceof FieldDeclaration) {
                FieldDeclaration currentField = (FieldDeclaration)currentNode;
                if (mergedNodes.size() == 0) {
                    mergedNodes.add(currentNode);
                } else {
                    ASTNode previousMergedNode = (ASTNode)mergedNodes.get(mergedNodes.size() - 1);
                    if (previousMergedNode instanceof MultiFieldDeclaration) {
                        MultiFieldDeclaration multiFieldDeclaration = (MultiFieldDeclaration)previousMergedNode;
                        int length = multiFieldDeclaration.declarations.length;
                        multiFieldDeclaration.declarations = new FieldDeclaration[length + 1];
                        System.arraycopy(multiFieldDeclaration.declarations, 0, multiFieldDeclaration.declarations, 0, length);
                        multiFieldDeclaration.declarations[length] = currentField;
                    } else if (previousMergedNode instanceof FieldDeclaration) {
                        if (currentField.declarationSourceStart == ((FieldDeclaration)previousMergedNode).declarationSourceStart) {
                            mergedNodes.set(mergedNodes.size() - 1, new MultiFieldDeclaration(new FieldDeclaration[]{(FieldDeclaration)previousMergedNode, currentField}));
                        }
                    } else {
                        mergedNodes.add(currentNode);
                    }
                }
            } else {
                mergedNodes.add(currentNode);
            }
            ++i;
        }
        if (mergedNodes.size() != nodes.length) {
            ASTNode[] result = new ASTNode[mergedNodes.size()];
            mergedNodes.toArray(result);
            return result;
        }
        return nodes;
    }

    private boolean dumpBinaryExpression(BinaryExpression binaryExpression, int operator, BlockScope scope) {
        int numberOfParens = (binaryExpression.bits & 0x1FE00000) >> 21;
        if (numberOfParens > 0) {
            this.manageOpeningParenthesizedExpression(binaryExpression, numberOfParens);
        }
        BinaryExpressionFragmentBuilder builder = this.buildFragments(binaryExpression, scope);
        int fragmentsSize = builder.size();
        if ((builder.realFragmentsSize() > 1 || builder.size() > 4) && numberOfParens == 0) {
            this.scribe.printComment();
            Alignment binaryExpressionAlignment = this.scribe.createAlignment("binaryExpressionAlignment", this.preferences.binary_expression_alignment, 1, fragmentsSize, this.scribe.scanner.currentPosition);
            this.scribe.enterAlignment(binaryExpressionAlignment);
            boolean ok = false;
            ASTNode[] fragments = builder.fragments();
            int[] operators = builder.operators();
            do {
                try {
                    int i = 0;
                    while (i < fragmentsSize - 1) {
                        ASTNode fragment = fragments[i];
                        fragment.traverse(this, scope);
                        this.scribe.alignFragment(binaryExpressionAlignment, i);
                        this.scribe.printNextToken(operators[i], this.preferences.insert_space_before_binary_operator);
                        if (operators[i] == 2 && this.isMinus()) {
                            this.scribe.space();
                        }
                        if (this.preferences.insert_space_after_binary_operator) {
                            this.scribe.space();
                        }
                        this.scribe.printTrailingComment();
                        ++i;
                    }
                    fragments[fragmentsSize - 1].traverse(this, scope);
                    ok = true;
                }
                catch (AlignmentException e) {
                    this.scribe.redoAlignment(e);
                }
            } while (!ok);
            this.scribe.exitAlignment(binaryExpressionAlignment, true);
        } else {
            binaryExpression.left.traverse(this, scope);
            this.scribe.printNextToken(operator, this.preferences.insert_space_before_binary_operator);
            if (operator == 2 && this.isMinus()) {
                this.scribe.space();
            }
            if (this.preferences.insert_space_after_binary_operator) {
                this.scribe.space();
            }
            binaryExpression.right.traverse(this, scope);
        }
        if (numberOfParens > 0) {
            this.manageClosingParenthesizedExpression(binaryExpression, numberOfParens);
        }
        return false;
    }

    private boolean dumpEqualityExpression(BinaryExpression binaryExpression, int operator, BlockScope scope) {
        int numberOfParens = (binaryExpression.bits & 0x1FE00000) >> 21;
        if (numberOfParens > 0) {
            this.manageOpeningParenthesizedExpression(binaryExpression, numberOfParens);
        }
        binaryExpression.left.traverse(this, scope);
        this.scribe.printNextToken(operator, this.preferences.insert_space_before_binary_operator);
        if (this.preferences.insert_space_after_binary_operator) {
            this.scribe.space();
        }
        binaryExpression.right.traverse(this, scope);
        if (numberOfParens > 0) {
            this.manageClosingParenthesizedExpression(binaryExpression, numberOfParens);
        }
        return false;
    }

    private final TextEdit failedToFormat() {
        if (DEBUG) {
            System.out.println("COULD NOT FORMAT \n" + this.scribe.scanner);
            System.out.println(this.scribe);
        }
        return null;
    }

    private void format(AbstractMethodDeclaration methodDeclaration, ClassScope scope, boolean isChunkStart, boolean isFirstClassBodyDeclaration) {
        int newLinesBeforeMethod;
        if (isFirstClassBodyDeclaration) {
            int newLinesBeforeFirstClassBodyDeclaration = this.preferences.blank_lines_before_first_class_body_declaration;
            if (newLinesBeforeFirstClassBodyDeclaration > 0) {
                this.scribe.printEmptyLines(newLinesBeforeFirstClassBodyDeclaration);
            }
        } else {
            int newLineBeforeChunk;
            int n = newLineBeforeChunk = isChunkStart ? this.preferences.blank_lines_before_new_chunk : 0;
            if (newLineBeforeChunk > 0) {
                this.scribe.printEmptyLines(newLineBeforeChunk);
            }
        }
        if ((newLinesBeforeMethod = this.preferences.blank_lines_before_method) > 0 && !isFirstClassBodyDeclaration) {
            this.scribe.printEmptyLines(newLinesBeforeMethod);
        } else if (this.scribe.line != 0 || this.scribe.column != 1) {
            this.scribe.printNewLine();
        }
        methodDeclaration.traverse((ASTVisitor)this, scope);
    }

    private void format(FieldDeclaration fieldDeclaration, ASTVisitor visitor, MethodScope scope, boolean isChunkStart, boolean isFirstClassBodyDeclaration) {
        Expression initialization;
        if (isFirstClassBodyDeclaration) {
            int newLinesBeforeFirstClassBodyDeclaration = this.preferences.blank_lines_before_first_class_body_declaration;
            if (newLinesBeforeFirstClassBodyDeclaration > 0) {
                this.scribe.printEmptyLines(newLinesBeforeFirstClassBodyDeclaration);
            }
        } else {
            int newLinesBeforeField;
            int newLineBeforeChunk;
            int n = newLineBeforeChunk = isChunkStart ? this.preferences.blank_lines_before_new_chunk : 0;
            if (newLineBeforeChunk > 0) {
                this.scribe.printEmptyLines(newLineBeforeChunk);
            }
            if ((newLinesBeforeField = this.preferences.blank_lines_before_field) > 0) {
                this.scribe.printEmptyLines(newLinesBeforeField);
            }
        }
        Alignment memberAlignment = this.scribe.getMemberAlignment();
        this.scribe.printModifiers();
        this.scribe.space();
        fieldDeclaration.type.traverse((ASTVisitor)this, scope);
        this.scribe.alignFragment(memberAlignment, 0);
        this.scribe.printNextToken(28, true);
        int extraDimensions = this.getExtraDimension();
        if (extraDimensions != 0) {
            int i = 0;
            while (i < extraDimensions) {
                this.scribe.printNextToken(12);
                this.scribe.printNextToken(69);
                ++i;
            }
        }
        if ((initialization = fieldDeclaration.initialization) != null) {
            this.scribe.alignFragment(memberAlignment, 1);
            this.scribe.printNextToken(90, this.preferences.insert_space_before_assignment_operators);
            if (!(initialization instanceof ArrayInitializer) && this.preferences.insert_space_after_assignment_operators) {
                this.scribe.space();
            }
            initialization.traverse(this, scope);
        }
        this.scribe.printNextToken(23, this.preferences.insert_space_before_semicolon);
        if (memberAlignment != null) {
            this.scribe.alignFragment(memberAlignment, 2);
            this.scribe.printTrailingComment();
        } else {
            this.scribe.space();
            this.scribe.printTrailingComment();
        }
    }

    private void format(TypeDeclaration memberTypeDeclaration, ClassScope scope, boolean isChunkStart, boolean isFirstClassBodyDeclaration) {
        if (isFirstClassBodyDeclaration) {
            int newLinesBeforeFirstClassBodyDeclaration = this.preferences.blank_lines_before_first_class_body_declaration;
            if (newLinesBeforeFirstClassBodyDeclaration > 0) {
                this.scribe.printEmptyLines(newLinesBeforeFirstClassBodyDeclaration);
            }
        } else {
            int newLinesBeforeMember;
            int newLineBeforeChunk;
            int n = newLineBeforeChunk = isChunkStart ? this.preferences.blank_lines_before_new_chunk : 0;
            if (newLineBeforeChunk > 0) {
                this.scribe.printEmptyLines(newLineBeforeChunk);
            }
            if ((newLinesBeforeMember = this.preferences.blank_lines_before_member_type) > 0) {
                this.scribe.printEmptyLines(newLinesBeforeMember);
            }
        }
        memberTypeDeclaration.traverse((ASTVisitor)this, scope);
    }

    private void format(MultiFieldDeclaration multiFieldDeclaration, ASTVisitor visitor, MethodScope scope, boolean isChunkStart, boolean isFirstClassBodyDeclaration) {
        if (isFirstClassBodyDeclaration) {
            int newLinesBeforeFirstClassBodyDeclaration = this.preferences.blank_lines_before_first_class_body_declaration;
            if (newLinesBeforeFirstClassBodyDeclaration > 0) {
                this.scribe.printEmptyLines(newLinesBeforeFirstClassBodyDeclaration);
            }
        } else {
            int newLinesBeforeField;
            int newLineBeforeChunk;
            int n = newLineBeforeChunk = isChunkStart ? this.preferences.blank_lines_before_new_chunk : 0;
            if (newLineBeforeChunk > 0) {
                this.scribe.printEmptyLines(newLineBeforeChunk);
            }
            if ((newLinesBeforeField = this.preferences.blank_lines_before_field) > 0) {
                this.scribe.printEmptyLines(newLinesBeforeField);
            }
        }
        Alignment fieldAlignment = this.scribe.getMemberAlignment();
        this.scribe.printModifiers();
        this.scribe.space();
        multiFieldDeclaration.declarations[0].type.traverse((ASTVisitor)this, scope);
        int multipleFieldDeclarationsLength = multiFieldDeclaration.declarations.length;
        Alignment multiFieldDeclarationsAlignment = this.scribe.createAlignment("multiple_field", this.preferences.multiple_fields_alignment, multipleFieldDeclarationsLength - 1, this.scribe.scanner.currentPosition);
        this.scribe.enterAlignment(multiFieldDeclarationsAlignment);
        boolean ok = false;
        do {
            try {
                int i = 0;
                int length = multipleFieldDeclarationsLength;
                while (i < length) {
                    Expression initialization;
                    FieldDeclaration fieldDeclaration = multiFieldDeclaration.declarations[i];
                    if (i == 0) {
                        this.scribe.alignFragment(fieldAlignment, 0);
                        this.scribe.printNextToken(28, true);
                    } else {
                        this.scribe.printNextToken(28, false);
                    }
                    int extraDimensions = this.getExtraDimension();
                    if (extraDimensions != 0) {
                        int index = 0;
                        while (index < extraDimensions) {
                            this.scribe.printNextToken(12);
                            this.scribe.printNextToken(69);
                            ++index;
                        }
                    }
                    if ((initialization = fieldDeclaration.initialization) != null) {
                        if (i == 0) {
                            this.scribe.alignFragment(fieldAlignment, 1);
                        }
                        this.scribe.printNextToken(90, this.preferences.insert_space_before_assignment_operators);
                        if (!(initialization instanceof ArrayInitializer) && this.preferences.insert_space_after_assignment_operators) {
                            this.scribe.space();
                        }
                        initialization.traverse(this, scope);
                    }
                    if (i != length - 1) {
                        this.scribe.printNextToken(30, this.preferences.insert_space_before_comma_in_multiple_field_declarations);
                        this.scribe.alignFragment(multiFieldDeclarationsAlignment, i);
                        if (this.preferences.insert_space_after_comma_in_multiple_field_declarations) {
                            this.scribe.space();
                        }
                    } else {
                        this.scribe.printNextToken(23, this.preferences.insert_space_before_semicolon);
                        this.scribe.alignFragment(fieldAlignment, 2);
                        this.scribe.printTrailingComment();
                    }
                    ++i;
                }
                ok = true;
            }
            catch (AlignmentException e) {
                this.scribe.redoAlignment(e);
            }
        } while (!ok);
        this.scribe.exitAlignment(multiFieldDeclarationsAlignment, true);
    }

    public TextEdit format(String string, ASTNode[] nodes) {
        this.scribe.reset();
        long startTime = System.currentTimeMillis();
        char[] compilationUnitSource = string.toCharArray();
        this.localScanner.setSource(compilationUnitSource);
        this.scribe.initializeScanner(compilationUnitSource);
        if (nodes == null) {
            return null;
        }
        this.lastLocalDeclarationSourceStart = -1;
        try {
            this.formatClassBodyDeclarations(nodes);
        }
        catch (AbortFormatting abortFormatting) {
            return this.failedToFormat();
        }
        if (DEBUG) {
            System.out.println("Formatting time: " + (System.currentTimeMillis() - startTime));
        }
        return this.scribe.getRootEdit();
    }

    public TextEdit format(String string, CompilationUnitDeclaration compilationUnitDeclaration) {
        this.scribe.reset();
        if (compilationUnitDeclaration == null || compilationUnitDeclaration.ignoreFurtherInvestigation) {
            return this.failedToFormat();
        }
        long startTime = System.currentTimeMillis();
        char[] compilationUnitSource = string.toCharArray();
        this.localScanner.setSource(compilationUnitSource);
        this.scribe.initializeScanner(compilationUnitSource);
        this.lastLocalDeclarationSourceStart = -1;
        try {
            compilationUnitDeclaration.traverse((ASTVisitor)this, compilationUnitDeclaration.scope);
        }
        catch (AbortFormatting abortFormatting) {
            return this.failedToFormat();
        }
        if (DEBUG) {
            System.out.println("Formatting time: " + (System.currentTimeMillis() - startTime));
        }
        return this.scribe.getRootEdit();
    }

    public TextEdit format(String string, ConstructorDeclaration constructorDeclaration) {
        this.scribe.reset();
        long startTime = System.currentTimeMillis();
        char[] compilationUnitSource = string.toCharArray();
        this.localScanner.setSource(compilationUnitSource);
        this.scribe.initializeScanner(compilationUnitSource);
        if (constructorDeclaration == null) {
            return null;
        }
        this.lastLocalDeclarationSourceStart = -1;
        try {
            Statement[] statements;
            ExplicitConstructorCall explicitConstructorCall = constructorDeclaration.constructorCall;
            if (explicitConstructorCall != null && !explicitConstructorCall.isImplicitSuper()) {
                explicitConstructorCall.traverse(this, null);
            }
            if ((statements = constructorDeclaration.statements) != null) {
                this.formatStatements(null, statements, false);
            }
            if (this.hasComments()) {
                this.scribe.printNewLine();
            }
            this.scribe.printComment();
        }
        catch (AbortFormatting abortFormatting) {
            return this.failedToFormat();
        }
        if (DEBUG) {
            System.out.println("Formatting time: " + (System.currentTimeMillis() - startTime));
        }
        return this.scribe.getRootEdit();
    }

    public TextEdit format(String string, Expression expression) {
        this.scribe.reset();
        long startTime = System.currentTimeMillis();
        char[] compilationUnitSource = string.toCharArray();
        this.localScanner.setSource(compilationUnitSource);
        this.scribe.initializeScanner(compilationUnitSource);
        if (expression == null) {
            return null;
        }
        this.lastLocalDeclarationSourceStart = -1;
        try {
            expression.traverse(this, null);
            this.scribe.printComment();
        }
        catch (AbortFormatting abortFormatting) {
            return this.failedToFormat();
        }
        if (DEBUG) {
            System.out.println("Formatting time: " + (System.currentTimeMillis() - startTime));
        }
        return this.scribe.getRootEdit();
    }

    private void format(TypeDeclaration typeDeclaration) {
        TypeReference[] superInterfaces;
        if ((typeDeclaration.bits & 0x200) != 0) {
            String anonymous_type_declaration_brace_position = this.preferences.anonymous_type_declaration_brace_position;
            this.formatTypeOpeningBrace(anonymous_type_declaration_brace_position, this.preferences.insert_space_before_anonymous_type_open_brace, typeDeclaration);
            this.scribe.indent();
            this.formatTypeMembers(typeDeclaration);
            this.scribe.printComment();
            this.scribe.unIndent();
            if (this.preferences.insert_new_line_in_empty_anonymous_type_declaration) {
                this.scribe.printNewLine();
            }
            this.scribe.printNextToken(40);
            if (anonymous_type_declaration_brace_position.equals("next_line_shifted")) {
                this.scribe.unIndent();
            }
            return;
        }
        this.scribe.printModifiers();
        if (typeDeclaration.isInterface()) {
            this.scribe.printNextToken(89, true);
        } else {
            this.scribe.printNextToken(81, true);
        }
        this.scribe.printNextToken(28, true);
        TypeReference superclass = typeDeclaration.superclass;
        if (superclass != null) {
            Alignment superclassAlignment = this.scribe.createAlignment("superclass", this.preferences.type_declaration_superclass_alignment, 2, this.scribe.scanner.currentPosition);
            this.scribe.enterAlignment(superclassAlignment);
            boolean ok = false;
            do {
                try {
                    this.scribe.alignFragment(superclassAlignment, 0);
                    this.scribe.printNextToken(91, true);
                    this.scribe.alignFragment(superclassAlignment, 1);
                    this.scribe.space();
                    superclass.traverse((ASTVisitor)this, typeDeclaration.scope);
                    ok = true;
                }
                catch (AlignmentException e) {
                    this.scribe.redoAlignment(e);
                }
            } while (!ok);
            this.scribe.exitAlignment(superclassAlignment, true);
        }
        if ((superInterfaces = typeDeclaration.superInterfaces) != null) {
            int superInterfaceLength = superInterfaces.length;
            Alignment interfaceAlignment = this.scribe.createAlignment("superInterfaces", this.preferences.type_declaration_superinterfaces_alignment, superInterfaceLength + 1, this.scribe.scanner.currentPosition);
            this.scribe.enterAlignment(interfaceAlignment);
            boolean ok = false;
            do {
                try {
                    this.scribe.alignFragment(interfaceAlignment, 0);
                    if (typeDeclaration.isInterface()) {
                        this.scribe.printNextToken(91, true);
                    } else {
                        this.scribe.printNextToken(103, true);
                    }
                    int i = 0;
                    while (i < superInterfaceLength) {
                        if (i > 0) {
                            this.scribe.printNextToken(30, this.preferences.insert_space_before_comma_in_superinterfaces);
                            this.scribe.alignFragment(interfaceAlignment, i + 1);
                            if (this.preferences.insert_space_after_comma_in_superinterfaces) {
                                this.scribe.space();
                            }
                            superInterfaces[i].traverse((ASTVisitor)this, typeDeclaration.scope);
                        } else {
                            this.scribe.alignFragment(interfaceAlignment, i + 1);
                            this.scribe.space();
                            superInterfaces[i].traverse((ASTVisitor)this, typeDeclaration.scope);
                        }
                        ++i;
                    }
                    ok = true;
                }
                catch (AlignmentException e) {
                    this.scribe.redoAlignment(e);
                }
            } while (!ok);
            this.scribe.exitAlignment(interfaceAlignment, true);
        }
        String class_declaration_brace = this.preferences.type_declaration_brace_position;
        this.formatTypeOpeningBrace(class_declaration_brace, this.preferences.insert_space_before_type_open_brace, typeDeclaration);
        if (this.preferences.indent_body_declarations_compare_to_type_header) {
            this.scribe.indent();
        }
        this.formatTypeMembers(typeDeclaration);
        this.scribe.printComment();
        if (this.preferences.indent_body_declarations_compare_to_type_header) {
            this.scribe.unIndent();
        }
        if (this.preferences.insert_new_line_in_empty_type_declaration) {
            this.scribe.printNewLine();
        }
        this.scribe.printNextToken(40);
        this.scribe.printTrailingComment();
        if (class_declaration_brace.equals("next_line_shifted")) {
            this.scribe.unIndent();
        }
        if (this.hasComments()) {
            this.scribe.printNewLine();
        }
    }

    private void formatArrayInitializer(ArrayInitializer arrayInitializer, BlockScope scope, boolean insertSpaceBeforeOpeningBrace) {
        Expression[] expressions;
        int numberOfParens = (arrayInitializer.bits & 0x1FE00000) >> 21;
        if (numberOfParens > 0) {
            this.manageOpeningParenthesizedExpression(arrayInitializer, numberOfParens);
        }
        String array_initializer_brace_position = this.preferences.array_initializer_brace_position;
        this.formatOpeningBrace(array_initializer_brace_position, insertSpaceBeforeOpeningBrace);
        if (this.preferences.insert_new_line_after_opening_brace_in_array_initializer) {
            this.scribe.printNewLine();
        }
        if ((expressions = arrayInitializer.expressions) != null) {
            int expressionsLength = expressions.length;
            if (expressionsLength > 1) {
                Alignment arrayInitializerAlignment = this.scribe.createAlignment("array_initializer", this.preferences.array_initializer_expressions_alignment, 1, expressionsLength, this.scribe.scanner.currentPosition, this.preferences.array_initializer_continuation_indentation, true);
                if (this.preferences.insert_new_line_after_opening_brace_in_array_initializer) {
                    arrayInitializerAlignment.fragmentIndentations[0] = arrayInitializerAlignment.breakIndentationLevel;
                }
                this.scribe.enterAlignment(arrayInitializerAlignment);
                boolean ok = false;
                do {
                    try {
                        this.scribe.alignFragment(arrayInitializerAlignment, 0);
                        if (this.preferences.insert_space_before_first_initializer) {
                            this.scribe.space();
                        }
                        expressions[0].traverse(this, scope);
                        int i = 1;
                        while (i < expressionsLength) {
                            this.scribe.printNextToken(30, this.preferences.insert_space_before_comma_in_array_initializer);
                            this.scribe.alignFragment(arrayInitializerAlignment, i);
                            if (this.preferences.insert_space_after_comma_in_array_initializer) {
                                this.scribe.space();
                            }
                            expressions[i].traverse(this, scope);
                            if (i == expressionsLength - 1 && this.isComma()) {
                                this.scribe.printNextToken(30, this.preferences.insert_space_before_comma_in_array_initializer);
                            }
                            ++i;
                        }
                        ok = true;
                    }
                    catch (AlignmentException e) {
                        this.scribe.redoAlignment(e);
                    }
                } while (!ok);
                this.scribe.exitAlignment(arrayInitializerAlignment, true);
            } else {
                if (this.preferences.insert_space_before_first_initializer) {
                    this.scribe.space();
                }
                expressions[0].traverse(this, scope);
                if (expressionsLength == 1) {
                    if (this.isComma()) {
                        this.scribe.printNextToken(30, this.preferences.insert_space_before_comma_in_array_initializer);
                    }
                } else {
                    int i = 1;
                    while (i < expressionsLength) {
                        this.scribe.printNextToken(30, this.preferences.insert_space_before_comma_in_array_initializer);
                        if (this.preferences.insert_space_after_comma_in_array_initializer) {
                            this.scribe.space();
                        }
                        expressions[i].traverse(this, scope);
                        if (i == expressionsLength - 1 && this.isComma()) {
                            this.scribe.printNextToken(30, this.preferences.insert_space_before_comma_in_array_initializer);
                        }
                        ++i;
                    }
                }
            }
        }
        if (this.preferences.insert_new_line_before_closing_brace_in_array_initializer) {
            this.scribe.printNewLine();
        }
        this.scribe.printNextToken(40, this.preferences.insert_space_before_closing_brace_in_array_initializer, true);
        if (array_initializer_brace_position.equals("next_line_shifted")) {
            this.scribe.unIndent();
        }
        if (numberOfParens > 0) {
            this.manageClosingParenthesizedExpression(arrayInitializer, numberOfParens);
        }
    }

    private void formatCascadingMessageSends(CascadingMethodInvocationFragmentBuilder builder, BlockScope scope) {
        int size = builder.size();
        MessageSend[] fragments = builder.fragments();
        Expression fragment = fragments[0].receiver;
        int startingPositionInCascade = 1;
        if (!fragment.isImplicitThis()) {
            fragment.traverse(this, scope);
        } else {
            MessageSend currentMessageSend = fragments[1];
            int numberOfParens = (currentMessageSend.bits & 0x1FE00000) >> 21;
            if (numberOfParens > 0) {
                this.manageOpeningParenthesizedExpression(currentMessageSend, numberOfParens);
            }
            Expression[] arguments = currentMessageSend.arguments;
            this.scribe.printNextToken(28);
            this.scribe.printNextToken(27, this.preferences.insert_space_before_message_send);
            if (arguments != null) {
                int argumentLength = arguments.length;
                Alignment argumentsAlignment = this.scribe.createAlignment("messageArguments", 16, 1, argumentLength, this.scribe.scanner.currentPosition);
                this.scribe.enterAlignment(argumentsAlignment);
                boolean okForArguments = false;
                do {
                    try {
                        if (this.preferences.insert_space_within_message_send) {
                            this.scribe.space();
                        }
                        int j = 0;
                        while (j < argumentLength) {
                            if (j > 0) {
                                this.scribe.printNextToken(30, this.preferences.insert_space_before_comma_in_messagesend_arguments);
                            }
                            this.scribe.alignFragment(argumentsAlignment, j);
                            if (j > 0 && this.preferences.insert_space_after_comma_in_messagesend_arguments) {
                                this.scribe.space();
                            }
                            arguments[j].traverse(this, scope);
                            ++j;
                        }
                        okForArguments = true;
                    }
                    catch (AlignmentException e) {
                        this.scribe.redoAlignment(e);
                    }
                } while (!okForArguments);
                this.scribe.exitAlignment(argumentsAlignment, true);
            }
            this.scribe.printNextToken(29, this.preferences.insert_space_within_message_send);
            if (numberOfParens > 0) {
                this.manageClosingParenthesizedExpression(currentMessageSend, numberOfParens);
            }
            startingPositionInCascade = 2;
        }
        Alignment cascadingMessageSendAlignment = this.scribe.createAlignment("cascadingMessageSendAlignment", 16, 2, size, this.scribe.scanner.currentPosition);
        this.scribe.enterAlignment(cascadingMessageSendAlignment);
        boolean ok = false;
        do {
            try {
                this.scribe.alignFragment(cascadingMessageSendAlignment, 0);
                this.scribe.printNextToken(3);
                int i = startingPositionInCascade;
                while (i < size) {
                    MessageSend currentMessageSend = fragments[i];
                    int numberOfParens = (currentMessageSend.bits & 0x1FE00000) >> 21;
                    if (numberOfParens > 0) {
                        this.manageOpeningParenthesizedExpression(currentMessageSend, numberOfParens);
                    }
                    Expression[] arguments = currentMessageSend.arguments;
                    this.scribe.printNextToken(28);
                    this.scribe.printNextToken(27, this.preferences.insert_space_before_message_send);
                    if (arguments != null) {
                        int argumentLength = arguments.length;
                        Alignment argumentsAlignment = this.scribe.createAlignment("messageArguments", 16, 1, argumentLength, this.scribe.scanner.currentPosition);
                        this.scribe.enterAlignment(argumentsAlignment);
                        boolean okForArguments = false;
                        do {
                            try {
                                if (this.preferences.insert_space_within_message_send) {
                                    this.scribe.space();
                                }
                                int j = 0;
                                while (j < argumentLength) {
                                    if (j > 0) {
                                        this.scribe.printNextToken(30, this.preferences.insert_space_before_comma_in_messagesend_arguments);
                                    }
                                    this.scribe.alignFragment(argumentsAlignment, j);
                                    if (j > 0 && this.preferences.insert_space_after_comma_in_messagesend_arguments) {
                                        this.scribe.space();
                                    }
                                    arguments[j].traverse(this, scope);
                                    ++j;
                                }
                                okForArguments = true;
                            }
                            catch (AlignmentException e) {
                                this.scribe.redoAlignment(e);
                            }
                        } while (!okForArguments);
                        this.scribe.exitAlignment(argumentsAlignment, true);
                    }
                    this.scribe.printNextToken(29, this.preferences.insert_space_within_message_send);
                    if (numberOfParens > 0) {
                        this.manageClosingParenthesizedExpression(currentMessageSend, numberOfParens);
                    }
                    if (i < size - 1) {
                        this.scribe.alignFragment(cascadingMessageSendAlignment, i);
                        this.scribe.printNextToken(3);
                    }
                    ++i;
                }
                ok = true;
            }
            catch (AlignmentException e) {
                this.scribe.redoAlignment(e);
            }
        } while (!ok);
        this.scribe.exitAlignment(cascadingMessageSendAlignment, true);
    }

    private void formatClassBodyDeclarations(ASTNode[] nodes) {
        this.scribe.lastNumberOfNewLines = 1;
        ASTNode[] mergedNodes = this.computeMergedMemberDeclarations(nodes);
        Alignment memberAlignment = this.scribe.createMemberAlignment("typeMembers", this.preferences.type_member_alignment, 4, this.scribe.scanner.currentPosition);
        this.scribe.enterMemberAlignment(memberAlignment);
        boolean isChunkStart = false;
        boolean ok = false;
        int startIndex = 0;
        do {
            try {
                int i = startIndex;
                int max = mergedNodes.length;
                while (i < max) {
                    ASTNode member = mergedNodes[i];
                    if (member instanceof FieldDeclaration) {
                        isChunkStart = memberAlignment.checkChunkStart(1, i, this.scribe.scanner.currentPosition);
                        if (member instanceof MultiFieldDeclaration) {
                            MultiFieldDeclaration multiField = (MultiFieldDeclaration)member;
                            this.format(multiField, (ASTVisitor)this, null, isChunkStart, i == 0);
                        } else if (member instanceof Initializer) {
                            int newLinesBeforeFirstClassBodyDeclaration;
                            int newLineBeforeChunk;
                            int n = newLineBeforeChunk = isChunkStart ? this.preferences.blank_lines_before_new_chunk : 0;
                            if (newLineBeforeChunk > 0 && i != 0) {
                                this.scribe.printEmptyLines(newLineBeforeChunk);
                            } else if (i == 0 && (newLinesBeforeFirstClassBodyDeclaration = this.preferences.blank_lines_before_first_class_body_declaration) > 0) {
                                this.scribe.printEmptyLines(newLinesBeforeFirstClassBodyDeclaration);
                            }
                            Initializer initializer = (Initializer)member;
                            initializer.traverse((ASTVisitor)this, null);
                        } else {
                            FieldDeclaration field = (FieldDeclaration)member;
                            this.format(field, (ASTVisitor)this, null, isChunkStart, i == 0);
                        }
                    } else if (member instanceof AbstractMethodDeclaration) {
                        isChunkStart = memberAlignment.checkChunkStart(2, i, this.scribe.scanner.currentPosition);
                        this.format((AbstractMethodDeclaration)member, null, isChunkStart, i == 0);
                    } else {
                        isChunkStart = memberAlignment.checkChunkStart(3, i, this.scribe.scanner.currentPosition);
                        this.format((TypeDeclaration)member, null, isChunkStart, i == 0);
                    }
                    if (this.isSemiColon()) {
                        this.scribe.printNextToken(23, this.preferences.insert_space_before_semicolon);
                        this.scribe.printTrailingComment();
                    }
                    if (i != max - 1) {
                        this.scribe.printNewLine();
                    }
                    ++i;
                }
                ok = true;
            }
            catch (AlignmentException e) {
                startIndex = memberAlignment.chunkStartIndex;
                this.scribe.redoMemberAlignment(e);
            }
        } while (!ok);
        this.scribe.exitMemberAlignment(memberAlignment);
        if (this.hasComments()) {
            this.scribe.printNewLine();
        }
        this.scribe.printComment();
    }

    private void formatEmptyStatement() {
        if (this.preferences.put_empty_statement_on_new_line) {
            this.scribe.printNewLine();
        }
        this.scribe.printNextToken(23, this.preferences.insert_space_before_semicolon);
        this.scribe.printTrailingComment();
    }

    private void formatGuardClauseBlock(Block block, BlockScope scope) {
        this.scribe.printNextToken(59, this.preferences.insert_space_before_block_open_brace);
        this.scribe.space();
        Statement[] statements = block.statements;
        statements[0].traverse(this, scope);
        this.scribe.space();
        this.scribe.printNextToken(40, false, true);
        this.scribe.printTrailingComment();
    }

    private void formatLocalDeclaration(LocalDeclaration localDeclaration, BlockScope scope, boolean insertSpaceBeforeComma, boolean insertSpaceAfterComma) {
        Expression initialization;
        if (!this.isMultipleLocalDeclaration(localDeclaration)) {
            if (localDeclaration.modifiers != 0) {
                this.scribe.printModifiers();
                this.scribe.space();
            }
            if (localDeclaration.type != null) {
                localDeclaration.type.traverse((ASTVisitor)this, scope);
            }
            this.scribe.printNextToken(28, true);
        } else {
            this.scribe.printNextToken(28, false);
        }
        int extraDimensions = this.getExtraDimension();
        if (extraDimensions != 0) {
            int index = 0;
            while (index < extraDimensions) {
                this.scribe.printNextToken(12);
                this.scribe.printNextToken(69);
                ++index;
            }
        }
        if ((initialization = localDeclaration.initialization) != null) {
            this.scribe.printNextToken(90, this.preferences.insert_space_before_assignment_operators);
            if (!(initialization instanceof ArrayInitializer) && this.preferences.insert_space_after_assignment_operators) {
                this.scribe.space();
            }
            initialization.traverse(this, scope);
        }
        if (this.isPartOfMultipleLocalDeclaration()) {
            this.scribe.printNextToken(30, insertSpaceBeforeComma);
            if (insertSpaceAfterComma) {
                this.scribe.space();
            }
        }
    }

    private void formatMessageSend(MessageSend messageSend, BlockScope scope, Alignment messageAlignment) {
        if (messageAlignment != null) {
            this.scribe.alignFragment(messageAlignment, 0);
            this.scribe.printNextToken(3);
        }
        this.scribe.printNextToken(28);
        this.scribe.printNextToken(27, this.preferences.insert_space_before_message_send);
        Expression[] arguments = messageSend.arguments;
        if (arguments != null) {
            int argumentsLength = arguments.length;
            if (argumentsLength > 1) {
                Alignment argumentsAlignment = this.scribe.createAlignment("messageArguments", this.preferences.message_send_arguments_alignment, argumentsLength, this.scribe.scanner.currentPosition);
                this.scribe.enterAlignment(argumentsAlignment);
                boolean ok = false;
                do {
                    try {
                        if (this.preferences.insert_space_within_message_send) {
                            this.scribe.space();
                        }
                        int i = 0;
                        while (i < argumentsLength) {
                            if (i > 0) {
                                this.scribe.printNextToken(30, this.preferences.insert_space_before_comma_in_messagesend_arguments);
                            }
                            this.scribe.alignFragment(argumentsAlignment, i);
                            if (i > 0 && this.preferences.insert_space_after_comma_in_messagesend_arguments) {
                                this.scribe.space();
                            }
                            arguments[i].traverse(this, scope);
                            ++i;
                        }
                        ok = true;
                    }
                    catch (AlignmentException e) {
                        this.scribe.redoAlignment(e);
                    }
                } while (!ok);
                this.scribe.exitAlignment(argumentsAlignment, true);
            } else {
                if (this.preferences.insert_space_within_message_send) {
                    this.scribe.space();
                }
                int i = 0;
                while (i < argumentsLength) {
                    if (i > 0) {
                        this.scribe.printNextToken(30, this.preferences.insert_space_before_comma_in_messagesend_arguments);
                    }
                    if (i > 0 && this.preferences.insert_space_after_comma_in_messagesend_arguments) {
                        this.scribe.space();
                    }
                    arguments[i].traverse(this, scope);
                    ++i;
                }
            }
        }
        this.scribe.printNextToken(29, this.preferences.insert_space_between_empty_arguments);
    }

    private void formatMethodArguments(AbstractMethodDeclaration methodDeclaration, boolean spaceBeforeOpenParen, boolean spaceBetweenEmptyArgument, boolean spaceBeforeClosingParen, boolean spaceBeforeFirstArgument, boolean spaceBeforeComma, boolean spaceAfterComma) {
        this.scribe.printNextToken(27, spaceBeforeOpenParen);
        Argument[] arguments = methodDeclaration.arguments;
        if (arguments != null) {
            int argumentLength = arguments.length;
            Alignment argumentsAlignment = this.scribe.createAlignment("methodArguments", this.preferences.method_declaration_arguments_alignment, argumentLength, this.scribe.scanner.currentPosition);
            this.scribe.enterAlignment(argumentsAlignment);
            boolean ok = false;
            do {
                try {
                    if (spaceBeforeFirstArgument) {
                        this.scribe.space();
                    }
                    int i = 0;
                    while (i < argumentLength) {
                        if (i > 0) {
                            this.scribe.printNextToken(30, spaceBeforeComma);
                        }
                        this.scribe.alignFragment(argumentsAlignment, i);
                        if (i > 0 && spaceAfterComma) {
                            this.scribe.space();
                        }
                        arguments[i].traverse(this, methodDeclaration.scope);
                        ++i;
                    }
                    ok = true;
                }
                catch (AlignmentException e) {
                    this.scribe.redoAlignment(e);
                }
            } while (!ok);
            this.scribe.exitAlignment(argumentsAlignment, true);
            this.scribe.printNextToken(29, spaceBeforeClosingParen);
        } else {
            this.scribe.printNextToken(29, spaceBetweenEmptyArgument);
        }
    }

    private void formatOpeningBrace(String bracePosition, boolean insertSpaceBeforeBrace) {
        if (bracePosition.equals("next_line")) {
            this.scribe.printNewLine();
        } else if (bracePosition.equals("next_line_shifted")) {
            this.scribe.printNewLine();
            this.scribe.indent();
        }
        this.scribe.printNextToken(59, insertSpaceBeforeBrace);
        this.scribe.printTrailingComment();
    }

    private void formatStatements(BlockScope scope, Statement[] statements, boolean insertNewLineAfterLastStatement) {
        int statementsLength = statements.length;
        int i = 0;
        while (i < statementsLength) {
            Statement statement = statements[i];
            if (i > 0 && statements[i - 1] instanceof EmptyStatement && !(statement instanceof EmptyStatement)) {
                this.scribe.printNewLine();
            }
            statement.traverse(this, scope);
            if (statement instanceof Expression) {
                this.scribe.printNextToken(23, this.preferences.insert_space_before_semicolon);
                this.scribe.printTrailingComment();
                if (i != statementsLength - 1 || i == statementsLength - 1 && insertNewLineAfterLastStatement) {
                    this.scribe.printNewLine();
                }
            } else if (statement instanceof LocalDeclaration) {
                LocalDeclaration currentLocal = (LocalDeclaration)statement;
                if (i < statementsLength - 1) {
                    if (statements[i + 1] instanceof LocalDeclaration) {
                        LocalDeclaration nextLocal = (LocalDeclaration)statements[i + 1];
                        if (currentLocal.declarationSourceStart != nextLocal.declarationSourceStart) {
                            this.scribe.printNextToken(23, this.preferences.insert_space_before_semicolon);
                            this.scribe.printTrailingComment();
                            if (i != statementsLength - 1 || i == statementsLength - 1 && insertNewLineAfterLastStatement) {
                                this.scribe.printNewLine();
                            }
                        }
                    } else {
                        this.scribe.printNextToken(23, this.preferences.insert_space_before_semicolon);
                        this.scribe.printTrailingComment();
                        if (i != statementsLength - 1 || i == statementsLength - 1 && insertNewLineAfterLastStatement) {
                            this.scribe.printNewLine();
                        }
                    }
                } else {
                    this.scribe.printNextToken(23, this.preferences.insert_space_before_semicolon);
                    this.scribe.printTrailingComment();
                    if (i != statementsLength - 1 || i == statementsLength - 1 && insertNewLineAfterLastStatement) {
                        this.scribe.printNewLine();
                    }
                }
            } else if (i != statementsLength - 1) {
                if (!(statement instanceof EmptyStatement) && !(statements[i + 1] instanceof EmptyStatement)) {
                    this.scribe.printNewLine();
                }
            } else if (i == statementsLength - 1 && insertNewLineAfterLastStatement) {
                this.scribe.printNewLine();
            }
            ++i;
        }
    }

    private void formatThrowsClause(AbstractMethodDeclaration methodDeclaration, boolean spaceBeforeComma, boolean spaceAfterComma) {
        TypeReference[] thrownExceptions = methodDeclaration.thrownExceptions;
        if (thrownExceptions != null) {
            int thrownExceptionsLength = thrownExceptions.length;
            Alignment throwsAlignment = this.scribe.createAlignment("throws", this.preferences.method_throws_clause_alignment, thrownExceptionsLength, this.scribe.scanner.currentPosition);
            this.scribe.enterAlignment(throwsAlignment);
            boolean ok = false;
            do {
                try {
                    this.scribe.alignFragment(throwsAlignment, 0);
                    this.scribe.printNextToken(104, true);
                    int i = 0;
                    while (i < thrownExceptionsLength) {
                        if (i > 0) {
                            this.scribe.printNextToken(30, spaceBeforeComma);
                            this.scribe.alignFragment(throwsAlignment, i);
                            if (spaceAfterComma) {
                                this.scribe.space();
                            }
                        } else {
                            this.scribe.space();
                        }
                        thrownExceptions[i].traverse((ASTVisitor)this, methodDeclaration.scope);
                        ++i;
                    }
                    ok = true;
                }
                catch (AlignmentException e) {
                    this.scribe.redoAlignment(e);
                }
            } while (!ok);
            this.scribe.exitAlignment(throwsAlignment, true);
        }
    }

    private void formatTypeMembers(TypeDeclaration typeDeclaration) {
        Alignment memberAlignment = this.scribe.createMemberAlignment("typeMembers", this.preferences.type_member_alignment, 3, this.scribe.scanner.currentPosition);
        this.scribe.enterMemberAlignment(memberAlignment);
        ASTNode[] members = this.computeMergedMemberDeclarations(typeDeclaration);
        boolean isChunkStart = false;
        boolean ok = false;
        int startIndex = 0;
        do {
            try {
                int i = startIndex;
                int max = members.length;
                while (i < max) {
                    ASTNode member = members[i];
                    if (member instanceof FieldDeclaration) {
                        isChunkStart = memberAlignment.checkChunkStart(1, i, this.scribe.scanner.currentPosition);
                        if (member instanceof MultiFieldDeclaration) {
                            MultiFieldDeclaration multiField = (MultiFieldDeclaration)member;
                            if (multiField.isStatic()) {
                                this.format(multiField, (ASTVisitor)this, typeDeclaration.staticInitializerScope, isChunkStart, i == 0);
                            } else {
                                this.format(multiField, (ASTVisitor)this, typeDeclaration.initializerScope, isChunkStart, i == 0);
                            }
                        } else if (member instanceof Initializer) {
                            int newLinesBeforeFirstClassBodyDeclaration;
                            int newLineBeforeChunk;
                            int n = newLineBeforeChunk = isChunkStart ? this.preferences.blank_lines_before_new_chunk : 0;
                            if (newLineBeforeChunk > 0 && i != 0) {
                                this.scribe.printEmptyLines(newLineBeforeChunk);
                            } else if (i == 0 && (newLinesBeforeFirstClassBodyDeclaration = this.preferences.blank_lines_before_first_class_body_declaration) > 0) {
                                this.scribe.printEmptyLines(newLinesBeforeFirstClassBodyDeclaration);
                            }
                            Initializer initializer = (Initializer)member;
                            if (initializer.isStatic()) {
                                initializer.traverse((ASTVisitor)this, typeDeclaration.staticInitializerScope);
                            } else {
                                initializer.traverse((ASTVisitor)this, typeDeclaration.initializerScope);
                            }
                        } else {
                            FieldDeclaration field = (FieldDeclaration)member;
                            if (field.isStatic()) {
                                this.format(field, (ASTVisitor)this, typeDeclaration.staticInitializerScope, isChunkStart, i == 0);
                            } else {
                                this.format(field, (ASTVisitor)this, typeDeclaration.initializerScope, isChunkStart, i == 0);
                            }
                        }
                    } else if (member instanceof AbstractMethodDeclaration) {
                        isChunkStart = memberAlignment.checkChunkStart(2, i, this.scribe.scanner.currentPosition);
                        this.format((AbstractMethodDeclaration)member, typeDeclaration.scope, isChunkStart, i == 0);
                    } else {
                        isChunkStart = memberAlignment.checkChunkStart(3, i, this.scribe.scanner.currentPosition);
                        this.format((TypeDeclaration)member, typeDeclaration.scope, isChunkStart, i == 0);
                    }
                    if (this.isSemiColon()) {
                        this.scribe.printNextToken(23, this.preferences.insert_space_before_semicolon);
                        this.scribe.printTrailingComment();
                    }
                    this.scribe.printNewLine();
                    if (this.scribe.memberAlignment != null) {
                        this.scribe.indentationLevel = this.scribe.memberAlignment.originalIndentationLevel;
                    }
                    ++i;
                }
                ok = true;
            }
            catch (AlignmentException e) {
                startIndex = memberAlignment.chunkStartIndex;
                this.scribe.redoMemberAlignment(e);
            }
        } while (!ok);
        this.scribe.exitMemberAlignment(memberAlignment);
    }

    private void formatTypeOpeningBrace(String bracePosition, boolean insertSpaceBeforeBrace, TypeDeclaration typeDeclaration) {
        int memberLength;
        boolean insertNewLine;
        int typeCount;
        int fieldCount = typeDeclaration.fields == null ? 0 : typeDeclaration.fields.length;
        int methodCount = typeDeclaration.methods == null ? 0 : typeDeclaration.methods.length;
        int n = typeCount = typeDeclaration.memberTypes == null ? 0 : typeDeclaration.memberTypes.length;
        if (methodCount == 1 && typeDeclaration.methods[0].isDefaultConstructor()) {
            methodCount = 0;
        }
        boolean bl = insertNewLine = (memberLength = fieldCount + methodCount + typeCount) > 0;
        if (!insertNewLine) {
            insertNewLine = (typeDeclaration.bits & 0x200) != 0 ? this.preferences.insert_new_line_in_empty_anonymous_type_declaration : this.preferences.insert_new_line_in_empty_type_declaration;
        }
        this.formatOpeningBrace(bracePosition, insertSpaceBeforeBrace);
        if (insertNewLine) {
            this.scribe.printNewLine();
        }
    }

    private int getExtraDimension() {
        this.localScanner.resetTo(this.scribe.scanner.currentPosition, this.scribe.scannerEndPosition - 1);
        int dimensions = 0;
        try {
            int token;
            while ((token = this.localScanner.getNextToken()) != 54) {
                switch (token) {
                    case 69: {
                        ++dimensions;
                        break;
                    }
                    case 23: 
                    case 27: 
                    case 28: 
                    case 29: 
                    case 30: 
                    case 59: 
                    case 90: {
                        return dimensions;
                    }
                }
            }
        }
        catch (InvalidInputException invalidInputException) {}
        return dimensions;
    }

    private boolean isComma() {
        this.localScanner.resetTo(this.scribe.scanner.currentPosition, this.scribe.scannerEndPosition - 1);
        try {
            int token = this.localScanner.getNextToken();
            block5: while (true) {
                switch (token) {
                    case 1001: 
                    case 1002: 
                    case 1003: {
                        token = this.localScanner.getNextToken();
                        continue block5;
                    }
                }
                break;
            }
            return token == 30;
        }
        catch (InvalidInputException invalidInputException) {
            return false;
        }
    }

    private boolean isGuardClause(Block block) {
        return block.statements != null && block.statements.length == 1 && (block.statements[0] instanceof ReturnStatement || block.statements[0] instanceof ThrowStatement);
    }

    private boolean isMinus() {
        this.localScanner.resetTo(this.scribe.scanner.currentPosition, this.scribe.scannerEndPosition - 1);
        try {
            int token = this.localScanner.getNextToken();
            block5: while (true) {
                switch (token) {
                    case 1001: 
                    case 1002: 
                    case 1003: {
                        token = this.localScanner.getNextToken();
                        continue block5;
                    }
                }
                break;
            }
            return token == 2;
        }
        catch (InvalidInputException invalidInputException) {
            return false;
        }
    }

    private boolean isMultipleLocalDeclaration(LocalDeclaration localDeclaration) {
        if (localDeclaration.declarationSourceStart == this.lastLocalDeclarationSourceStart) {
            return true;
        }
        this.lastLocalDeclarationSourceStart = localDeclaration.declarationSourceStart;
        return false;
    }

    private boolean isPartOfMultipleLocalDeclaration() {
        this.localScanner.resetTo(this.scribe.scanner.currentPosition, this.scribe.scannerEndPosition - 1);
        try {
            int token;
            while ((token = this.localScanner.getNextToken()) != 54) {
                switch (token) {
                    case 30: {
                        return true;
                    }
                    case 1001: 
                    case 1002: 
                    case 1003: {
                        break;
                    }
                    default: {
                        return false;
                    }
                }
            }
        }
        catch (InvalidInputException invalidInputException) {}
        return false;
    }

    private boolean isSemiColon() {
        this.localScanner.resetTo(this.scribe.scanner.currentPosition, this.scribe.scannerEndPosition - 1);
        try {
            int token = this.localScanner.getNextToken();
            block5: while (true) {
                switch (token) {
                    case 1001: 
                    case 1002: 
                    case 1003: {
                        token = this.localScanner.getNextToken();
                        continue block5;
                    }
                }
                break;
            }
            return token == 23;
        }
        catch (InvalidInputException invalidInputException) {
            return false;
        }
    }

    private boolean hasComments() {
        this.localScanner.resetTo(this.scribe.scanner.startPosition, this.scribe.scannerEndPosition - 1);
        try {
            switch (this.localScanner.getNextToken()) {
                case 1001: 
                case 1002: 
                case 1003: {
                    return true;
                }
            }
        }
        catch (InvalidInputException invalidInputException) {}
        return false;
    }

    private void manageClosingParenthesizedExpression(Expression expression, int numberOfParens) {
        int i = 0;
        while (i < numberOfParens) {
            this.scribe.printNextToken(29, this.preferences.insert_space_before_closing_paren_in_parenthesized_expression);
            ++i;
        }
    }

    private void manageOpeningParenthesizedExpression(Expression expression, int numberOfParens) {
        int i = 0;
        while (i < numberOfParens) {
            this.scribe.printNextToken(27, this.preferences.insert_space_before_open_paren_in_parenthesized_expression);
            if (this.preferences.insert_space_after_open_paren_in_parenthesized_expression) {
                this.scribe.space();
            }
            ++i;
        }
    }

    public boolean visit(AllocationExpression allocationExpression, BlockScope scope) {
        int numberOfParens = (allocationExpression.bits & 0x1FE00000) >> 21;
        if (numberOfParens > 0) {
            this.manageOpeningParenthesizedExpression(allocationExpression, numberOfParens);
        }
        this.scribe.printNextToken(41);
        this.scribe.space();
        allocationExpression.type.traverse((ASTVisitor)this, scope);
        this.scribe.printNextToken(27, this.preferences.insert_space_before_message_send);
        Expression[] arguments = allocationExpression.arguments;
        if (arguments != null) {
            int argumentLength = arguments.length;
            Alignment argumentsAlignment = this.scribe.createAlignment("allocation", this.preferences.allocation_expression_arguments_alignment, argumentLength, this.scribe.scanner.currentPosition);
            this.scribe.enterAlignment(argumentsAlignment);
            boolean ok = false;
            do {
                try {
                    if (this.preferences.insert_space_within_message_send) {
                        this.scribe.space();
                    }
                    int i = 0;
                    while (i < argumentLength) {
                        if (i > 0) {
                            this.scribe.printNextToken(30, this.preferences.insert_space_before_comma_in_allocation_expression);
                        }
                        this.scribe.alignFragment(argumentsAlignment, i);
                        if (i > 0 && this.preferences.insert_space_after_comma_in_allocation_expression) {
                            this.scribe.space();
                        }
                        arguments[i].traverse(this, scope);
                        ++i;
                    }
                    ok = true;
                }
                catch (AlignmentException e) {
                    this.scribe.redoAlignment(e);
                }
            } while (!ok);
            this.scribe.exitAlignment(argumentsAlignment, true);
            this.scribe.printNextToken(29, this.preferences.insert_space_within_message_send);
        } else {
            this.scribe.printNextToken(29, this.preferences.insert_space_between_empty_arguments);
        }
        if (numberOfParens > 0) {
            this.manageClosingParenthesizedExpression(allocationExpression, numberOfParens);
        }
        return false;
    }

    public boolean visit(AND_AND_Expression and_and_Expression, BlockScope scope) {
        return this.dumpBinaryExpression(and_and_Expression, 25, scope);
    }

    public boolean visit(Argument argument, BlockScope scope) {
        if (argument.modifiers != 0) {
            this.scribe.printModifiers();
            this.scribe.space();
        }
        if (argument.type != null) {
            argument.type.traverse((ASTVisitor)this, scope);
        }
        this.scribe.printNextToken(28, true);
        int extraDimensions = this.getExtraDimension();
        if (extraDimensions != 0) {
            int i = 0;
            while (i < extraDimensions) {
                this.scribe.printNextToken(12);
                this.scribe.printNextToken(69);
                ++i;
            }
        }
        return false;
    }

    public boolean visit(ArrayAllocationExpression arrayAllocationExpression, BlockScope scope) {
        int numberOfParens = (arrayAllocationExpression.bits & 0x1FE00000) >> 21;
        if (numberOfParens > 0) {
            this.manageOpeningParenthesizedExpression(arrayAllocationExpression, numberOfParens);
        }
        this.scribe.printNextToken(41);
        this.scribe.space();
        arrayAllocationExpression.type.traverse((ASTVisitor)this, scope);
        Expression[] dimensions = arrayAllocationExpression.dimensions;
        int dimensionsLength = dimensions.length;
        int i = 0;
        while (i < dimensionsLength) {
            this.scribe.printNextToken(12);
            if (dimensions[i] != null) {
                dimensions[i].traverse(this, scope);
            }
            this.scribe.printNextToken(69);
            ++i;
        }
        ArrayInitializer initializer = arrayAllocationExpression.initializer;
        if (initializer != null) {
            this.formatArrayInitializer(initializer, scope, this.preferences.insert_space_before_opening_brace_in_array_initializer);
        }
        if (numberOfParens > 0) {
            this.manageClosingParenthesizedExpression(arrayAllocationExpression, numberOfParens);
        }
        return false;
    }

    public boolean visit(ArrayInitializer arrayInitializer, BlockScope scope) {
        this.formatArrayInitializer(arrayInitializer, scope, this.preferences.insert_space_before_opening_brace_in_array_initializer || this.preferences.insert_space_after_assignment_operators);
        return false;
    }

    public boolean visit(ArrayQualifiedTypeReference arrayQualifiedTypeReference, BlockScope scope) {
        int numberOfParens = (arrayQualifiedTypeReference.bits & 0x1FE00000) >> 21;
        if (numberOfParens > 0) {
            this.manageOpeningParenthesizedExpression(arrayQualifiedTypeReference, numberOfParens);
        }
        this.scribe.printQualifiedReference(arrayQualifiedTypeReference.sourceEnd - 1);
        int dimensions = this.getExtraDimension();
        if (dimensions != 0) {
            int i = 0;
            while (i < dimensions) {
                this.scribe.printNextToken(12);
                this.scribe.printNextToken(69);
                ++i;
            }
        }
        if (numberOfParens > 0) {
            this.manageClosingParenthesizedExpression(arrayQualifiedTypeReference, numberOfParens);
        }
        return false;
    }

    public boolean visit(ArrayQualifiedTypeReference arrayQualifiedTypeReference, ClassScope scope) {
        int numberOfParens = (arrayQualifiedTypeReference.bits & 0x1FE00000) >> 21;
        if (numberOfParens > 0) {
            this.manageOpeningParenthesizedExpression(arrayQualifiedTypeReference, numberOfParens);
        }
        this.scribe.printQualifiedReference(arrayQualifiedTypeReference.sourceEnd - 1);
        int dimensions = this.getExtraDimension();
        if (dimensions != 0) {
            int i = 0;
            while (i < dimensions) {
                this.scribe.printNextToken(12);
                this.scribe.printNextToken(69);
                ++i;
            }
        }
        if (numberOfParens > 0) {
            this.manageClosingParenthesizedExpression(arrayQualifiedTypeReference, numberOfParens);
        }
        return false;
    }

    public boolean visit(ArrayReference arrayReference, BlockScope scope) {
        int numberOfParens = (arrayReference.bits & 0x1FE00000) >> 21;
        if (numberOfParens > 0) {
            this.manageOpeningParenthesizedExpression(arrayReference, numberOfParens);
        }
        arrayReference.receiver.traverse(this, scope);
        this.scribe.printNextToken(12, this.preferences.insert_space_before_bracket_in_array_reference);
        if (this.preferences.insert_space_between_brackets_in_array_reference) {
            this.scribe.space();
        }
        arrayReference.position.traverse(this, scope);
        this.scribe.printNextToken(69, this.preferences.insert_space_between_brackets_in_array_reference);
        if (numberOfParens > 0) {
            this.manageClosingParenthesizedExpression(arrayReference, numberOfParens);
        }
        return false;
    }

    public boolean visit(ArrayTypeReference arrayTypeReference, BlockScope scope) {
        int numberOfParens = (arrayTypeReference.bits & 0x1FE00000) >> 21;
        if (numberOfParens > 0) {
            this.manageOpeningParenthesizedExpression(arrayTypeReference, numberOfParens);
        }
        this.scribe.printNextToken(SINGLETYPEREFERENCE_EXPECTEDTOKENS, false, true);
        int dimensions = this.getExtraDimension();
        if (dimensions != 0) {
            if (this.preferences.insert_space_before_bracket_in_array_type_reference) {
                this.scribe.space();
            }
            int i = 0;
            while (i < dimensions) {
                this.scribe.printNextToken(12);
                if (this.preferences.insert_space_between_brackets_in_array_type_reference) {
                    this.scribe.space();
                }
                this.scribe.printNextToken(69);
                ++i;
            }
        }
        if (numberOfParens > 0) {
            this.manageClosingParenthesizedExpression(arrayTypeReference, numberOfParens);
        }
        return false;
    }

    public boolean visit(ArrayTypeReference arrayTypeReference, ClassScope scope) {
        int numberOfParens = (arrayTypeReference.bits & 0x1FE00000) >> 21;
        if (numberOfParens > 0) {
            this.manageOpeningParenthesizedExpression(arrayTypeReference, numberOfParens);
        }
        this.scribe.printNextToken(SINGLETYPEREFERENCE_EXPECTEDTOKENS, false, true);
        int dimensions = this.getExtraDimension();
        if (dimensions != 0) {
            if (this.preferences.insert_space_before_bracket_in_array_type_reference) {
                this.scribe.space();
            }
            int i = 0;
            while (i < dimensions) {
                this.scribe.printNextToken(12);
                if (this.preferences.insert_space_between_brackets_in_array_type_reference) {
                    this.scribe.space();
                }
                this.scribe.printNextToken(69);
                ++i;
            }
        }
        if (numberOfParens > 0) {
            this.manageClosingParenthesizedExpression(arrayTypeReference, numberOfParens);
        }
        return false;
    }

    public boolean visit(AssertStatement assertStatement, BlockScope scope) {
        this.scribe.printNextToken(71);
        this.scribe.space();
        assertStatement.assertExpression.traverse(this, scope);
        if (assertStatement.exceptionArgument != null) {
            this.scribe.printNextToken(53, this.preferences.insert_space_before_colon_in_assert);
            if (this.preferences.insert_space_after_colon_in_assert) {
                this.scribe.space();
            }
            assertStatement.exceptionArgument.traverse(this, scope);
        }
        this.scribe.printNextToken(23, this.preferences.insert_space_before_semicolon);
        this.scribe.printTrailingComment();
        return false;
    }

    public boolean visit(Assignment assignment, BlockScope scope) {
        int numberOfParens = (assignment.bits & 0x1FE00000) >> 21;
        if (numberOfParens > 0) {
            this.manageOpeningParenthesizedExpression(assignment, numberOfParens);
        }
        assignment.lhs.traverse(this, scope);
        this.scribe.printNextToken(90, this.preferences.insert_space_before_assignment_operators);
        if (!(assignment.expression instanceof ArrayInitializer) && this.preferences.insert_space_after_assignment_operators) {
            this.scribe.space();
        }
        assignment.expression.traverse(this, scope);
        if (numberOfParens > 0) {
            this.manageClosingParenthesizedExpression(assignment, numberOfParens);
        }
        return false;
    }

    public boolean visit(BinaryExpression binaryExpression, BlockScope scope) {
        switch ((binaryExpression.bits & 0xFC0) >> 6) {
            case 2: {
                return this.dumpBinaryExpression(binaryExpression, 20, scope);
            }
            case 9: {
                return this.dumpBinaryExpression(binaryExpression, 6, scope);
            }
            case 6: {
                return this.dumpBinaryExpression(binaryExpression, 16, scope);
            }
            case 7: {
                return this.dumpBinaryExpression(binaryExpression, 15, scope);
            }
            case 10: {
                return this.dumpBinaryExpression(binaryExpression, 11, scope);
            }
            case 4: {
                return this.dumpBinaryExpression(binaryExpression, 17, scope);
            }
            case 5: {
                return this.dumpBinaryExpression(binaryExpression, 14, scope);
            }
            case 13: {
                return this.dumpBinaryExpression(binaryExpression, 2, scope);
            }
            case 15: {
                return this.dumpBinaryExpression(binaryExpression, 4, scope);
            }
            case 3: {
                return this.dumpBinaryExpression(binaryExpression, 22, scope);
            }
            case 14: {
                return this.dumpBinaryExpression(binaryExpression, 1, scope);
            }
            case 16: {
                return this.dumpBinaryExpression(binaryExpression, 5, scope);
            }
            case 17: {
                return this.dumpBinaryExpression(binaryExpression, 9, scope);
            }
            case 19: {
                return this.dumpBinaryExpression(binaryExpression, 10, scope);
            }
            case 8: {
                return this.dumpBinaryExpression(binaryExpression, 21, scope);
            }
        }
        throw new IllegalStateException();
    }

    public boolean visit(Block block, BlockScope scope) {
        String block_brace_position = this.preferences.block_brace_position;
        this.formatOpeningBrace(block_brace_position, this.preferences.insert_space_before_block_open_brace);
        Statement[] statements = block.statements;
        if (statements != null) {
            this.scribe.printNewLine();
            if (this.preferences.indent_block_statements) {
                this.scribe.indent();
            }
            this.formatStatements(scope, statements, true);
            this.scribe.printComment();
            if (this.preferences.indent_block_statements) {
                this.scribe.unIndent();
            }
        } else if (this.preferences.insert_new_line_in_empty_block) {
            this.scribe.printNewLine();
            if (this.preferences.indent_block_statements) {
                this.scribe.indent();
            }
            this.scribe.printComment();
            if (this.preferences.indent_block_statements) {
                this.scribe.unIndent();
            }
        } else {
            if (this.preferences.indent_block_statements) {
                this.scribe.indent();
            }
            this.scribe.printComment();
            if (this.preferences.indent_block_statements) {
                this.scribe.unIndent();
            }
        }
        this.scribe.printNextToken(40);
        this.scribe.printTrailingComment();
        if (block_brace_position.equals("next_line_shifted")) {
            this.scribe.unIndent();
        }
        return false;
    }

    public boolean visit(BreakStatement breakStatement, BlockScope scope) {
        this.scribe.printNextToken(72);
        if (breakStatement.label != null) {
            this.scribe.printNextToken(28, true);
        }
        this.scribe.printNextToken(23, this.preferences.insert_space_before_semicolon);
        this.scribe.printTrailingComment();
        return false;
    }

    public boolean visit(CaseStatement caseStatement, BlockScope scope) {
        if (caseStatement.constantExpression == null) {
            this.scribe.printNextToken(84);
            this.scribe.printNextToken(53, this.preferences.insert_space_before_colon_in_default);
        } else {
            this.scribe.printNextToken(83);
            this.scribe.space();
            caseStatement.constantExpression.traverse(this, scope);
            this.scribe.printNextToken(53, this.preferences.insert_space_before_colon_in_case);
        }
        return false;
    }

    public boolean visit(CastExpression castExpression, BlockScope scope) {
        int numberOfParens = (castExpression.bits & 0x1FE00000) >> 21;
        if (numberOfParens > 0) {
            this.manageOpeningParenthesizedExpression(castExpression, numberOfParens);
        }
        this.scribe.printNextToken(27);
        if (this.preferences.insert_space_after_opening_paren_in_cast) {
            this.scribe.space();
        }
        castExpression.type.traverse(this, scope);
        this.scribe.printNextToken(29, this.preferences.insert_space_before_closing_paren_in_cast);
        if (this.preferences.insert_space_after_closing_paren_in_cast) {
            this.scribe.space();
        }
        castExpression.expression.traverse(this, scope);
        if (numberOfParens > 0) {
            this.manageClosingParenthesizedExpression(castExpression, numberOfParens);
        }
        return false;
    }

    public boolean visit(CharLiteral charLiteral, BlockScope scope) {
        int numberOfParens = (charLiteral.bits & 0x1FE00000) >> 21;
        if (numberOfParens > 0) {
            this.manageOpeningParenthesizedExpression(charLiteral, numberOfParens);
        }
        this.scribe.printNextToken(51);
        if (numberOfParens > 0) {
            this.manageClosingParenthesizedExpression(charLiteral, numberOfParens);
        }
        return false;
    }

    public boolean visit(ClassLiteralAccess classLiteral, BlockScope scope) {
        int numberOfParens = (classLiteral.bits & 0x1FE00000) >> 21;
        if (numberOfParens > 0) {
            this.manageOpeningParenthesizedExpression(classLiteral, numberOfParens);
        }
        classLiteral.type.traverse((ASTVisitor)this, scope);
        this.scribe.printNextToken(3);
        this.scribe.printNextToken(81);
        if (numberOfParens > 0) {
            this.manageClosingParenthesizedExpression(classLiteral, numberOfParens);
        }
        return false;
    }

    public boolean visit(Clinit clinit, ClassScope scope) {
        return false;
    }

    public boolean visit(CompilationUnitDeclaration compilationUnitDeclaration, CompilationUnitScope scope) {
        TypeDeclaration[] types;
        int i;
        if (compilationUnitDeclaration.currentPackage != null) {
            int blankLinesBeforePackage = this.preferences.blank_lines_before_package;
            if (blankLinesBeforePackage > 0) {
                this.scribe.printEmptyLines(blankLinesBeforePackage - 1);
            }
            this.scribe.printNextToken(85);
            this.scribe.space();
            this.scribe.printQualifiedReference(compilationUnitDeclaration.currentPackage.sourceEnd);
            this.scribe.printNextToken(23, this.preferences.insert_space_before_semicolon);
            this.scribe.printTrailingComment();
            int blankLinesAfterPackage = this.preferences.blank_lines_after_package;
            if (blankLinesAfterPackage > 0) {
                this.scribe.printEmptyLines(blankLinesAfterPackage);
            } else {
                this.scribe.printNewLine();
            }
        } else {
            this.scribe.printComment();
        }
        ImportReference[] imports = compilationUnitDeclaration.imports;
        if (imports != null) {
            int blankLinesBeforeImports = this.preferences.blank_lines_before_imports;
            if (blankLinesBeforeImports > 0) {
                this.scribe.printEmptyLines(blankLinesBeforeImports);
            }
            int importLength = imports.length;
            i = 0;
            while (i < importLength) {
                imports[i].traverse((ASTVisitor)this, scope);
                ++i;
            }
            int blankLinesAfterImports = this.preferences.blank_lines_after_imports;
            if (blankLinesAfterImports > 0) {
                this.scribe.printEmptyLines(blankLinesAfterImports);
            }
        }
        if ((types = compilationUnitDeclaration.types) != null) {
            int typesLength = types.length;
            i = 0;
            while (i < typesLength - 1) {
                types[i].traverse((ASTVisitor)this, scope);
                this.scribe.printComment();
                this.scribe.printNewLine();
                ++i;
            }
            this.format(types[typesLength - 1]);
        }
        this.scribe.printComment();
        return false;
    }

    public boolean visit(CompoundAssignment compoundAssignment, BlockScope scope) {
        int operator;
        int numberOfParens = (compoundAssignment.bits & 0x1FE00000) >> 21;
        if (numberOfParens > 0) {
            this.manageOpeningParenthesizedExpression(compoundAssignment, numberOfParens);
        }
        compoundAssignment.lhs.traverse(this, scope);
        switch (compoundAssignment.operator) {
            case 14: {
                operator = 92;
                break;
            }
            case 13: {
                operator = 93;
                break;
            }
            case 15: {
                operator = 94;
                break;
            }
            case 9: {
                operator = 95;
                break;
            }
            case 2: {
                operator = 96;
                break;
            }
            case 3: {
                operator = 97;
                break;
            }
            case 8: {
                operator = 98;
                break;
            }
            case 16: {
                operator = 99;
                break;
            }
            case 10: {
                operator = 100;
                break;
            }
            case 17: {
                operator = 101;
                break;
            }
            default: {
                operator = 102;
            }
        }
        this.scribe.printNextToken(operator, this.preferences.insert_space_before_assignment_operators);
        if (this.preferences.insert_space_after_assignment_operators) {
            this.scribe.space();
        }
        compoundAssignment.expression.traverse(this, scope);
        if (numberOfParens > 0) {
            this.manageClosingParenthesizedExpression(compoundAssignment, numberOfParens);
        }
        return false;
    }

    public boolean visit(ConditionalExpression conditionalExpression, BlockScope scope) {
        int numberOfParens = (conditionalExpression.bits & 0x1FE00000) >> 21;
        if (numberOfParens > 0) {
            this.manageOpeningParenthesizedExpression(conditionalExpression, numberOfParens);
        }
        conditionalExpression.condition.traverse(this, scope);
        Alignment conditionalExpressionAlignment = this.scribe.createAlignment("conditionalExpression", this.preferences.conditional_expression_alignment, 2, this.scribe.scanner.currentPosition);
        this.scribe.enterAlignment(conditionalExpressionAlignment);
        boolean ok = false;
        do {
            try {
                this.scribe.alignFragment(conditionalExpressionAlignment, 0);
                this.scribe.printNextToken(26, this.preferences.insert_space_before_question_in_conditional);
                if (this.preferences.insert_space_after_question_in_conditional) {
                    this.scribe.space();
                }
                conditionalExpression.valueIfTrue.traverse(this, scope);
                this.scribe.printTrailingComment();
                this.scribe.alignFragment(conditionalExpressionAlignment, 1);
                this.scribe.printNextToken(53, this.preferences.insert_space_before_colon_in_conditional);
                if (this.preferences.insert_space_after_colon_in_conditional) {
                    this.scribe.space();
                }
                conditionalExpression.valueIfFalse.traverse(this, scope);
                ok = true;
            }
            catch (AlignmentException e) {
                this.scribe.redoAlignment(e);
            }
        } while (!ok);
        this.scribe.exitAlignment(conditionalExpressionAlignment, true);
        if (numberOfParens > 0) {
            this.manageClosingParenthesizedExpression(conditionalExpression, numberOfParens);
        }
        return false;
    }

    public boolean visit(ConstructorDeclaration constructorDeclaration, ClassScope scope) {
        if (constructorDeclaration.ignoreFurtherInvestigation) {
            this.scribe.printComment();
            this.scribe.scanner.resetTo(constructorDeclaration.declarationSourceEnd + 1, this.scribe.scannerEndPosition);
            this.scribe.printTrailingComment();
            return false;
        }
        this.scribe.printModifiers();
        this.scribe.space();
        this.scribe.printNextToken(28, true);
        this.formatMethodArguments(constructorDeclaration, this.preferences.insert_space_before_method_declaration_open_paren, this.preferences.insert_space_between_empty_arguments, this.preferences.insert_space_before_closing_paren, this.preferences.insert_space_before_first_argument, this.preferences.insert_space_before_comma_in_constructor_arguments, this.preferences.insert_space_after_comma_in_constructor_arguments);
        this.formatThrowsClause(constructorDeclaration, this.preferences.insert_space_before_comma_in_constructor_throws, this.preferences.insert_space_after_comma_in_constructor_throws);
        if (!constructorDeclaration.isNative() && !constructorDeclaration.isAbstract()) {
            Statement[] statements;
            String method_declaration_brace = this.preferences.method_declaration_brace_position;
            this.formatOpeningBrace(method_declaration_brace, this.preferences.insert_space_before_method_open_brace);
            int numberOfBlankLinesAtBeginningOfMethodBody = this.preferences.number_of_blank_lines_to_insert_at_beginning_of_method_body;
            if (numberOfBlankLinesAtBeginningOfMethodBody > 0) {
                this.scribe.printEmptyLines(numberOfBlankLinesAtBeginningOfMethodBody);
            }
            if (constructorDeclaration.constructorCall != null && !constructorDeclaration.constructorCall.isImplicitSuper()) {
                this.scribe.printNewLine();
                if (this.preferences.indent_block_statements) {
                    this.scribe.indent();
                }
                constructorDeclaration.constructorCall.traverse(this, constructorDeclaration.scope);
                if (this.preferences.indent_block_statements) {
                    this.scribe.unIndent();
                }
            }
            if ((statements = constructorDeclaration.statements) != null) {
                this.scribe.printNewLine();
                if (this.preferences.indent_block_statements) {
                    this.scribe.indent();
                }
                this.formatStatements(constructorDeclaration.scope, statements, true);
                this.scribe.printComment();
                if (this.preferences.indent_block_statements) {
                    this.scribe.unIndent();
                }
            } else if (this.preferences.insert_new_line_in_empty_method_body) {
                this.scribe.printNewLine();
                if (this.preferences.indent_block_statements) {
                    this.scribe.indent();
                }
                this.scribe.printComment();
                if (this.preferences.indent_block_statements) {
                    this.scribe.unIndent();
                }
            }
            this.scribe.printNextToken(40);
            this.scribe.printTrailingComment();
            if (method_declaration_brace.equals("next_line_shifted")) {
                this.scribe.unIndent();
            }
        } else {
            this.scribe.printNextToken(23, this.preferences.insert_space_before_semicolon);
            this.scribe.printTrailingComment();
        }
        return false;
    }

    public boolean visit(ContinueStatement continueStatement, BlockScope scope) {
        this.scribe.printNextToken(73);
        if (continueStatement.label != null) {
            this.scribe.printNextToken(28, true);
        }
        this.scribe.printNextToken(23, this.preferences.insert_space_before_semicolon);
        this.scribe.printTrailingComment();
        return false;
    }

    public boolean visit(DoStatement doStatement, BlockScope scope) {
        this.scribe.printNextToken(74);
        Statement action = doStatement.action;
        if (action != null) {
            if (action instanceof Block) {
                action.traverse(this, scope);
            } else {
                this.scribe.printNewLine();
                this.scribe.indent();
                action.traverse(this, scope);
                this.scribe.unIndent();
                this.scribe.printNewLine();
            }
            if (action instanceof Expression) {
                this.scribe.printNextToken(23, this.preferences.insert_space_before_semicolon);
                this.scribe.printTrailingComment();
                this.scribe.printNewLine();
            }
        } else {
            this.scribe.indent();
            this.formatEmptyStatement();
            this.scribe.unIndent();
        }
        if (this.preferences.insert_new_line_in_control_statements) {
            this.scribe.printNewLine();
        }
        this.scribe.printNextToken(70, this.preferences.insert_space_after_block_close_brace);
        this.scribe.printNextToken(27, this.preferences.insert_space_before_while_condition);
        if (this.preferences.insert_space_in_while_condition) {
            this.scribe.space();
        }
        doStatement.condition.traverse(this, scope);
        this.scribe.printNextToken(29, this.preferences.insert_space_in_while_condition);
        this.scribe.printNextToken(23, this.preferences.insert_space_before_semicolon);
        this.scribe.printTrailingComment();
        return false;
    }

    public boolean visit(DoubleLiteral doubleLiteral, BlockScope scope) {
        Constant constant;
        int numberOfParens = (doubleLiteral.bits & 0x1FE00000) >> 21;
        if (numberOfParens > 0) {
            this.manageOpeningParenthesizedExpression(doubleLiteral, numberOfParens);
        }
        if ((constant = doubleLiteral.constant) != null && constant.doubleValue() < 0.0) {
            this.scribe.printNextToken(2);
        }
        this.scribe.printNextToken(50);
        if (numberOfParens > 0) {
            this.manageClosingParenthesizedExpression(doubleLiteral, numberOfParens);
        }
        return false;
    }

    public boolean visit(EmptyStatement statement, BlockScope scope) {
        this.formatEmptyStatement();
        return false;
    }

    public boolean visit(EqualExpression equalExpression, BlockScope scope) {
        if ((equalExpression.bits & 0xFC0) >> 6 == 18) {
            return this.dumpEqualityExpression(equalExpression, 18, scope);
        }
        return this.dumpEqualityExpression(equalExpression, 19, scope);
    }

    public boolean visit(ExplicitConstructorCall explicitConstructor, BlockScope scope) {
        if (explicitConstructor.isImplicitSuper()) {
            return false;
        }
        Expression qualification = explicitConstructor.qualification;
        if (qualification != null) {
            qualification.traverse(this, scope);
            this.scribe.printNextToken(3);
        }
        if (explicitConstructor.isSuperAccess()) {
            this.scribe.printNextToken(42);
        } else {
            this.scribe.printNextToken(43);
        }
        this.scribe.printNextToken(27, this.preferences.insert_space_before_message_send);
        Expression[] arguments = explicitConstructor.arguments;
        if (arguments != null) {
            int argumentLength = arguments.length;
            Alignment argumentsAlignment = this.scribe.createAlignment("explicit_constructor_call", this.preferences.explicit_constructor_arguments_alignment, argumentLength, this.scribe.scanner.currentPosition);
            this.scribe.enterAlignment(argumentsAlignment);
            boolean ok = false;
            do {
                try {
                    if (this.preferences.insert_space_within_message_send) {
                        this.scribe.space();
                    }
                    int i = 0;
                    while (i < argumentLength) {
                        if (i > 0) {
                            this.scribe.printNextToken(30, this.preferences.insert_space_before_comma_in_explicitconstructorcall_arguments);
                        }
                        this.scribe.alignFragment(argumentsAlignment, i);
                        if (i > 0 && this.preferences.insert_space_after_comma_in_explicitconstructorcall_arguments) {
                            this.scribe.space();
                        }
                        arguments[i].traverse(this, scope);
                        ++i;
                    }
                    ok = true;
                }
                catch (AlignmentException e) {
                    this.scribe.redoAlignment(e);
                }
            } while (!ok);
            this.scribe.exitAlignment(argumentsAlignment, true);
            this.scribe.printNextToken(29, this.preferences.insert_space_within_message_send);
        } else {
            this.scribe.printNextToken(29, this.preferences.insert_space_between_empty_arguments);
        }
        this.scribe.printNextToken(23, this.preferences.insert_space_before_semicolon);
        this.scribe.printTrailingComment();
        return false;
    }

    public boolean visit(FalseLiteral falseLiteral, BlockScope scope) {
        int numberOfParens = (falseLiteral.bits & 0x1FE00000) >> 21;
        if (numberOfParens > 0) {
            this.manageOpeningParenthesizedExpression(falseLiteral, numberOfParens);
        }
        this.scribe.printNextToken(44);
        if (numberOfParens > 0) {
            this.manageClosingParenthesizedExpression(falseLiteral, numberOfParens);
        }
        return false;
    }

    public boolean visit(FieldReference fieldReference, BlockScope scope) {
        int numberOfParens = (fieldReference.bits & 0x1FE00000) >> 21;
        if (numberOfParens > 0) {
            this.manageOpeningParenthesizedExpression(fieldReference, numberOfParens);
        }
        fieldReference.receiver.traverse(this, scope);
        this.scribe.printNextToken(3);
        this.scribe.printNextToken(28);
        if (numberOfParens > 0) {
            this.manageClosingParenthesizedExpression(fieldReference, numberOfParens);
        }
        return false;
    }

    public boolean visit(FloatLiteral floatLiteral, BlockScope scope) {
        Constant constant;
        int numberOfParens = (floatLiteral.bits & 0x1FE00000) >> 21;
        if (numberOfParens > 0) {
            this.manageOpeningParenthesizedExpression(floatLiteral, numberOfParens);
        }
        if ((constant = floatLiteral.constant) != null && floatLiteral.constant.floatValue() < 0.0f) {
            this.scribe.printNextToken(2);
        }
        this.scribe.printNextToken(49);
        if (numberOfParens > 0) {
            this.manageClosingParenthesizedExpression(floatLiteral, numberOfParens);
        }
        return false;
    }

    public boolean visit(ForStatement forStatement, BlockScope scope) {
        Statement[] increments;
        Expression condition;
        Statement[] initializations;
        this.scribe.printNextToken(75);
        this.scribe.printNextToken(27, this.preferences.insert_space_before_for_paren);
        if (this.preferences.insert_space_in_for_parens) {
            this.scribe.space();
        }
        if ((initializations = forStatement.initializations) != null) {
            int length = initializations.length;
            int i = 0;
            while (i < length) {
                if (initializations[i] instanceof LocalDeclaration) {
                    this.formatLocalDeclaration((LocalDeclaration)initializations[i], scope, this.preferences.insert_space_before_comma_in_for_inits, this.preferences.insert_space_after_comma_in_for_inits);
                } else {
                    initializations[i].traverse(this, scope);
                    if (i >= 0 && i < length - 1) {
                        this.scribe.printNextToken(30, this.preferences.insert_space_before_comma_in_for_inits);
                        if (this.preferences.insert_space_after_comma_in_for_inits) {
                            this.scribe.space();
                        }
                    }
                }
                ++i;
            }
        }
        this.scribe.printNextToken(23, this.preferences.insert_space_before_semicolon);
        if (this.preferences.insert_space_after_semicolon_in_for) {
            this.scribe.space();
        }
        if ((condition = forStatement.condition) != null) {
            condition.traverse(this, scope);
        }
        this.scribe.printNextToken(23, this.preferences.insert_space_before_semicolon);
        if (this.preferences.insert_space_after_semicolon_in_for) {
            this.scribe.space();
        }
        if ((increments = forStatement.increments) != null) {
            int i = 0;
            int length = increments.length;
            while (i < length) {
                increments[i].traverse(this, scope);
                if (i != length - 1) {
                    this.scribe.printNextToken(30, this.preferences.insert_space_before_comma_in_for_increments);
                    if (this.preferences.insert_space_after_comma_in_for_increments) {
                        this.scribe.space();
                    }
                }
                ++i;
            }
        }
        this.scribe.printNextToken(29, this.preferences.insert_space_in_for_parens);
        Statement action = forStatement.action;
        if (action != null) {
            if (action instanceof Block) {
                action.traverse(this, scope);
            } else if (action instanceof EmptyStatement && !this.preferences.put_empty_statement_on_new_line) {
                action.traverse(this, scope);
            } else {
                this.scribe.indent();
                this.scribe.printNewLine();
                action.traverse(this, scope);
                this.scribe.unIndent();
            }
            if (action instanceof Expression) {
                this.scribe.printNextToken(23, this.preferences.insert_space_before_semicolon);
                this.scribe.printTrailingComment();
            }
        } else {
            this.scribe.indent();
            this.formatEmptyStatement();
            this.scribe.unIndent();
        }
        return false;
    }

    public boolean visit(IfStatement ifStatement, BlockScope scope) {
        this.scribe.printNextToken(76);
        this.scribe.printNextToken(27, this.preferences.insert_space_before_if_condition);
        if (this.preferences.insert_space_in_if_condition) {
            this.scribe.space();
        }
        ifStatement.condition.traverse(this, scope);
        this.scribe.printNextToken(29, this.preferences.insert_space_in_if_condition);
        Statement thenStatement = ifStatement.thenStatement;
        Statement elseStatement = ifStatement.elseStatement;
        if (thenStatement != null) {
            if (thenStatement instanceof Block) {
                if (this.isGuardClause((Block)thenStatement) && elseStatement == null && this.preferences.format_guardian_clause_on_one_line) {
                    this.formatGuardClauseBlock((Block)thenStatement, scope);
                } else {
                    if (thenStatement instanceof Block) {
                        thenStatement.traverse(this, scope);
                    } else {
                        this.scribe.printNewLine();
                        this.scribe.indent();
                        thenStatement.traverse(this, scope);
                        this.scribe.unIndent();
                    }
                    if (elseStatement != null && this.preferences.insert_new_line_in_control_statements) {
                        this.scribe.printNewLine();
                    }
                }
            } else if (elseStatement == null && this.preferences.keep_simple_if_on_one_line) {
                Alignment compactIfAlignment = this.scribe.createAlignment("compactIf", this.preferences.compact_if_alignment, 1, 1, this.scribe.scanner.currentPosition);
                this.scribe.enterAlignment(compactIfAlignment);
                boolean ok = false;
                do {
                    try {
                        this.scribe.alignFragment(compactIfAlignment, 0);
                        this.scribe.space();
                        thenStatement.traverse(this, scope);
                        if (thenStatement instanceof Expression) {
                            this.scribe.printNextToken(23, this.preferences.insert_space_before_semicolon);
                        }
                        ok = true;
                    }
                    catch (AlignmentException e) {
                        this.scribe.redoAlignment(e);
                    }
                } while (!ok);
                this.scribe.exitAlignment(compactIfAlignment, true);
            } else if (this.preferences.keep_then_statement_on_same_line) {
                this.scribe.space();
                thenStatement.traverse(this, scope);
                if (thenStatement instanceof Expression) {
                    this.scribe.printNextToken(23, this.preferences.insert_space_before_semicolon);
                    this.scribe.printTrailingComment();
                }
                if (elseStatement != null) {
                    this.scribe.printNewLine();
                }
            } else {
                this.scribe.printTrailingComment();
                this.scribe.printNewLine();
                this.scribe.indent();
                thenStatement.traverse(this, scope);
                if (thenStatement instanceof Expression) {
                    this.scribe.printNextToken(23, this.preferences.insert_space_before_semicolon);
                    this.scribe.printTrailingComment();
                }
                if (elseStatement != null) {
                    this.scribe.printNewLine();
                }
                this.scribe.unIndent();
            }
        }
        if (elseStatement != null) {
            this.scribe.printNextToken(87, true);
            if (elseStatement instanceof Block) {
                elseStatement.traverse(this, scope);
            } else if (elseStatement instanceof IfStatement) {
                if (!this.preferences.compact_else_if) {
                    this.scribe.printNewLine();
                    this.scribe.indent();
                }
                this.scribe.space();
                elseStatement.traverse(this, scope);
                if (!this.preferences.compact_else_if) {
                    this.scribe.unIndent();
                }
            } else if (this.preferences.keep_else_statement_on_same_line) {
                this.scribe.space();
                elseStatement.traverse(this, scope);
                if (elseStatement instanceof Expression) {
                    this.scribe.printNextToken(23, this.preferences.insert_space_before_semicolon);
                    this.scribe.printTrailingComment();
                }
            } else {
                this.scribe.printNewLine();
                this.scribe.indent();
                elseStatement.traverse(this, scope);
                if (elseStatement instanceof Expression) {
                    this.scribe.printNextToken(23, this.preferences.insert_space_before_semicolon);
                }
                this.scribe.unIndent();
            }
        }
        return false;
    }

    public boolean visit(ImportReference importRef, CompilationUnitScope scope) {
        this.scribe.printNextToken(82);
        this.scribe.space();
        if (importRef.onDemand) {
            this.scribe.printQualifiedReference(importRef.sourceEnd);
            this.scribe.printNextToken(3);
            this.scribe.printNextToken(4);
            this.scribe.printNextToken(23, this.preferences.insert_space_before_semicolon);
        } else {
            this.scribe.printQualifiedReference(importRef.sourceEnd);
            this.scribe.printNextToken(23, this.preferences.insert_space_before_semicolon);
        }
        this.scribe.printTrailingComment();
        this.scribe.printNewLine();
        return false;
    }

    public boolean visit(Initializer initializer, MethodScope scope) {
        if (initializer.isStatic()) {
            this.scribe.printNextToken(57);
        }
        initializer.block.traverse(this, scope);
        return false;
    }

    public boolean visit(InstanceOfExpression instanceOfExpression, BlockScope scope) {
        int numberOfParens = (instanceOfExpression.bits & 0x1FE00000) >> 21;
        if (numberOfParens > 0) {
            this.manageOpeningParenthesizedExpression(instanceOfExpression, numberOfParens);
        }
        instanceOfExpression.expression.traverse(this, scope);
        this.scribe.printNextToken(13, true);
        this.scribe.space();
        instanceOfExpression.type.traverse((ASTVisitor)this, scope);
        if (numberOfParens > 0) {
            this.manageClosingParenthesizedExpression(instanceOfExpression, numberOfParens);
        }
        return false;
    }

    public boolean visit(IntLiteral intLiteral, BlockScope scope) {
        Constant constant;
        int numberOfParens = (intLiteral.bits & 0x1FE00000) >> 21;
        if (numberOfParens > 0) {
            this.manageOpeningParenthesizedExpression(intLiteral, numberOfParens);
        }
        if ((constant = intLiteral.constant) != null && constant.intValue() < 0) {
            this.scribe.printNextToken(2);
        }
        this.scribe.printNextToken(47);
        if (numberOfParens > 0) {
            this.manageClosingParenthesizedExpression(intLiteral, numberOfParens);
        }
        return false;
    }

    public boolean visit(LabeledStatement labeledStatement, BlockScope scope) {
        this.scribe.printNextToken(28);
        this.scribe.printNextToken(53, this.preferences.insert_space_before_colon_in_labeled_statement);
        if (this.preferences.insert_space_after_colon_in_labeled_statement) {
            this.scribe.space();
        }
        labeledStatement.statement.traverse(this, scope);
        return false;
    }

    public boolean visit(LocalDeclaration localDeclaration, BlockScope scope) {
        this.formatLocalDeclaration(localDeclaration, scope, this.preferences.insert_space_before_comma_in_multiple_local_declarations, this.preferences.insert_space_after_comma_in_multiple_local_declarations);
        return false;
    }

    public boolean visit(LongLiteral longLiteral, BlockScope scope) {
        Constant constant;
        int numberOfParens = (longLiteral.bits & 0x1FE00000) >> 21;
        if (numberOfParens > 0) {
            this.manageOpeningParenthesizedExpression(longLiteral, numberOfParens);
        }
        if ((constant = longLiteral.constant) != null && constant.longValue() < 0L) {
            this.scribe.printNextToken(2);
        }
        this.scribe.printNextToken(48);
        if (numberOfParens > 0) {
            this.manageClosingParenthesizedExpression(longLiteral, numberOfParens);
        }
        return false;
    }

    public boolean visit(TypeDeclaration memberTypeDeclaration, ClassScope scope) {
        this.format(memberTypeDeclaration);
        return false;
    }

    public boolean visit(MessageSend messageSend, BlockScope scope) {
        CascadingMethodInvocationFragmentBuilder builder;
        int numberOfParens = (messageSend.bits & 0x1FE00000) >> 21;
        if (numberOfParens > 0) {
            this.manageOpeningParenthesizedExpression(messageSend, numberOfParens);
        }
        if ((builder = this.buildFragments(messageSend, scope)).size() >= 3 && numberOfParens == 0) {
            this.formatCascadingMessageSends(builder, scope);
        } else {
            Alignment messageAlignment = null;
            if (!messageSend.receiver.isImplicitThis()) {
                messageSend.receiver.traverse(this, scope);
                messageAlignment = this.scribe.createAlignment("messageAlignment", this.preferences.message_send_selector_alignment, 1, this.scribe.scanner.currentPosition);
                this.scribe.enterAlignment(messageAlignment);
                boolean ok = false;
                do {
                    try {
                        this.formatMessageSend(messageSend, scope, messageAlignment);
                        ok = true;
                    }
                    catch (AlignmentException e) {
                        this.scribe.redoAlignment(e);
                    }
                } while (!ok);
                this.scribe.exitAlignment(messageAlignment, true);
            } else {
                this.formatMessageSend(messageSend, scope, null);
            }
        }
        if (numberOfParens > 0) {
            this.manageClosingParenthesizedExpression(messageSend, numberOfParens);
        }
        return false;
    }

    public boolean visit(MethodDeclaration methodDeclaration, ClassScope scope) {
        if (methodDeclaration.ignoreFurtherInvestigation) {
            this.scribe.printComment();
            this.scribe.scanner.resetTo(methodDeclaration.declarationSourceEnd + 1, this.scribe.scannerEndPosition);
            this.scribe.printTrailingComment();
            return false;
        }
        this.scribe.printModifiers();
        this.scribe.space();
        TypeReference returnType = methodDeclaration.returnType;
        MethodScope methodDeclarationScope = methodDeclaration.scope;
        if (returnType != null) {
            returnType.traverse((ASTVisitor)this, methodDeclarationScope);
        }
        this.scribe.printNextToken(28, true);
        this.formatMethodArguments(methodDeclaration, this.preferences.insert_space_before_method_declaration_open_paren, this.preferences.insert_space_between_empty_arguments, this.preferences.insert_space_before_closing_paren, this.preferences.insert_space_before_first_argument, this.preferences.insert_space_before_comma_in_method_arguments, this.preferences.insert_space_after_comma_in_method_arguments);
        int extraDimensions = this.getExtraDimension();
        if (extraDimensions != 0) {
            int i = 0;
            while (i < extraDimensions) {
                this.scribe.printNextToken(12);
                this.scribe.printNextToken(69);
                ++i;
            }
        }
        this.formatThrowsClause(methodDeclaration, this.preferences.insert_space_before_comma_in_method_throws, this.preferences.insert_space_after_comma_in_method_throws);
        if (!methodDeclaration.isNative() && !methodDeclaration.isAbstract() && (methodDeclaration.modifiers & 0x1000000) == 0) {
            Statement[] statements;
            String method_declaration_brace = this.preferences.method_declaration_brace_position;
            this.formatOpeningBrace(method_declaration_brace, this.preferences.insert_space_before_method_open_brace);
            int numberOfBlankLinesAtBeginningOfMethodBody = this.preferences.number_of_blank_lines_to_insert_at_beginning_of_method_body;
            if (numberOfBlankLinesAtBeginningOfMethodBody > 0) {
                this.scribe.printEmptyLines(numberOfBlankLinesAtBeginningOfMethodBody);
            }
            if ((statements = methodDeclaration.statements) != null) {
                this.scribe.printNewLine();
                if (this.preferences.indent_block_statements) {
                    this.scribe.indent();
                }
                this.formatStatements(methodDeclarationScope, statements, true);
                this.scribe.printComment();
                if (this.preferences.indent_block_statements) {
                    this.scribe.unIndent();
                }
            } else if (this.preferences.insert_new_line_in_empty_method_body) {
                this.scribe.printNewLine();
                if (this.preferences.indent_block_statements) {
                    this.scribe.indent();
                }
                this.scribe.printComment();
                if (this.preferences.indent_block_statements) {
                    this.scribe.unIndent();
                }
            }
            this.scribe.printNextToken(40);
            this.scribe.printTrailingComment();
            if (method_declaration_brace.equals("next_line_shifted")) {
                this.scribe.unIndent();
            }
        } else {
            this.scribe.printNextToken(23, this.preferences.insert_space_before_semicolon);
            this.scribe.printTrailingComment();
        }
        return false;
    }

    public boolean visit(NullLiteral nullLiteral, BlockScope scope) {
        int numberOfParens = (nullLiteral.bits & 0x1FE00000) >> 21;
        if (numberOfParens > 0) {
            this.manageOpeningParenthesizedExpression(nullLiteral, numberOfParens);
        }
        this.scribe.printNextToken(45);
        if (numberOfParens > 0) {
            this.manageClosingParenthesizedExpression(nullLiteral, numberOfParens);
        }
        return false;
    }

    public boolean visit(OR_OR_Expression or_or_Expression, BlockScope scope) {
        return this.dumpBinaryExpression(or_or_Expression, 24, scope);
    }

    public boolean visit(PostfixExpression postfixExpression, BlockScope scope) {
        int numberOfParens = (postfixExpression.bits & 0x1FE00000) >> 21;
        if (numberOfParens > 0) {
            this.manageOpeningParenthesizedExpression(postfixExpression, numberOfParens);
        }
        postfixExpression.lhs.traverse(this, scope);
        int operator = postfixExpression.operator == 14 ? 7 : 8;
        this.scribe.printNextToken(operator, this.preferences.insert_space_before_postfix_operator);
        if (this.preferences.insert_space_after_postfix_operator) {
            this.scribe.space();
        }
        if (numberOfParens > 0) {
            this.manageClosingParenthesizedExpression(postfixExpression, numberOfParens);
        }
        return false;
    }

    public boolean visit(PrefixExpression prefixExpression, BlockScope scope) {
        int numberOfParens = (prefixExpression.bits & 0x1FE00000) >> 21;
        if (numberOfParens > 0) {
            this.manageOpeningParenthesizedExpression(prefixExpression, numberOfParens);
        }
        int operator = prefixExpression.operator == 14 ? 7 : 8;
        this.scribe.printNextToken(operator, this.preferences.insert_space_before_prefix_operator);
        if (this.preferences.insert_space_after_prefix_operator) {
            this.scribe.space();
        }
        prefixExpression.lhs.traverse(this, scope);
        if (numberOfParens > 0) {
            this.manageClosingParenthesizedExpression(prefixExpression, numberOfParens);
        }
        return false;
    }

    public boolean visit(QualifiedAllocationExpression qualifiedAllocationExpression, BlockScope scope) {
        Expression enclosingInstance;
        int numberOfParens = (qualifiedAllocationExpression.bits & 0x1FE00000) >> 21;
        if (numberOfParens > 0) {
            this.manageOpeningParenthesizedExpression(qualifiedAllocationExpression, numberOfParens);
        }
        if ((enclosingInstance = qualifiedAllocationExpression.enclosingInstance) != null) {
            enclosingInstance.traverse(this, scope);
            this.scribe.printNextToken(3);
        }
        this.scribe.printNextToken(41);
        this.scribe.space();
        qualifiedAllocationExpression.type.traverse((ASTVisitor)this, scope);
        this.scribe.printNextToken(27, this.preferences.insert_space_before_message_send);
        Expression[] arguments = qualifiedAllocationExpression.arguments;
        if (arguments != null) {
            int argumentLength = arguments.length;
            Alignment argumentsAlignment = this.scribe.createAlignment("allocation", this.preferences.qualified_allocation_expression_arguments_alignment, argumentLength, this.scribe.scanner.currentPosition);
            this.scribe.enterAlignment(argumentsAlignment);
            boolean ok = false;
            do {
                try {
                    if (this.preferences.insert_space_within_message_send) {
                        this.scribe.space();
                    }
                    int i = 0;
                    while (i < argumentLength) {
                        if (i > 0) {
                            this.scribe.printNextToken(30, this.preferences.insert_space_before_comma_in_allocation_expression);
                        }
                        this.scribe.alignFragment(argumentsAlignment, i);
                        if (i > 0 && this.preferences.insert_space_after_comma_in_allocation_expression) {
                            this.scribe.space();
                        }
                        arguments[i].traverse(this, scope);
                        ++i;
                    }
                    ok = true;
                }
                catch (AlignmentException e) {
                    this.scribe.redoAlignment(e);
                }
            } while (!ok);
            this.scribe.exitAlignment(argumentsAlignment, true);
            this.scribe.printNextToken(29, this.preferences.insert_space_within_message_send);
        } else {
            this.scribe.printNextToken(29, this.preferences.insert_space_between_empty_arguments);
        }
        TypeDeclaration anonymousType = qualifiedAllocationExpression.anonymousType;
        if (anonymousType != null) {
            anonymousType.traverse((ASTVisitor)this, scope);
        }
        if (numberOfParens > 0) {
            this.manageClosingParenthesizedExpression(qualifiedAllocationExpression, numberOfParens);
        }
        return false;
    }

    public boolean visit(QualifiedNameReference qualifiedNameReference, BlockScope scope) {
        int numberOfParens = (qualifiedNameReference.bits & 0x1FE00000) >> 21;
        if (numberOfParens > 0) {
            this.manageOpeningParenthesizedExpression(qualifiedNameReference, numberOfParens);
        }
        this.scribe.printQualifiedReference(qualifiedNameReference.sourceEnd + 1);
        if (numberOfParens > 0) {
            this.manageClosingParenthesizedExpression(qualifiedNameReference, numberOfParens);
        }
        return false;
    }

    public boolean visit(QualifiedSuperReference qualifiedSuperReference, BlockScope scope) {
        int numberOfParens = (qualifiedSuperReference.bits & 0x1FE00000) >> 21;
        if (numberOfParens > 0) {
            this.manageOpeningParenthesizedExpression(qualifiedSuperReference, numberOfParens);
        }
        qualifiedSuperReference.qualification.traverse((ASTVisitor)this, scope);
        this.scribe.printNextToken(3);
        this.scribe.printNextToken(42);
        if (numberOfParens > 0) {
            this.manageClosingParenthesizedExpression(qualifiedSuperReference, numberOfParens);
        }
        return false;
    }

    public boolean visit(QualifiedThisReference qualifiedThisReference, BlockScope scope) {
        int numberOfParens = (qualifiedThisReference.bits & 0x1FE00000) >> 21;
        if (numberOfParens > 0) {
            this.manageOpeningParenthesizedExpression(qualifiedThisReference, numberOfParens);
        }
        qualifiedThisReference.qualification.traverse((ASTVisitor)this, scope);
        this.scribe.printNextToken(3);
        this.scribe.printNextToken(43);
        if (numberOfParens > 0) {
            this.manageClosingParenthesizedExpression(qualifiedThisReference, numberOfParens);
        }
        return false;
    }

    public boolean visit(QualifiedTypeReference qualifiedTypeReference, BlockScope scope) {
        int numberOfParens = (qualifiedTypeReference.bits & 0x1FE00000) >> 21;
        if (numberOfParens > 0) {
            this.manageOpeningParenthesizedExpression(qualifiedTypeReference, numberOfParens);
        }
        this.scribe.printQualifiedReference(qualifiedTypeReference.sourceEnd + 1);
        if (numberOfParens > 0) {
            this.manageClosingParenthesizedExpression(qualifiedTypeReference, numberOfParens);
        }
        return false;
    }

    public boolean visit(QualifiedTypeReference qualifiedTypeReference, ClassScope scope) {
        int numberOfParens = (qualifiedTypeReference.bits & 0x1FE00000) >> 21;
        if (numberOfParens > 0) {
            this.manageOpeningParenthesizedExpression(qualifiedTypeReference, numberOfParens);
        }
        this.scribe.printQualifiedReference(qualifiedTypeReference.sourceEnd + 1);
        if (numberOfParens > 0) {
            this.manageClosingParenthesizedExpression(qualifiedTypeReference, numberOfParens);
        }
        return false;
    }

    public boolean visit(ReturnStatement returnStatement, BlockScope scope) {
        this.scribe.printNextToken(77);
        Expression expression = returnStatement.expression;
        if (expression != null) {
            this.scribe.space();
            expression.traverse(this, scope);
        }
        this.scribe.printNextToken(23, this.preferences.insert_space_before_semicolon);
        this.scribe.printTrailingComment();
        return false;
    }

    public boolean visit(SingleNameReference singleNameReference, BlockScope scope) {
        int numberOfParens = (singleNameReference.bits & 0x1FE00000) >> 21;
        if (numberOfParens > 0) {
            this.manageOpeningParenthesizedExpression(singleNameReference, numberOfParens);
        }
        this.scribe.printNextToken(SINGLETYPEREFERENCE_EXPECTEDTOKENS, false, true);
        if (numberOfParens > 0) {
            this.manageClosingParenthesizedExpression(singleNameReference, numberOfParens);
        }
        return false;
    }

    public boolean visit(SingleTypeReference singleTypeReference, BlockScope scope) {
        int numberOfParens = (singleTypeReference.bits & 0x1FE00000) >> 21;
        if (numberOfParens > 0) {
            this.manageOpeningParenthesizedExpression(singleTypeReference, numberOfParens);
        }
        this.scribe.printNextToken(SINGLETYPEREFERENCE_EXPECTEDTOKENS, false, true);
        if (numberOfParens > 0) {
            this.manageClosingParenthesizedExpression(singleTypeReference, numberOfParens);
        }
        return false;
    }

    public boolean visit(SingleTypeReference singleTypeReference, ClassScope scope) {
        int numberOfParens = (singleTypeReference.bits & 0x1FE00000) >> 21;
        if (numberOfParens > 0) {
            this.manageOpeningParenthesizedExpression(singleTypeReference, numberOfParens);
        }
        this.scribe.printNextToken(SINGLETYPEREFERENCE_EXPECTEDTOKENS, false, true);
        if (numberOfParens > 0) {
            this.manageClosingParenthesizedExpression(singleTypeReference, numberOfParens);
        }
        return false;
    }

    public boolean visit(StringLiteral stringLiteral, BlockScope scope) {
        int numberOfParens = (stringLiteral.bits & 0x1FE00000) >> 21;
        if (numberOfParens > 0) {
            this.manageOpeningParenthesizedExpression(stringLiteral, numberOfParens);
        }
        this.scribe.printNextToken(52);
        this.scribe.printTrailingComment();
        if (numberOfParens > 0) {
            this.manageClosingParenthesizedExpression(stringLiteral, numberOfParens);
        }
        return false;
    }

    public boolean visit(SuperReference superReference, BlockScope scope) {
        int numberOfParens = (superReference.bits & 0x1FE00000) >> 21;
        if (numberOfParens > 0) {
            this.manageOpeningParenthesizedExpression(superReference, numberOfParens);
        }
        this.scribe.printNextToken(42);
        if (numberOfParens > 0) {
            this.manageClosingParenthesizedExpression(superReference, numberOfParens);
        }
        return false;
    }

    public boolean visit(SwitchStatement switchStatement, BlockScope scope) {
        this.scribe.printNextToken(78);
        this.scribe.printNextToken(27, this.preferences.insert_space_before_switch_condition);
        if (this.preferences.insert_space_in_switch_condition) {
            this.scribe.space();
        }
        switchStatement.expression.traverse(this, scope);
        this.scribe.printNextToken(29, this.preferences.insert_space_in_switch_condition);
        String switch_brace = this.preferences.switch_brace_position;
        this.formatOpeningBrace(switch_brace, this.preferences.insert_space_before_switch_open_brace);
        this.scribe.printNewLine();
        if (this.preferences.indent_switchstatements_compare_to_switch) {
            this.scribe.indent();
        }
        Statement[] statements = switchStatement.statements;
        boolean wasACase = false;
        boolean wasAStatement = false;
        if (statements != null) {
            int statementsLength = statements.length;
            int i = 0;
            while (i < statementsLength) {
                Statement statement = statements[i];
                if (statement instanceof CaseStatement) {
                    if (wasACase && this.preferences.indent_switchstatements_compare_to_cases || wasAStatement && this.preferences.indent_switchstatements_compare_to_cases) {
                        this.scribe.unIndent();
                    }
                    statement.traverse(this, scope);
                    wasACase = true;
                    wasAStatement = false;
                    if (this.preferences.indent_switchstatements_compare_to_cases) {
                        this.scribe.indent();
                    }
                } else if (statement instanceof BreakStatement) {
                    if (this.preferences.indent_breaks_compare_to_cases) {
                        if (wasAStatement && !this.preferences.indent_switchstatements_compare_to_cases) {
                            this.scribe.indent();
                        }
                    } else {
                        if (wasAStatement && this.preferences.indent_switchstatements_compare_to_cases) {
                            this.scribe.unIndent();
                        }
                        if (wasACase && this.preferences.indent_switchstatements_compare_to_cases) {
                            this.scribe.unIndent();
                        }
                    }
                    statement.traverse(this, scope);
                    if (this.preferences.indent_breaks_compare_to_cases) {
                        this.scribe.unIndent();
                    }
                    wasACase = false;
                    wasAStatement = false;
                } else {
                    statement.traverse(this, scope);
                    wasAStatement = true;
                    wasACase = false;
                }
                if (statement instanceof Expression) {
                    this.scribe.printNextToken(23, this.preferences.insert_space_before_semicolon);
                    this.scribe.printTrailingComment();
                } else if (statement instanceof LocalDeclaration) {
                    LocalDeclaration currentLocal = (LocalDeclaration)statement;
                    if (i < statementsLength - 1) {
                        if (statements[i + 1] instanceof LocalDeclaration) {
                            LocalDeclaration nextLocal = (LocalDeclaration)statements[i + 1];
                            if (currentLocal.declarationSourceStart != nextLocal.declarationSourceStart) {
                                this.scribe.printNextToken(23, this.preferences.insert_space_before_semicolon);
                                this.scribe.printTrailingComment();
                            }
                        } else {
                            this.scribe.printNextToken(23, this.preferences.insert_space_before_semicolon);
                            this.scribe.printTrailingComment();
                        }
                    } else {
                        this.scribe.printNextToken(23, this.preferences.insert_space_before_semicolon);
                        this.scribe.printTrailingComment();
                    }
                }
                this.scribe.printNewLine();
                ++i;
            }
        }
        if ((wasACase || wasAStatement) && this.preferences.indent_switchstatements_compare_to_cases) {
            this.scribe.unIndent();
        }
        if (this.preferences.indent_switchstatements_compare_to_switch) {
            this.scribe.unIndent();
        }
        this.scribe.printNewLine();
        this.scribe.printNextToken(40);
        this.scribe.printTrailingComment();
        if (switch_brace.equals("next_line_shifted")) {
            this.scribe.unIndent();
        }
        return false;
    }

    public boolean visit(SynchronizedStatement synchronizedStatement, BlockScope scope) {
        this.scribe.printNextToken(55);
        this.scribe.printNextToken(27, this.preferences.insert_space_before_synchronized_condition);
        if (this.preferences.insert_space_in_synchronized_condition) {
            this.scribe.space();
        }
        synchronizedStatement.expression.traverse(this, scope);
        this.scribe.printNextToken(29, this.preferences.insert_space_in_synchronized_condition);
        synchronizedStatement.block.traverse(this, scope);
        return false;
    }

    public boolean visit(ThisReference thisReference, BlockScope scope) {
        if (!thisReference.isImplicitThis()) {
            int numberOfParens = (thisReference.bits & 0x1FE00000) >> 21;
            if (numberOfParens > 0) {
                this.manageOpeningParenthesizedExpression(thisReference, numberOfParens);
            }
            this.scribe.printNextToken(43);
            if (numberOfParens > 0) {
                this.manageClosingParenthesizedExpression(thisReference, numberOfParens);
            }
        }
        return false;
    }

    public boolean visit(ThrowStatement throwStatement, BlockScope scope) {
        this.scribe.printNextToken(79);
        this.scribe.space();
        throwStatement.exception.traverse(this, scope);
        this.scribe.printNextToken(23, this.preferences.insert_space_before_semicolon);
        this.scribe.printTrailingComment();
        return false;
    }

    public boolean visit(TrueLiteral trueLiteral, BlockScope scope) {
        int numberOfParens = (trueLiteral.bits & 0x1FE00000) >> 21;
        if (numberOfParens > 0) {
            this.manageOpeningParenthesizedExpression(trueLiteral, numberOfParens);
        }
        this.scribe.printNextToken(46);
        if (numberOfParens > 0) {
            this.manageClosingParenthesizedExpression(trueLiteral, numberOfParens);
        }
        return false;
    }

    public boolean visit(TryStatement tryStatement, BlockScope scope) {
        this.scribe.printNextToken(80);
        tryStatement.tryBlock.traverse(this, scope);
        if (this.preferences.insert_new_line_in_control_statements) {
            this.scribe.printNewLine();
        }
        if (tryStatement.catchArguments != null) {
            int i = 0;
            int max = tryStatement.catchBlocks.length;
            while (i < max) {
                this.scribe.printNextToken(86, this.preferences.insert_space_after_block_close_brace);
                this.scribe.printNextToken(27, this.preferences.insert_space_before_catch_expression);
                if (this.preferences.insert_space_in_catch_expression) {
                    this.scribe.space();
                }
                tryStatement.catchArguments[i].traverse(this, scope);
                this.scribe.printNextToken(29, this.preferences.insert_space_in_catch_expression);
                tryStatement.catchBlocks[i].traverse(this, scope);
                if (this.preferences.insert_new_line_in_control_statements) {
                    this.scribe.printNewLine();
                }
                ++i;
            }
        }
        if (tryStatement.finallyBlock != null) {
            this.scribe.printNextToken(88, this.preferences.insert_space_after_block_close_brace);
            tryStatement.finallyBlock.traverse(this, scope);
        }
        return false;
    }

    public boolean visit(TypeDeclaration localTypeDeclaration, BlockScope scope) {
        this.format(localTypeDeclaration);
        return false;
    }

    public boolean visit(TypeDeclaration typeDeclaration, CompilationUnitScope scope) {
        this.format(typeDeclaration);
        return false;
    }

    public boolean visit(UnaryExpression unaryExpression, BlockScope scope) {
        int operator;
        int numberOfParens = (unaryExpression.bits & 0x1FE00000) >> 21;
        if (numberOfParens > 0) {
            this.manageOpeningParenthesizedExpression(unaryExpression, numberOfParens);
        }
        switch ((unaryExpression.bits & 0xFC0) >> 6) {
            case 14: {
                operator = 1;
                break;
            }
            case 13: {
                operator = 2;
                break;
            }
            case 12: {
                operator = 56;
                break;
            }
            default: {
                operator = 58;
            }
        }
        this.scribe.printNextToken(operator, this.preferences.insert_space_before_unary_operator);
        if (this.preferences.insert_space_after_unary_operator) {
            this.scribe.space();
        }
        unaryExpression.expression.traverse(this, scope);
        if (numberOfParens > 0) {
            this.manageClosingParenthesizedExpression(unaryExpression, numberOfParens);
        }
        return false;
    }

    public boolean visit(WhileStatement whileStatement, BlockScope scope) {
        this.scribe.printNextToken(70);
        this.scribe.printNextToken(27, this.preferences.insert_space_before_while_condition);
        if (this.preferences.insert_space_in_while_condition) {
            this.scribe.space();
        }
        whileStatement.condition.traverse(this, scope);
        this.scribe.printNextToken(29, this.preferences.insert_space_in_while_condition);
        Statement action = whileStatement.action;
        if (action != null) {
            if (action instanceof Block) {
                action.traverse(this, scope);
            } else {
                this.scribe.printNewLine();
                this.scribe.indent();
                action.traverse(this, scope);
                this.scribe.unIndent();
            }
            if (action instanceof Expression) {
                this.scribe.printNextToken(23, this.preferences.insert_space_before_semicolon);
                this.scribe.printTrailingComment();
            }
        } else {
            this.scribe.indent();
            this.formatEmptyStatement();
            this.scribe.unIndent();
        }
        return false;
    }

    public static class MultiFieldDeclaration
    extends FieldDeclaration {
        FieldDeclaration[] declarations;

        MultiFieldDeclaration(FieldDeclaration[] declarations) {
            this.declarations = declarations;
            this.modifiers = declarations[0].modifiers;
        }
    }
}

