/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.formatter;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import org.eclipse.jdt.core.ICodeFormatter;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.internal.compiler.ConfigurableOption;
import org.eclipse.jdt.internal.compiler.parser.Scanner;
import org.eclipse.jdt.internal.compiler.parser.TerminalTokens;
import org.eclipse.jdt.internal.formatter.impl.FormatterOptions;
import org.eclipse.jdt.internal.formatter.impl.SplitLine;

public class CodeFormatter
implements TerminalTokens,
ICodeFormatter {
    public FormatterOptions options;
    public static final int BLOCK = 59;
    public static final int NONINDENT_BLOCK = -100;
    StringBuffer formattedSource;
    StringBuffer currentLineBuffer;
    Scanner scanner = new Scanner(true, true, false, 0x2F0000L, null, null);
    private int[] constructions;
    private int constructionsCount;
    private int indentationLevel;
    private int initialIndentationLevel;
    Scanner splitScanner;
    int currentCommentOffset;
    int currentLineIndentationLevel;
    int maxLineSize = 30;
    private boolean containsOpenCloseBraces;
    private int indentationLevelForOpenCloseBraces;
    private int[] positionsToMap;
    private int[] mappedPositions;
    private int indexToMap;
    private int indexInMap;
    private int globalDelta;
    private int lineDelta;
    private int splitDelta;
    private int beginningOfLineIndex;
    private int multipleLineCommentCounter;
    static /* synthetic */ Class class$0;

    public CodeFormatter(ConfigurableOption[] settings) {
        this(CodeFormatter.convertConfigurableOptions(settings));
    }

    public CodeFormatter() {
        this((Map)null);
    }

    public CodeFormatter(Map settings) {
        this.scanner.recordLineSeparator = true;
        this.splitScanner = new Scanner(true, true, false, 0x2F0000L, null, null);
        this.options = new FormatterOptions(settings);
    }

    private static boolean breakLineBeforeOperator(int operator) {
        switch (operator) {
            case 23: 
            case 30: 
            case 90: {
                return false;
            }
        }
        return true;
    }

    private static Map convertConfigurableOptions(ConfigurableOption[] settings) {
        Hashtable<String, String> options = new Hashtable<String, String>(10);
        int i = 0;
        while (i < settings.length) {
            String string = settings[i].getComponentName();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("[Lorg.eclipse.jdt.internal.formatter.CodeFormatter;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (string.equals(clazz.getName())) {
                String optionName = settings[i].getOptionName();
                int valueIndex = settings[i].getCurrentValueIndex();
                if (optionName.equals("newline.openingBrace")) {
                    options.put("org.eclipse.jdt.core.formatter.newline.openingBrace", valueIndex == 0 ? "insert" : "do not insert");
                } else if (optionName.equals("newline.controlStatement")) {
                    options.put("org.eclipse.jdt.core.formatter.newline.controlStatement", valueIndex == 0 ? "insert" : "do not insert");
                } else if (optionName.equals("newline.clearAll")) {
                    options.put("org.eclipse.jdt.core.formatter.newline.clearAll", valueIndex == 0 ? "clear all" : "preserve one");
                } else if (optionName.equals("newline.elseIf")) {
                    options.put("org.eclipse.jdt.core.formatter.newline.elseIf", valueIndex == 0 ? "do not insert" : "insert");
                } else if (optionName.equals("newline.emptyBlock")) {
                    options.put("org.eclipse.jdt.core.formatter.newline.emptyBlock", valueIndex == 0 ? "insert" : "do not insert");
                } else if (optionName.equals("lineSplit")) {
                    options.put("org.eclipse.jdt.core.formatter.lineSplit", String.valueOf(valueIndex));
                } else if (optionName.equals("style.assignment")) {
                    options.put("org.eclipse.jdt.core.formatter.style.assignment", valueIndex == 0 ? "compact" : "normal");
                } else if (optionName.equals("tabulation.char")) {
                    options.put("org.eclipse.jdt.core.formatter.tabulation.char", valueIndex == 0 ? "tab" : "space");
                } else if (optionName.equals("tabulation.size")) {
                    options.put("org.eclipse.jdt.core.formatter.tabulation.size", String.valueOf(valueIndex));
                } else if (optionName.equals("space.castexpression")) {
                    options.put("org.eclipse.jdt.core.formatter.space.castexpression", valueIndex == 0 ? "insert" : "do not insert");
                }
            }
            ++i;
        }
        return options;
    }

    private final String copyRemainingSource() {
        char[] str = this.scanner.source;
        int startPosition = this.scanner.startPosition;
        int length = str.length - startPosition;
        StringBuffer bufr = new StringBuffer(length);
        if (startPosition < str.length) {
            bufr.append(str, startPosition, length);
        }
        return bufr.toString();
    }

    private void dumpTab(int tabCount) {
        if (this.options.indentWithTab) {
            int j = 0;
            while (j < tabCount) {
                this.formattedSource.append('\t');
                this.increaseSplitDelta(1);
                ++j;
            }
        } else {
            int i = 0;
            int max = this.options.tabSize * tabCount;
            while (i < max) {
                this.formattedSource.append(' ');
                this.increaseSplitDelta(1);
                ++i;
            }
        }
    }

    private void flushBuffer() {
        String currentString = this.currentLineBuffer.toString();
        this.splitDelta = 0;
        this.beginningOfLineIndex = this.formattedSource.length();
        if (this.containsOpenCloseBraces) {
            this.containsOpenCloseBraces = false;
            this.outputLine(currentString, false, this.indentationLevelForOpenCloseBraces, 0, -1, null, 0);
            this.indentationLevelForOpenCloseBraces = this.currentLineIndentationLevel;
        } else {
            this.outputLine(currentString, false, this.currentLineIndentationLevel, 0, -1, null, 0);
        }
        int scannerSourceLength = this.scanner.source.length;
        if (scannerSourceLength > 2) {
            if (this.scanner.source[scannerSourceLength - 1] == '\n' && this.scanner.source[scannerSourceLength - 2] == '\r') {
                this.formattedSource.append(this.options.lineSeparatorSequence);
                this.increaseGlobalDelta(this.options.lineSeparatorSequence.length - 2);
            } else if (this.scanner.source[scannerSourceLength - 1] == '\n') {
                this.formattedSource.append(this.options.lineSeparatorSequence);
                this.increaseGlobalDelta(this.options.lineSeparatorSequence.length - 1);
            } else if (this.scanner.source[scannerSourceLength - 1] == '\r') {
                this.formattedSource.append(this.options.lineSeparatorSequence);
                this.increaseGlobalDelta(this.options.lineSeparatorSequence.length - 1);
            }
        }
        this.updateMappedPositions(this.scanner.startPosition);
        this.updateRemainingMappedPositions();
    }

    private void format() {
        this.reset();
        int token = 0;
        int previousToken = 0;
        int previousCompilableToken = 0;
        int indentationOffset = 0;
        int newLinesInWhitespace = 0;
        int pendingNewLines = 0;
        boolean expectingOpenBrace = false;
        boolean clearNonBlockIndents = false;
        boolean pendingSpace = true;
        boolean pendingNewlineAfterParen = false;
        boolean inAssignment = false;
        boolean inArrayAssignment = false;
        boolean inThrowsClause = false;
        boolean inClassOrInterfaceHeader = false;
        int openBracketCount = 0;
        int unarySignModifier = 0;
        int openParenthesisCount = 1;
        int[] openParenthesis = new int[10];
        int tokenBeforeColonCount = 0;
        int[] tokenBeforeColon = new int[10];
        this.constructionsCount = 0;
        int nlicsToken = 0;
        boolean specialElse = false;
        this.currentLineIndentationLevel += this.constructionsCount;
        try {
            while (true) {
                block102: {
                    block103: {
                        block104: {
                            boolean openAndCloseBrace;
                            block101: {
                                try {
                                    token = this.scanner.getNextToken();
                                    if (token != 1001) break block101;
                                    int length = this.scanner.currentPosition;
                                    int index = length - 1;
                                    while (index >= 0) {
                                        switch (this.scanner.source[index]) {
                                            case '\n': 
                                            case '\r': {
                                                --this.scanner.currentPosition;
                                                break;
                                            }
                                            default: {
                                                break block101;
                                            }
                                        }
                                        --index;
                                    }
                                }
                                catch (InvalidInputException e) {
                                    if (!this.handleInvalidToken(e)) {
                                        throw e;
                                    }
                                    token = 0;
                                }
                            }
                            if (token == 54) break;
                            if (clearNonBlockIndents && token != 1000) {
                                switch (token) {
                                    case 87: {
                                        if (this.constructionsCount > 0 && this.constructions[this.constructionsCount - 1] == 87) {
                                            pendingNewLines = 1;
                                            specialElse = true;
                                        }
                                        this.indentationLevel += this.popInclusiveUntil(76);
                                        break;
                                    }
                                    case 86: {
                                        this.indentationLevel += this.popInclusiveUntil(86);
                                        break;
                                    }
                                    case 88: {
                                        this.indentationLevel += this.popInclusiveUntil(86);
                                        break;
                                    }
                                    case 70: {
                                        if (nlicsToken == 74) {
                                            this.indentationLevel += this.pop(74);
                                            break;
                                        }
                                    }
                                    default: {
                                        this.indentationLevel += this.popExclusiveUntilBlockOrCase();
                                    }
                                }
                                clearNonBlockIndents = false;
                            }
                            if (token == 83 || token == 84) {
                                this.indentationLevel += this.pop(83);
                            }
                            if (token == 104) {
                                inThrowsClause = true;
                            }
                            if ((token == 81 || token == 89) && previousToken != 3) {
                                inClassOrInterfaceHeader = true;
                            }
                            if (pendingNewlineAfterParen && previousCompilableToken == 87 && token == 76 && this.options.compactElseIfMode) {
                                pendingNewlineAfterParen = false;
                                pendingNewLines = 0;
                                this.indentationLevel += this.pop(87);
                            }
                            boolean bl = pendingNewlineAfterParen = pendingNewlineAfterParen || previousCompilableToken == 29 && token == 59;
                            if (pendingNewlineAfterParen && token != 1000) {
                                pendingNewlineAfterParen = false;
                                if (!(token == 59 || CodeFormatter.isComment(token) || token == 3 || previousCompilableToken == 29 && token == 23)) {
                                    this.newLine(1);
                                    this.currentLineIndentationLevel = this.indentationLevel;
                                    pendingNewLines = 0;
                                    pendingSpace = false;
                                } else if (token == 59 && this.options.newLineBeforeOpeningBraceMode) {
                                    this.newLine(1);
                                    this.currentLineIndentationLevel = this.constructionsCount > 0 && this.constructions[this.constructionsCount - 1] != 59 && this.constructions[this.constructionsCount - 1] != -100 ? this.indentationLevel - 1 : this.indentationLevel;
                                    pendingNewLines = 0;
                                    pendingSpace = false;
                                }
                            }
                            if (token == 59 && this.options.newLineBeforeOpeningBraceMode && this.constructionsCount > 0 && this.constructions[this.constructionsCount - 1] == 74) {
                                this.newLine(1);
                                this.currentLineIndentationLevel = this.indentationLevel - 1;
                                pendingNewLines = 0;
                                pendingSpace = false;
                            }
                            if (token == 59 && inThrowsClause) {
                                inThrowsClause = false;
                                if (this.options.newLineBeforeOpeningBraceMode) {
                                    this.newLine(1);
                                    this.currentLineIndentationLevel = this.indentationLevel;
                                    pendingNewLines = 0;
                                    pendingSpace = false;
                                }
                            }
                            if (token == 59 && inClassOrInterfaceHeader) {
                                inClassOrInterfaceHeader = false;
                                if (this.options.newLineBeforeOpeningBraceMode) {
                                    this.newLine(1);
                                    this.currentLineIndentationLevel = this.indentationLevel;
                                    pendingNewLines = 0;
                                    pendingSpace = false;
                                }
                            }
                            if ((pendingNewLines > 0 && !CodeFormatter.isComment(token) || newLinesInWhitespace > 0 && openParenthesisCount <= 1 && CodeFormatter.isComment(token) || previousCompilableToken == 59 && token == 40) && token != 1000) {
                                boolean commaAndCloseBrace;
                                boolean closeBraceAndCloseParen = previousToken == 40 && token == 29;
                                boolean nlicsOption = previousToken == 40 && !this.options.newlineInControlStatementMode && (token == 87 || token == 70 && nlicsToken == 74 || token == 86 || token == 88);
                                boolean semiColonAndCloseBrace = previousToken == 40 && token == 23;
                                boolean commentAndOpenBrace = previousToken == 1002 && token == 59;
                                boolean bl2 = commaAndCloseBrace = previousToken == 40 && token == 30;
                                if (specialElse || !commentAndOpenBrace && !closeBraceAndCloseParen && !nlicsOption && !semiColonAndCloseBrace && !commaAndCloseBrace) {
                                    if (!this.options.clearAllBlankLinesMode) {
                                        pendingNewLines = pendingNewLines < newLinesInWhitespace ? newLinesInWhitespace : pendingNewLines;
                                        int n = pendingNewLines = pendingNewLines > 2 ? 2 : pendingNewLines;
                                    }
                                    if (previousCompilableToken == 59 && token == 40) {
                                        this.containsOpenCloseBraces = true;
                                        this.indentationLevelForOpenCloseBraces = this.currentLineIndentationLevel;
                                        if (CodeFormatter.isComment(previousToken)) {
                                            this.newLine(pendingNewLines);
                                        } else if (this.options.newLineInEmptyBlockMode) {
                                            if (inArrayAssignment) {
                                                this.newLine(1);
                                            } else {
                                                this.newLine(pendingNewLines);
                                            }
                                        }
                                    } else if (previousToken != 1002 && previousToken != 1003 || token != 23) {
                                        this.newLine(pendingNewLines);
                                    }
                                    if ((previousCompilableToken == 23 || previousCompilableToken == 59 || previousCompilableToken == 40 || CodeFormatter.isComment(previousToken)) && token == 40) {
                                        indentationOffset = -1;
                                        this.indentationLevel += this.popExclusiveUntilBlock();
                                    }
                                    this.currentLineIndentationLevel = previousToken == 1001 && inAssignment ? ++this.currentLineIndentationLevel : this.indentationLevel + indentationOffset;
                                    pendingSpace = false;
                                    indentationOffset = 0;
                                }
                                pendingNewLines = 0;
                                newLinesInWhitespace = 0;
                                specialElse = false;
                                if (nlicsToken == 74 && token == 70) {
                                    nlicsToken = 0;
                                }
                            }
                            switch (token) {
                                case 87: 
                                case 88: {
                                    expectingOpenBrace = true;
                                    pendingNewlineAfterParen = true;
                                    this.indentationLevel += this.pushControlStatement(token);
                                    break;
                                }
                                case 83: 
                                case 84: {
                                    if (tokenBeforeColonCount == tokenBeforeColon.length) {
                                        int[] nArray = tokenBeforeColon;
                                        tokenBeforeColon = new int[tokenBeforeColonCount * 2];
                                        System.arraycopy(nArray, 0, tokenBeforeColon, 0, tokenBeforeColonCount);
                                    }
                                    tokenBeforeColon[tokenBeforeColonCount++] = 83;
                                    this.indentationLevel += this.pushControlStatement(83);
                                    break;
                                }
                                case 26: {
                                    if (tokenBeforeColonCount == tokenBeforeColon.length) {
                                        int[] nArray = tokenBeforeColon;
                                        tokenBeforeColon = new int[tokenBeforeColonCount * 2];
                                        System.arraycopy(nArray, 0, tokenBeforeColon, 0, tokenBeforeColonCount);
                                    }
                                    tokenBeforeColon[tokenBeforeColonCount++] = token;
                                    break;
                                }
                                case 70: 
                                case 75: 
                                case 76: 
                                case 78: {
                                    if (openParenthesisCount == openParenthesis.length) {
                                        int[] nArray = openParenthesis;
                                        openParenthesis = new int[openParenthesisCount * 2];
                                        System.arraycopy(nArray, 0, openParenthesis, 0, openParenthesisCount);
                                    }
                                    openParenthesis[openParenthesisCount++] = 0;
                                    expectingOpenBrace = true;
                                    this.indentationLevel += this.pushControlStatement(token);
                                    break;
                                }
                                case 80: {
                                    pendingNewlineAfterParen = true;
                                }
                                case 86: {
                                    expectingOpenBrace = true;
                                    this.indentationLevel += this.pushControlStatement(86);
                                    break;
                                }
                                case 74: {
                                    expectingOpenBrace = true;
                                    this.indentationLevel += this.pushControlStatement(token);
                                    nlicsToken = token;
                                    break;
                                }
                                case 41: {
                                    break;
                                }
                                case 27: {
                                    if (previousToken == 55) {
                                        this.indentationLevel += this.pushControlStatement(previousToken);
                                        break;
                                    }
                                    if (previousCompilableToken != 12 && previousToken != 28 && previousToken != 0 && previousToken != 58 && previousToken != 27 && previousToken != 56 && previousToken != 23 && previousToken != 59 && previousToken != 40 && previousToken != 42 && previousToken != 43) {
                                        this.space();
                                    }
                                    if (openParenthesisCount > 0) {
                                        int n = openParenthesisCount - 1;
                                        openParenthesis[n] = openParenthesis[n] + 1;
                                    } else {
                                        openParenthesis[0] = openParenthesis[0] + 1;
                                    }
                                    pendingSpace = false;
                                    break;
                                }
                                case 29: {
                                    if (openParenthesisCount > 1 && openParenthesis[openParenthesisCount - 1] > 0) {
                                        int n = openParenthesisCount - 1;
                                        openParenthesis[n] = openParenthesis[n] - 1;
                                        if (openParenthesis[openParenthesisCount - 1] <= 0) {
                                            pendingNewlineAfterParen = true;
                                            inAssignment = false;
                                            --openParenthesisCount;
                                        }
                                    } else {
                                        openParenthesis[0] = openParenthesis[0] - 1;
                                    }
                                    pendingSpace = false;
                                    break;
                                }
                                case 59: {
                                    if (previousCompilableToken == 69 || previousCompilableToken == 90) {
                                        inArrayAssignment = true;
                                        inAssignment = false;
                                    }
                                    if (inArrayAssignment) {
                                        this.indentationLevel += this.pushBlock();
                                        break;
                                    }
                                    pendingNewLines = 1;
                                    this.indentationLevel += this.pushBlock();
                                    break;
                                }
                                case 40: {
                                    if (previousCompilableToken == 29) {
                                        pendingSpace = false;
                                    }
                                    if (inArrayAssignment) {
                                        inArrayAssignment = false;
                                        pendingNewLines = 1;
                                        this.indentationLevel += this.popInclusiveUntilBlock();
                                        break;
                                    }
                                    pendingNewLines = 1;
                                    this.indentationLevel += this.popInclusiveUntilBlock();
                                    if (previousCompilableToken == 29) {
                                        this.currentLineBuffer.append(this.options.lineSeparatorSequence);
                                        this.increaseLineDelta(this.options.lineSeparatorSequence.length);
                                    }
                                    if (this.constructionsCount <= 0) break;
                                    switch (this.constructions[this.constructionsCount - 1]) {
                                        case 55: 
                                        case 70: 
                                        case 74: 
                                        case 75: 
                                        case 76: 
                                        case 78: 
                                        case 80: 
                                        case 86: 
                                        case 87: 
                                        case 88: {
                                            clearNonBlockIndents = true;
                                        }
                                    }
                                    break;
                                }
                                case 12: {
                                    ++openBracketCount;
                                    pendingSpace = false;
                                    break;
                                }
                                case 69: {
                                    openBracketCount -= openBracketCount > 0 ? 1 : 0;
                                    pendingSpace = false;
                                    break;
                                }
                                case 3: 
                                case 30: {
                                    pendingSpace = false;
                                    break;
                                }
                                case 23: {
                                    if (openParenthesisCount <= 1) {
                                        pendingNewLines = 1;
                                        if (expectingOpenBrace) {
                                            clearNonBlockIndents = true;
                                            expectingOpenBrace = false;
                                        }
                                    }
                                    inAssignment = false;
                                    pendingSpace = false;
                                    break;
                                }
                                case 7: 
                                case 8: {
                                    if (previousToken != 28 && previousToken != 69) break;
                                    pendingSpace = false;
                                    break;
                                }
                                case 1: 
                                case 2: {
                                    if (CodeFormatter.isLiteralToken(previousToken) || previousToken == 28 || previousToken == 29 || previousToken == 69) break;
                                    unarySignModifier = 1;
                                    break;
                                }
                                case 53: {
                                    if (tokenBeforeColonCount <= 0) break;
                                    if (tokenBeforeColon[tokenBeforeColonCount - 1] == 83) {
                                        pendingNewLines = 1;
                                    }
                                    --tokenBeforeColonCount;
                                    break;
                                }
                                case 90: {
                                    inAssignment = true;
                                    break;
                                }
                                case 1001: {
                                    pendingNewLines = 1;
                                    if (!inAssignment) break;
                                    ++this.currentLineIndentationLevel;
                                    break;
                                }
                                case 1002: 
                                case 1003: {
                                    this.currentCommentOffset = this.getCurrentCommentOffset();
                                    pendingNewLines = 1;
                                    break;
                                }
                                case 1000: {
                                    char[] source = this.scanner.source;
                                    newLinesInWhitespace = 0;
                                    int i = this.scanner.startPosition;
                                    int max = this.scanner.currentPosition;
                                    while (i < max) {
                                        if (source[i] == '\r') {
                                            newLinesInWhitespace = i < max - 1 ? (source[++i] == '\n' ? ++newLinesInWhitespace : ++newLinesInWhitespace) : ++newLinesInWhitespace;
                                        } else if (source[i] == '\n') {
                                            ++newLinesInWhitespace;
                                        }
                                        ++i;
                                    }
                                    this.increaseLineDelta(this.scanner.startPosition - this.scanner.currentPosition);
                                    break;
                                }
                                default: {
                                    if (token != 28 && !CodeFormatter.isLiteralToken(token) && token != 42 && token != 43) break;
                                    if (previousToken == 7 || previousToken == 8 || previousToken == 1 && unarySignModifier > 0 || previousToken == 2 && unarySignModifier > 0) {
                                        pendingSpace = false;
                                    }
                                    unarySignModifier = 0;
                                }
                            }
                            if (token == 1000) break block102;
                            boolean bl3 = openAndCloseBrace = previousCompilableToken == 59 && token == 40;
                            if (!pendingSpace || !this.insertSpaceAfter(previousToken) || inAssignment && (previousToken == 59 || token == 40) || previousToken == 1001 || this.options.compactAssignmentMode && token == 90 || openAndCloseBrace) break block103;
                            if (previousCompilableToken != 29) break block104;
                            switch (token) {
                                case 28: 
                                case 31: 
                                case 32: 
                                case 33: 
                                case 34: 
                                case 35: 
                                case 36: 
                                case 37: 
                                case 38: 
                                case 41: 
                                case 42: 
                                case 43: 
                                case 47: 
                                case 48: 
                                case 49: 
                                case 50: 
                                case 51: 
                                case 52: {
                                    if (this.options.isAddindSpaceInCastExpression()) {
                                        this.space();
                                        break;
                                    }
                                    break block103;
                                }
                                default: {
                                    this.space();
                                    break;
                                }
                            }
                            break block103;
                        }
                        this.space();
                    }
                    this.outputCurrentToken(token);
                    if (token == 1001 && openParenthesisCount > 1) {
                        pendingNewLines = 0;
                        this.currentLineBuffer.append(this.options.lineSeparatorSequence);
                        this.increaseLineDelta(this.options.lineSeparatorSequence.length);
                    }
                    pendingSpace = true;
                }
                if (token == 1000) continue;
                previousToken = token;
                if (token == 1002 || token == 1001 || token == 1003) continue;
                previousCompilableToken = token;
            }
            this.output(this.copyRemainingSource());
            this.flushBuffer();
        }
        catch (InvalidInputException invalidInputException) {
            this.output(this.copyRemainingSource());
            this.flushBuffer();
        }
    }

    public String formatSourceString(String sourceString) {
        char[] sourceChars = sourceString.toCharArray();
        this.formattedSource = new StringBuffer(sourceChars.length);
        this.scanner.setSource(sourceChars);
        this.format();
        return this.formattedSource.toString();
    }

    public String format(String string, int indentLevel) {
        return this.format(string, indentLevel, null);
    }

    public String format(String string, int indentLevel, int[] positions) {
        return this.format(string, indentLevel, positions, null);
    }

    public String format(String string, int indentLevel, int[] positions, String lineSeparator) {
        if (lineSeparator != null) {
            this.options.setLineSeparator(lineSeparator);
        }
        if (positions != null) {
            this.setPositionsToMap(positions);
            this.setInitialIndentationLevel(indentLevel);
            String formattedString = this.formatSourceString(string);
            System.arraycopy(this.mappedPositions, 0, positions, 0, positions.length);
            return formattedString;
        }
        this.setInitialIndentationLevel(indentLevel);
        return this.formatSourceString(string);
    }

    public String format(String string) {
        return this.format(string, 0, null);
    }

    public static String format(String sourceString, int initialIndentationLevel, ConfigurableOption[] options) {
        CodeFormatter formatter = new CodeFormatter(options);
        formatter.setInitialIndentationLevel(initialIndentationLevel);
        return formatter.formatSourceString(sourceString);
    }

    private int getCurrentCommentOffset() {
        int linePtr = this.scanner.linePtr;
        if (linePtr < 0) {
            return 0;
        }
        int offset = 0;
        int beginningOfLine = this.scanner.lineEnds[linePtr];
        int currentStartPosition = this.scanner.startPosition;
        char[] source = this.scanner.source;
        while (beginningOfLine > currentStartPosition) {
            if (linePtr > 0) {
                beginningOfLine = this.scanner.lineEnds[--linePtr];
                continue;
            }
            beginningOfLine = 0;
            break;
        }
        int i = currentStartPosition - 1;
        while (i >= beginningOfLine) {
            char currentCharacter = source[i];
            switch (currentCharacter) {
                case '\t': {
                    offset += this.options.tabSize;
                    break;
                }
                case ' ': {
                    ++offset;
                    break;
                }
                case '\n': 
                case '\r': {
                    break;
                }
                default: {
                    return offset;
                }
            }
            --i;
        }
        return offset;
    }

    public static ConfigurableOption[] getDefaultOptions(Locale locale) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[Lorg.eclipse.jdt.internal.formatter.CodeFormatter;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        String componentName = clazz.getName();
        FormatterOptions options = new FormatterOptions();
        return new ConfigurableOption[]{new ConfigurableOption(componentName, "newline.openingBrace", locale, options.newLineBeforeOpeningBraceMode ? 0 : 1), new ConfigurableOption(componentName, "newline.controlStatement", locale, options.newlineInControlStatementMode ? 0 : 1), new ConfigurableOption(componentName, "newline.clearAll", locale, options.clearAllBlankLinesMode ? 0 : 1), new ConfigurableOption(componentName, "newline.elseIf", locale, options.compactElseIfMode ? 0 : 1), new ConfigurableOption(componentName, "newline.emptyBlock", locale, options.newLineInEmptyBlockMode ? 0 : 1), new ConfigurableOption(componentName, "line.split", locale, options.maxLineLength), new ConfigurableOption(componentName, "style.compactAssignment", locale, options.compactAssignmentMode ? 0 : 1), new ConfigurableOption(componentName, "tabulation.char", locale, options.indentWithTab ? 0 : 1), new ConfigurableOption(componentName, "tabulation.size", locale, options.tabSize), new ConfigurableOption(componentName, "space.castexpression", locale, options.spaceInCastExpression ? 0 : 1)};
    }

    public int[] getMappedPositions() {
        return this.mappedPositions;
    }

    private static int getTokenPriority(int token) {
        switch (token) {
            case 91: 
            case 103: 
            case 104: {
                return 10;
            }
            case 23: {
                return 20;
            }
            case 30: {
                return 25;
            }
            case 90: {
                return 30;
            }
            case 24: 
            case 25: {
                return 40;
            }
            case 26: 
            case 53: {
                return 50;
            }
            case 18: 
            case 19: {
                return 60;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                return 70;
            }
            case 1: 
            case 2: {
                return 80;
            }
            case 4: 
            case 5: 
            case 6: {
                return 90;
            }
            case 9: 
            case 10: 
            case 11: {
                return 100;
            }
            case 20: 
            case 21: 
            case 22: {
                return 110;
            }
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: {
                return 120;
            }
            case 3: {
                return 130;
            }
        }
        return Integer.MAX_VALUE;
    }

    private boolean handleInvalidToken(Exception e) {
        return e.getMessage().equals("Invalid_Character_Constant") || e.getMessage().equals("Invalid_Char_In_String") || e.getMessage().equals("Invalid_Escape");
    }

    private final void increaseGlobalDelta(int offset) {
        this.globalDelta += offset;
    }

    private final void increaseLineDelta(int offset) {
        this.lineDelta += offset;
    }

    private final void increaseSplitDelta(int offset) {
        this.splitDelta += offset;
    }

    private boolean insertSpaceAfter(int token) {
        switch (token) {
            case 0: 
            case 3: 
            case 12: 
            case 27: 
            case 56: 
            case 58: 
            case 1001: {
                return false;
            }
        }
        return true;
    }

    private boolean insertSpaceBefore(int token) {
        switch (token) {
            case 90: {
                return !this.options.compactAssignmentMode;
            }
        }
        return false;
    }

    private static boolean isComment(int token) {
        boolean result = token == 1002 || token == 1001 || token == 1003;
        return result;
    }

    private static boolean isLiteralToken(int token) {
        boolean result = token == 47 || token == 48 || token == 49 || token == 50 || token == 51 || token == 52;
        return result;
    }

    private void newLine(int newLineCount) {
        this.splitDelta = 0;
        this.beginningOfLineIndex = this.formattedSource.length();
        String currentLine = this.currentLineBuffer.toString();
        if (this.containsOpenCloseBraces) {
            this.containsOpenCloseBraces = false;
            this.outputLine(currentLine, false, this.indentationLevelForOpenCloseBraces, 0, -1, null, 0);
            this.indentationLevelForOpenCloseBraces = this.currentLineIndentationLevel;
        } else {
            this.outputLine(currentLine, false, this.currentLineIndentationLevel, 0, -1, null, 0);
        }
        int i = 0;
        while (i < newLineCount) {
            this.formattedSource.append(this.options.lineSeparatorSequence);
            this.increaseSplitDelta(this.options.lineSeparatorSequence.length);
            ++i;
        }
        int currentLength = currentLine.length();
        this.currentLineBuffer = new StringBuffer(currentLength > this.maxLineSize ? (this.maxLineSize = currentLength) : this.maxLineSize);
        this.increaseGlobalDelta(this.splitDelta);
        this.increaseGlobalDelta(this.lineDelta);
        this.lineDelta = 0;
        this.currentLineIndentationLevel = this.initialIndentationLevel;
    }

    private String operatorString(int operator) {
        switch (operator) {
            case 91: {
                return "extends";
            }
            case 103: {
                return "implements";
            }
            case 104: {
                return "throws";
            }
            case 23: {
                return ";";
            }
            case 30: {
                return ",";
            }
            case 90: {
                return "=";
            }
            case 25: {
                return "&&";
            }
            case 24: {
                return "||";
            }
            case 26: {
                return "?";
            }
            case 53: {
                return ":";
            }
            case 18: {
                return "==";
            }
            case 19: {
                return "!=";
            }
            case 17: {
                return "<";
            }
            case 14: {
                return "<=";
            }
            case 16: {
                return ">";
            }
            case 15: {
                return ">=";
            }
            case 13: {
                return "instanceof";
            }
            case 1: {
                return "+";
            }
            case 2: {
                return "-";
            }
            case 4: {
                return "*";
            }
            case 6: {
                return "/";
            }
            case 5: {
                return "%";
            }
            case 11: {
                return "<<";
            }
            case 9: {
                return ">>";
            }
            case 10: {
                return ">>>";
            }
            case 20: {
                return "&";
            }
            case 22: {
                return "|";
            }
            case 21: {
                return "^";
            }
            case 94: {
                return "*=";
            }
            case 95: {
                return "/=";
            }
            case 99: {
                return "%=";
            }
            case 92: {
                return "+=";
            }
            case 93: {
                return "-=";
            }
            case 100: {
                return "<<=";
            }
            case 101: {
                return ">>=";
            }
            case 102: {
                return ">>>=";
            }
            case 96: {
                return "&=";
            }
            case 98: {
                return "^=";
            }
            case 97: {
                return "|=";
            }
            case 3: {
                return ".";
            }
        }
        return "";
    }

    private void output(String stringToOutput) {
        int i = 0;
        int max = stringToOutput.length();
        while (i < max) {
            char currentCharacter = stringToOutput.charAt(i);
            if (currentCharacter != '\t') {
                this.currentLineBuffer.append(currentCharacter);
            }
            ++i;
        }
    }

    private void outputCurrentToken(int token) {
        char[] source = this.scanner.source;
        int startPosition = this.scanner.startPosition;
        switch (token) {
            case 1001: 
            case 1002: 
            case 1003: {
                boolean endOfLine = false;
                int commentOffset = this.getCurrentCommentOffset();
                int beginningOfLineSpaces = 0;
                endOfLine = false;
                commentOffset = this.getCurrentCommentOffset();
                beginningOfLineSpaces = 0;
                boolean pendingCarriageReturn = false;
                int i = startPosition;
                int max = this.scanner.currentPosition;
                while (i < max) {
                    char currentCharacter = source[i];
                    this.updateMappedPositions(i);
                    switch (currentCharacter) {
                        case '\r': {
                            pendingCarriageReturn = true;
                            endOfLine = true;
                            break;
                        }
                        case '\n': {
                            if (pendingCarriageReturn) {
                                this.increaseGlobalDelta(this.options.lineSeparatorSequence.length - 2);
                            } else {
                                this.increaseGlobalDelta(this.options.lineSeparatorSequence.length - 1);
                            }
                            pendingCarriageReturn = false;
                            this.currentLineBuffer.append(this.options.lineSeparatorSequence);
                            beginningOfLineSpaces = 0;
                            endOfLine = true;
                            break;
                        }
                        case '\t': {
                            if (pendingCarriageReturn) {
                                pendingCarriageReturn = false;
                                this.increaseGlobalDelta(this.options.lineSeparatorSequence.length - 1);
                                this.currentLineBuffer.append(this.options.lineSeparatorSequence);
                                beginningOfLineSpaces = 0;
                                endOfLine = true;
                            }
                            if (endOfLine) {
                                if ((beginningOfLineSpaces += this.options.tabSize) > commentOffset) {
                                    this.currentLineBuffer.append(currentCharacter);
                                    break;
                                }
                                this.increaseGlobalDelta(-1);
                                break;
                            }
                            this.currentLineBuffer.append(currentCharacter);
                            break;
                        }
                        case ' ': {
                            if (pendingCarriageReturn) {
                                pendingCarriageReturn = false;
                                this.increaseGlobalDelta(this.options.lineSeparatorSequence.length - 1);
                                this.currentLineBuffer.append(this.options.lineSeparatorSequence);
                                beginningOfLineSpaces = 0;
                                endOfLine = true;
                            }
                            if (endOfLine) {
                                if (++beginningOfLineSpaces > commentOffset) {
                                    this.currentLineBuffer.append(currentCharacter);
                                    break;
                                }
                                this.increaseGlobalDelta(-1);
                                break;
                            }
                            this.currentLineBuffer.append(currentCharacter);
                            break;
                        }
                        default: {
                            if (pendingCarriageReturn) {
                                pendingCarriageReturn = false;
                                this.increaseGlobalDelta(this.options.lineSeparatorSequence.length - 1);
                                this.currentLineBuffer.append(this.options.lineSeparatorSequence);
                                beginningOfLineSpaces = 0;
                                endOfLine = true;
                                break;
                            }
                            beginningOfLineSpaces = 0;
                            this.currentLineBuffer.append(currentCharacter);
                            endOfLine = false;
                        }
                    }
                    ++i;
                }
                this.updateMappedPositions(this.scanner.currentPosition - 1);
                ++this.multipleLineCommentCounter;
                break;
            }
            default: {
                int i = startPosition;
                int max = this.scanner.currentPosition;
                while (i < max) {
                    char currentCharacter = source[i];
                    this.updateMappedPositions(i);
                    this.currentLineBuffer.append(currentCharacter);
                    ++i;
                }
                break block0;
            }
        }
    }

    private void outputLine(String currentString, boolean preIndented, int depth, int operator, int substringIndex, int[] startSubstringIndexes, int offsetInGlobalLine) {
        boolean placeOperatorAhead;
        boolean emptyFirstSubString = false;
        String operatorString = this.operatorString(operator);
        boolean placeOperatorBehind = !CodeFormatter.breakLineBeforeOperator(operator);
        boolean bl = placeOperatorAhead = !placeOperatorBehind;
        if (placeOperatorAhead) {
            if (!preIndented) {
                this.dumpTab(depth);
                preIndented = true;
            }
            if (operator != 0) {
                if (this.insertSpaceBefore(operator)) {
                    this.formattedSource.append(' ');
                    this.increaseSplitDelta(1);
                }
                this.formattedSource.append(operatorString);
                this.increaseSplitDelta(operatorString.length());
                if (this.insertSpaceAfter(operator) && operator != 103 && operator != 91 && operator != 104) {
                    this.formattedSource.append(' ');
                    this.increaseSplitDelta(1);
                }
            }
        }
        SplitLine splitLine = null;
        if (this.options.maxLineLength == 0 || this.getLength(currentString, depth) < this.options.maxLineLength || (splitLine = this.split(currentString, offsetInGlobalLine)) == null) {
            if (operator == 91 || operator == 103 || operator == 104) {
                this.formattedSource.append(' ');
                this.increaseSplitDelta(1);
            }
            if (placeOperatorBehind && !preIndented) {
                this.dumpTab(depth);
            }
            int max = currentString.length();
            if (this.multipleLineCommentCounter != 0) {
                try {
                    BufferedReader reader = new BufferedReader(new StringReader(currentString));
                    String line = reader.readLine();
                    while (line != null) {
                        this.updateMappedPositionsWhileSplitting(this.beginningOfLineIndex, this.beginningOfLineIndex + line.length() + this.options.lineSeparatorSequence.length);
                        this.formattedSource.append(line);
                        this.beginningOfLineIndex += line.length();
                        line = reader.readLine();
                        if (line == null) continue;
                        this.formattedSource.append(this.options.lineSeparatorSequence);
                        this.beginningOfLineIndex += this.options.lineSeparatorSequence.length;
                        this.dumpTab(this.currentLineIndentationLevel);
                    }
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                this.updateMappedPositionsWhileSplitting(this.beginningOfLineIndex, this.beginningOfLineIndex + max);
                int i = 0;
                while (i < max) {
                    char currentChar = currentString.charAt(i);
                    switch (currentChar) {
                        case '\r': {
                            break;
                        }
                        case '\n': {
                            if (i == max - 1) break;
                            this.formattedSource.append(this.options.lineSeparatorSequence);
                            this.dumpTab(depth - 1);
                            break;
                        }
                        default: {
                            this.formattedSource.append(currentChar);
                        }
                    }
                    ++i;
                }
            }
            if (substringIndex != -1) {
                if (this.multipleLineCommentCounter == 0) {
                    int startPosition = this.beginningOfLineIndex + startSubstringIndexes[substringIndex];
                    this.updateMappedPositionsWhileSplitting(startPosition, startPosition + max);
                }
                if (substringIndex + 1 != startSubstringIndexes.length) {
                    this.increaseSplitDelta(startSubstringIndexes[substringIndex] + max - startSubstringIndexes[substringIndex + 1]);
                }
            }
            if (placeOperatorBehind) {
                if (this.insertSpaceBefore(operator)) {
                    this.formattedSource.append(' ');
                    if (operator != 0) {
                        this.increaseSplitDelta(1);
                    }
                }
                this.formattedSource.append(operatorString);
                if (operator != 0) {
                    this.increaseSplitDelta(operatorString.length());
                }
            }
            return;
        }
        if (this.options.maxLineLength != 0 && splitLine != null && (operator == 91 || operator == 103 || operator == 104)) {
            this.formattedSource.append(this.options.lineSeparatorSequence);
            this.increaseSplitDelta(this.options.lineSeparatorSequence.length);
            this.dumpTab(depth + 1);
        } else if (operator == 91 || operator == 103 || operator == 104) {
            this.formattedSource.append(' ');
            this.increaseSplitDelta(1);
        }
        String[] result = splitLine.substrings;
        int[] splitOperators = splitLine.operators;
        if (result[0].length() == 0) {
            --depth;
            emptyFirstSubString = true;
        }
        int i = 0;
        int max = result.length;
        while (i < max) {
            String currentResult = result[i];
            if (currentResult.length() != 0 || splitOperators[i] != 0) {
                int newDepth = currentResult.startsWith("/*") || currentResult.startsWith("//") ? this.indentationLevel - 1 : depth;
                this.outputLine(currentResult, i == 0 || i == 1 && emptyFirstSubString ? preIndented : false, i == 0 ? newDepth : newDepth + 1, splitOperators[i], i, splitLine.startSubstringsIndexes, currentString.indexOf(currentResult));
                if (i != max - 1) {
                    this.formattedSource.append(this.options.lineSeparatorSequence);
                    this.increaseSplitDelta(this.options.lineSeparatorSequence.length);
                }
            }
            ++i;
        }
        if (result.length == splitOperators.length - 1) {
            int lastOperator = splitOperators[result.length];
            String lastOperatorString = this.operatorString(lastOperator);
            this.formattedSource.append(this.options.lineSeparatorSequence);
            this.increaseSplitDelta(this.options.lineSeparatorSequence.length);
            if (CodeFormatter.breakLineBeforeOperator(lastOperator)) {
                this.dumpTab(depth + 1);
                if (lastOperator != 0) {
                    if (this.insertSpaceBefore(lastOperator)) {
                        this.formattedSource.append(' ');
                        this.increaseSplitDelta(1);
                    }
                    this.formattedSource.append(lastOperatorString);
                    this.increaseSplitDelta(lastOperatorString.length());
                    if (this.insertSpaceAfter(lastOperator) && lastOperator != 103 && lastOperator != 91 && lastOperator != 104) {
                        this.formattedSource.append(' ');
                        this.increaseSplitDelta(1);
                    }
                }
            }
        }
        if (placeOperatorBehind) {
            if (this.insertSpaceBefore(operator)) {
                this.formattedSource.append(' ');
                this.increaseSplitDelta(1);
            }
            this.formattedSource.append(operatorString);
        }
    }

    private int pop(int token) {
        int delta = 0;
        if (this.constructionsCount > 0 && this.constructions[this.constructionsCount - 1] == token) {
            --delta;
            --this.constructionsCount;
        }
        return delta;
    }

    private int popExclusiveUntilBlock() {
        int startCount = this.constructionsCount;
        int delta = 0;
        int i = startCount - 1;
        while (i >= 0 && this.constructions[i] != 59 && this.constructions[i] != -100) {
            --this.constructionsCount;
            --delta;
            --i;
        }
        return delta;
    }

    private int popExclusiveUntilBlockOrCase() {
        int startCount = this.constructionsCount;
        int delta = 0;
        int i = startCount - 1;
        while (i >= 0 && this.constructions[i] != 59 && this.constructions[i] != -100 && this.constructions[i] != 83) {
            --this.constructionsCount;
            --delta;
            --i;
        }
        return delta;
    }

    private int popInclusiveUntil(int token) {
        int startCount = this.constructionsCount;
        int delta = 0;
        int i = startCount - 1;
        while (i >= 0 && this.constructions[i] != token) {
            if (this.constructions[i] != -100) {
                --delta;
            }
            --this.constructionsCount;
            --i;
        }
        if (this.constructionsCount > 0) {
            if (this.constructions[this.constructionsCount - 1] != -100) {
                --delta;
            }
            --this.constructionsCount;
        }
        return delta;
    }

    private int popInclusiveUntilBlock() {
        int startCount = this.constructionsCount;
        int delta = 0;
        int i = startCount - 1;
        while (i >= 0 && this.constructions[i] != 59 && this.constructions[i] != -100) {
            --delta;
            --this.constructionsCount;
            --i;
        }
        if (this.constructionsCount > 0) {
            if (this.constructions[this.constructionsCount - 1] == 59) {
                --delta;
            }
            --this.constructionsCount;
        }
        return delta;
    }

    private int pushBlock() {
        int delta = 0;
        if (this.constructionsCount == this.constructions.length) {
            this.constructions = new int[this.constructionsCount * 2];
            System.arraycopy(this.constructions, 0, this.constructions, 0, this.constructionsCount);
        }
        if (this.constructionsCount == 0 || this.constructions[this.constructionsCount - 1] == 59 || this.constructions[this.constructionsCount - 1] == -100 || this.constructions[this.constructionsCount - 1] == 83) {
            ++delta;
            this.constructions[this.constructionsCount++] = 59;
        } else {
            this.constructions[this.constructionsCount++] = -100;
        }
        return delta;
    }

    private int pushControlStatement(int token) {
        if (this.constructionsCount == this.constructions.length) {
            this.constructions = new int[this.constructionsCount * 2];
            System.arraycopy(this.constructions, 0, this.constructions, 0, this.constructionsCount);
        }
        this.constructions[this.constructionsCount++] = token;
        return 1;
    }

    private void reset() {
        this.constructionsCount = 0;
        if (this.constructions == null) {
            this.constructions = new int[10];
        }
        this.currentLineIndentationLevel = this.indentationLevel = this.initialIndentationLevel;
        this.currentCommentOffset = -1;
        this.currentLineBuffer = new StringBuffer();
    }

    private static boolean separateFirstArgumentOn(int currentToken) {
        return currentToken != 76 && currentToken != 27 && currentToken != 58 && currentToken != 70 && currentToken != 75 && currentToken != 78;
    }

    public void setPositionsToMap(int[] positions) {
        this.positionsToMap = positions;
        this.lineDelta = 0;
        this.globalDelta = 0;
        this.mappedPositions = new int[positions.length];
    }

    private void space() {
        this.currentLineBuffer.append(' ');
        this.increaseLineDelta(1);
    }

    public SplitLine split(String stringToSplit) {
        return this.split(stringToSplit, 0);
    }

    public SplitLine split(String stringToSplit, int offsetInGlobalLine) {
        if (stringToSplit.indexOf("//$NON-NLS") != -1) {
            return null;
        }
        int currentToken = 0;
        int splitTokenType = 0;
        int splitTokenDepth = Integer.MAX_VALUE;
        int splitTokenPriority = Integer.MAX_VALUE;
        int[] substringsStartPositions = new int[10];
        int[] substringsEndPositions = new int[10];
        int substringsCount = 1;
        int[] splitOperators = new int[10];
        int splitOperatorsCount = 0;
        int[] openParenthesisPosition = new int[10];
        int openParenthesisPositionCount = 0;
        int position = 0;
        int lastOpenParenthesisPosition = -1;
        int lastCommentStartPosition = -1;
        int firstTokenOnLine = -1;
        int previousToken = -1;
        this.splitScanner.setSource(stringToSplit.toCharArray());
        try {
            while (true) {
                try {
                    if (currentToken != 1000) {
                        previousToken = currentToken;
                    }
                    currentToken = this.splitScanner.getNextToken();
                }
                catch (InvalidInputException e) {
                    if (!this.handleInvalidToken(e)) {
                        throw e;
                    }
                    currentToken = 0;
                }
                if (currentToken != 54) {
                    if (firstTokenOnLine == -1) {
                        firstTokenOnLine = currentToken;
                    }
                    switch (currentToken) {
                        case 29: 
                        case 40: {
                            if (openParenthesisPositionCount <= 0) break;
                            if (openParenthesisPositionCount == 1 && lastOpenParenthesisPosition < openParenthesisPosition[0]) {
                                lastOpenParenthesisPosition = openParenthesisPosition[0];
                            } else if (splitTokenDepth == Integer.MAX_VALUE || splitTokenDepth > openParenthesisPositionCount && openParenthesisPositionCount == 1) {
                                splitTokenType = 0;
                                splitTokenDepth = openParenthesisPositionCount;
                                splitTokenPriority = Integer.MAX_VALUE;
                                substringsStartPositions[0] = 0;
                                substringsCount = 1;
                                substringsEndPositions[0] = openParenthesisPosition[0];
                                position = openParenthesisPosition[0];
                                splitOperatorsCount = 1;
                                splitOperators[0] = 0;
                            }
                            --openParenthesisPositionCount;
                            break;
                        }
                        case 27: 
                        case 59: {
                            if (openParenthesisPositionCount == openParenthesisPosition.length) {
                                int[] nArray = openParenthesisPosition;
                                openParenthesisPosition = new int[openParenthesisPositionCount * 2];
                                System.arraycopy(nArray, 0, openParenthesisPosition, 0, openParenthesisPositionCount);
                            }
                            openParenthesisPosition[openParenthesisPositionCount++] = this.splitScanner.currentPosition;
                            if (currentToken != 27 || previousToken != 29) break;
                            openParenthesisPosition[openParenthesisPositionCount - 1] = this.splitScanner.startPosition;
                            break;
                        }
                        case 23: 
                        case 30: 
                        case 90: {
                            if (openParenthesisPositionCount < splitTokenDepth || openParenthesisPositionCount == splitTokenDepth && splitTokenPriority > CodeFormatter.getTokenPriority(currentToken)) {
                                splitTokenDepth = openParenthesisPositionCount;
                                splitTokenType = currentToken;
                                splitTokenPriority = CodeFormatter.getTokenPriority(currentToken);
                                substringsStartPositions[0] = 0;
                                if (CodeFormatter.separateFirstArgumentOn(firstTokenOnLine) && openParenthesisPositionCount > 0) {
                                    substringsCount = 2;
                                    substringsEndPositions[0] = openParenthesisPosition[splitTokenDepth - 1];
                                    substringsStartPositions[1] = openParenthesisPosition[splitTokenDepth - 1];
                                    substringsEndPositions[1] = this.splitScanner.startPosition;
                                    splitOperatorsCount = 2;
                                    splitOperators[0] = 0;
                                    splitOperators[1] = currentToken;
                                    position = this.splitScanner.currentPosition;
                                    break;
                                }
                                substringsCount = 1;
                                substringsEndPositions[0] = this.splitScanner.startPosition;
                                position = this.splitScanner.currentPosition;
                                splitOperatorsCount = 1;
                                splitOperators[0] = currentToken;
                                break;
                            }
                            if (openParenthesisPositionCount != splitTokenDepth || splitTokenPriority != CodeFormatter.getTokenPriority(currentToken) || splitTokenType == 90 || currentToken == 90) break;
                            if (substringsCount == substringsStartPositions.length) {
                                int[] nArray = substringsStartPositions;
                                substringsStartPositions = new int[substringsCount * 2];
                                System.arraycopy(nArray, 0, substringsStartPositions, 0, substringsCount);
                                int[] nArray2 = substringsEndPositions;
                                substringsEndPositions = new int[substringsCount * 2];
                                System.arraycopy(nArray2, 0, substringsEndPositions, 0, substringsCount);
                            }
                            if (splitOperatorsCount == splitOperators.length) {
                                int[] nArray = splitOperators;
                                splitOperators = new int[splitOperatorsCount * 2];
                                System.arraycopy(nArray, 0, splitOperators, 0, splitOperatorsCount);
                            }
                            substringsStartPositions[substringsCount] = position;
                            substringsEndPositions[substringsCount++] = this.splitScanner.startPosition;
                            position = this.splitScanner.currentPosition;
                            splitOperators[splitOperatorsCount++] = currentToken;
                            break;
                        }
                        case 53: {
                            if (splitOperatorsCount == 0 || splitOperators[splitOperatorsCount - 1] != 26) break;
                        }
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 9: 
                        case 10: 
                        case 11: 
                        case 13: 
                        case 14: 
                        case 15: 
                        case 16: 
                        case 17: 
                        case 18: 
                        case 19: 
                        case 20: 
                        case 21: 
                        case 22: 
                        case 24: 
                        case 25: 
                        case 26: 
                        case 91: 
                        case 92: 
                        case 93: 
                        case 94: 
                        case 95: 
                        case 96: 
                        case 97: 
                        case 98: 
                        case 99: 
                        case 100: 
                        case 101: 
                        case 102: 
                        case 103: 
                        case 104: {
                            if ((openParenthesisPositionCount < splitTokenDepth || openParenthesisPositionCount == splitTokenDepth && splitTokenPriority > CodeFormatter.getTokenPriority(currentToken)) && (currentToken != 1 && currentToken != 2 || previousToken != 59 && previousToken != 12 && this.splitScanner.startPosition != 0)) {
                                splitTokenDepth = openParenthesisPositionCount;
                                splitTokenType = currentToken;
                                splitTokenPriority = CodeFormatter.getTokenPriority(currentToken);
                                substringsStartPositions[0] = 0;
                                if (CodeFormatter.separateFirstArgumentOn(firstTokenOnLine) && openParenthesisPositionCount > 0) {
                                    substringsCount = 2;
                                    substringsEndPositions[0] = openParenthesisPosition[splitTokenDepth - 1];
                                    substringsStartPositions[1] = openParenthesisPosition[splitTokenDepth - 1];
                                    substringsEndPositions[1] = this.splitScanner.startPosition;
                                    splitOperatorsCount = 3;
                                    splitOperators[0] = 0;
                                    splitOperators[1] = 0;
                                    splitOperators[2] = currentToken;
                                    position = this.splitScanner.currentPosition;
                                    break;
                                }
                                substringsCount = 1;
                                substringsEndPositions[0] = this.splitScanner.startPosition;
                                position = this.splitScanner.currentPosition;
                                splitOperatorsCount = 2;
                                splitOperators[0] = 0;
                                splitOperators[1] = currentToken;
                                break;
                            }
                            if (openParenthesisPositionCount != splitTokenDepth || splitTokenPriority != CodeFormatter.getTokenPriority(currentToken)) break;
                            if (substringsCount == substringsStartPositions.length) {
                                int[] nArray = substringsStartPositions;
                                substringsStartPositions = new int[substringsCount * 2];
                                System.arraycopy(nArray, 0, substringsStartPositions, 0, substringsCount);
                                int[] nArray3 = substringsEndPositions;
                                substringsEndPositions = new int[substringsCount * 2];
                                System.arraycopy(nArray3, 0, substringsEndPositions, 0, substringsCount);
                            }
                            if (splitOperatorsCount == splitOperators.length) {
                                int[] nArray = splitOperators;
                                splitOperators = new int[splitOperatorsCount * 2];
                                System.arraycopy(nArray, 0, splitOperators, 0, splitOperatorsCount);
                            }
                            substringsStartPositions[substringsCount] = position;
                            substringsEndPositions[substringsCount++] = this.splitScanner.startPosition;
                            position = this.splitScanner.currentPosition;
                            splitOperators[splitOperatorsCount++] = currentToken;
                        }
                    }
                    if (CodeFormatter.isComment(currentToken)) {
                        lastCommentStartPosition = this.splitScanner.startPosition;
                        continue;
                    }
                    lastCommentStartPosition = -1;
                    continue;
                }
                break;
            }
        }
        catch (InvalidInputException invalidInputException) {
            return null;
        }
        if (splitOperatorsCount == 0) {
            return null;
        }
        if ((splitOperatorsCount == 2 && splitOperators[1] == 3 && splitTokenDepth == 0 && lastOpenParenthesisPosition > -1 || splitOperatorsCount > 2 && splitOperators[1] == 3 && splitTokenDepth == 0 && lastOpenParenthesisPosition > -1 && lastOpenParenthesisPosition <= this.options.maxLineLength || CodeFormatter.separateFirstArgumentOn(firstTokenOnLine) && splitTokenDepth > 0 && lastOpenParenthesisPosition > -1) && lastOpenParenthesisPosition < this.splitScanner.source.length && this.splitScanner.source[lastOpenParenthesisPosition] != ')') {
            SplitLine sl = this.split(stringToSplit.substring(lastOpenParenthesisPosition), lastOpenParenthesisPosition);
            if (sl == null || sl.operators[0] != 30) {
                return new SplitLine(new int[2], new String[]{stringToSplit.substring(0, lastOpenParenthesisPosition).trim(), stringToSplit.substring(lastOpenParenthesisPosition)}, new int[]{offsetInGlobalLine, lastOpenParenthesisPosition + offsetInGlobalLine});
            }
            int startIndex = sl.substrings[0].length() == 0 ? 1 : 0;
            int subStringsLength = sl.substrings.length + 1 - startIndex;
            String[] result = new String[subStringsLength];
            int[] startIndexes = new int[subStringsLength];
            int operatorsLength = sl.operators.length + 1 - startIndex;
            int[] operators = new int[operatorsLength];
            result[0] = stringToSplit.substring(0, lastOpenParenthesisPosition);
            operators[0] = 0;
            System.arraycopy(sl.startSubstringsIndexes, startIndex, startIndexes, 1, subStringsLength - 1);
            int i = subStringsLength - 1;
            while (i >= 0) {
                int n = i--;
                startIndexes[n] = startIndexes[n] + offsetInGlobalLine;
            }
            System.arraycopy(sl.substrings, startIndex, result, 1, subStringsLength - 1);
            System.arraycopy(sl.operators, startIndex, operators, 1, operatorsLength - 1);
            return new SplitLine(operators, result, startIndexes);
        }
        if (lastCommentStartPosition > -1 && lastCommentStartPosition < this.options.maxLineLength && splitTokenPriority > 50) {
            int end = lastCommentStartPosition;
            int start = lastCommentStartPosition;
            if (stringToSplit.charAt(end - 1) == ' ') {
                --end;
            }
            if (start != end && stringToSplit.charAt(start) == ' ') {
                ++start;
            }
            int[] nArray = new int[2];
            nArray[1] = start;
            return new SplitLine(new int[2], new String[]{stringToSplit.substring(0, end), stringToSplit.substring(start)}, nArray);
        }
        if (position != stringToSplit.length()) {
            if (substringsCount == substringsStartPositions.length) {
                int[] nArray = substringsStartPositions;
                substringsStartPositions = new int[substringsCount * 2];
                System.arraycopy(nArray, 0, substringsStartPositions, 0, substringsCount);
                int[] nArray4 = substringsEndPositions;
                substringsEndPositions = new int[substringsCount * 2];
                System.arraycopy(nArray4, 0, substringsEndPositions, 0, substringsCount);
            }
            substringsStartPositions[substringsCount] = position;
            substringsEndPositions[substringsCount++] = stringToSplit.length();
        }
        if (splitOperatorsCount == splitOperators.length) {
            int[] nArray = splitOperators;
            splitOperators = new int[splitOperatorsCount * 2];
            System.arraycopy(nArray, 0, splitOperators, 0, splitOperatorsCount);
        }
        splitOperators[splitOperatorsCount] = 0;
        String[] result = new String[substringsCount];
        int i = 0;
        while (i < substringsCount) {
            int start = substringsStartPositions[i];
            int end = substringsEndPositions[i];
            if (stringToSplit.charAt(start) == ' ') {
                ++start;
                int n = i;
                substringsStartPositions[n] = substringsStartPositions[n] + 1;
            }
            if (end != start && stringToSplit.charAt(end - 1) == ' ') {
                --end;
            }
            result[i] = stringToSplit.substring(start, end);
            int n = i++;
            substringsStartPositions[n] = substringsStartPositions[n] + offsetInGlobalLine;
        }
        if (splitOperatorsCount > substringsCount) {
            int[] nArray = substringsStartPositions;
            substringsStartPositions = new int[splitOperatorsCount];
            System.arraycopy(nArray, 0, substringsStartPositions, 0, substringsCount);
            int[] nArray5 = substringsEndPositions;
            substringsEndPositions = new int[splitOperatorsCount];
            System.arraycopy(nArray5, 0, substringsEndPositions, 0, substringsCount);
            i = substringsCount;
            while (i < splitOperatorsCount) {
                substringsStartPositions[i] = position;
                substringsEndPositions[i] = position;
                ++i;
            }
            int[] nArray6 = splitOperators;
            splitOperators = new int[splitOperatorsCount];
            System.arraycopy(nArray6, 0, splitOperators, 0, splitOperatorsCount);
        } else {
            int[] nArray = substringsStartPositions;
            substringsStartPositions = new int[substringsCount];
            System.arraycopy(nArray, 0, substringsStartPositions, 0, substringsCount);
            int[] nArray7 = substringsEndPositions;
            substringsEndPositions = new int[substringsCount];
            System.arraycopy(nArray7, 0, substringsEndPositions, 0, substringsCount);
            int[] nArray8 = splitOperators;
            splitOperators = new int[substringsCount];
            System.arraycopy(nArray8, 0, splitOperators, 0, substringsCount);
        }
        SplitLine splitLine = new SplitLine(splitOperators, result, substringsStartPositions);
        return splitLine;
    }

    private void updateMappedPositions(int startPosition) {
        if (this.positionsToMap == null) {
            return;
        }
        char[] source = this.scanner.source;
        int sourceLength = source.length;
        while (this.indexToMap < this.positionsToMap.length && this.positionsToMap[this.indexToMap] <= startPosition) {
            int posToMap = this.positionsToMap[this.indexToMap];
            if (posToMap < 0 || posToMap >= sourceLength) {
                if (posToMap == sourceLength) {
                    this.mappedPositions[this.indexToMap] = this.formattedSource.length();
                }
                this.indexToMap = this.positionsToMap.length;
                return;
            }
            this.mappedPositions[this.indexToMap] = CharOperation.isWhitespace(source[posToMap]) ? startPosition + this.globalDelta + this.lineDelta : (posToMap == sourceLength - 1 ? startPosition + this.globalDelta + this.lineDelta : posToMap + this.globalDelta + this.lineDelta);
            ++this.indexToMap;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void updateMappedPositionsWhileSplitting(int startPosition, int endPosition) {
        if (this.mappedPositions != null && this.mappedPositions.length != this.indexInMap) ** GOTO lbl5
        return;
lbl-1000:
        // 1 sources

        {
            v0 = this.indexInMap++;
            this.mappedPositions[v0] = this.mappedPositions[v0] + this.splitDelta;
lbl5:
            // 2 sources

            ** while (this.indexInMap < this.mappedPositions.length && startPosition <= this.mappedPositions[this.indexInMap] && this.mappedPositions[this.indexInMap] < endPosition && this.indexInMap < this.indexToMap)
        }
lbl6:
        // 1 sources

    }

    private void updateRemainingMappedPositions() {
        if (this.positionsToMap == null) {
            return;
        }
        int sourceLength = this.formattedSource.length();
        while (this.indexToMap < this.positionsToMap.length) {
            this.mappedPositions[this.indexToMap] = sourceLength - 1;
            ++this.indexToMap;
        }
    }

    private int getLength(String s, int tabDepth) {
        int length = 0;
        int i = 0;
        while (i < tabDepth) {
            length += this.options.tabSize;
            ++i;
        }
        i = 0;
        int max = s.length();
        while (i < max) {
            char currentChar = s.charAt(i);
            switch (currentChar) {
                case '\t': {
                    length += this.options.tabSize;
                    break;
                }
                default: {
                    ++length;
                }
            }
            ++i;
        }
        return length;
    }

    public void setInitialIndentationLevel(int newIndentationLevel) {
        this.currentLineIndentationLevel = this.indentationLevel = newIndentationLevel;
        this.initialIndentationLevel = this.indentationLevel;
    }
}

