/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.util;

import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.util.ClassFileBytesDisassembler;
import org.eclipse.jdt.core.util.ClassFormatException;
import org.eclipse.jdt.core.util.IClassFileAttribute;
import org.eclipse.jdt.core.util.IClassFileReader;
import org.eclipse.jdt.core.util.ICodeAttribute;
import org.eclipse.jdt.core.util.IConstantPoolEntry;
import org.eclipse.jdt.core.util.IConstantValueAttribute;
import org.eclipse.jdt.core.util.IExceptionAttribute;
import org.eclipse.jdt.core.util.IExceptionTableEntry;
import org.eclipse.jdt.core.util.IFieldInfo;
import org.eclipse.jdt.core.util.IInnerClassesAttribute;
import org.eclipse.jdt.core.util.IInnerClassesAttributeEntry;
import org.eclipse.jdt.core.util.ILineNumberAttribute;
import org.eclipse.jdt.core.util.ILocalVariableAttribute;
import org.eclipse.jdt.core.util.ILocalVariableTableEntry;
import org.eclipse.jdt.core.util.IMethodInfo;
import org.eclipse.jdt.core.util.ISourceAttribute;
import org.eclipse.jdt.internal.core.util.ClassFileReader;
import org.eclipse.jdt.internal.core.util.DefaultBytecodeVisitor;
import org.eclipse.jdt.internal.core.util.Util;

public class Disassembler
extends ClassFileBytesDisassembler {
    private static final char[] ANY_EXCEPTION = Util.bind("classfileformat.anyexceptionhandler").toCharArray();
    private static final String EMPTY_OUTPUT = "";

    private void checkSuperFlags(StringBuffer buffer, int accessFlags, String lineSeparator, int tabNumber) {
        buffer.append(Util.bind("disassembler.commentstart"));
        if ((accessFlags & 0x20) != 0) {
            buffer.append(Util.bind("classfileformat.superflagisset"));
        } else {
            buffer.append(Util.bind("classfileformat.superflagisnotset"));
        }
        buffer.append(Util.bind("disassembler.commentend"));
        this.writeNewLine(buffer, lineSeparator, tabNumber);
    }

    private void decodeModifiersForField(StringBuffer buffer, int accessFlags) {
        boolean firstModifier = true;
        if ((accessFlags & 0x10) != 0) {
            if (!firstModifier) {
                buffer.append(Util.bind("disassembler.space"));
            }
            if (firstModifier) {
                firstModifier = false;
            }
            buffer.append("final");
        }
        if ((accessFlags & 2) != 0) {
            if (!firstModifier) {
                buffer.append(Util.bind("disassembler.space"));
            }
            if (firstModifier) {
                firstModifier = false;
            }
            buffer.append("private");
        }
        if ((accessFlags & 4) != 0) {
            if (!firstModifier) {
                buffer.append(Util.bind("disassembler.space"));
            }
            if (firstModifier) {
                firstModifier = false;
            }
            buffer.append("protected");
        }
        if ((accessFlags & 1) != 0) {
            if (!firstModifier) {
                buffer.append(Util.bind("disassembler.space"));
            }
            if (firstModifier) {
                firstModifier = false;
            }
            buffer.append("public");
        }
        if ((accessFlags & 8) != 0) {
            if (!firstModifier) {
                buffer.append(Util.bind("disassembler.space"));
            }
            if (firstModifier) {
                firstModifier = false;
            }
            buffer.append("static");
        }
        if ((accessFlags & 0x80) != 0) {
            if (!firstModifier) {
                buffer.append(Util.bind("disassembler.space"));
            }
            if (firstModifier) {
                firstModifier = false;
            }
            buffer.append("transient");
        }
        if ((accessFlags & 0x40) != 0) {
            if (!firstModifier) {
                buffer.append(Util.bind("disassembler.space"));
            }
            if (firstModifier) {
                firstModifier = false;
            }
            buffer.append("volatile");
        }
        if (!firstModifier) {
            buffer.append(Util.bind("disassembler.space"));
        }
    }

    private final void decodeModifiersForInnerClasses(StringBuffer buffer, int accessFlags) {
        boolean firstModifier = true;
        if ((accessFlags & 1) != 0) {
            if (!firstModifier) {
                buffer.append(Util.bind("disassembler.space"));
            }
            if (firstModifier) {
                firstModifier = false;
            }
            buffer.append("public");
        }
        if ((accessFlags & 2) != 0) {
            if (!firstModifier) {
                buffer.append(Util.bind("disassembler.space"));
            }
            if (firstModifier) {
                firstModifier = false;
            }
            buffer.append("private");
        }
        if ((accessFlags & 4) != 0) {
            if (!firstModifier) {
                buffer.append(Util.bind("disassembler.space"));
            }
            if (firstModifier) {
                firstModifier = false;
            }
            buffer.append("protected");
        }
        if ((accessFlags & 8) != 0) {
            if (!firstModifier) {
                buffer.append(Util.bind("disassembler.space"));
            }
            if (firstModifier) {
                firstModifier = false;
            }
            buffer.append("static");
        }
        if ((accessFlags & 0x10) != 0) {
            if (!firstModifier) {
                buffer.append(Util.bind("disassembler.space"));
            }
            if (firstModifier) {
                firstModifier = false;
            }
            buffer.append("final");
        }
        if ((accessFlags & 0x400) != 0) {
            if (!firstModifier) {
                buffer.append(Util.bind("disassembler.space"));
            }
            if (firstModifier) {
                firstModifier = false;
            }
            buffer.append("abstract");
        }
        if (!firstModifier) {
            buffer.append(Util.bind("disassembler.space"));
        }
    }

    private final void decodeModifiersForMethod(StringBuffer buffer, int accessFlags) {
        boolean firstModifier = true;
        if ((accessFlags & 0x400) != 0) {
            if (!firstModifier) {
                buffer.append(Util.bind("disassembler.space"));
            }
            if (firstModifier) {
                firstModifier = false;
            }
            buffer.append("abstract");
        }
        if ((accessFlags & 0x10) != 0) {
            if (!firstModifier) {
                buffer.append(Util.bind("disassembler.space"));
            }
            if (firstModifier) {
                firstModifier = false;
            }
            buffer.append("final");
        }
        if ((accessFlags & 0x100) != 0) {
            if (!firstModifier) {
                buffer.append(Util.bind("disassembler.space"));
            }
            if (firstModifier) {
                firstModifier = false;
            }
            buffer.append("native");
        }
        if ((accessFlags & 2) != 0) {
            if (!firstModifier) {
                buffer.append(Util.bind("disassembler.space"));
            }
            if (firstModifier) {
                firstModifier = false;
            }
            buffer.append("private");
        }
        if ((accessFlags & 4) != 0) {
            if (!firstModifier) {
                buffer.append(Util.bind("disassembler.space"));
            }
            if (firstModifier) {
                firstModifier = false;
            }
            buffer.append("protected");
        }
        if ((accessFlags & 1) != 0) {
            if (!firstModifier) {
                buffer.append(Util.bind("disassembler.space"));
            }
            if (firstModifier) {
                firstModifier = false;
            }
            buffer.append("public");
        }
        if ((accessFlags & 8) != 0) {
            if (!firstModifier) {
                buffer.append(Util.bind("disassembler.space"));
            }
            if (firstModifier) {
                firstModifier = false;
            }
            buffer.append("static");
        }
        if ((accessFlags & 0x800) != 0) {
            if (!firstModifier) {
                buffer.append(Util.bind("disassembler.space"));
            }
            if (firstModifier) {
                firstModifier = false;
            }
            buffer.append("strictfp");
        }
        if ((accessFlags & 0x20) != 0) {
            if (!firstModifier) {
                buffer.append(Util.bind("disassembler.space"));
            }
            if (firstModifier) {
                firstModifier = false;
            }
            buffer.append("synchronized");
        }
        if (!firstModifier) {
            buffer.append(Util.bind("disassembler.space"));
        }
    }

    private final void decodeModifiersForType(StringBuffer buffer, int accessFlags) {
        boolean firstModifier = true;
        if ((accessFlags & 0x400) != 0) {
            if (!firstModifier) {
                buffer.append(Util.bind("disassembler.space"));
            }
            if (firstModifier) {
                firstModifier = false;
            }
            buffer.append("abstract");
        }
        if ((accessFlags & 0x10) != 0) {
            if (!firstModifier) {
                buffer.append(Util.bind("disassembler.space"));
            }
            if (firstModifier) {
                firstModifier = false;
            }
            buffer.append("final");
        }
        if ((accessFlags & 1) != 0) {
            if (!firstModifier) {
                buffer.append(Util.bind("disassembler.space"));
            }
            if (firstModifier) {
                firstModifier = false;
            }
            buffer.append("public");
        }
        if (!firstModifier) {
            buffer.append(Util.bind("disassembler.space"));
        }
    }

    private String decodeStringValue(String s) {
        StringBuffer buffer = new StringBuffer();
        char[] chars = s.toCharArray();
        int i = 0;
        int max = chars.length;
        while (i < max) {
            char c = chars[i];
            switch (c) {
                case '\b': {
                    buffer.append("\\b");
                    break;
                }
                case '\t': {
                    buffer.append("\\t");
                    break;
                }
                case '\n': {
                    buffer.append("\\n");
                    break;
                }
                case '\f': {
                    buffer.append("\\f");
                    break;
                }
                case '\r': {
                    buffer.append("\\r");
                    break;
                }
                case '\"': {
                    buffer.append("\\\"");
                    break;
                }
                case '\'': {
                    buffer.append("\\'");
                    break;
                }
                case '\\': {
                    buffer.append("\\\\");
                    break;
                }
                case '\u0000': {
                    buffer.append("\\0");
                    break;
                }
                case '\u0001': {
                    buffer.append("\\1");
                    break;
                }
                case '\u0002': {
                    buffer.append("\\2");
                    break;
                }
                case '\u0003': {
                    buffer.append("\\3");
                    break;
                }
                case '\u0004': {
                    buffer.append("\\4");
                    break;
                }
                case '\u0005': {
                    buffer.append("\\5");
                    break;
                }
                case '\u0006': {
                    buffer.append("\\6");
                    break;
                }
                case '\u0007': {
                    buffer.append("\\7");
                    break;
                }
                default: {
                    buffer.append(c);
                }
            }
            ++i;
        }
        return buffer.toString();
    }

    public String disassemble(byte[] classFileBytes, String lineSeparator) throws ClassFormatException {
        return this.disassemble(new ClassFileReader(classFileBytes, 65535), lineSeparator, 2);
    }

    public String disassemble(byte[] classFileBytes, String lineSeparator, int mode) throws ClassFormatException {
        return this.disassemble(new ClassFileReader(classFileBytes, 65535), lineSeparator, mode);
    }

    public String disassemble(IClassFileReader classFileReader, String lineSeparator) {
        return this.disassemble(classFileReader, lineSeparator, 2);
    }

    public String disassemble(IClassFileReader classFileReader, String lineSeparator, int mode) {
        char[][] superclassInterfaces;
        int length;
        char[] className;
        ISourceAttribute sourceAttribute;
        if (classFileReader == null) {
            return EMPTY_OUTPUT;
        }
        StringBuffer buffer = new StringBuffer();
        if (mode == 1) {
            int minorVersion = classFileReader.getMinorVersion();
            int majorVersion = classFileReader.getMajorVersion();
            buffer.append(Util.bind("disassembler.commentstart"));
            this.writeNewLine(buffer, lineSeparator, 0);
            buffer.append(Util.bind("disassembler.begincommentline"));
            if (minorVersion == 3 && majorVersion == 45) {
                buffer.append(Util.bind("classfileformat.targetoption", " 1.1"));
            } else if (minorVersion == 0 && majorVersion == 46) {
                buffer.append(Util.bind("classfileformat.targetoption", "1.2"));
            } else if (minorVersion == 0 && majorVersion == 47) {
                buffer.append(Util.bind("classfileformat.targetoption", "1.3"));
            } else if (minorVersion == 0 && majorVersion == 48) {
                buffer.append(Util.bind("classfileformat.targetoption", "1.4"));
            } else if (minorVersion == 0 && majorVersion == 49) {
                buffer.append(Util.bind("classfileformat.targetoption", "1.5"));
            }
            this.writeNewLine(buffer, lineSeparator, 0);
            buffer.append(Util.bind("disassembler.begincommentline"));
            buffer.append(Util.bind("classfileformat.magicnumber"));
            buffer.append(Integer.toHexString(classFileReader.getMagic()).toUpperCase());
            this.writeNewLine(buffer, lineSeparator, 0);
            buffer.append(Util.bind("disassembler.begincommentline"));
            buffer.append(Util.bind("classfileformat.minorversion"));
            buffer.append(minorVersion);
            this.writeNewLine(buffer, lineSeparator, 0);
            buffer.append(Util.bind("disassembler.begincommentline"));
            buffer.append(Util.bind("classfileformat.majorversion"));
            buffer.append(majorVersion);
            this.writeNewLine(buffer, lineSeparator, 0);
            buffer.append(Util.bind("disassembler.commentend"));
            this.writeNewLine(buffer, lineSeparator, 0);
        }
        if ((sourceAttribute = classFileReader.getSourceFileAttribute()) != null) {
            buffer.append(Util.bind("classfileformat.sourcename"));
            buffer.append(sourceAttribute.getSourceFileName());
            this.writeNewLine(buffer, lineSeparator, 0);
        }
        if ((className = classFileReader.getClassName()) == null) {
            return buffer.toString();
        }
        IInnerClassesAttribute innerClassesAttribute = classFileReader.getInnerClassesAttribute();
        if (innerClassesAttribute != null) {
            IInnerClassesAttributeEntry[] entries = innerClassesAttribute.getInnerClassAttributesEntries();
            int i = 0;
            int max = entries.length;
            while (i < max) {
                IInnerClassesAttributeEntry entry = entries[i];
                char[] innerClassName = entry.getInnerClassName();
                if (innerClassName != null && CharOperation.equals(classFileReader.getClassName(), innerClassName)) {
                    this.decodeModifiersForInnerClasses(buffer, entry.getAccessFlags());
                }
                ++i;
            }
        } else {
            this.decodeModifiersForType(buffer, classFileReader.getAccessFlags());
        }
        if (classFileReader.isClass()) {
            buffer.append("class ");
        } else {
            buffer.append("interface ");
        }
        CharOperation.replace(className, '/', '.');
        buffer.append(className);
        char[] superclassName = classFileReader.getSuperclassName();
        if (superclassName != null) {
            buffer.append(" extends ");
            CharOperation.replace(superclassName, '/', '.');
            buffer.append(superclassName);
        }
        if ((length = (superclassInterfaces = classFileReader.getInterfaceNames()).length) != 0) {
            buffer.append(" implements ");
            int i = 0;
            while (i < length - 1) {
                char[] superinterface = superclassInterfaces[i];
                CharOperation.replace(superinterface, '/', '.');
                buffer.append(superinterface).append(Util.bind("disassembler.comma"));
                ++i;
            }
            char[] superinterface = superclassInterfaces[length - 1];
            CharOperation.replace(superinterface, '/', '.');
            buffer.append(superinterface);
        }
        buffer.append(Util.bind("disassembler.opentypedeclaration"));
        this.writeNewLine(buffer, lineSeparator, 1);
        this.checkSuperFlags(buffer, classFileReader.getAccessFlags(), lineSeparator, 1);
        this.disassembleTypeMembers(classFileReader, buffer, lineSeparator, 1, mode);
        if (mode == 1) {
            IClassFileAttribute[] attributes;
            if (innerClassesAttribute != null) {
                this.disassemble(innerClassesAttribute, buffer, lineSeparator, 1);
            }
            if ((length = (attributes = classFileReader.getAttributes()).length) != 0) {
                int i = 0;
                while (i < length) {
                    IClassFileAttribute attribute = attributes[i];
                    if (attribute != innerClassesAttribute && attribute != sourceAttribute) {
                        this.disassemble(attribute, buffer, lineSeparator, 0);
                    }
                    ++i;
                }
            }
        }
        this.writeNewLine(buffer, lineSeparator, 0);
        buffer.append(Util.bind("disassembler.closetypedeclaration"));
        return buffer.toString();
    }

    private void disassemble(IInnerClassesAttribute innerClassesAttribute, StringBuffer buffer, String lineSeparator, int tabNumber) {
        int accessFlags;
        int innerNameIndex;
        int outerClassNameIndex;
        int innerClassNameIndex;
        IInnerClassesAttributeEntry innerClassesAttributeEntry;
        this.writeNewLine(buffer, lineSeparator, tabNumber);
        buffer.append(Util.bind("disassembler.innerattributesheader"));
        this.writeNewLine(buffer, lineSeparator, tabNumber + 1);
        IInnerClassesAttributeEntry[] innerClassesAttributeEntries = innerClassesAttribute.getInnerClassAttributesEntries();
        int length = innerClassesAttributeEntries.length;
        int i = 0;
        while (i < length - 1) {
            innerClassesAttributeEntry = innerClassesAttributeEntries[i];
            innerClassNameIndex = innerClassesAttributeEntry.getInnerClassNameIndex();
            outerClassNameIndex = innerClassesAttributeEntry.getOuterClassNameIndex();
            innerNameIndex = innerClassesAttributeEntry.getInnerNameIndex();
            accessFlags = innerClassesAttributeEntry.getAccessFlags();
            buffer.append(Util.bind("disassembler.openinnerclassentry"));
            this.writeNewLine(buffer, lineSeparator, tabNumber);
            this.dumpTab(tabNumber + 1, buffer);
            buffer.append(Util.bind("disassembler.inner_class_info_name")).append(Util.bind("disassembler.constantpoolindex")).append(innerClassNameIndex);
            if (innerClassNameIndex != 0) {
                buffer.append(Util.bind("disassembler.space")).append(innerClassesAttributeEntry.getInnerClassName());
            }
            this.writeNewLine(buffer, lineSeparator, tabNumber);
            this.dumpTab(tabNumber + 1, buffer);
            buffer.append(Util.bind("disassembler.outer_class_info_name")).append(Util.bind("disassembler.constantpoolindex")).append(outerClassNameIndex);
            if (outerClassNameIndex != 0) {
                buffer.append(Util.bind("disassembler.space")).append(innerClassesAttributeEntry.getOuterClassName());
            }
            this.writeNewLine(buffer, lineSeparator, tabNumber);
            this.dumpTab(tabNumber + 1, buffer);
            buffer.append(Util.bind("disassembler.inner_name")).append(Util.bind("disassembler.constantpoolindex")).append(innerNameIndex);
            if (innerNameIndex != 0) {
                buffer.append(Util.bind("disassembler.space")).append(innerClassesAttributeEntry.getInnerName());
            }
            this.writeNewLine(buffer, lineSeparator, tabNumber);
            this.dumpTab(tabNumber + 1, buffer);
            buffer.append(Util.bind("disassembler.inner_accessflags")).append(accessFlags).append(Util.bind("disassembler.space"));
            this.decodeModifiersForInnerClasses(buffer, accessFlags);
            buffer.append(Util.bind("disassembler.closeinnerclassentry")).append(Util.bind("disassembler.comma"));
            this.writeNewLine(buffer, lineSeparator, tabNumber + 1);
            ++i;
        }
        innerClassesAttributeEntry = innerClassesAttributeEntries[length - 1];
        innerClassNameIndex = innerClassesAttributeEntry.getInnerClassNameIndex();
        outerClassNameIndex = innerClassesAttributeEntry.getOuterClassNameIndex();
        innerNameIndex = innerClassesAttributeEntry.getInnerNameIndex();
        accessFlags = innerClassesAttributeEntry.getAccessFlags();
        buffer.append(Util.bind("disassembler.openinnerclassentry"));
        this.writeNewLine(buffer, lineSeparator, tabNumber);
        this.dumpTab(tabNumber + 1, buffer);
        buffer.append(Util.bind("disassembler.inner_class_info_name")).append(Util.bind("disassembler.constantpoolindex")).append(innerClassNameIndex);
        if (innerClassNameIndex != 0) {
            buffer.append(Util.bind("disassembler.space")).append(innerClassesAttributeEntry.getInnerClassName());
        }
        this.writeNewLine(buffer, lineSeparator, tabNumber);
        this.dumpTab(tabNumber + 1, buffer);
        buffer.append(Util.bind("disassembler.outer_class_info_name")).append(Util.bind("disassembler.constantpoolindex")).append(outerClassNameIndex);
        if (outerClassNameIndex != 0) {
            buffer.append(Util.bind("disassembler.space")).append(innerClassesAttributeEntry.getOuterClassName());
        }
        this.writeNewLine(buffer, lineSeparator, tabNumber);
        this.dumpTab(tabNumber + 1, buffer);
        buffer.append(Util.bind("disassembler.inner_name")).append(Util.bind("disassembler.constantpoolindex")).append(innerNameIndex);
        if (innerNameIndex != 0) {
            buffer.append(Util.bind("disassembler.space")).append(innerClassesAttributeEntry.getInnerName());
        }
        this.writeNewLine(buffer, lineSeparator, tabNumber);
        this.dumpTab(tabNumber + 1, buffer);
        buffer.append(Util.bind("disassembler.inner_accessflags")).append(accessFlags).append(Util.bind("disassembler.space"));
        this.decodeModifiersForInnerClasses(buffer, accessFlags);
        buffer.append(Util.bind("disassembler.closeinnerclassentry"));
    }

    private void disassemble(IFieldInfo fieldInfo, StringBuffer buffer, String lineSeparator, int tabNumber, int mode) {
        this.writeNewLine(buffer, lineSeparator, tabNumber);
        this.decodeModifiersForField(buffer, fieldInfo.getAccessFlags());
        char[] fieldDescriptor = fieldInfo.getDescriptor();
        CharOperation.replace(fieldDescriptor, '/', '.');
        buffer.append(Signature.toCharArray(fieldDescriptor));
        buffer.append(Util.bind("disassembler.space"));
        buffer.append(new String(fieldInfo.getName()));
        IConstantValueAttribute constantValueAttribute = fieldInfo.getConstantValueAttribute();
        if (constantValueAttribute != null) {
            buffer.append(Util.bind("disassembler.fieldhasconstant"));
            IConstantPoolEntry constantPoolEntry = constantValueAttribute.getConstantValue();
            switch (constantPoolEntry.getKind()) {
                case 5: {
                    buffer.append(String.valueOf(constantPoolEntry.getLongValue()) + "L");
                    break;
                }
                case 4: {
                    buffer.append(String.valueOf(constantPoolEntry.getFloatValue()) + "f");
                    break;
                }
                case 6: {
                    buffer.append(constantPoolEntry.getDoubleValue());
                    break;
                }
                case 3: {
                    switch (fieldDescriptor[0]) {
                        case 'C': {
                            buffer.append("'" + (char)constantPoolEntry.getIntegerValue() + "'");
                            break;
                        }
                        case 'Z': {
                            buffer.append(constantPoolEntry.getIntegerValue() == 1 ? "true" : "false");
                            break;
                        }
                        case 'B': {
                            buffer.append(constantPoolEntry.getIntegerValue());
                            break;
                        }
                        case 'S': {
                            buffer.append(constantPoolEntry.getIntegerValue());
                            break;
                        }
                        case 'I': {
                            buffer.append(constantPoolEntry.getIntegerValue());
                        }
                    }
                    break;
                }
                case 8: {
                    buffer.append("\"" + this.decodeStringValue(constantPoolEntry.getStringValue()) + "\"");
                }
            }
        }
        buffer.append(Util.bind("disassembler.endoffieldheader"));
        IClassFileAttribute[] attributes = fieldInfo.getAttributes();
        int length = attributes.length;
        if (length != 0) {
            int i = 0;
            while (i < length) {
                IClassFileAttribute attribute = attributes[i];
                if (attribute != constantValueAttribute) {
                    this.disassemble(attribute, buffer, lineSeparator, tabNumber);
                }
                ++i;
            }
        }
        if (mode == 1) {
            this.writeNewLine(buffer, lineSeparator, tabNumber);
            CharOperation.replace(fieldDescriptor, '.', '/');
            buffer.append(Util.bind("disassembler.commentstart")).append(Util.bind("classfileformat.fieldddescriptor")).append(Util.bind("classfileformat.fielddescriptorindex")).append(fieldInfo.getDescriptorIndex()).append(Util.bind("disassembler.space")).append(fieldDescriptor).append(Util.bind("disassembler.commentend"));
        }
        this.writeNewLine(buffer, lineSeparator, tabNumber);
    }

    private void disassemble(IClassFileReader classFileReader, IMethodInfo methodInfo, StringBuffer buffer, String lineSeparator, int tabNumber, int mode) {
        int length;
        ICodeAttribute codeAttribute = methodInfo.getCodeAttribute();
        this.writeNewLine(buffer, lineSeparator, tabNumber);
        char[] methodDescriptor = methodInfo.getDescriptor();
        if (mode == 1) {
            CharOperation.replace(methodDescriptor, '.', '/');
            buffer.append(Util.bind("disassembler.commentstart")).append(Util.bind("classfileformat.methoddescriptor")).append(Util.bind("disassembler.constantpoolindex")).append(methodInfo.getDescriptorIndex()).append(Util.bind("disassembler.space")).append(methodDescriptor).append(Util.bind("disassembler.commentend"));
        }
        this.writeNewLine(buffer, lineSeparator, tabNumber);
        int accessFlags = methodInfo.getAccessFlags();
        this.decodeModifiersForMethod(buffer, accessFlags);
        CharOperation.replace(methodDescriptor, '/', '.');
        char[] methodName = null;
        if (methodInfo.isConstructor()) {
            methodName = classFileReader.getClassName();
            buffer.append(Signature.toCharArray(methodDescriptor, methodName, this.getParameterNames(methodDescriptor, codeAttribute, accessFlags), true, false));
        } else if (methodInfo.isClinit()) {
            methodName = Util.bind("classfileformat.clinitname").toCharArray();
            buffer.append(methodName);
        } else {
            methodName = methodInfo.getName();
            buffer.append(Signature.toCharArray(methodDescriptor, methodName, this.getParameterNames(methodDescriptor, codeAttribute, accessFlags), false, true));
        }
        IExceptionAttribute exceptionAttribute = methodInfo.getExceptionAttribute();
        if (exceptionAttribute != null) {
            buffer.append(" throws ");
            char[][] exceptionNames = exceptionAttribute.getExceptionNames();
            length = exceptionNames.length;
            int i = 0;
            while (i < length - 1) {
                char[] exceptionName = exceptionNames[i];
                CharOperation.replace(exceptionName, '/', '.');
                buffer.append(exceptionName).append(Util.bind("disassembler.comma"));
                ++i;
            }
            char[] exceptionName = exceptionNames[length - 1];
            CharOperation.replace(exceptionName, '/', '.');
            buffer.append(exceptionName);
        }
        buffer.append(Util.bind("disassembler.endofmethodheader"));
        this.writeNewLine(buffer, lineSeparator, tabNumber + 1);
        IClassFileAttribute[] attributes = methodInfo.getAttributes();
        length = attributes.length;
        if (length != 0) {
            int i = 0;
            while (i < length) {
                IClassFileAttribute attribute = attributes[i];
                if (attribute != codeAttribute && attribute != exceptionAttribute) {
                    this.disassemble(attribute, buffer, lineSeparator, tabNumber);
                    this.writeNewLine(buffer, lineSeparator, tabNumber);
                }
                ++i;
            }
        }
        if (codeAttribute != null) {
            this.disassemble(codeAttribute, buffer, lineSeparator, tabNumber);
            this.writeNewLine(buffer, lineSeparator, tabNumber);
        }
    }

    private void disassemble(IClassFileAttribute classFileAttribute, StringBuffer buffer, String lineSeparator, int tabNumber) {
        this.writeNewLine(buffer, lineSeparator, tabNumber + 1);
        buffer.append(Util.bind("disassembler.genericattributeheader"));
        this.writeNewLine(buffer, lineSeparator, tabNumber + 2);
        buffer.append(Util.bind("disassembler.genericattributename")).append(classFileAttribute.getAttributeName()).append(Util.bind("disassembler.genericattributelength")).append(classFileAttribute.getAttributeLength());
    }

    private void disassemble(ICodeAttribute codeAttribute, StringBuffer buffer, String lineSeparator, int tabNumber) {
        ILocalVariableAttribute localVariableAttribute;
        int localVariableAttributeLength;
        ILineNumberAttribute lineNumberAttribute;
        int lineAttributeLength;
        buffer.append(Util.bind("disassembler.commentstart")).append(Util.bind("classfileformat.maxStack")).append(codeAttribute.getMaxStack()).append(Util.bind("disassembler.comma")).append(Util.bind("classfileformat.maxLocals")).append(codeAttribute.getMaxLocals()).append(Util.bind("disassembler.commentend"));
        this.writeNewLine(buffer, lineSeparator, tabNumber + 1);
        buffer.append(Util.bind("disassembler.codeattributeheader"));
        this.writeNewLine(buffer, lineSeparator, tabNumber - 1);
        DefaultBytecodeVisitor visitor = new DefaultBytecodeVisitor(codeAttribute.getCodeLength(), buffer, lineSeparator, tabNumber + 1);
        try {
            codeAttribute.traverse(visitor);
        }
        catch (ClassFormatException classFormatException) {
            this.dumpTab(tabNumber + 2, buffer);
            buffer.append("Class format Exception");
            this.writeNewLine(buffer, lineSeparator, tabNumber + 1);
        }
        int exceptionTableLength = codeAttribute.getExceptionTableLength();
        if (exceptionTableLength != 0) {
            this.writeNewLine(buffer, lineSeparator, tabNumber + 1);
            IExceptionTableEntry[] exceptionTableEntries = codeAttribute.getExceptionTable();
            buffer.append(Util.bind("disassembler.exceptiontableheader"));
            this.writeNewLine(buffer, lineSeparator, tabNumber + 2);
            int i = 0;
            while (i < exceptionTableLength) {
                IExceptionTableEntry exceptionTableEntry = exceptionTableEntries[i];
                buffer.append(Util.bind("classfileformat.exceptiontablefrom")).append(exceptionTableEntry.getStartPC()).append(Util.bind("classfileformat.exceptiontableto")).append(exceptionTableEntry.getEndPC()).append(Util.bind("classfileformat.exceptiontablegoto")).append(exceptionTableEntry.getHandlerPC()).append(Util.bind("classfileformat.exceptiontablewhen"));
                if (exceptionTableEntry.getCatchTypeIndex() == 0) {
                    buffer.append(ANY_EXCEPTION);
                } else {
                    char[] catchType = exceptionTableEntry.getCatchType();
                    CharOperation.replace(catchType, '/', '.');
                    buffer.append(catchType);
                }
                this.writeNewLine(buffer, lineSeparator, tabNumber + 2);
                ++i;
            }
        }
        int n = lineAttributeLength = (lineNumberAttribute = codeAttribute.getLineNumberAttribute()) == null ? 0 : lineNumberAttribute.getLineNumberTableLength();
        if (lineAttributeLength != 0) {
            this.writeNewLine(buffer, lineSeparator, tabNumber + 1);
            buffer.append(Util.bind("disassembler.linenumberattributeheader"));
            this.writeNewLine(buffer, lineSeparator, tabNumber + 2);
            int[][] lineattributesEntries = lineNumberAttribute.getLineNumberTable();
            int i = 0;
            while (i < lineAttributeLength - 1) {
                buffer.append(Util.bind("classfileformat.linenumbertablefrom")).append(lineattributesEntries[i][0]).append(Util.bind("classfileformat.linenumbertableto")).append(lineattributesEntries[i][1]).append(Util.bind("classfileformat.linenumbertableclose"));
                this.writeNewLine(buffer, lineSeparator, tabNumber + 2);
                ++i;
            }
            buffer.append(Util.bind("classfileformat.linenumbertablefrom")).append(lineattributesEntries[lineAttributeLength - 1][0]).append(Util.bind("classfileformat.linenumbertableto")).append(lineattributesEntries[lineAttributeLength - 1][1]).append(Util.bind("classfileformat.linenumbertableclose"));
        }
        int n2 = localVariableAttributeLength = (localVariableAttribute = codeAttribute.getLocalVariableAttribute()) == null ? 0 : localVariableAttribute.getLocalVariableTableLength();
        if (localVariableAttributeLength != 0) {
            this.writeNewLine(buffer, lineSeparator, tabNumber + 1);
            buffer.append(Util.bind("disassembler.localvariabletableattributeheader"));
            this.writeNewLine(buffer, lineSeparator, tabNumber + 2);
            ILocalVariableTableEntry[] localVariableTableEntries = localVariableAttribute.getLocalVariableTable();
            int i = 0;
            while (i < localVariableAttributeLength - 1) {
                ILocalVariableTableEntry localVariableTableEntry = localVariableTableEntries[i];
                int startPC = localVariableTableEntry.getStartPC();
                int length = localVariableTableEntry.getLength();
                buffer.append(Util.bind("classfileformat.localvariabletablefrom")).append(startPC).append(Util.bind("classfileformat.localvariabletableto")).append(startPC + length).append(Util.bind("classfileformat.localvariabletablelocalname")).append(localVariableTableEntry.getName()).append(Util.bind("classfileformat.localvariabletablelocalindex")).append(localVariableTableEntry.getIndex()).append(Util.bind("classfileformat.localvariabletablelocaltype")).append(Signature.toCharArray(localVariableTableEntry.getDescriptor()));
                this.writeNewLine(buffer, lineSeparator, tabNumber + 2);
                ++i;
            }
            ILocalVariableTableEntry localVariableTableEntry = localVariableTableEntries[localVariableAttributeLength - 1];
            int startPC = localVariableTableEntry.getStartPC();
            int length = localVariableTableEntry.getLength();
            buffer.append(Util.bind("classfileformat.localvariabletablefrom")).append(startPC).append(Util.bind("classfileformat.localvariabletableto")).append(startPC + length).append(Util.bind("classfileformat.localvariabletablelocalname")).append(localVariableTableEntry.getName()).append(Util.bind("classfileformat.localvariabletablelocalindex")).append(localVariableTableEntry.getIndex()).append(Util.bind("classfileformat.localvariabletablelocaltype")).append(Signature.toCharArray(localVariableTableEntry.getDescriptor()));
        }
    }

    private void disassembleTypeMembers(IClassFileReader classFileReader, StringBuffer buffer, String lineSeparator, int tabNumber, int mode) {
        IFieldInfo[] fields = classFileReader.getFieldInfos();
        int i = 0;
        int max = fields.length;
        while (i < max) {
            this.disassemble(fields[i], buffer, lineSeparator, tabNumber, mode);
            ++i;
        }
        IMethodInfo[] methods = classFileReader.getMethodInfos();
        int i2 = 0;
        int max2 = methods.length;
        while (i2 < max2) {
            this.disassemble(classFileReader, methods[i2], buffer, lineSeparator, tabNumber, mode);
            ++i2;
        }
    }

    private final void dumpTab(int tabNumber, StringBuffer buffer) {
        int i = 0;
        while (i < tabNumber) {
            buffer.append(Util.bind("disassembler.identation"));
            ++i;
        }
    }

    public String getDescription() {
        return Util.bind("disassembler.description");
    }

    private char[][] getParameterNames(char[] methodDescriptor, ICodeAttribute codeAttribute, int accessFlags) {
        int paramCount = Signature.getParameterCount(methodDescriptor);
        char[][] parameterNames = new char[paramCount][];
        if (codeAttribute != null) {
            ILocalVariableAttribute localVariableAttribute = codeAttribute.getLocalVariableAttribute();
            if (localVariableAttribute != null) {
                ILocalVariableTableEntry[] entries = localVariableAttribute.getLocalVariableTable();
                int startingIndex = (accessFlags & 8) != 0 ? 0 : 1;
                int i = 0;
                while (i < paramCount) {
                    ILocalVariableTableEntry searchedEntry = this.getEntryFor(startingIndex + i, entries);
                    parameterNames[i] = searchedEntry != null ? searchedEntry.getName() : Util.bind("disassembler.parametername").toCharArray();
                    ++i;
                }
            } else {
                int i = 0;
                while (i < paramCount) {
                    parameterNames[i] = Util.bind("disassembler.parametername").toCharArray();
                    ++i;
                }
            }
        } else {
            int i = 0;
            while (i < paramCount) {
                parameterNames[i] = Util.bind("disassembler.parametername").toCharArray();
                ++i;
            }
        }
        return parameterNames;
    }

    private ILocalVariableTableEntry getEntryFor(int localIndex, ILocalVariableTableEntry[] entries) {
        int i = 0;
        int max = entries.length;
        while (i < max) {
            ILocalVariableTableEntry entry = entries[i];
            if (localIndex == entry.getIndex()) {
                return entry;
            }
            ++i;
        }
        return null;
    }

    private void writeNewLine(StringBuffer buffer, String lineSeparator, int tabNumber) {
        buffer.append(lineSeparator);
        this.dumpTab(tabNumber, buffer);
    }
}

