/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.pattern;

import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchDocument;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.index.IIndex;
import org.eclipse.jdt.internal.core.index.impl.BlocksIndexInput;
import org.eclipse.jdt.internal.core.index.impl.EntryResult;
import org.eclipse.jdt.internal.core.index.impl.IndexInput;
import org.eclipse.jdt.internal.core.index.impl.IndexedFile;
import org.eclipse.jdt.internal.core.search.IndexQueryRequestor;
import org.eclipse.jdt.internal.core.search.PathCollector;
import org.eclipse.jdt.internal.core.search.PatternSearchJob;
import org.eclipse.jdt.internal.core.search.indexing.IndexManager;
import org.eclipse.jdt.internal.core.util.Util;

public abstract class InternalSearchPattern {
    public final int kind;
    public final int matchRule;
    public IJavaElement focus;

    public InternalSearchPattern(int patternKind, int matchRule) {
        this.kind = patternKind;
        this.matchRule = matchRule;
    }

    public abstract void decodeIndexKey(char[] var1);

    public abstract char[] encodeIndexKey();

    protected char[] encodeIndexKey(char[] key) {
        if (this.isCaseSensitive() && key != null) {
            switch (this.matchMode()) {
                case 0: 
                case 1: {
                    return key;
                }
                case 2: {
                    int starPos = CharOperation.indexOf('*', key);
                    switch (starPos) {
                        case -1: {
                            return key;
                        }
                        default: {
                            char[] result = new char[starPos];
                            System.arraycopy(key, 0, result, 0, starPos);
                            return result;
                        }
                        case 0: 
                    }
                    break;
                }
                case 3: {
                    return key;
                }
            }
        }
        return CharOperation.NO_CHAR;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void findIndexMatches(IIndex index, IndexQueryRequestor requestor, SearchParticipant participant, IJavaSearchScope scope, IProgressMonitor progressMonitor) throws IOException {
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        BlocksIndexInput input = new BlocksIndexInput(index.getIndexFile());
        try {
            ((IndexInput)input).open();
            this.findIndexMatches(input, requestor, participant, scope, progressMonitor);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            ((IndexInput)input).close();
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        ((IndexInput)input).close();
    }

    public void findIndexMatches(IndexInput input, IndexQueryRequestor requestor, SearchParticipant participant, IJavaSearchScope scope, IProgressMonitor progressMonitor) throws IOException {
        char[][] categories = this.getMatchCategories();
        char[] queryKey = this.encodeIndexKey();
        int iCategory = 0;
        int categoriesLength = categories.length;
        while (iCategory < categoriesLength) {
            if (progressMonitor != null && progressMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            char[] category = categories[iCategory];
            this.findIndexMatches(input, requestor, participant, scope, progressMonitor, queryKey, category);
            ++iCategory;
        }
    }

    protected void findIndexMatches(IndexInput input, IndexQueryRequestor requestor, SearchParticipant participant, IJavaSearchScope scope, IProgressMonitor progressMonitor, char[] queryKey, char[] category) throws IOException {
        char[] pattern = CharOperation.concat(category, queryKey);
        EntryResult[] entries = input.queryEntries(pattern, 1);
        if (entries == null) {
            return;
        }
        int iMatch = 0;
        int matchesLength = entries.length;
        while (iMatch < matchesLength) {
            if (progressMonitor != null && progressMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            EntryResult entry = entries[iMatch];
            char[] word = entry.getWord();
            char[] indexKey = CharOperation.subarray(word, category.length, word.length);
            SearchPattern indexRecord = this.getIndexRecord();
            indexRecord.decodeIndexKey(indexKey);
            if (this.isMatchingIndexRecord()) {
                int[] references = entry.getFileReferences();
                int iReference = 0;
                int refererencesLength = references.length;
                while (iReference < refererencesLength) {
                    String documentPath = IndexedFile.convertPath(input.getIndexedFile(references[iReference]).getPath());
                    if (scope.encloses(documentPath) && !requestor.acceptIndexMatch(documentPath, indexRecord, participant)) {
                        throw new OperationCanceledException();
                    }
                    ++iReference;
                }
            }
            ++iMatch;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void findMatches(SearchParticipant[] participants, IJavaSearchScope scope, SearchRequestor requestor, IProgressMonitor monitor) throws CoreException {
        if (monitor != null && monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (monitor != null) {
            monitor.beginTask(Util.bind("engine.searching"), 100);
        }
        if (SearchEngine.VERBOSE) {
            System.out.println("Searching for " + this + " in " + scope);
        }
        IndexManager indexManager = JavaModelManager.getJavaModelManager().getIndexManager();
        try {
            int length;
            requestor.beginReporting();
            int iParticipant = 0;
            int n = length = participants == null ? 0 : participants.length;
            while (iParticipant < length) {
                Object var15_15;
                if (monitor != null && monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                SearchParticipant participant = participants[iParticipant];
                try {
                    participant.beginSearching();
                    requestor.enterParticipant(participant);
                    PathCollector pathCollector = new PathCollector();
                    indexManager.performConcurrentJob(new PatternSearchJob((SearchPattern)this, participant, scope, pathCollector), 3, monitor);
                    if (monitor != null && monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    String[] indexMatchPaths = pathCollector.getPaths();
                    pathCollector = null;
                    int indexMatchLength = indexMatchPaths == null ? 0 : indexMatchPaths.length;
                    SearchDocument[] indexMatches = new SearchDocument[indexMatchLength];
                    int iMatch = 0;
                    while (true) {
                        block14: {
                            if (iMatch < indexMatchLength) break block14;
                            participant.locateMatches(indexMatches, (SearchPattern)this, scope, requestor, monitor);
                            break;
                        }
                        String documentPath = indexMatchPaths[iMatch];
                        indexMatches[iMatch] = participant.getDocument(documentPath);
                        ++iMatch;
                    }
                }
                catch (Throwable throwable) {
                    var15_15 = null;
                    requestor.exitParticipant(participant);
                    participant.doneSearching();
                    throw throwable;
                }
                {
                    var15_15 = null;
                    requestor.exitParticipant(participant);
                    participant.doneSearching();
                }
                if (monitor != null && monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                ++iParticipant;
            }
        }
        catch (Throwable throwable) {
            Object var17_18 = null;
            requestor.endReporting();
            if (monitor == null) throw throwable;
            monitor.done();
            throw throwable;
        }
        {
            Object var17_19 = null;
            requestor.endReporting();
            if (monitor == null) return;
        }
        monitor.done();
    }

    public abstract SearchPattern getIndexRecord();

    public abstract char[][] getMatchCategories();

    public boolean isCaseSensitive() {
        return (this.matchRule & 4) != 0;
    }

    public abstract boolean isMatchingIndexRecord();

    public boolean isPolymorphicSearch() {
        return false;
    }

    public int matchMode() {
        return this.matchRule & 0xFFFFFFFB;
    }
}

