/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.indexing;

import java.io.IOException;
import java.util.HashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.compiler.util.Util;
import org.eclipse.jdt.internal.core.ClasspathEntry;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.index.IIndex;
import org.eclipse.jdt.internal.core.search.JavaSearchDocument;
import org.eclipse.jdt.internal.core.search.indexing.IndexManager;
import org.eclipse.jdt.internal.core.search.indexing.IndexRequest;
import org.eclipse.jdt.internal.core.search.indexing.ReadWriteMonitor;
import org.eclipse.jdt.internal.core.search.indexing.SaveIndex;
import org.eclipse.jdt.internal.core.search.processing.JobManager;
import org.eclipse.jdt.internal.core.util.SimpleLookupTable;

public class IndexAllProject
extends IndexRequest {
    IProject project;

    public IndexAllProject(IProject project, IndexManager manager) {
        super(project.getFullPath(), manager);
        this.project = project;
    }

    public boolean equals(Object o) {
        if (o instanceof IndexAllProject) {
            return this.project.equals((Object)((IndexAllProject)o).project);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean execute(IProgressMonitor progressMonitor) {
        if (this.isCancelled) return true;
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            return true;
        }
        if (!this.project.isAccessible()) {
            return true;
        }
        IIndex index = this.manager.getIndexForUpdate(this.containerPath, true, true);
        if (index == null) {
            return true;
        }
        ReadWriteMonitor monitor = this.manager.getMonitorFor(index);
        if (monitor == null) {
            return true;
        }
        try {
            try {
                monitor.enterRead();
                this.saveIfNecessary(index, monitor);
                String[] paths = index.queryInDocumentNames("");
                int max = paths == null ? 0 : paths.length;
                final SimpleLookupTable indexedFileNames = new SimpleLookupTable(max == 0 ? 33 : max + 11);
                int i = 0;
                while (i < max) {
                    indexedFileNames.put(paths[i], "DELETED");
                    ++i;
                }
                final long indexLastModified = max == 0 ? 0L : index.getIndexFile().lastModified();
                JavaProject javaProject = (JavaProject)JavaCore.create(this.project);
                IClasspathEntry[] entries = javaProject.getRawClasspath(false, false);
                IWorkspaceRoot root = this.project.getWorkspace().getRoot();
                int i2 = 0;
                int length = entries.length;
                while (i2 < length) {
                    IResource sourceFolder;
                    if (this.isCancelled) {
                        Object var19_27 = null;
                        monitor.exitRead();
                        return false;
                    }
                    IClasspathEntry entry = entries[i2];
                    if (entry.getEntryKind() == 3 && (sourceFolder = root.findMember(entry.getPath())) != null) {
                        final HashSet<IPath> outputs = new HashSet<IPath>();
                        if (sourceFolder.getType() == 4) {
                            outputs.add(javaProject.getOutputLocation(false, false));
                            int j = 0;
                            while (j < length) {
                                IPath output = entries[j].getOutputLocation();
                                if (output != null) {
                                    outputs.add(output);
                                }
                                ++j;
                            }
                        }
                        final boolean hasOutputs = !outputs.isEmpty();
                        final char[][] patterns = ((ClasspathEntry)entry).fullExclusionPatternChars();
                        if (max == 0) {
                            sourceFolder.accept(new IResourceProxyVisitor(){

                                public boolean visit(IResourceProxy proxy) {
                                    if (IndexAllProject.this.isCancelled) {
                                        return false;
                                    }
                                    switch (proxy.getType()) {
                                        case 1: {
                                            IFile file;
                                            if (Util.isJavaFileName(proxy.getName()) && (file = (IFile)proxy.requestResource()).getLocation() != null && (patterns == null || !org.eclipse.jdt.internal.core.util.Util.isExcluded((IResource)file, patterns))) {
                                                indexedFileNames.put(new JavaSearchDocument(file, null).getPath(), file);
                                            }
                                            return false;
                                        }
                                        case 2: {
                                            if (patterns != null && org.eclipse.jdt.internal.core.util.Util.isExcluded(proxy.requestResource(), patterns)) {
                                                return false;
                                            }
                                            if (!hasOutputs || !outputs.contains(proxy.requestFullPath())) break;
                                            return false;
                                        }
                                    }
                                    return true;
                                }
                            }, 0);
                        } else {
                            sourceFolder.accept(new IResourceProxyVisitor(){

                                public boolean visit(IResourceProxy proxy) {
                                    if (IndexAllProject.this.isCancelled) {
                                        return false;
                                    }
                                    switch (proxy.getType()) {
                                        case 1: {
                                            IFile file;
                                            IPath location;
                                            if (Util.isJavaFileName(proxy.getName()) && (location = (file = (IFile)proxy.requestResource()).getLocation()) != null && (patterns == null || !org.eclipse.jdt.internal.core.util.Util.isExcluded((IResource)file, patterns))) {
                                                String path;
                                                indexedFileNames.put(path, indexedFileNames.get(path = new JavaSearchDocument(file, null).getPath()) == null || indexLastModified < location.toFile().lastModified() ? file : "OK");
                                            }
                                            return false;
                                        }
                                        case 2: {
                                            if (patterns != null && org.eclipse.jdt.internal.core.util.Util.isExcluded(proxy.requestResource(), patterns)) {
                                                return false;
                                            }
                                            if (!hasOutputs || !outputs.contains(proxy.requestFullPath())) break;
                                            return false;
                                        }
                                    }
                                    return true;
                                }
                            }, 0);
                        }
                    }
                    ++i2;
                }
                Object[] names = indexedFileNames.keyTable;
                Object[] values = indexedFileNames.valueTable;
                int i3 = 0;
                int length2 = names.length;
                while (i3 < length2) {
                    String name = (String)names[i3];
                    if (name != null) {
                        if (this.isCancelled) {
                            Object var19_28 = null;
                            monitor.exitRead();
                            return false;
                        }
                        Object value = values[i3];
                        if (value != "OK") {
                            if (value == "DELETED") {
                                this.manager.remove(name, this.containerPath);
                            } else {
                                this.manager.addSource((IFile)value, this.containerPath);
                            }
                        }
                    }
                    ++i3;
                }
                this.manager.request(new SaveIndex(this.containerPath, this.manager));
            }
            catch (CoreException e) {
                if (JobManager.VERBOSE) {
                    JobManager.verbose("-> failed to index " + this.project + " because of the following exception:");
                    e.printStackTrace();
                }
                this.manager.removeIndex(this.containerPath);
                Object var19_29 = null;
                monitor.exitRead();
                return false;
            }
            catch (IOException e) {
                if (JobManager.VERBOSE) {
                    JobManager.verbose("-> failed to index " + this.project + " because of the following exception:");
                    e.printStackTrace();
                }
                this.manager.removeIndex(this.containerPath);
                Object var19_30 = null;
                monitor.exitRead();
                return false;
            }
            Object var19_32 = null;
            monitor.exitRead();
            return true;
        }
        catch (Throwable throwable) {
            Object var19_31 = null;
            monitor.exitRead();
            throw throwable;
        }
    }

    public int hashCode() {
        return this.project.hashCode();
    }

    protected Integer updatedIndexState() {
        return IndexManager.REBUILDING_STATE;
    }

    public String toString() {
        return "indexing project " + this.project.getFullPath();
    }
}

