/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.index.impl;

import java.io.UTFDataFormatException;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.core.index.impl.IndexBlock;
import org.eclipse.jdt.internal.core.index.impl.WordEntry;

public class SimpleIndexBlock
extends IndexBlock {
    protected int offset = 0;

    public SimpleIndexBlock(int blockSize) {
        super(blockSize);
    }

    public boolean addEntry(WordEntry entry) {
        int n;
        int off = this.offset;
        char[] word = entry.getWord();
        int sizeEstimate = 2 + word.length * 3 + 4 + (n = entry.getNumRefs()) * 4;
        if (off + sizeEstimate > this.blockSize - 2) {
            return false;
        }
        off += this.field.putUTF(off, word);
        this.field.putInt4(off, n);
        off += 4;
        int i = 0;
        while (i < n) {
            this.field.putInt4(off, entry.getRef(i));
            off += 4;
            ++i;
        }
        this.offset = off;
        return true;
    }

    public WordEntry findEntry(char[] word) {
        try {
            int byteLen;
            int off = 0;
            while ((byteLen = this.field.getUInt2(off)) != 0) {
                char[] tempWord = this.field.getUTF(off);
                off += byteLen + 2;
                if (CharOperation.equals(tempWord, word)) {
                    WordEntry entry = new WordEntry(word);
                    int n = this.field.getInt4(off);
                    off += 4;
                    int i = 0;
                    while (i < n) {
                        int ref = this.field.getInt4(off);
                        off += 4;
                        entry.addRef(ref);
                        ++i;
                    }
                    return entry;
                }
                int n = this.field.getInt4(off);
                off += 4 + 4 * n;
            }
            return null;
        }
        catch (UTFDataFormatException uTFDataFormatException) {
            return null;
        }
    }

    public void flush() {
        if (this.offset > 0) {
            this.field.putInt2(this.offset, 0);
            this.offset = 0;
        }
    }

    public boolean isEmpty() {
        return this.offset == 0;
    }

    public boolean nextEntry(WordEntry entry) {
        try {
            int off = this.offset;
            int byteLen = this.field.getUInt2(off);
            if (byteLen == 0) {
                return false;
            }
            char[] word = this.field.getUTF(off);
            entry.reset(word);
            int n = this.field.getInt4(off += byteLen + 2);
            off += 4;
            int i = 0;
            while (i < n) {
                int ref = this.field.getInt4(off);
                off += 4;
                entry.addRef(ref);
                ++i;
            }
            this.offset = off;
            return true;
        }
        catch (UTFDataFormatException uTFDataFormatException) {
            return false;
        }
    }

    public void reset() {
        super.reset();
        this.offset = 0;
    }
}

