/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.builder;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.jdt.internal.core.builder.ClasspathLocation;
import org.eclipse.jdt.internal.core.util.SimpleLookupTable;
import org.eclipse.jdt.internal.core.util.SimpleSet;

public class ClasspathJar
extends ClasspathLocation {
    static SimpleLookupTable PackageCache = new SimpleLookupTable();
    String zipFilename;
    IFile resource;
    ZipFile zipFile;
    boolean closeZipFileAtEnd;
    SimpleSet knownPackageNames;

    static SimpleSet findPackageSet(ZipFile zipFile) {
        String zipFileName = zipFile.getName();
        File zipFileObject = new File(zipFileName);
        long lastModified = zipFileObject.lastModified();
        long fileSize = zipFileObject.length();
        PackageCacheEntry cacheEntry = (PackageCacheEntry)PackageCache.get(zipFileName);
        if (cacheEntry != null && cacheEntry.lastModified == lastModified && cacheEntry.fileSize == fileSize) {
            return cacheEntry.packageSet;
        }
        SimpleSet packageSet = new SimpleSet(41);
        packageSet.add("");
        Enumeration<? extends ZipEntry> e = zipFile.entries();
        block0: while (e.hasMoreElements()) {
            String fileName = e.nextElement().getName();
            int last = fileName.lastIndexOf(47);
            while (last > 0) {
                String packageName = fileName.substring(0, last);
                if (packageSet.includes(packageName)) continue block0;
                packageSet.add(packageName);
                last = packageName.lastIndexOf(47);
            }
        }
        PackageCache.put(zipFileName, new PackageCacheEntry(lastModified, fileSize, packageSet));
        return packageSet;
    }

    ClasspathJar(String zipFilename) {
        this.zipFilename = zipFilename;
        this.zipFile = null;
        this.knownPackageNames = null;
    }

    ClasspathJar(IFile resource) {
        this.resource = resource;
        IPath location = resource.getLocation();
        this.zipFilename = location != null ? location.toString() : "";
        this.zipFile = null;
        this.knownPackageNames = null;
    }

    public ClasspathJar(ZipFile zipFile) {
        this.zipFilename = zipFile.getName();
        this.zipFile = zipFile;
        this.closeZipFileAtEnd = false;
        this.knownPackageNames = null;
    }

    public void cleanup() {
        if (this.zipFile != null && this.closeZipFileAtEnd) {
            try {
                this.zipFile.close();
            }
            catch (IOException iOException) {}
            this.zipFile = null;
        }
        this.knownPackageNames = null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClasspathJar)) {
            return false;
        }
        return this.zipFilename.equals(((ClasspathJar)o).zipFilename);
    }

    public NameEnvironmentAnswer findClass(String binaryFileName, String qualifiedPackageName, String qualifiedBinaryFileName) {
        if (!this.isPackage(qualifiedPackageName)) {
            return null;
        }
        try {
            ClassFileReader reader = ClassFileReader.read(this.zipFile, qualifiedBinaryFileName);
            if (reader != null) {
                return new NameEnvironmentAnswer(reader);
            }
        }
        catch (Exception exception) {}
        return null;
    }

    public IPath getProjectRelativePath() {
        if (this.resource == null) {
            return null;
        }
        return this.resource.getProjectRelativePath();
    }

    public boolean isPackage(String qualifiedPackageName) {
        if (this.knownPackageNames != null) {
            return this.knownPackageNames.includes(qualifiedPackageName);
        }
        try {
            if (this.zipFile == null) {
                this.zipFile = new ZipFile(this.zipFilename);
                this.closeZipFileAtEnd = true;
            }
            this.knownPackageNames = ClasspathJar.findPackageSet(this.zipFile);
        }
        catch (Exception exception) {
            this.knownPackageNames = new SimpleSet();
        }
        return this.knownPackageNames.includes(qualifiedPackageName);
    }

    public String toString() {
        return "Classpath jar file " + this.zipFilename;
    }

    static class PackageCacheEntry {
        long lastModified;
        long fileSize;
        SimpleSet packageSet;

        PackageCacheEntry(long lastModified, long fileSize, SimpleSet packageSet) {
            this.lastModified = lastModified;
            this.fileSize = fileSize;
            this.packageSet = packageSet;
        }
    }
}

