/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModelStatus;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.compiler.util.ObjectVector;
import org.eclipse.jdt.internal.core.ClasspathEntry;
import org.eclipse.jdt.internal.core.DeltaProcessingState;
import org.eclipse.jdt.internal.core.JavaElementDelta;
import org.eclipse.jdt.internal.core.JavaModel;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaModelOperation;
import org.eclipse.jdt.internal.core.JavaModelStatus;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.PackageFragmentRoot;
import org.eclipse.jdt.internal.core.search.indexing.IndexManager;
import org.eclipse.jdt.internal.core.util.Util;

public class SetClasspathOperation
extends JavaModelOperation {
    IClasspathEntry[] oldResolvedPath;
    IClasspathEntry[] newResolvedPath;
    IClasspathEntry[] newRawPath;
    boolean canChangeResources;
    boolean needCycleCheck;
    boolean needValidation;
    boolean needSave;
    IPath newOutputLocation;
    JavaProject project;
    boolean identicalRoots;
    public static final IClasspathEntry[] ReuseClasspath = new IClasspathEntry[0];
    public static final IClasspathEntry[] UpdateClasspath = new IClasspathEntry[0];
    public static final IPath ReuseOutputLocation = new Path("Reuse Existing Output Location");

    public SetClasspathOperation(JavaProject project, IClasspathEntry[] oldResolvedPath, IClasspathEntry[] newRawPath, IPath newOutputLocation, boolean canChangeResource, boolean needValidation, boolean needSave) {
        super(new IJavaElement[]{project});
        this.oldResolvedPath = oldResolvedPath;
        this.newRawPath = newRawPath;
        this.newOutputLocation = newOutputLocation;
        this.canChangeResources = canChangeResource;
        this.needValidation = needValidation;
        this.needSave = needSave;
        this.project = project;
    }

    protected void addClasspathDeltas(IPackageFragmentRoot[] roots, int flag, JavaElementDelta delta) {
        int i = 0;
        while (i < roots.length) {
            IPackageFragmentRoot root = roots[i];
            delta.changed(root, flag);
            if ((flag & 0x80) != 0 || (flag & 0x1000) != 0 || (flag & 0x2000) != 0) {
                try {
                    root.close();
                }
                catch (JavaModelException javaModelException) {}
                ((PackageFragmentRoot)root).setSourceAttachmentProperty(null);
            }
            ++i;
        }
    }

    protected int classpathContains(IClasspathEntry[] list, IClasspathEntry entry) {
        IPath[] exclusionPatterns = entry.getExclusionPatterns();
        int i = 0;
        while (i < list.length) {
            IClasspathEntry other = list[i];
            if (other.getContentKind() == entry.getContentKind() && other.getEntryKind() == entry.getEntryKind() && other.isExported() == entry.isExported() && other.getPath().equals((Object)entry.getPath())) {
                IPath entryOutput = entry.getOutputLocation();
                IPath otherOutput = other.getOutputLocation();
                if (!(entryOutput != null ? !entryOutput.equals((Object)otherOutput) : otherOutput != null)) {
                    IPath[] otherExcludes = other.getExclusionPatterns();
                    if (exclusionPatterns != otherExcludes) {
                        int excludeLength = exclusionPatterns.length;
                        if (otherExcludes.length == excludeLength) {
                            int j = 0;
                            while (j < excludeLength) {
                                if (exclusionPatterns[j].toString().equals(otherExcludes[j].toString())) {
                                    ++j;
                                    continue;
                                }
                                break;
                            }
                        }
                    } else {
                        return i;
                    }
                }
            }
            ++i;
        }
        return -1;
    }

    protected void collectAllSubfolders(IFolder folder, ArrayList collection) throws JavaModelException {
        try {
            IResource[] members = folder.members();
            int i = 0;
            int max = members.length;
            while (i < max) {
                IResource r = members[i];
                if (r.getType() == 2) {
                    collection.add(r);
                    this.collectAllSubfolders((IFolder)r, collection);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            throw new JavaModelException(e);
        }
    }

    protected ArrayList determineAffectedPackageFragments(IPath location) throws JavaModelException {
        ArrayList<IPackageFragment> fragments = new ArrayList<IPackageFragment>();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IResource resource = null;
        if (location != null) {
            resource = workspace.getRoot().findMember(location);
        }
        if (resource != null && resource.getType() == 2) {
            IFolder folder = (IFolder)resource;
            IClasspathEntry[] classpath = this.project.getExpandedClasspath(true);
            int i = 0;
            while (i < classpath.length) {
                IClasspathEntry entry = classpath[i];
                IPath path = classpath[i].getPath();
                if (entry.getEntryKind() != 2 && path.isPrefixOf(location) && !path.equals((Object)location)) {
                    IPackageFragmentRoot[] roots = this.project.computePackageFragmentRoots(classpath[i]);
                    IPackageFragmentRoot root = roots[0];
                    ArrayList<IFolder> folders = new ArrayList<IFolder>();
                    folders.add(folder);
                    this.collectAllSubfolders(folder, folders);
                    Iterator elements = folders.iterator();
                    int segments = path.segmentCount();
                    while (elements.hasNext()) {
                        IFolder f = (IFolder)elements.next();
                        IPath relativePath = f.getFullPath().removeFirstSegments(segments);
                        String name = relativePath.toOSString();
                        if ((name = name.replace(File.pathSeparatorChar, '.')).endsWith(".")) {
                            name = name.substring(0, name.length() - 1);
                        }
                        IPackageFragment pkg = root.getPackageFragment(name);
                        fragments.add(pkg);
                    }
                }
                ++i;
            }
        }
        return fragments;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void executeOperation() throws JavaModelException {
        block20: {
            this.updateProjectReferencesIfNecessary();
            this.saveClasspathIfNecessary();
            originalException = null;
            try {
                try {
                    if (this.newRawPath == SetClasspathOperation.UpdateClasspath) {
                        this.newRawPath = this.project.getRawClasspath();
                    }
                    if (this.newRawPath != SetClasspathOperation.ReuseClasspath) {
                        this.updateClasspath();
                        this.project.updatePackageFragmentRoots();
                        JavaModelManager.getJavaModelManager().getDeltaProcessor().addForRefresh(this.project);
                    }
                }
                catch (JavaModelException e) {
                    originalException = e;
                    throw e;
                }
                var3_5 = null;
            }
            catch (Throwable var4_3) {
                var3_4 = null;
                try {
                    try {
                        if (this.newOutputLocation != SetClasspathOperation.ReuseOutputLocation) {
                            this.updateOutputLocation();
                        }
                    }
                    catch (JavaModelException e) {
                        if (originalException == null) throw e;
                        throw originalException;
                    }
                    v0 = null;
                }
                catch (Throwable var7_8) {
                    v0 = null;
                }
                var6_10 = v0;
                if (this.identicalRoots != false) throw var4_3;
                if (this.canChangeResources == false) throw var4_3;
                try {
                    this.project.getProject().touch(this.progressMonitor);
                    throw var4_3;
                }
                catch (CoreException e) {
                    if (JavaModelManager.CP_RESOLVE_VERBOSE == false) throw var4_3;
                    System.out.println("CPInit - FAILED to touch project: " + this.project.getElementName());
                    e.printStackTrace();
                    throw var4_3;
                }
            }
            ** try [egrp 2[TRYBLOCK] [4 : 82->110)] { 
lbl-1000:
            // 1 sources

            try {}
            catch (JavaModelException e) {
                if (originalException == null) throw e;
                throw originalException;
            }
            if (this.newOutputLocation != SetClasspathOperation.ReuseOutputLocation) {
                this.updateOutputLocation();
            }
            v1 = null;
            ** GOTO lbl58
lbl56:
            // 1 sources

            catch (Throwable var7_9) {
                v1 = var6_11 = null;
lbl58:
                // 2 sources

                if (this.identicalRoots || !this.canChangeResources) break block20;
                ** try [egrp 4[TRYBLOCK] [6 : 134->153)] { 
lbl60:
                // 1 sources

                this.project.getProject().touch(this.progressMonitor);
lbl62:
                // 1 sources

                catch (CoreException e) {
                    if (!JavaModelManager.CP_RESOLVE_VERBOSE) break block20;
                    System.out.println("CPInit - FAILED to touch project: " + this.project.getElementName());
                    e.printStackTrace();
                }
            }
        }
        this.done();
    }

    protected void generateClasspathChangeDeltas() {
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        boolean needToUpdateDependents = false;
        JavaElementDelta delta = new JavaElementDelta(this.getJavaModel());
        boolean hasDelta = false;
        int oldLength = this.oldResolvedPath.length;
        int newLength = this.newResolvedPath.length;
        final IndexManager indexManager = manager.getIndexManager();
        HashMap<IPath, IPackageFragmentRoot> oldRoots = null;
        IPackageFragmentRoot[] roots = null;
        if (this.project.isOpen()) {
            try {
                roots = this.project.getPackageFragmentRoots();
            }
            catch (JavaModelException javaModelException) {}
        } else {
            Map allRemovedRoots = manager.getDeltaProcessor().removedRoots;
            if (allRemovedRoots != null) {
                roots = (IPackageFragmentRoot[])allRemovedRoots.get(this.project);
            }
        }
        if (roots != null) {
            oldRoots = new HashMap<IPath, IPackageFragmentRoot>();
            int i = 0;
            while (i < roots.length) {
                IPackageFragmentRoot root = roots[i];
                oldRoots.put(root.getPath(), root);
                ++i;
            }
        }
        int i = 0;
        while (i < oldLength) {
            int index = this.classpathContains(this.newResolvedPath, this.oldResolvedPath[i]);
            if (index == -1) {
                if (this.oldResolvedPath[i].getEntryKind() == 2) {
                    needToUpdateDependents = true;
                    this.needCycleCheck = true;
                } else {
                    IPackageFragmentRoot oldRoot;
                    Object[] pkgFragmentRoots = null;
                    if (oldRoots != null && (oldRoot = (IPackageFragmentRoot)oldRoots.get(this.oldResolvedPath[i].getPath())) != null) {
                        pkgFragmentRoots = new IPackageFragmentRoot[]{oldRoot};
                    }
                    if (pkgFragmentRoots == null) {
                        try {
                            ObjectVector accumulatedRoots = new ObjectVector();
                            HashSet<String> rootIDs = new HashSet<String>(5);
                            rootIDs.add(this.project.rootID());
                            this.project.computePackageFragmentRoots(this.oldResolvedPath[i], accumulatedRoots, rootIDs, true, false, false);
                            pkgFragmentRoots = new IPackageFragmentRoot[accumulatedRoots.size()];
                            accumulatedRoots.copyInto(pkgFragmentRoots);
                        }
                        catch (JavaModelException javaModelException) {
                            pkgFragmentRoots = new IPackageFragmentRoot[]{};
                        }
                    }
                    this.addClasspathDeltas((IPackageFragmentRoot[])pkgFragmentRoots, 128, delta);
                    int changeKind = this.oldResolvedPath[i].getEntryKind();
                    needToUpdateDependents |= changeKind == 3 || this.oldResolvedPath[i].isExported();
                    if (indexManager != null) {
                        IClasspathEntry oldEntry = this.oldResolvedPath[i];
                        final IPath path = oldEntry.getPath();
                        switch (changeKind) {
                            case 3: {
                                final char[][] exclusionPatterns = ((ClasspathEntry)oldEntry).fullExclusionPatternChars();
                                this.postAction(new JavaModelOperation.IPostAction(){

                                    public String getID() {
                                        return path.toString();
                                    }

                                    public void run() {
                                        indexManager.removeSourceFolderFromIndex(SetClasspathOperation.this.project, path, exclusionPatterns);
                                    }
                                }, 2);
                                break;
                            }
                            case 1: {
                                final DeltaProcessingState deltaState = manager.deltaState;
                                this.postAction(new JavaModelOperation.IPostAction(){

                                    public String getID() {
                                        return path.toString();
                                    }

                                    public void run() {
                                        if (deltaState.otherRoots.get(path) == null) {
                                            indexManager.discardJobs(path.toString());
                                            indexManager.removeIndex(path);
                                        }
                                    }
                                }, 2);
                            }
                        }
                    }
                    hasDelta = true;
                }
            } else if (this.oldResolvedPath[i].getEntryKind() == 2) {
                this.needCycleCheck |= this.oldResolvedPath[i].isExported() != this.newResolvedPath[index].isExported();
            } else {
                IPath newRootPath;
                IPath oldRootPath;
                int sourceAttachmentRootFlags;
                needToUpdateDependents |= this.oldResolvedPath[i].isExported() != this.newResolvedPath[index].isExported();
                if (index != i) {
                    this.addClasspathDeltas(this.project.computePackageFragmentRoots(this.oldResolvedPath[i]), 256, delta);
                    int changeKind = this.oldResolvedPath[i].getEntryKind();
                    needToUpdateDependents |= changeKind == 3;
                    hasDelta = true;
                }
                IPath newSourcePath = this.newResolvedPath[index].getSourceAttachmentPath();
                int sourceAttachmentFlags = this.getSourceAttachmentDeltaFlag(this.oldResolvedPath[i].getSourceAttachmentPath(), newSourcePath);
                int flags = sourceAttachmentFlags | (sourceAttachmentRootFlags = this.getSourceAttachmentDeltaFlag(oldRootPath = this.oldResolvedPath[i].getSourceAttachmentRootPath(), newRootPath = this.newResolvedPath[index].getSourceAttachmentRootPath()));
                if (flags != 0) {
                    this.addClasspathDeltas(this.project.computePackageFragmentRoots(this.oldResolvedPath[i]), flags, delta);
                    hasDelta = true;
                } else if (oldRootPath == null && newRootPath == null) {
                    IPackageFragmentRoot[] computedRoots = this.project.computePackageFragmentRoots(this.oldResolvedPath[i]);
                    int j = 0;
                    while (j < computedRoots.length) {
                        IPackageFragmentRoot root = computedRoots[j];
                        try {
                            root.close();
                        }
                        catch (JavaModelException javaModelException) {}
                        ((PackageFragmentRoot)root).setSourceAttachmentProperty(null);
                        ++j;
                    }
                }
            }
            ++i;
        }
        i = 0;
        while (i < newLength) {
            int index = this.classpathContains(this.oldResolvedPath, this.newResolvedPath[i]);
            if (index == -1) {
                if (this.newResolvedPath[i].getEntryKind() == 2) {
                    needToUpdateDependents = true;
                    this.needCycleCheck = true;
                } else {
                    this.addClasspathDeltas(this.project.computePackageFragmentRoots(this.newResolvedPath[i]), 64, delta);
                    int changeKind = this.newResolvedPath[i].getEntryKind();
                    if (indexManager != null) {
                        switch (changeKind) {
                            case 1: {
                                boolean pathHasChanged = true;
                                final IPath newPath = this.newResolvedPath[i].getPath();
                                int j = 0;
                                while (j < oldLength) {
                                    IClasspathEntry oldEntry = this.oldResolvedPath[j];
                                    if (oldEntry.getPath().equals((Object)newPath)) {
                                        pathHasChanged = false;
                                        break;
                                    }
                                    ++j;
                                }
                                if (!pathHasChanged) break;
                                this.postAction(new JavaModelOperation.IPostAction(){

                                    public String getID() {
                                        return newPath.toString();
                                    }

                                    public void run() {
                                        indexManager.indexLibrary(newPath, SetClasspathOperation.this.project.getProject());
                                    }
                                }, 2);
                                break;
                            }
                            case 3: {
                                IClasspathEntry entry = this.newResolvedPath[i];
                                final IPath path = entry.getPath();
                                final char[][] exclusionPatterns = ((ClasspathEntry)entry).fullExclusionPatternChars();
                                this.postAction(new JavaModelOperation.IPostAction(){

                                    public String getID() {
                                        return path.toString();
                                    }

                                    public void run() {
                                        indexManager.indexSourceFolder(SetClasspathOperation.this.project, path, exclusionPatterns);
                                    }
                                }, 1);
                            }
                        }
                    }
                    needToUpdateDependents |= changeKind == 3 || this.newResolvedPath[i].isExported();
                    hasDelta = true;
                }
            }
            ++i;
        }
        if (hasDelta) {
            this.addDelta(delta);
        } else {
            this.identicalRoots = true;
        }
        if (needToUpdateDependents) {
            this.updateAffectedProjects(this.project.getProject().getFullPath());
        }
    }

    private int getSourceAttachmentDeltaFlag(IPath oldPath, IPath newPath) {
        if (oldPath == null) {
            if (newPath != null) {
                return 4096;
            }
            return 0;
        }
        if (newPath == null) {
            return 8192;
        }
        if (!oldPath.equals((Object)newPath)) {
            return 12288;
        }
        return 0;
    }

    public boolean isReadOnly() {
        return !this.canChangeResources;
    }

    protected void saveClasspathIfNecessary() throws JavaModelException {
        IPath outputLocationForSave;
        if (!this.canChangeResources || !this.needSave) {
            return;
        }
        IClasspathEntry[] classpathForSave = this.newRawPath == ReuseClasspath || this.newRawPath == UpdateClasspath ? this.project.getRawClasspath() : this.newRawPath;
        if (this.project.saveClasspath(classpathForSave, outputLocationForSave = this.newOutputLocation == ReuseOutputLocation ? this.project.getOutputLocation() : this.newOutputLocation)) {
            this.setAttribute("hasModifiedResource", "true");
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(20);
        buffer.append("SetClasspathOperation\n");
        buffer.append(" - classpath : ");
        if (this.newRawPath == ReuseClasspath) {
            buffer.append("<Reuse Existing Classpath>");
        } else {
            buffer.append("{");
            int i = 0;
            while (i < this.newRawPath.length) {
                if (i > 0) {
                    buffer.append(",");
                }
                IClasspathEntry element = this.newRawPath[i];
                buffer.append(" ").append(element.toString());
                ++i;
            }
        }
        buffer.append("\n - output location : ");
        if (this.newOutputLocation == ReuseOutputLocation) {
            buffer.append("<Reuse Existing Output Location>");
        } else {
            buffer.append(this.newOutputLocation.toString());
        }
        return buffer.toString();
    }

    private void updateClasspath() throws JavaModelException {
        this.beginTask(Util.bind("classpath.settingProgress", this.project.getElementName()), 2);
        this.project.getPerProjectInfo().updateClasspathInformation(this.newRawPath);
        if (this.newResolvedPath == null) {
            this.newResolvedPath = this.project.getResolvedClasspath(true, this.canChangeResources);
        }
        if (this.oldResolvedPath != null) {
            this.generateClasspathChangeDeltas();
        } else {
            this.needCycleCheck = true;
            this.updateAffectedProjects(this.project.getProject().getFullPath());
        }
        this.updateCycleMarkersIfNecessary();
    }

    protected void updateAffectedProjects(IPath prerequisiteProjectPath) {
        this.removeAllPostAction(prerequisiteProjectPath.toString());
        try {
            JavaModel model = JavaModelManager.getJavaModelManager().getJavaModel();
            JavaProject initialProject = this.project;
            IJavaProject[] projects = model.getJavaProjects();
            int i = 0;
            int projectCount = projects.length;
            while (i < projectCount) {
                block7: {
                    try {
                        final JavaProject affectedProject = (JavaProject)projects[i];
                        if (affectedProject.equals(initialProject)) break block7;
                        IClasspathEntry[] classpath = affectedProject.getExpandedClasspath(true);
                        int j = 0;
                        int entryCount = classpath.length;
                        while (j < entryCount) {
                            IClasspathEntry entry = classpath[j];
                            if (entry.getEntryKind() == 2 && entry.getPath().equals((Object)prerequisiteProjectPath)) {
                                this.postAction(new JavaModelOperation.IPostAction(){

                                    public String getID() {
                                        return affectedProject.getPath().toString();
                                    }

                                    public void run() throws JavaModelException {
                                        affectedProject.setRawClasspath(UpdateClasspath, ReuseOutputLocation, SetClasspathOperation.this.progressMonitor, SetClasspathOperation.this.canChangeResources, affectedProject.getResolvedClasspath(true), false, false);
                                    }
                                }, 2);
                                break;
                            }
                            ++j;
                        }
                    }
                    catch (JavaModelException javaModelException) {}
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {}
    }

    protected void updateCycleMarkersIfNecessary() {
        if (!this.needCycleCheck) {
            return;
        }
        if (!this.canChangeResources) {
            return;
        }
        if (!this.project.hasCycleMarker() && !this.project.hasClasspathCycle(this.newResolvedPath)) {
            return;
        }
        this.postAction(new JavaModelOperation.IPostAction(){

            public String getID() {
                return "updateCycleMarkers";
            }

            public void run() throws JavaModelException {
                JavaProject.updateAllCycleMarkers(null);
            }
        }, 2);
    }

    protected void updateOutputLocation() throws JavaModelException {
        JavaModelManager.PerProjectInfo perProjectInfo;
        this.beginTask(Util.bind("classpath.settingOutputLocationProgress", this.project.getElementName()), 2);
        IPath oldLocation = this.project.getOutputLocation();
        boolean deltaToFire = false;
        JavaElementDelta delta = this.newJavaElementDelta();
        ArrayList added = this.determineAffectedPackageFragments(oldLocation);
        Iterator iter = added.iterator();
        while (iter.hasNext()) {
            IPackageFragment frag = (IPackageFragment)iter.next();
            ((IPackageFragmentRoot)frag.getParent()).close();
            if (Util.isExcluded(frag)) continue;
            delta.added(frag);
            deltaToFire = true;
        }
        ArrayList removed = this.determineAffectedPackageFragments(this.newOutputLocation);
        iter = removed.iterator();
        while (iter.hasNext()) {
            IPackageFragment frag = (IPackageFragment)iter.next();
            ((IPackageFragmentRoot)frag.getParent()).close();
            if (Util.isExcluded(frag)) continue;
            delta.removed(frag);
            deltaToFire = true;
        }
        JavaModelManager.PerProjectInfo perProjectInfo2 = perProjectInfo = this.project.getPerProjectInfo();
        synchronized (perProjectInfo2) {
            perProjectInfo.outputLocation = this.newOutputLocation;
        }
        if (deltaToFire) {
            this.addDelta(delta);
        }
        this.worked(1);
    }

    protected void updateProjectReferencesIfNecessary() throws JavaModelException {
        if (!this.canChangeResources) {
            return;
        }
        if (this.newRawPath == ReuseClasspath || this.newRawPath == UpdateClasspath) {
            return;
        }
        String[] oldRequired = this.project.projectPrerequisites(this.oldResolvedPath);
        if (this.newResolvedPath == null) {
            this.newResolvedPath = this.project.getResolvedClasspath(this.newRawPath, null, true, true, null);
        }
        String[] newRequired = this.project.projectPrerequisites(this.newResolvedPath);
        try {
            int newSize;
            HashSet newReferences;
            IProjectDescription description;
            IProject projectResource;
            block13: {
                String projectName;
                projectResource = this.project.getProject();
                description = projectResource.getDescription();
                IProject[] projectReferences = description.getReferencedProjects();
                HashSet<String> oldReferences = new HashSet<String>(projectReferences.length);
                int i = 0;
                while (i < projectReferences.length) {
                    String projectName2 = projectReferences[i].getName();
                    oldReferences.add(projectName2);
                    ++i;
                }
                newReferences = (HashSet)oldReferences.clone();
                int i2 = 0;
                while (i2 < oldRequired.length) {
                    projectName = oldRequired[i2];
                    newReferences.remove(projectName);
                    ++i2;
                }
                i2 = 0;
                while (i2 < newRequired.length) {
                    projectName = newRequired[i2];
                    newReferences.add(projectName);
                    ++i2;
                }
                newSize = newReferences.size();
                if (oldReferences.size() == newSize) {
                    Iterator iter = newReferences.iterator();
                    while (iter.hasNext()) {
                        if (oldReferences.contains(iter.next())) {
                            continue;
                        }
                        break block13;
                    }
                    return;
                }
            }
            String[] requiredProjectNames = new String[newSize];
            int index = 0;
            Iterator iter = newReferences.iterator();
            while (iter.hasNext()) {
                requiredProjectNames[index++] = (String)iter.next();
            }
            Util.sort(requiredProjectNames);
            IProject[] requiredProjectArray = new IProject[newSize];
            IWorkspaceRoot wksRoot = projectResource.getWorkspace().getRoot();
            int i = 0;
            while (i < newSize) {
                requiredProjectArray[i] = wksRoot.getProject(requiredProjectNames[i]);
                ++i;
            }
            description.setReferencedProjects(requiredProjectArray);
            projectResource.setDescription(description, this.progressMonitor);
        }
        catch (CoreException e) {
            throw new JavaModelException(e);
        }
    }

    public IJavaModelStatus verify() {
        IJavaModelStatus status = super.verify();
        if (!status.isOK()) {
            return status;
        }
        if (this.needValidation) {
            IPath outputLocation;
            IClasspathEntry[] entries = this.newRawPath;
            if (entries == ReuseClasspath) {
                try {
                    entries = this.project.getRawClasspath();
                }
                catch (JavaModelException e) {
                    return e.getJavaModelStatus();
                }
            }
            if ((outputLocation = this.newOutputLocation) == ReuseOutputLocation) {
                try {
                    outputLocation = this.project.getOutputLocation();
                }
                catch (JavaModelException e) {
                    return e.getJavaModelStatus();
                }
            }
            return ClasspathEntry.validateClasspath(this.project, entries, outputLocation);
        }
        return JavaModelStatus.VERIFIED_OK;
    }
}

