/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.ITypeNameRequestor;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.compiler.util.SuffixConstants;
import org.eclipse.jdt.internal.core.IJavaElementRequestor;
import org.eclipse.jdt.internal.core.JarPackageFragment;
import org.eclipse.jdt.internal.core.JavaElementRequestor;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.SingleTypeRequestor;
import org.eclipse.jdt.internal.core.util.Util;

public class NameLookup
implements SuffixConstants {
    public static final int ACCEPT_CLASSES = 2;
    public static final int ACCEPT_INTERFACES = 4;
    protected IPackageFragmentRoot[] fPackageFragmentRoots = null;
    protected Map fPackageFragments;
    protected IWorkspace workspace;
    protected ThreadLocal unitsToLookInside = new ThreadLocal();

    public NameLookup(IJavaProject project) throws JavaModelException {
        this.configureFromProject(project);
    }

    protected boolean acceptType(IType type, int acceptFlags) {
        if (acceptFlags == 0) {
            return true;
        }
        try {
            if (type.isClass()) {
                return (acceptFlags & 2) != 0;
            }
            return (acceptFlags & 4) != 0;
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }

    private void configureFromProject(IJavaProject project) throws JavaModelException {
        this.workspace = ResourcesPlugin.getWorkspace();
        this.fPackageFragmentRoots = ((JavaProject)project).getAllPackageFragmentRoots();
        this.fPackageFragments = new HashMap();
        IPackageFragment[] frags = this.getPackageFragmentsInRoots(this.fPackageFragmentRoots, project);
        int i = 0;
        while (i < frags.length) {
            IPackageFragment fragment = frags[i];
            IPackageFragment[] entry = (IPackageFragment[])this.fPackageFragments.get(fragment.getElementName());
            if (entry == null) {
                entry = new IPackageFragment[]{fragment};
                this.fPackageFragments.put(fragment.getElementName(), entry);
            } else {
                IPackageFragment[] copy = new IPackageFragment[entry.length + 1];
                System.arraycopy(entry, 0, copy, 0, entry.length);
                copy[entry.length] = fragment;
                this.fPackageFragments.put(fragment.getElementName(), copy);
            }
            ++i;
        }
    }

    private void findAllTypes(String prefix, boolean partialMatch, int acceptFlags, IJavaElementRequestor requestor) {
        int count = this.fPackageFragmentRoots.length;
        int i = 0;
        while (i < count) {
            block7: {
                if (requestor.isCanceled()) {
                    return;
                }
                IPackageFragmentRoot root = this.fPackageFragmentRoots[i];
                IJavaElement[] packages = null;
                try {
                    packages = root.getChildren();
                }
                catch (JavaModelException javaModelException) {
                    break block7;
                }
                if (packages != null) {
                    int j = 0;
                    int packageCount = packages.length;
                    while (j < packageCount) {
                        if (requestor.isCanceled()) {
                            return;
                        }
                        this.seekTypes(prefix, (IPackageFragment)packages[j], partialMatch, acceptFlags, requestor);
                        ++j;
                    }
                }
            }
            ++i;
        }
    }

    public ICompilationUnit findCompilationUnit(String qualifiedTypeName) {
        String pkgName = "";
        String cuName = qualifiedTypeName;
        int index = qualifiedTypeName.lastIndexOf(46);
        if (index != -1) {
            pkgName = qualifiedTypeName.substring(0, index);
            cuName = qualifiedTypeName.substring(index + 1);
        }
        if ((index = cuName.indexOf(36)) != -1) {
            cuName = cuName.substring(0, index);
        }
        cuName = String.valueOf(cuName) + ".java";
        IPackageFragment[] frags = (IPackageFragment[])this.fPackageFragments.get(pkgName);
        if (frags != null) {
            int i = 0;
            while (i < frags.length) {
                ICompilationUnit cu;
                IPackageFragment frag = frags[i];
                if (!(frag instanceof JarPackageFragment) && (cu = frag.getCompilationUnit(cuName)) != null && cu.exists()) {
                    return cu;
                }
                ++i;
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IPackageFragment findPackageFragment(IPath path) {
        if (!path.isAbsolute()) {
            throw new IllegalArgumentException(Util.bind("path.mustBeAbsolute"));
        }
        IResource possibleFragment = this.workspace.getRoot().findMember(path);
        if (possibleFragment == null) {
            int i = 0;
            while (i < this.fPackageFragmentRoots.length) {
                block15: {
                    IPath rootPath;
                    int matchingCount;
                    IPackageFragmentRoot root = this.fPackageFragmentRoots[i];
                    if (root.isExternal() && (matchingCount = (rootPath = root.getPath()).matchingFirstSegments(path)) != 0) {
                        String name = path.toOSString();
                        name = name.substring(rootPath.toOSString().length() + 1, name.length());
                        name = name.replace(File.separatorChar, '.');
                        IJavaElement[] list = null;
                        try {
                            list = root.getChildren();
                        }
                        catch (JavaModelException javaModelException) {
                            break block15;
                        }
                        int elementCount = list.length;
                        int j = 0;
                        while (j < elementCount) {
                            IPackageFragment packageFragment = (IPackageFragment)list[j];
                            if (this.nameMatches(name, packageFragment, false)) {
                                return packageFragment;
                            }
                            ++j;
                        }
                    }
                }
                ++i;
            }
            return null;
        }
        IJavaElement fromFactory = JavaCore.create(possibleFragment);
        if (fromFactory == null) {
            return null;
        }
        if (fromFactory instanceof IPackageFragment) {
            return (IPackageFragment)fromFactory;
        }
        if (!(fromFactory instanceof IJavaProject)) return null;
        JavaProject project = (JavaProject)fromFactory;
        try {
            IClasspathEntry entry = project.getClasspathEntryFor(path);
            if (entry == null) return null;
            IPackageFragmentRoot root = project.getPackageFragmentRoot(project.getResource());
            IPackageFragment[] pkgs = (IPackageFragment[])this.fPackageFragments.get("");
            if (pkgs == null) {
                return null;
            }
            int i = 0;
            while (i < pkgs.length) {
                if (pkgs[i].getParent().equals(root)) {
                    return pkgs[i];
                }
                ++i;
            }
            return null;
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    public IPackageFragment[] findPackageFragments(String name, boolean partialMatch) {
        int count = this.fPackageFragmentRoots.length;
        if (partialMatch) {
            name = name.toLowerCase();
            int i = 0;
            while (i < count) {
                block11: {
                    IPackageFragmentRoot root = this.fPackageFragmentRoots[i];
                    IJavaElement[] list = null;
                    try {
                        list = root.getChildren();
                    }
                    catch (JavaModelException javaModelException) {
                        break block11;
                    }
                    int elementCount = list.length;
                    IPackageFragment[] result = new IPackageFragment[elementCount];
                    int resultLength = 0;
                    int j = 0;
                    while (j < elementCount) {
                        IPackageFragment packageFragment = (IPackageFragment)list[j];
                        if (this.nameMatches(name, packageFragment, true)) {
                            result[resultLength++] = packageFragment;
                        }
                        ++j;
                    }
                    if (resultLength > 0) {
                        IPackageFragment[] iPackageFragmentArray = result;
                        result = new IPackageFragment[resultLength];
                        System.arraycopy(iPackageFragmentArray, 0, result, 0, resultLength);
                        return result;
                    }
                    return null;
                }
                ++i;
            }
        } else {
            IPackageFragment[] fragments = (IPackageFragment[])this.fPackageFragments.get(name);
            if (fragments != null) {
                IPackageFragment[] result = new IPackageFragment[fragments.length];
                int resultLength = 0;
                int i = 0;
                while (i < fragments.length) {
                    IPackageFragment packageFragment = fragments[i];
                    result[resultLength++] = packageFragment;
                    ++i;
                }
                if (resultLength > 0) {
                    IPackageFragment[] iPackageFragmentArray = result;
                    result = new IPackageFragment[resultLength];
                    System.arraycopy(iPackageFragmentArray, 0, result, 0, resultLength);
                    return result;
                }
                return null;
            }
        }
        return null;
    }

    public IType findType(String typeName, String packageName, boolean partialMatch, int acceptFlags) {
        if (packageName == null || packageName.length() == 0) {
            packageName = "";
        } else if (typeName.length() > 0 && Character.isLowerCase(typeName.charAt(0)) && this.findPackageFragments(String.valueOf(packageName) + "." + typeName, false) != null) {
            return null;
        }
        JavaElementRequestor elementRequestor = new JavaElementRequestor();
        this.seekPackageFragments(packageName, false, elementRequestor);
        IPackageFragment[] packages = elementRequestor.getPackageFragments();
        int i = 0;
        int length = packages.length;
        while (i < length) {
            IType type = this.findType(typeName, packages[i], partialMatch, acceptFlags);
            if (type != null) {
                return type;
            }
            ++i;
        }
        return null;
    }

    private IPackageFragment[] getPackageFragmentsInRoots(IPackageFragmentRoot[] roots, IJavaProject project) {
        ArrayList<IJavaElement> frags = new ArrayList<IJavaElement>();
        int i = 0;
        while (i < roots.length) {
            IPackageFragmentRoot root = roots[i];
            try {
                IJavaElement[] children = root.getChildren();
                int length = children.length;
                if (length != 0) {
                    int j;
                    if (children[0].getParent().getParent().equals(project)) {
                        j = 0;
                        while (j < length) {
                            frags.add(children[j]);
                            ++j;
                        }
                    } else {
                        j = 0;
                        while (j < length) {
                            frags.add(root.getPackageFragment(children[j].getElementName()));
                            ++j;
                        }
                    }
                }
            }
            catch (JavaModelException javaModelException) {}
            ++i;
        }
        IPackageFragment[] fragments = new IPackageFragment[frags.size()];
        frags.toArray(fragments);
        return fragments;
    }

    public IType findType(String name, IPackageFragment pkg, boolean partialMatch, int acceptFlags) {
        if (pkg == null) {
            return null;
        }
        SingleTypeRequestor typeRequestor = new SingleTypeRequestor();
        this.seekTypes(name, pkg, partialMatch, acceptFlags, typeRequestor);
        IType type = typeRequestor.getType();
        return type;
    }

    IType findSecondaryType(String typeName, IPackageFragment pkg, boolean partialMatch, final int acceptFlags) {
        try {
            final ArrayList paths = new ArrayList();
            ITypeNameRequestor nameRequestor = new ITypeNameRequestor(){

                public void acceptClass(char[] packageName, char[] simpleTypeName, char[][] enclosingTypeNames, String path) {
                    if ((acceptFlags & 2) != 0 && (enclosingTypeNames == null || enclosingTypeNames.length == 0)) {
                        paths.add(path);
                    }
                }

                public void acceptInterface(char[] packageName, char[] simpleTypeName, char[][] enclosingTypeNames, String path) {
                    if ((acceptFlags & 4) != 0 && (enclosingTypeNames == null || enclosingTypeNames.length == 0)) {
                        paths.add(path);
                    }
                }
            };
            new SearchEngine().searchAllTypeNames(this.workspace, pkg.getElementName().toCharArray(), typeName.toCharArray(), partialMatch ? 1 : 0, !partialMatch, 0, SearchEngine.createJavaSearchScope(new IJavaElement[]{pkg}, false), nameRequestor, 2, null);
            if (!paths.isEmpty()) {
                int i = 0;
                int l = paths.size();
                while (i < l) {
                    String pathname = (String)paths.get(i);
                    if (org.eclipse.jdt.internal.compiler.util.Util.isJavaFileName(pathname)) {
                        IFile file = this.workspace.getRoot().getFile((IPath)new Path(pathname));
                        ICompilationUnit unit = JavaCore.createCompilationUnitFrom(file);
                        return unit.getType(typeName);
                    }
                    ++i;
                }
            }
        }
        catch (JavaModelException javaModelException) {
        }
        catch (OperationCanceledException operationCanceledException) {}
        return null;
    }

    public IType findType(String name, boolean partialMatch, int acceptFlags) {
        int index = name.lastIndexOf(46);
        String className = null;
        String packageName = null;
        if (index == -1) {
            packageName = "";
            className = name;
        } else {
            packageName = name.substring(0, index);
            className = name.substring(index + 1);
        }
        return this.findType(className, packageName, partialMatch, acceptFlags);
    }

    protected boolean nameMatches(String searchName, IJavaElement element, boolean partialMatch) {
        if (partialMatch) {
            return element.getElementName().toLowerCase().startsWith(searchName);
        }
        return element.getElementName().equals(searchName);
    }

    public void seekPackageFragments(String name, boolean partialMatch, IJavaElementRequestor requestor) {
        int count = this.fPackageFragmentRoots.length;
        String matchName = partialMatch ? name.toLowerCase() : name;
        int i = 0;
        while (i < count) {
            block7: {
                if (requestor.isCanceled()) {
                    return;
                }
                IPackageFragmentRoot root = this.fPackageFragmentRoots[i];
                IJavaElement[] list = null;
                try {
                    list = root.getChildren();
                }
                catch (JavaModelException javaModelException) {
                    break block7;
                }
                int elementCount = list.length;
                int j = 0;
                while (j < elementCount) {
                    if (requestor.isCanceled()) {
                        return;
                    }
                    IPackageFragment packageFragment = (IPackageFragment)list[j];
                    if (this.nameMatches(matchName, packageFragment, partialMatch)) {
                        requestor.acceptPackageFragment(packageFragment);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    public void seekTypes(String name, IPackageFragment pkg, boolean partialMatch, int acceptFlags, IJavaElementRequestor requestor) {
        String matchName;
        String string = matchName = partialMatch ? name.toLowerCase() : name;
        if (matchName.indexOf(46) >= 0) {
            matchName = matchName.replace('.', '$');
        }
        if (pkg == null) {
            this.findAllTypes(matchName, partialMatch, acceptFlags, requestor);
            return;
        }
        IPackageFragmentRoot root = (IPackageFragmentRoot)pkg.getParent();
        try {
            int packageFlavor = root.getKind();
            switch (packageFlavor) {
                case 2: {
                    this.seekTypesInBinaryPackage(matchName, pkg, partialMatch, acceptFlags, requestor);
                    break;
                }
                case 1: {
                    this.seekTypesInSourcePackage(matchName, pkg, partialMatch, acceptFlags, requestor);
                    break;
                }
                default: {
                    return;
                }
            }
        }
        catch (JavaModelException javaModelException) {
            return;
        }
    }

    protected void seekTypesInBinaryPackage(String name, IPackageFragment pkg, boolean partialMatch, int acceptFlags, IJavaElementRequestor requestor) {
        IClassFile[] classFiles = null;
        try {
            classFiles = pkg.getClassFiles();
        }
        catch (JavaModelException javaModelException) {
            return;
        }
        int length = classFiles.length;
        String unqualifiedName = name;
        int index = name.lastIndexOf(36);
        if (index != -1 && ((unqualifiedName = name.substring(index + 1, name.length())).length() > 0 && Character.isDigit(unqualifiedName.charAt(0)) || unqualifiedName.length() == 0)) {
            unqualifiedName = name;
        }
        String matchName = partialMatch ? name.toLowerCase() : name;
        int i = 0;
        while (i < length) {
            block10: {
                if (requestor.isCanceled()) {
                    return;
                }
                IClassFile classFile = classFiles[i];
                String elementName = classFile.getElementName();
                if (partialMatch) {
                    elementName = elementName.toLowerCase();
                }
                if (elementName.startsWith(matchName)) {
                    IType type = null;
                    try {
                        type = classFile.getType();
                    }
                    catch (JavaModelException javaModelException) {
                        break block10;
                    }
                    if ((!partialMatch || type.getElementName().length() > 0 && !Character.isDigit(type.getElementName().charAt(0))) && this.nameMatches(unqualifiedName, type, partialMatch) && this.acceptType(type, acceptFlags)) {
                        requestor.acceptType(type);
                    }
                }
            }
            ++i;
        }
    }

    protected void seekTypesInSourcePackage(String name, IPackageFragment pkg, boolean partialMatch, int acceptFlags, IJavaElementRequestor requestor) {
        int index;
        int workingCopiesSize;
        ICompilationUnit[] compilationUnits = null;
        try {
            compilationUnits = pkg.getCompilationUnits();
        }
        catch (JavaModelException javaModelException) {
            return;
        }
        int length = compilationUnits.length;
        boolean[] isWorkingCopy = new boolean[length];
        Map workingCopies = (Map)this.unitsToLookInside.get();
        if (workingCopies != null && (workingCopiesSize = workingCopies.size()) > 0) {
            HashMap temp = new HashMap(workingCopiesSize);
            temp.putAll(workingCopies);
            int i = 0;
            while (i < length) {
                ICompilationUnit unit = compilationUnits[i];
                ICompilationUnit workingCopy = (ICompilationUnit)temp.remove(unit);
                if (workingCopy != null) {
                    compilationUnits[i] = workingCopy;
                    isWorkingCopy[i] = true;
                }
                ++i;
            }
            index = 0;
            Collection values = temp.values();
            Iterator iterator = values.iterator();
            while (iterator.hasNext()) {
                ICompilationUnit workingCopy = (ICompilationUnit)iterator.next();
                if (!pkg.equals(workingCopy.getParent())) continue;
                if (index == 0) {
                    int valuesLength = values.size();
                    index = length;
                    ICompilationUnit[] iCompilationUnitArray = compilationUnits;
                    compilationUnits = new ICompilationUnit[length += valuesLength];
                    System.arraycopy(iCompilationUnitArray, 0, compilationUnits, 0, index);
                    boolean[] blArray = isWorkingCopy;
                    isWorkingCopy = new boolean[length];
                    System.arraycopy(blArray, 0, isWorkingCopy, 0, index);
                }
                isWorkingCopy[index] = true;
                compilationUnits[index++] = workingCopy;
            }
            if (index > 0 && index < length) {
                ICompilationUnit[] iCompilationUnitArray = compilationUnits;
                compilationUnits = new ICompilationUnit[index];
                System.arraycopy(iCompilationUnitArray, 0, compilationUnits, 0, index);
                boolean[] blArray = isWorkingCopy;
                isWorkingCopy = new boolean[index];
                System.arraycopy(blArray, 0, isWorkingCopy, 0, index);
                length = index;
            }
        }
        String matchName = name;
        index = name.indexOf(36);
        boolean potentialMemberType = false;
        String potentialMatchName = null;
        if (index != -1) {
            potentialMatchName = name.substring(0, index);
            potentialMemberType = true;
        }
        String unitName = partialMatch ? matchName.toLowerCase() : String.valueOf(matchName) + ".java";
        String potentialUnitName = null;
        if (potentialMemberType) {
            potentialUnitName = partialMatch ? potentialMatchName.toLowerCase() : String.valueOf(potentialMatchName) + ".java";
        }
        int i = 0;
        while (i < length) {
            block25: {
                IType type;
                int j;
                int typeLength;
                IType[] types;
                if (requestor.isCanceled()) {
                    return;
                }
                ICompilationUnit compilationUnit = compilationUnits[i];
                if (isWorkingCopy[i] && !potentialMemberType || this.nameMatches(unitName, compilationUnit, partialMatch)) {
                    types = null;
                    try {
                        types = compilationUnit.getTypes();
                    }
                    catch (JavaModelException javaModelException) {
                        break block25;
                    }
                    typeLength = types.length;
                    j = 0;
                    while (j < typeLength) {
                        if (requestor.isCanceled()) {
                            return;
                        }
                        type = types[j];
                        if (this.nameMatches(matchName, type, partialMatch) && this.acceptType(type, acceptFlags)) {
                            requestor.acceptType(type);
                        }
                        ++j;
                    }
                } else if (potentialMemberType && this.nameMatches(potentialUnitName, compilationUnit, partialMatch)) {
                    types = null;
                    try {
                        types = compilationUnit.getTypes();
                    }
                    catch (JavaModelException javaModelException) {
                        break block25;
                    }
                    typeLength = types.length;
                    j = 0;
                    while (j < typeLength) {
                        if (requestor.isCanceled()) {
                            return;
                        }
                        type = types[j];
                        if (this.nameMatches(potentialMatchName, type, partialMatch)) {
                            this.seekQualifiedMemberTypes(name.substring(index + 1, name.length()), type, partialMatch, requestor, acceptFlags);
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
    }

    public void setUnitsToLookInside(ICompilationUnit[] unitsToLookInside) {
        if (unitsToLookInside == null) {
            this.unitsToLookInside.set(null);
        } else {
            HashMap<ICompilationUnit, ICompilationUnit> workingCopies = new HashMap<ICompilationUnit, ICompilationUnit>();
            this.unitsToLookInside.set(workingCopies);
            int i = 0;
            int length = unitsToLookInside.length;
            while (i < length) {
                ICompilationUnit unitToLookInside = unitsToLookInside[i];
                ICompilationUnit original = unitToLookInside.getPrimary();
                workingCopies.put(original, unitToLookInside);
                ++i;
            }
        }
    }

    protected void seekQualifiedMemberTypes(String qualifiedName, IType type, boolean partialMatch, IJavaElementRequestor requestor, int acceptFlags) {
        if (type == null) {
            return;
        }
        IType[] types = null;
        try {
            types = type.getTypes();
        }
        catch (JavaModelException javaModelException) {
            return;
        }
        String matchName = qualifiedName;
        int index = qualifiedName.indexOf(36);
        boolean nested = false;
        if (index != -1) {
            matchName = qualifiedName.substring(0, index);
            nested = true;
        }
        int length = types.length;
        int i = 0;
        while (i < length) {
            if (requestor.isCanceled()) {
                return;
            }
            IType memberType = types[i];
            if (this.nameMatches(matchName, memberType, partialMatch)) {
                if (nested) {
                    this.seekQualifiedMemberTypes(qualifiedName.substring(index + 1, qualifiedName.length()), memberType, partialMatch, requestor, acceptFlags);
                } else if (this.acceptType(memberType, acceptFlags)) {
                    requestor.acceptMemberType(memberType);
                }
            }
            ++i;
        }
    }
}

