/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.jdom.IDOMCompilationUnit;
import org.eclipse.jdt.core.jdom.IDOMNode;
import org.eclipse.jdt.internal.core.Assert;
import org.eclipse.jdt.internal.core.JavaElementInfo;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaModelOperation;
import org.eclipse.jdt.internal.core.JavaModelStatus;
import org.eclipse.jdt.internal.core.SourceMapper;
import org.eclipse.jdt.internal.core.SourceRefElement;
import org.eclipse.jdt.internal.core.util.Util;

public abstract class JavaElement
extends PlatformObject
implements IJavaElement {
    public static final char JEM_JAVAPROJECT = '=';
    public static final char JEM_PACKAGEFRAGMENTROOT = '/';
    public static final char JEM_PACKAGEFRAGMENT = '<';
    public static final char JEM_FIELD = '^';
    public static final char JEM_METHOD = '~';
    public static final char JEM_INITIALIZER = '|';
    public static final char JEM_COMPILATIONUNIT = '{';
    public static final char JEM_CLASSFILE = '(';
    public static final char JEM_TYPE = '[';
    public static final char JEM_PACKAGEDECLARATION = '%';
    public static final char JEM_IMPORTDECLARATION = '#';
    public static final char JEM_COUNT = '!';
    public static final char JEM_LOCALVARIABLE = '@';
    public int occurrenceCount = 1;
    protected JavaElement parent;
    protected String name;
    protected static final JavaElement[] NO_ELEMENTS = new JavaElement[0];
    protected static final Object NO_INFO = new Object();

    protected JavaElement(JavaElement parent, String name) throws IllegalArgumentException {
        this.parent = parent;
        this.name = name;
    }

    public void close() throws JavaModelException {
        JavaModelManager.getJavaModelManager().removeInfoAndChildren(this);
    }

    protected abstract void closing(Object var1) throws JavaModelException;

    protected abstract Object createElementInfo();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (this.parent == null) {
            return super.equals(o);
        }
        JavaElement other = (JavaElement)o;
        return this.occurrenceCount == other.occurrenceCount && this.name.equals(other.name) && this.parent.equals(other.parent);
    }

    protected boolean equalsDOMNode(IDOMNode node) {
        return false;
    }

    public boolean exists() {
        try {
            this.getElementInfo();
            return true;
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }

    public IDOMNode findNode(IDOMCompilationUnit dom) {
        int type = this.getElementType();
        if (type == 5 || type == 8 || type == 13 || type == 10 || type == 9 || type == 11 || type == 7) {
            ArrayList<JavaElement> path = new ArrayList<JavaElement>();
            IJavaElement element = this;
            while (element != null && element.getElementType() != 5) {
                if (element.getElementType() != 12) {
                    path.add(0, (JavaElement)element);
                }
                element = element.getParent();
            }
            if (path.size() == 0) {
                if (this.equalsDOMNode(dom)) {
                    return dom;
                }
                return null;
            }
            return ((JavaElement)path.get(0)).followPath(path, 0, dom.getFirstChild());
        }
        return null;
    }

    protected IDOMNode followPath(ArrayList path, int position, IDOMNode node) {
        if (this.equalsDOMNode(node)) {
            if (position == path.size() - 1) {
                return node;
            }
            if (node.getFirstChild() != null) {
                return ((JavaElement)path.get(++position)).followPath(path, position, node.getFirstChild());
            }
            return null;
        }
        if (node.getNextNode() != null) {
            return this.followPath(path, position, node.getNextNode());
        }
        return null;
    }

    protected abstract void generateInfos(Object var1, HashMap var2, IProgressMonitor var3) throws JavaModelException;

    public IJavaElement getAncestor(int ancestorType) {
        IJavaElement element = this;
        while (element != null) {
            if (element.getElementType() == ancestorType) {
                return element;
            }
            element = element.getParent();
        }
        return null;
    }

    public IJavaElement[] getChildren() throws JavaModelException {
        Object elementInfo = this.getElementInfo();
        if (elementInfo instanceof JavaElementInfo) {
            return ((JavaElementInfo)elementInfo).getChildren();
        }
        return NO_ELEMENTS;
    }

    public ArrayList getChildrenOfType(int type) throws JavaModelException {
        IJavaElement[] children = this.getChildren();
        int size = children.length;
        ArrayList<JavaElement> list = new ArrayList<JavaElement>(size);
        int i = 0;
        while (i < size) {
            JavaElement elt = (JavaElement)children[i];
            if (elt.getElementType() == type) {
                list.add(elt);
            }
            ++i;
        }
        return list;
    }

    public IClassFile getClassFile() {
        return null;
    }

    public ICompilationUnit getCompilationUnit() {
        return null;
    }

    public Object getElementInfo() throws JavaModelException {
        return this.getElementInfo(null);
    }

    public Object getElementInfo(IProgressMonitor monitor) throws JavaModelException {
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        Object info = manager.getInfo(this);
        if (info != null) {
            return info;
        }
        return this.openWhenClosed(this.createElementInfo(), monitor);
    }

    public String getElementName() {
        return this.name;
    }

    public abstract IJavaElement getHandleFromMemento(String var1, StringTokenizer var2, WorkingCopyOwner var3);

    public IJavaElement getHandleFromMemento(StringTokenizer memento, WorkingCopyOwner owner) {
        if (!memento.hasMoreTokens()) {
            return this;
        }
        String token = memento.nextToken();
        return this.getHandleFromMemento(token, memento, owner);
    }

    public IJavaElement getHandleUpdatingCountFromMemento(StringTokenizer memento, WorkingCopyOwner owner) {
        this.occurrenceCount = Integer.parseInt(memento.nextToken());
        if (!memento.hasMoreTokens()) {
            return this;
        }
        String token = memento.nextToken();
        return this.getHandleFromMemento(token, memento, owner);
    }

    public String getHandleIdentifier() {
        return this.getHandleMemento();
    }

    public String getHandleMemento() {
        StringBuffer buff = new StringBuffer(((JavaElement)this.getParent()).getHandleMemento());
        buff.append(this.getHandleMementoDelimiter());
        buff.append(this.getElementName());
        if (this.occurrenceCount > 1) {
            buff.append('!');
            buff.append(this.occurrenceCount);
        }
        return buff.toString();
    }

    protected abstract char getHandleMementoDelimiter();

    public IJavaModel getJavaModel() {
        IJavaElement current = this;
        do {
            if (!(current instanceof IJavaModel)) continue;
            return (IJavaModel)current;
        } while ((current = current.getParent()) != null);
        return null;
    }

    public IJavaProject getJavaProject() {
        IJavaElement current = this;
        do {
            if (!(current instanceof IJavaProject)) continue;
            return (IJavaProject)current;
        } while ((current = current.getParent()) != null);
        return null;
    }

    public IOpenable getOpenable() {
        return this.getOpenableParent();
    }

    public IOpenable getOpenableParent() {
        return (IOpenable)((Object)this.parent);
    }

    public IJavaElement getParent() {
        return this.parent;
    }

    public IJavaElement getPrimaryElement() {
        return this.getPrimaryElement(true);
    }

    public IJavaElement getPrimaryElement(boolean checkOwner) {
        return this;
    }

    protected IJavaElement getSourceElementAt(int position) throws JavaModelException {
        if (this instanceof ISourceReference) {
            IJavaElement[] children = this.getChildren();
            int i = 0;
            while (i < children.length) {
                SourceRefElement child;
                ISourceRange range;
                IJavaElement aChild = children[i];
                if (aChild instanceof SourceRefElement && position < (range = (child = (SourceRefElement)children[i]).getSourceRange()).getOffset() + range.getLength() && position >= range.getOffset()) {
                    if (child instanceof IParent) {
                        return child.getSourceElementAt(position);
                    }
                    return child;
                }
                ++i;
            }
        } else {
            Assert.isTrue(false);
        }
        return this;
    }

    public SourceMapper getSourceMapper() {
        return ((JavaElement)this.getParent()).getSourceMapper();
    }

    public boolean hasChildren() throws JavaModelException {
        return this.getChildren().length > 0;
    }

    public int hashCode() {
        if (this.parent == null) {
            return super.hashCode();
        }
        return Util.combineHashCodes(this.name.hashCode(), this.parent.hashCode());
    }

    public boolean isAncestorOf(IJavaElement e) {
        IJavaElement parentElement = e.getParent();
        while (parentElement != null && !parentElement.equals(this)) {
            parentElement = parentElement.getParent();
        }
        return parentElement != null;
    }

    public boolean isReadOnly() {
        return false;
    }

    public boolean isStructureKnown() throws JavaModelException {
        return ((JavaElementInfo)this.getElementInfo()).isStructureKnown();
    }

    protected JavaModelException newNotPresentException() {
        return new JavaModelException(new JavaModelStatus(969, this));
    }

    /*
     * Exception decompiling
     */
    protected Object openWhenClosed(Object info, IProgressMonitor monitor) throws JavaModelException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 133->136)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String readableName() {
        return this.getElementName();
    }

    public static void runOperation(JavaModelOperation operation, IProgressMonitor monitor) throws JavaModelException {
        try {
            if (operation.isReadOnly()) {
                operation.run(monitor);
            } else {
                ResourcesPlugin.getWorkspace().run((IWorkspaceRunnable)operation, monitor);
            }
        }
        catch (CoreException ce) {
            Throwable e;
            if (ce instanceof JavaModelException) {
                throw (JavaModelException)ce;
            }
            if (ce.getStatus().getCode() == 76 && (e = ce.getStatus().getException()) instanceof JavaModelException) {
                throw (JavaModelException)((Object)e);
            }
            throw new JavaModelException(ce);
        }
    }

    protected String tabString(int tab) {
        StringBuffer buffer = new StringBuffer();
        int i = tab;
        while (i > 0) {
            buffer.append("  ");
            --i;
        }
        return buffer.toString();
    }

    public String toDebugString() {
        StringBuffer buffer = new StringBuffer();
        this.toStringInfo(0, buffer, NO_INFO);
        return buffer.toString();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        this.toString(0, buffer);
        return buffer.toString();
    }

    protected void toString(int tab, StringBuffer buffer) {
        Object info = this.toStringInfo(tab, buffer);
        if (tab == 0) {
            this.toStringAncestors(buffer);
        }
        this.toStringChildren(tab, buffer, info);
    }

    public String toStringWithAncestors() {
        StringBuffer buffer = new StringBuffer();
        this.toStringInfo(0, buffer, NO_INFO);
        this.toStringAncestors(buffer);
        return buffer.toString();
    }

    protected void toStringAncestors(StringBuffer buffer) {
        JavaElement parentElement = (JavaElement)this.getParent();
        if (parentElement != null && parentElement.getParent() != null) {
            buffer.append(" [in ");
            parentElement.toStringInfo(0, buffer, NO_INFO);
            parentElement.toStringAncestors(buffer);
            buffer.append("]");
        }
    }

    protected void toStringChildren(int tab, StringBuffer buffer, Object info) {
        if (info == null || !(info instanceof JavaElementInfo)) {
            return;
        }
        IJavaElement[] children = ((JavaElementInfo)info).getChildren();
        int i = 0;
        while (i < children.length) {
            buffer.append("\n");
            ((JavaElement)children[i]).toString(tab + 1, buffer);
            ++i;
        }
    }

    public Object toStringInfo(int tab, StringBuffer buffer) {
        Object info = JavaModelManager.getJavaModelManager().peekAtInfo(this);
        this.toStringInfo(tab, buffer, info);
        return info;
    }

    protected void toStringInfo(int tab, StringBuffer buffer, Object info) {
        buffer.append(this.tabString(tab));
        buffer.append(this.getElementName());
        if (info == null) {
            buffer.append(" (not open)");
        }
    }
}

