/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.problem;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.IErrorHandlingPolicy;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.AbstractVariableDeclaration;
import org.eclipse.jdt.internal.compiler.ast.AllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.ArrayAllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.ArrayReference;
import org.eclipse.jdt.internal.compiler.ast.Assignment;
import org.eclipse.jdt.internal.compiler.ast.BinaryExpression;
import org.eclipse.jdt.internal.compiler.ast.Block;
import org.eclipse.jdt.internal.compiler.ast.BranchStatement;
import org.eclipse.jdt.internal.compiler.ast.CaseStatement;
import org.eclipse.jdt.internal.compiler.ast.CastExpression;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.CompoundAssignment;
import org.eclipse.jdt.internal.compiler.ast.ConditionalExpression;
import org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration;
import org.eclipse.jdt.internal.compiler.ast.EqualExpression;
import org.eclipse.jdt.internal.compiler.ast.ExplicitConstructorCall;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.FieldReference;
import org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.eclipse.jdt.internal.compiler.ast.InstanceOfExpression;
import org.eclipse.jdt.internal.compiler.ast.IntLiteral;
import org.eclipse.jdt.internal.compiler.ast.JavadocSingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.Literal;
import org.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.jdt.internal.compiler.ast.LongLiteral;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.NameReference;
import org.eclipse.jdt.internal.compiler.ast.NumberLiteral;
import org.eclipse.jdt.internal.compiler.ast.QualifiedNameReference;
import org.eclipse.jdt.internal.compiler.ast.Reference;
import org.eclipse.jdt.internal.compiler.ast.ReturnStatement;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.ThisReference;
import org.eclipse.jdt.internal.compiler.ast.ThrowStatement;
import org.eclipse.jdt.internal.compiler.ast.TryStatement;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.ast.UnaryExpression;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.ReferenceContext;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypes;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReasons;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticArgumentBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.parser.Scanner;
import org.eclipse.jdt.internal.compiler.problem.ProblemHandler;
import org.eclipse.jdt.internal.compiler.util.Util;

public class ProblemReporter
extends ProblemHandler
implements ProblemReasons {
    public ReferenceContext referenceContext;

    public ProblemReporter(IErrorHandlingPolicy policy, CompilerOptions options, IProblemFactory problemFactory) {
        super(policy, options, problemFactory);
    }

    public void abortDueToInternalError(String errorMessage) {
        String[] arguments = new String[]{errorMessage};
        this.handle(0, arguments, arguments, 31, 0, 0);
    }

    public void abortDueToInternalError(String errorMessage, ASTNode location) {
        String[] arguments = new String[]{errorMessage};
        this.handle(0, arguments, arguments, 31, location.sourceStart, location.sourceEnd);
    }

    public void abstractMethodCannotBeOverridden(SourceTypeBinding type, MethodBinding concreteMethod) {
        this.handle(67109275, new String[]{new String(type.sourceName()), new String(CharOperation.concat(concreteMethod.declaringClass.readableName(), concreteMethod.readableName(), '.'))}, new String[]{new String(type.sourceName()), new String(CharOperation.concat(concreteMethod.declaringClass.shortReadableName(), concreteMethod.shortReadableName(), '.'))}, type.sourceStart(), type.sourceEnd());
    }

    public void abstractMethodInAbstractClass(SourceTypeBinding type, AbstractMethodDeclaration methodDecl) {
        String[] arguments = new String[]{new String(type.sourceName()), new String(methodDecl.selector)};
        this.handle(67109227, arguments, arguments, methodDecl.sourceStart, methodDecl.sourceEnd);
    }

    public void abstractMethodMustBeImplemented(SourceTypeBinding type, MethodBinding abstractMethod) {
        this.handle(67109264, new String[]{new String(CharOperation.concat(abstractMethod.declaringClass.readableName(), abstractMethod.readableName(), '.'))}, new String[]{new String(CharOperation.concat(abstractMethod.declaringClass.shortReadableName(), abstractMethod.shortReadableName(), '.'))}, type.sourceStart(), type.sourceEnd());
    }

    public void abstractMethodNeedingNoBody(AbstractMethodDeclaration method) {
        this.handle(603979889, ProblemHandler.NoArgument, ProblemHandler.NoArgument, method.sourceStart, method.sourceEnd, method, method.compilationResult());
    }

    public void alreadyDefinedLabel(char[] labelName, ASTNode location) {
        String[] arguments = new String[]{new String(labelName)};
        this.handle(536871083, arguments, arguments, location.sourceStart, location.sourceEnd);
    }

    public void anonymousClassCannotExtendFinalClass(Expression expression, TypeBinding type) {
        this.handle(0x100001D, new String[]{new String(type.readableName())}, new String[]{new String(type.shortReadableName())}, expression.sourceStart, expression.sourceEnd);
    }

    public void argumentTypeCannotBeVoid(SourceTypeBinding type, AbstractMethodDeclaration methodDecl, Argument arg) {
        String[] arguments = new String[]{new String(methodDecl.selector), new String(arg.name)};
        this.handle(67109228, arguments, arguments, methodDecl.sourceStart, methodDecl.sourceEnd);
    }

    public void argumentTypeCannotBeVoidArray(SourceTypeBinding type, AbstractMethodDeclaration methodDecl, Argument arg) {
        String[] arguments = new String[]{new String(methodDecl.selector), new String(arg.name)};
        this.handle(67109229, arguments, arguments, methodDecl.sourceStart, methodDecl.sourceEnd);
    }

    public void argumentTypeProblem(SourceTypeBinding type, AbstractMethodDeclaration methodDecl, Argument arg, TypeBinding expectedType) {
        int id;
        int problemId = expectedType.problemId();
        switch (problemId) {
            case 1: {
                id = 67109234;
                break;
            }
            case 2: {
                id = 67109235;
                break;
            }
            case 3: {
                id = 67109236;
                break;
            }
            case 4: {
                id = 67109237;
                break;
            }
            case 5: {
                id = 67109238;
                break;
            }
            default: {
                this.needImplementation();
                return;
            }
        }
        this.handle(id, new String[]{new String(methodDecl.selector), new String(arg.name), new String(expectedType.readableName())}, new String[]{new String(methodDecl.selector), new String(arg.name), new String(expectedType.shortReadableName())}, arg.type.sourceStart, arg.type.sourceEnd);
    }

    public void arrayConstantsOnlyInArrayInitializers(int sourceStart, int sourceEnd) {
        this.handle(0x600000D0, ProblemHandler.NoArgument, ProblemHandler.NoArgument, sourceStart, sourceEnd);
    }

    public void assignmentHasNoEffect(Assignment assignment, char[] name) {
        String[] arguments = new String[]{new String(name)};
        this.handle(0x200000B2, arguments, arguments, assignment.sourceStart, assignment.sourceEnd);
    }

    public void attemptToReturnNonVoidExpression(ReturnStatement returnStatement, TypeBinding expectedType) {
        this.handle(67108969, new String[]{new String(expectedType.readableName())}, new String[]{new String(expectedType.shortReadableName())}, returnStatement.sourceStart, returnStatement.sourceEnd);
    }

    public void attemptToReturnVoidValue(ReturnStatement returnStatement) {
        this.handle(67108970, ProblemHandler.NoArgument, ProblemHandler.NoArgument, returnStatement.sourceStart, returnStatement.sourceEnd);
    }

    public void bytecodeExceeds64KLimit(AbstractMethodDeclaration location) {
        String[] arguments = new String[]{new String(location.selector), this.parametersAsString(location.binding)};
        if (location.isConstructor()) {
            this.handle(536870981, arguments, arguments, 31, location.sourceStart, location.sourceEnd);
        } else {
            this.handle(536870975, arguments, arguments, 31, location.sourceStart, location.sourceEnd);
        }
    }

    public void bytecodeExceeds64KLimit(TypeDeclaration location) {
        this.handle(0x20000040, ProblemHandler.NoArgument, ProblemHandler.NoArgument, 31, location.sourceStart, location.sourceEnd);
    }

    public void cannotAllocateVoidArray(Expression expression) {
        this.handle(536870966, ProblemHandler.NoArgument, ProblemHandler.NoArgument, expression.sourceStart, expression.sourceEnd);
    }

    public void cannotAssignToFinalField(FieldBinding field, ASTNode location) {
        this.handle(0x2000050, new String[]{field.declaringClass == null ? "array" : new String(field.declaringClass.readableName()), new String(field.readableName())}, new String[]{field.declaringClass == null ? "array" : new String(field.declaringClass.shortReadableName()), new String(field.shortReadableName())}, location.sourceStart, location.sourceEnd);
    }

    public void cannotAssignToFinalLocal(LocalVariableBinding local, ASTNode location) {
        String[] arguments = new String[]{new String(local.readableName())};
        this.handle(536870970, arguments, arguments, location.sourceStart, location.sourceEnd);
    }

    public void cannotAssignToFinalOuterLocal(LocalVariableBinding local, ASTNode location) {
        String[] arguments = new String[]{new String(local.readableName())};
        this.handle(536870972, arguments, arguments, location.sourceStart, location.sourceEnd);
    }

    public void cannotDeclareLocalInterface(char[] interfaceName, int sourceStart, int sourceEnd) {
        String[] arguments = new String[]{new String(interfaceName)};
        this.handle(536870938, arguments, arguments, sourceStart, sourceEnd);
    }

    public void cannotDefineDimensionsAndInitializer(ArrayAllocationExpression expresssion) {
        this.handle(536871070, ProblemHandler.NoArgument, ProblemHandler.NoArgument, expresssion.sourceStart, expresssion.sourceEnd);
    }

    public void cannotDireclyInvokeAbstractMethod(MessageSend messageSend, MethodBinding method) {
        this.handle(67108968, new String[]{new String(method.declaringClass.readableName()), new String(method.selector), this.parametersAsString(method)}, new String[]{new String(method.declaringClass.shortReadableName()), new String(method.selector), this.parametersAsShortString(method)}, messageSend.sourceStart, messageSend.sourceEnd);
    }

    public void cannotImportPackage(ImportReference importRef) {
        String[] arguments = new String[]{CharOperation.toString(importRef.tokens)};
        this.handle(268435843, arguments, arguments, importRef.sourceStart, importRef.sourceEnd);
    }

    public void cannotInstantiate(TypeReference typeRef, TypeBinding type) {
        this.handle(16777373, new String[]{new String(type.readableName())}, new String[]{new String(type.shortReadableName())}, typeRef.sourceStart, typeRef.sourceEnd);
    }

    public void cannotReferToNonFinalOuterLocal(LocalVariableBinding local, ASTNode location) {
        String[] arguments = new String[]{new String(local.readableName())};
        this.handle(536870937, arguments, arguments, location.sourceStart, location.sourceEnd);
    }

    public void cannotReturnInInitializer(ASTNode location) {
        this.handle(0x200000A2, ProblemHandler.NoArgument, ProblemHandler.NoArgument, location.sourceStart, location.sourceEnd);
    }

    public void cannotThrowNull(ThrowStatement statement) {
        this.handle(536871089, ProblemHandler.NoArgument, ProblemHandler.NoArgument, statement.sourceStart, statement.sourceEnd);
    }

    public void cannotThrowType(SourceTypeBinding type, AbstractMethodDeclaration methodDecl, TypeReference exceptionType, TypeBinding expectedType) {
        this.handle(0x1000140, new String[]{new String(expectedType.readableName())}, new String[]{new String(expectedType.shortReadableName())}, exceptionType.sourceStart, exceptionType.sourceEnd);
    }

    public void cannotUseSuperInJavaLangObject(ASTNode reference) {
        this.handle(0x1000001, ProblemHandler.NoArgument, ProblemHandler.NoArgument, reference.sourceStart, reference.sourceEnd);
    }

    public void cannotUseSuperInCodeSnippet(int start, int end) {
        this.handle(536871334, ProblemHandler.NoArgument, ProblemHandler.NoArgument, 31, start, end);
    }

    public void caseExpressionMustBeConstant(Expression expression) {
        this.handle(153, ProblemHandler.NoArgument, ProblemHandler.NoArgument, expression.sourceStart, expression.sourceEnd);
    }

    public void classExtendFinalClass(SourceTypeBinding type, TypeReference superclass, TypeBinding expectedType) {
        String name = new String(type.sourceName());
        String expectedFullName = new String(expectedType.readableName());
        String expectedShortName = new String(expectedType.shortReadableName());
        if (expectedShortName.equals(name)) {
            expectedShortName = expectedFullName;
        }
        this.handle(16777529, new String[]{expectedFullName, name}, new String[]{expectedShortName, name}, superclass.sourceStart, superclass.sourceEnd);
    }

    public void codeSnippetMissingClass(String missing, int start, int end) {
        String[] arguments = new String[]{missing};
        this.handle(536871332, arguments, arguments, 31, start, end);
    }

    public void codeSnippetMissingMethod(String className, String missingMethod, String argumentTypes, int start, int end) {
        String[] arguments = new String[]{className, missingMethod, argumentTypes};
        this.handle(536871333, arguments, arguments, 31, start, end);
    }

    public int computeSeverity(int problemId) {
        switch (problemId) {
            case 16777381: {
                return this.options.getSeverity(32768L);
            }
            case 268435844: {
                return this.options.getSeverity(0x400000L);
            }
            case 67108974: {
                return this.options.getSeverity(4096L);
            }
            case 67109274: {
                return this.options.getSeverity(8192L);
            }
            case 67109277: 
            case 67109278: {
                return this.options.getSeverity(0x4000000L);
            }
            case 0x1000005: 
            case 33554505: 
            case 67108967: 
            case 67109276: 
            case 0x8000085: {
                return this.options.getSeverity(16384L);
            }
            case 536870973: {
                return this.options.getSeverity(65536L);
            }
            case 536870974: {
                return this.options.getSeverity(131072L);
            }
            case 536871063: {
                return this.options.getSeverity(262144L);
            }
            case 33554622: 
            case 33554623: 
            case 0x40000C0: 
            case 67109057: {
                return this.options.getSeverity(524288L);
            }
            case 536871173: {
                return this.options.getSeverity(0x100000L);
            }
            case 536871352: {
                return this.options.getSeverity(0x200000L);
            }
            case 570425420: 
            case 603979893: {
                return this.options.getSeverity(0x800000L);
            }
            case 0x21000012: 
            case 570425422: 
            case 603979895: {
                return this.options.getSeverity(0x100000000L);
            }
            case 0x200000B2: {
                return this.options.getSeverity(0x2000000L);
            }
            case 553648135: 
            case 570425421: 
            case 603979894: 
            case 603979910: {
                return this.options.getSeverity(0x8000000L);
            }
            case 536871362: {
                return 0;
            }
            case 536871002: 
            case 536871006: 
            case 536871007: 
            case 570425435: {
                return this.options.getSeverity(0x10000000L);
            }
            case 570425436: 
            case 570425437: {
                return this.options.getSeverity(0x20000000L);
            }
            case 536871091: {
                return this.options.getSeverity(0x40000000L);
            }
            case 536871092: {
                return this.options.getSeverity(0x80000000L);
            }
            case 536871372: {
                return this.options.getSeverity(0x200000000L);
            }
            case 553648309: 
            case 553648310: 
            case 553648311: {
                return this.options.getSeverity(0x400000000L);
            }
            case 536871096: {
                return this.options.getSeverity(0x1000000000L);
            }
            case 536871097: 
            case 536871098: {
                return this.options.getSeverity(0x2000000000L);
            }
            case 570425423: {
                return this.options.getSeverity(0x4000000000L);
            }
            case -1610612266: 
            case -1610612260: 
            case -1610612257: 
            case -1610612253: 
            case -1610612252: 
            case -1610612251: {
                return this.options.getSeverity(0x800000000L);
            }
            case -2130706430: 
            case -2130706429: 
            case -2130706427: 
            case -2113929146: 
            case -2113929145: 
            case -2113929144: 
            case -2113929143: 
            case -2080374684: 
            case -2080374683: 
            case -2080374681: 
            case -2080374670: 
            case -2080374669: 
            case -2080374668: 
            case -2013265790: 
            case -2013265789: 
            case -2013265787: 
            case -1610612264: 
            case -1610612263: 
            case -1610612262: 
            case -1610612258: 
            case -1610612256: 
            case -1610612255: 
            case -1610612254: {
                if (!this.options.reportInvalidJavadocTags) {
                    return -1;
                }
                return this.options.getSeverity(0x800000000L);
            }
            case -1610612265: 
            case -1610612261: 
            case -1610612259: {
                return this.options.getSeverity(0x8000000000L);
            }
            case -1610612250: {
                return this.options.getSeverity(0x10000000000L);
            }
        }
        return 1;
    }

    public void conditionalArgumentsIncompatibleTypes(ConditionalExpression expression, TypeBinding trueType, TypeBinding falseType) {
        this.handle(0x1000010, new String[]{new String(trueType.readableName()), new String(falseType.readableName())}, new String[]{new String(trueType.sourceName()), new String(falseType.sourceName())}, expression.sourceStart, expression.sourceEnd);
    }

    public void conflictingImport(ImportReference importRef) {
        String[] arguments = new String[]{CharOperation.toString(importRef.tokens)};
        this.handle(0x10000181, arguments, arguments, importRef.sourceStart, importRef.sourceEnd);
    }

    public void constantOutOfFormat(NumberLiteral literal) {
        if (literal instanceof LongLiteral || literal instanceof IntLiteral) {
            char[] source = literal.source();
            try {
                String Radix;
                int radix;
                if (source[1] == 'x' || source[1] == 'X') {
                    radix = 16;
                    Radix = "Hex";
                } else {
                    radix = 8;
                    Radix = "Octal";
                }
                int place = -1;
                int i = radix == 8 ? 1 : 2;
                while (i < source.length) {
                    if (Character.digit(source[i], radix) == -1) {
                        place = i;
                        break;
                    }
                    ++i;
                }
                String[] arguments = new String[]{new String(literal.literalType(null).readableName()), String.valueOf(Radix) + " " + new String(source) + " (digit " + new String(new char[]{source[place]}) + ")"};
                this.handle(536871066, arguments, arguments, literal.sourceStart, literal.sourceEnd);
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.constantOutOfRange(literal, literal.literalType(null));
            }
        }
    }

    public void constantOutOfRange(Literal literal, TypeBinding literalType) {
        String[] arguments = new String[]{new String(literalType.readableName()), new String(literal.source())};
        this.handle(536871066, arguments, arguments, literal.sourceStart, literal.sourceEnd);
    }

    public void deprecatedField(FieldBinding field, ASTNode location) {
        this.handle(33554505, new String[]{new String(field.declaringClass.readableName()), new String(field.name)}, new String[]{new String(field.declaringClass.shortReadableName()), new String(field.name)}, location.sourceStart, location.sourceEnd);
    }

    public void deprecatedMethod(MethodBinding method, ASTNode location) {
        if (method.isConstructor()) {
            this.handle(0x8000085, new String[]{new String(method.declaringClass.readableName()), this.parametersAsString(method)}, new String[]{new String(method.declaringClass.shortReadableName()), this.parametersAsShortString(method)}, location.sourceStart, location.sourceEnd);
        } else {
            this.handle(67108967, new String[]{new String(method.declaringClass.readableName()), new String(method.selector), this.parametersAsString(method)}, new String[]{new String(method.declaringClass.shortReadableName()), new String(method.selector), this.parametersAsShortString(method)}, location.sourceStart, location.sourceEnd);
        }
    }

    public void deprecatedType(TypeBinding type, ASTNode location) {
        if (location == null) {
            return;
        }
        this.handle(0x1000005, new String[]{new String(type.readableName())}, new String[]{new String(type.shortReadableName())}, location.sourceStart, location.sourceEnd);
    }

    public void duplicateCase(CaseStatement caseStatement) {
        this.handle(0x20000AA, ProblemHandler.NoArgument, ProblemHandler.NoArgument, caseStatement.sourceStart, caseStatement.sourceEnd);
    }

    public void duplicateDefaultCase(ASTNode statement) {
        this.handle(166, ProblemHandler.NoArgument, ProblemHandler.NoArgument, statement.sourceStart, statement.sourceEnd);
    }

    public void duplicateFieldInType(SourceTypeBinding type, FieldDeclaration fieldDecl) {
        this.handle(33554772, new String[]{new String(type.sourceName()), new String(fieldDecl.name)}, new String[]{new String(type.shortReadableName()), new String(fieldDecl.name)}, fieldDecl.sourceStart, fieldDecl.sourceEnd);
    }

    public void duplicateImport(ImportReference importRef) {
        String[] arguments = new String[]{CharOperation.toString(importRef.tokens)};
        this.handle(268435842, arguments, arguments, importRef.sourceStart, importRef.sourceEnd);
    }

    public void duplicateInitializationOfBlankFinalField(FieldBinding field, Reference reference) {
        String[] arguments = new String[]{new String(field.readableName())};
        this.handle(0x2000052, arguments, arguments, reference.sourceStart, reference.sourceEnd);
    }

    public void duplicateInitializationOfFinalLocal(LocalVariableBinding local, ASTNode location) {
        String[] arguments = new String[]{new String(local.readableName())};
        this.handle(536870969, arguments, arguments, location.sourceStart, location.sourceEnd);
    }

    public void duplicateMethodInType(SourceTypeBinding type, AbstractMethodDeclaration methodDecl) {
        String[] arguments = new String[]{new String(methodDecl.selector), new String(type.sourceName())};
        this.handle(67109219, arguments, arguments, methodDecl.sourceStart, methodDecl.sourceEnd);
    }

    public void duplicateModifierForField(ReferenceBinding type, FieldDeclaration fieldDecl) {
        String[] arguments = new String[]{new String(fieldDecl.name)};
        this.handle(33554773, arguments, arguments, fieldDecl.sourceStart, fieldDecl.sourceEnd);
    }

    public void duplicateModifierForMethod(ReferenceBinding type, AbstractMethodDeclaration methodDecl) {
        this.handle(67109221, new String[]{new String(type.sourceName()), new String(methodDecl.selector)}, new String[]{new String(type.shortReadableName()), new String(methodDecl.selector)}, methodDecl.sourceStart, methodDecl.sourceEnd);
    }

    public void duplicateModifierForType(SourceTypeBinding type) {
        String[] arguments = new String[]{new String(type.sourceName())};
        this.handle(16777517, arguments, arguments, type.sourceStart(), type.sourceEnd());
    }

    public void duplicateModifierForVariable(LocalDeclaration localDecl, boolean complainForArgument) {
        String[] arguments = new String[]{new String(localDecl.name)};
        this.handle(complainForArgument ? 67109232 : 67109259, arguments, arguments, localDecl.sourceStart, localDecl.sourceEnd);
    }

    public void duplicateNestedType(TypeDeclaration typeDecl) {
        String[] arguments = new String[]{new String(typeDecl.name)};
        this.handle(16777535, arguments, arguments, typeDecl.sourceStart, typeDecl.sourceEnd);
    }

    public void duplicateSuperinterface(SourceTypeBinding type, TypeDeclaration typeDecl, ReferenceBinding superType) {
        this.handle(16777530, new String[]{new String(superType.readableName()), new String(type.sourceName())}, new String[]{new String(superType.shortReadableName()), new String(type.sourceName())}, typeDecl.sourceStart, typeDecl.sourceEnd);
    }

    public void duplicateTypes(CompilationUnitDeclaration compUnitDecl, TypeDeclaration typeDecl) {
        String[] arguments = new String[]{new String(compUnitDecl.getFileName()), new String(typeDecl.name)};
        this.referenceContext = typeDecl;
        this.handle(16777539, arguments, arguments, typeDecl.sourceStart, typeDecl.sourceEnd, compUnitDecl.compilationResult);
    }

    public void errorNoMethodFor(MessageSend messageSend, TypeBinding recType, TypeBinding[] params) {
        StringBuffer buffer = new StringBuffer();
        StringBuffer shortBuffer = new StringBuffer();
        int i = 0;
        int length = params.length;
        while (i < length) {
            if (i != 0) {
                buffer.append(", ");
                shortBuffer.append(", ");
            }
            buffer.append(new String(params[i].readableName()));
            shortBuffer.append(new String(params[i].shortReadableName()));
            ++i;
        }
        int id = recType.isArrayType() ? 0x4000074 : 67108978;
        this.handle(id, new String[]{new String(recType.readableName()), new String(messageSend.selector), buffer.toString()}, new String[]{new String(recType.shortReadableName()), new String(messageSend.selector), shortBuffer.toString()}, messageSend.sourceStart, messageSend.sourceEnd);
    }

    public void errorThisSuperInStatic(ASTNode reference) {
        String[] arguments = new String[]{reference.isSuper() ? "super" : "this"};
        this.handle(536871112, arguments, arguments, reference.sourceStart, reference.sourceEnd);
    }

    public void exceptionTypeProblem(SourceTypeBinding type, AbstractMethodDeclaration methodDecl, TypeReference exceptionType, TypeBinding expectedType) {
        int id;
        int problemId = expectedType.problemId();
        switch (problemId) {
            case 1: {
                id = 67109239;
                break;
            }
            case 2: {
                id = 67109240;
                break;
            }
            case 3: {
                id = 67109241;
                break;
            }
            case 4: {
                id = 67109242;
                break;
            }
            case 5: {
                id = 67109243;
                break;
            }
            default: {
                this.needImplementation();
                return;
            }
        }
        this.handle(id, new String[]{new String(methodDecl.selector), new String(expectedType.readableName())}, new String[]{new String(methodDecl.selector), new String(expectedType.shortReadableName())}, exceptionType.sourceStart, exceptionType.sourceEnd);
    }

    public void expressionShouldBeAVariable(Expression expression) {
        this.handle(1610612959, ProblemHandler.NoArgument, ProblemHandler.NoArgument, expression.sourceStart, expression.sourceEnd);
    }

    public void fieldHiding(FieldDeclaration fieldDecl, Binding hiddenVariable) {
        FieldBinding field = fieldDecl.binding;
        if (hiddenVariable instanceof LocalVariableBinding) {
            this.handle(570425436, new String[]{new String(field.declaringClass.readableName()), new String(field.name)}, new String[]{new String(field.declaringClass.shortReadableName()), new String(field.name)}, fieldDecl.sourceStart, fieldDecl.sourceEnd);
        } else if (hiddenVariable instanceof FieldBinding) {
            FieldBinding hiddenField = (FieldBinding)hiddenVariable;
            this.handle(570425437, new String[]{new String(field.declaringClass.readableName()), new String(field.name), new String(hiddenField.declaringClass.readableName())}, new String[]{new String(field.declaringClass.shortReadableName()), new String(field.name), new String(hiddenField.declaringClass.shortReadableName())}, fieldDecl.sourceStart, fieldDecl.sourceEnd);
        }
    }

    private int fieldLocation(FieldBinding field, ASTNode node) {
        if (node instanceof QualifiedNameReference) {
            QualifiedNameReference ref = (QualifiedNameReference)node;
            FieldBinding[] bindings = ref.otherBindings;
            if (bindings != null) {
                int i = bindings.length;
                while (--i >= 0) {
                    if (bindings[i] != field) continue;
                    return (int)ref.sourcePositions[i + 1];
                }
            }
        }
        return node.sourceEnd;
    }

    public void fieldsOrThisBeforeConstructorInvocation(ThisReference reference) {
        this.handle(0x800008A, ProblemHandler.NoArgument, ProblemHandler.NoArgument, reference.sourceStart, reference.sourceEnd);
    }

    public void fieldTypeProblem(SourceTypeBinding type, FieldDeclaration fieldDecl, TypeBinding expectedType) {
        int id;
        int problemId = expectedType.problemId();
        switch (problemId) {
            case 1: {
                id = 33554782;
                break;
            }
            case 2: {
                id = 33554783;
                break;
            }
            case 3: {
                id = 33554784;
                break;
            }
            case 4: {
                id = 33554785;
                break;
            }
            case 5: {
                id = 33554786;
                break;
            }
            default: {
                this.needImplementation();
                return;
            }
        }
        this.handle(id, new String[]{new String(fieldDecl.name), new String(type.sourceName()), new String(expectedType.readableName())}, new String[]{new String(fieldDecl.name), new String(type.sourceName()), new String(expectedType.shortReadableName())}, fieldDecl.type.sourceStart, fieldDecl.type.sourceEnd);
    }

    public void finallyMustCompleteNormally(Block finallyBlock) {
        this.handle(536871096, ProblemHandler.NoArgument, ProblemHandler.NoArgument, finallyBlock.sourceStart, finallyBlock.sourceEnd);
    }

    public void finalMethodCannotBeOverridden(MethodBinding currentMethod, MethodBinding inheritedMethod) {
        this.handle(67109265, new String[]{new String(inheritedMethod.declaringClass.readableName())}, new String[]{new String(inheritedMethod.declaringClass.shortReadableName())}, currentMethod.sourceStart(), currentMethod.sourceEnd());
    }

    public void forwardReference(Reference reference, int indexInQualification, TypeBinding type) {
        this.handle(570425419, ProblemHandler.NoArgument, ProblemHandler.NoArgument, reference.sourceStart, reference.sourceEnd);
    }

    private void handle(int problemId, String[] problemArguments, String[] messageArguments, int problemStartPosition, int problemEndPosition) {
        this.handle(problemId, problemArguments, messageArguments, problemStartPosition, problemEndPosition, this.referenceContext, this.referenceContext == null ? null : this.referenceContext.compilationResult());
        this.referenceContext = null;
    }

    private void handle(int problemId, String[] problemArguments, String[] messageArguments, int severity, int problemStartPosition, int problemEndPosition) {
        this.handle(problemId, problemArguments, messageArguments, severity, problemStartPosition, problemEndPosition, this.referenceContext, this.referenceContext == null ? null : this.referenceContext.compilationResult());
        this.referenceContext = null;
    }

    private void handle(int problemId, String[] problemArguments, String[] messageArguments, int problemStartPosition, int problemEndPosition, CompilationResult unitResult) {
        this.handle(problemId, problemArguments, messageArguments, problemStartPosition, problemEndPosition, this.referenceContext, unitResult);
        this.referenceContext = null;
    }

    public void hiddenCatchBlock(ReferenceBinding exceptionType, ASTNode location) {
        this.handle(16777381, new String[]{new String(exceptionType.readableName())}, new String[]{new String(exceptionType.shortReadableName())}, location.sourceStart, location.sourceEnd);
    }

    public void hidingEnclosingType(TypeDeclaration typeDecl) {
        String[] arguments = new String[]{new String(typeDecl.name)};
        this.handle(16777534, arguments, arguments, typeDecl.sourceStart, typeDecl.sourceEnd);
    }

    public void hierarchyCircularity(SourceTypeBinding sourceType, ReferenceBinding superType, TypeReference reference) {
        int start = 0;
        int end = 0;
        String typeName = "";
        String shortTypeName = "";
        if (reference == null) {
            start = sourceType.sourceStart();
            end = sourceType.sourceEnd();
            typeName = new String(superType.readableName());
            shortTypeName = new String(superType.sourceName());
        } else {
            start = reference.sourceStart;
            end = reference.sourceEnd;
            char[][] qName = reference.getTypeName();
            typeName = CharOperation.toString(qName);
            shortTypeName = new String(qName[qName.length - 1]);
        }
        if (sourceType == superType) {
            this.handle(16777532, new String[]{new String(sourceType.sourceName()), typeName}, new String[]{new String(sourceType.sourceName()), shortTypeName}, start, end);
        } else {
            this.handle(16777533, new String[]{new String(sourceType.sourceName()), typeName}, new String[]{new String(sourceType.sourceName()), shortTypeName}, start, end);
        }
    }

    public void hierarchyHasProblems(SourceTypeBinding type) {
        String[] arguments = new String[]{new String(type.sourceName())};
        this.handle(16777543, arguments, arguments, type.sourceStart(), type.sourceEnd());
    }

    public void illegalAbstractModifierCombinationForMethod(ReferenceBinding type, AbstractMethodDeclaration methodDecl) {
        String[] arguments = new String[]{new String(type.sourceName()), new String(methodDecl.selector)};
        this.handle(67109226, arguments, arguments, methodDecl.sourceStart, methodDecl.sourceEnd);
    }

    public void illegalModifierCombinationFinalAbstractForClass(SourceTypeBinding type) {
        String[] arguments = new String[]{new String(type.sourceName())};
        this.handle(16777524, arguments, arguments, type.sourceStart(), type.sourceEnd());
    }

    public void illegalModifierCombinationFinalVolatileForField(ReferenceBinding type, FieldDeclaration fieldDecl) {
        String[] arguments = new String[]{new String(fieldDecl.name)};
        this.handle(33554777, arguments, arguments, fieldDecl.sourceStart, fieldDecl.sourceEnd);
    }

    public void illegalModifierForClass(SourceTypeBinding type) {
        String[] arguments = new String[]{new String(type.sourceName())};
        this.handle(16777518, arguments, arguments, type.sourceStart(), type.sourceEnd());
    }

    public void illegalModifierForField(ReferenceBinding type, FieldDeclaration fieldDecl) {
        String[] arguments = new String[]{new String(fieldDecl.name)};
        this.handle(33554774, arguments, arguments, fieldDecl.sourceStart, fieldDecl.sourceEnd);
    }

    public void illegalModifierForInterface(SourceTypeBinding type) {
        String[] arguments = new String[]{new String(type.sourceName())};
        this.handle(16777519, arguments, arguments, type.sourceStart(), type.sourceEnd());
    }

    public void illegalModifierForInterfaceField(ReferenceBinding type, FieldDeclaration fieldDecl) {
        String[] arguments = new String[]{new String(fieldDecl.name)};
        this.handle(33554775, arguments, arguments, fieldDecl.sourceStart, fieldDecl.sourceEnd);
    }

    public void illegalModifierForInterfaceMethod(ReferenceBinding type, AbstractMethodDeclaration methodDecl) {
        String[] arguments = new String[]{new String(type.sourceName()), new String(methodDecl.selector)};
        this.handle(67109223, arguments, arguments, methodDecl.sourceStart, methodDecl.sourceEnd);
    }

    public void illegalModifierForLocalClass(SourceTypeBinding type) {
        String[] arguments = new String[]{new String(type.sourceName())};
        this.handle(16777522, arguments, arguments, type.sourceStart(), type.sourceEnd());
    }

    public void illegalModifierForMemberClass(SourceTypeBinding type) {
        String[] arguments = new String[]{new String(type.sourceName())};
        this.handle(0x1000130, arguments, arguments, type.sourceStart(), type.sourceEnd());
    }

    public void illegalModifierForMemberInterface(SourceTypeBinding type) {
        String[] arguments = new String[]{new String(type.sourceName())};
        this.handle(0x1000131, arguments, arguments, type.sourceStart(), type.sourceEnd());
    }

    public void illegalModifierForMethod(ReferenceBinding type, AbstractMethodDeclaration methodDecl) {
        String[] arguments = new String[]{new String(type.sourceName()), new String(methodDecl.selector)};
        this.handle(67109222, arguments, arguments, methodDecl.sourceStart, methodDecl.sourceEnd);
    }

    public void illegalModifierForVariable(LocalDeclaration localDecl, boolean complainAsArgument) {
        String[] arguments = new String[]{new String(localDecl.name)};
        this.handle(complainAsArgument ? 67109220 : 67109260, arguments, arguments, localDecl.sourceStart, localDecl.sourceEnd);
    }

    public void illegalPrimitiveOrArrayTypeForEnclosingInstance(TypeBinding enclosingType, ASTNode location) {
        this.handle(0x100001B, new String[]{new String(enclosingType.readableName())}, new String[]{new String(enclosingType.shortReadableName())}, location.sourceStart, location.sourceEnd);
    }

    public void illegalStaticModifierForMemberType(SourceTypeBinding type) {
        String[] arguments = new String[]{new String(type.sourceName())};
        this.handle(16777527, arguments, arguments, type.sourceStart(), type.sourceEnd());
    }

    public void illegalVisibilityModifierCombinationForField(ReferenceBinding type, FieldDeclaration fieldDecl) {
        String[] arguments = new String[]{new String(fieldDecl.name)};
        this.handle(33554776, arguments, arguments, fieldDecl.sourceStart, fieldDecl.sourceEnd);
    }

    public void illegalVisibilityModifierCombinationForMemberType(SourceTypeBinding type) {
        String[] arguments = new String[]{new String(type.sourceName())};
        this.handle(16777526, arguments, arguments, type.sourceStart(), type.sourceEnd());
    }

    public void illegalVisibilityModifierCombinationForMethod(ReferenceBinding type, AbstractMethodDeclaration methodDecl) {
        String[] arguments = new String[]{new String(type.sourceName()), new String(methodDecl.selector)};
        this.handle(67109224, arguments, arguments, methodDecl.sourceStart, methodDecl.sourceEnd);
    }

    public void illegalVisibilityModifierForInterfaceMemberType(SourceTypeBinding type) {
        String[] arguments = new String[]{new String(type.sourceName())};
        this.handle(16777525, arguments, arguments, type.sourceStart(), type.sourceEnd());
    }

    public void illegalVoidExpression(ASTNode location) {
        this.handle(536871076, ProblemHandler.NoArgument, ProblemHandler.NoArgument, location.sourceStart, location.sourceEnd);
    }

    public void importProblem(ImportReference importRef, Binding expectedImport) {
        int id;
        int problemId = expectedImport.problemId();
        switch (problemId) {
            case 1: {
                id = 268435846;
                break;
            }
            case 2: {
                id = 268435847;
                break;
            }
            case 3: {
                id = 0x10000188;
                break;
            }
            case 4: {
                id = 268435849;
                break;
            }
            case 5: {
                id = 268435850;
                break;
            }
            default: {
                this.needImplementation();
                return;
            }
        }
        char[][] tokens = expectedImport instanceof ProblemReferenceBinding ? ((ProblemReferenceBinding)expectedImport).compoundName : importRef.tokens;
        String[] arguments = new String[]{CharOperation.toString(tokens)};
        this.handle(id, arguments, arguments, importRef.sourceStart, (int)importRef.sourcePositions[tokens.length - 1]);
    }

    public void incompatibleExceptionInThrowsClause(SourceTypeBinding type, MethodBinding currentMethod, MethodBinding inheritedMethod, ReferenceBinding exceptionType) {
        if (type == currentMethod.declaringClass) {
            int id = currentMethod.declaringClass.isInterface() && !inheritedMethod.isPublic() ? 67109278 : 67109266;
            this.handle(id, new String[]{new String(exceptionType.sourceName()), new String(CharOperation.concat(inheritedMethod.declaringClass.readableName(), inheritedMethod.readableName(), '.'))}, new String[]{new String(exceptionType.sourceName()), new String(CharOperation.concat(inheritedMethod.declaringClass.shortReadableName(), inheritedMethod.shortReadableName(), '.'))}, currentMethod.sourceStart(), currentMethod.sourceEnd());
        } else {
            this.handle(67109267, new String[]{new String(exceptionType.sourceName()), new String(CharOperation.concat(currentMethod.declaringClass.sourceName(), currentMethod.readableName(), '.')), new String(CharOperation.concat(inheritedMethod.declaringClass.readableName(), inheritedMethod.readableName(), '.'))}, new String[]{new String(exceptionType.sourceName()), new String(CharOperation.concat(currentMethod.declaringClass.sourceName(), currentMethod.shortReadableName(), '.')), new String(CharOperation.concat(inheritedMethod.declaringClass.shortReadableName(), inheritedMethod.shortReadableName(), '.'))}, type.sourceStart(), type.sourceEnd());
        }
    }

    public void incompatibleReturnType(MethodBinding currentMethod, MethodBinding inheritedMethod) {
        StringBuffer methodSignature = new StringBuffer();
        methodSignature.append(inheritedMethod.declaringClass.readableName()).append('.').append(inheritedMethod.readableName());
        StringBuffer shortSignature = new StringBuffer();
        shortSignature.append(inheritedMethod.declaringClass.shortReadableName()).append('.').append(inheritedMethod.shortReadableName());
        int id = currentMethod.declaringClass.isInterface() && !inheritedMethod.isPublic() ? 67109277 : 67109268;
        this.handle(id, new String[]{methodSignature.toString()}, new String[]{shortSignature.toString()}, currentMethod.sourceStart(), currentMethod.sourceEnd());
    }

    public void incorrectLocationForEmptyDimension(ArrayAllocationExpression expression, int index) {
        this.handle(536871114, ProblemHandler.NoArgument, ProblemHandler.NoArgument, expression.dimensions[index + 1].sourceStart, expression.dimensions[index + 1].sourceEnd);
    }

    public void indirectAccessToStaticField(ASTNode location, FieldBinding field) {
        this.handle(570425422, new String[]{new String(field.declaringClass.readableName()), new String(field.name)}, new String[]{new String(field.declaringClass.shortReadableName()), new String(field.name)}, location.sourceStart, this.fieldLocation(field, location));
    }

    public void indirectAccessToStaticMethod(ASTNode location, MethodBinding method) {
        this.handle(603979895, new String[]{new String(method.declaringClass.readableName()), new String(method.selector), this.parametersAsString(method)}, new String[]{new String(method.declaringClass.shortReadableName()), new String(method.selector), this.parametersAsShortString(method)}, location.sourceStart, location.sourceEnd);
    }

    public void indirectAccessToStaticType(ASTNode location, ReferenceBinding type) {
        this.handle(603979895, new String[]{new String(type.enclosingType().readableName()), new String(type.sourceName)}, new String[]{new String(type.enclosingType().shortReadableName()), new String(type.sourceName)}, location.sourceStart, location.sourceEnd);
    }

    public void incorrectSwitchType(Expression expression, TypeBinding testType) {
        this.handle(16777385, new String[]{new String(testType.readableName())}, new String[]{new String(testType.shortReadableName())}, expression.sourceStart, expression.sourceEnd);
    }

    public void inheritedMethodReducesVisibility(SourceTypeBinding type, MethodBinding concreteMethod, MethodBinding[] abstractMethods) {
        StringBuffer concreteSignature = new StringBuffer();
        concreteSignature.append(concreteMethod.declaringClass.readableName()).append('.').append(concreteMethod.readableName());
        StringBuffer shortSignature = new StringBuffer();
        shortSignature.append(concreteMethod.declaringClass.shortReadableName()).append('.').append(concreteMethod.shortReadableName());
        this.handle(67109269, new String[]{concreteSignature.toString(), new String(abstractMethods[0].declaringClass.readableName())}, new String[]{new String(shortSignature.toString()), new String(abstractMethods[0].declaringClass.shortReadableName())}, type.sourceStart(), type.sourceEnd());
    }

    public void inheritedMethodsHaveIncompatibleReturnTypes(SourceTypeBinding type, MethodBinding[] inheritedMethods, int length) {
        StringBuffer methodSignatures = new StringBuffer();
        StringBuffer shortSignatures = new StringBuffer();
        int i = length;
        while (--i >= 0) {
            methodSignatures.append(inheritedMethods[i].declaringClass.readableName()).append('.').append(inheritedMethods[i].readableName());
            shortSignatures.append(inheritedMethods[i].declaringClass.shortReadableName()).append('.').append(inheritedMethods[i].shortReadableName());
            if (i == 0) continue;
            methodSignatures.append(", ");
            shortSignatures.append(", ");
        }
        this.handle(67109268, new String[]{methodSignatures.toString()}, new String[]{shortSignatures.toString()}, type.sourceStart(), type.sourceEnd());
    }

    public void initializerMustCompleteNormally(FieldDeclaration fieldDecl) {
        this.handle(536871075, ProblemHandler.NoArgument, ProblemHandler.NoArgument, fieldDecl.sourceStart, fieldDecl.sourceEnd);
    }

    public void innerTypesCannotDeclareStaticInitializers(ReferenceBinding innerType, ASTNode location) {
        this.handle(536870936, new String[]{new String(innerType.readableName())}, new String[]{new String(innerType.shortReadableName())}, location.sourceStart, location.sourceEnd);
    }

    public void interfaceCannotHaveConstructors(ConstructorDeclaration constructor) {
        this.handle(1610612943, ProblemHandler.NoArgument, ProblemHandler.NoArgument, constructor.sourceStart, constructor.sourceEnd, constructor, constructor.compilationResult());
    }

    public void interfaceCannotHaveInitializers(SourceTypeBinding type, FieldDeclaration fieldDecl) {
        String[] arguments = new String[]{new String(type.sourceName())};
        this.handle(16777516, arguments, arguments, fieldDecl.sourceStart, fieldDecl.sourceEnd);
    }

    public void invalidBreak(ASTNode location) {
        this.handle(536871084, ProblemHandler.NoArgument, ProblemHandler.NoArgument, location.sourceStart, location.sourceEnd);
    }

    public void invalidConstructor(Statement statement, MethodBinding targetConstructor) {
        boolean insideDefaultConstructor = this.referenceContext instanceof ConstructorDeclaration && ((ConstructorDeclaration)this.referenceContext).isDefaultConstructor();
        boolean insideImplicitConstructorCall = statement instanceof ExplicitConstructorCall && ((ExplicitConstructorCall)statement).accessMode == 1;
        int id = 0x8000082;
        switch (targetConstructor.problemId()) {
            case 1: {
                if (insideDefaultConstructor) {
                    id = 0x800008C;
                    break;
                }
                if (insideImplicitConstructorCall) {
                    id = 0x800008F;
                    break;
                }
                id = 0x8000082;
                break;
            }
            case 2: {
                if (insideDefaultConstructor) {
                    id = 0x800008D;
                    break;
                }
                if (insideImplicitConstructorCall) {
                    id = 0x8000090;
                    break;
                }
                id = 0x8000083;
                break;
            }
            case 3: {
                if (insideDefaultConstructor) {
                    id = 0x800008E;
                    break;
                }
                if (insideImplicitConstructorCall) {
                    id = 134217873;
                    break;
                }
                id = 0x8000084;
                break;
            }
            default: {
                this.needImplementation();
            }
        }
        this.handle(id, new String[]{new String(targetConstructor.declaringClass.readableName()), this.parametersAsString(targetConstructor)}, new String[]{new String(targetConstructor.declaringClass.shortReadableName()), this.parametersAsShortString(targetConstructor)}, statement.sourceStart, statement.sourceEnd);
    }

    public void invalidExplicitConstructorCall(ASTNode location) {
        this.handle(1207959691, ProblemHandler.NoArgument, ProblemHandler.NoArgument, location.sourceStart, location.sourceEnd);
    }

    public void invalidContinue(ASTNode location) {
        this.handle(536871085, ProblemHandler.NoArgument, ProblemHandler.NoArgument, location.sourceStart, location.sourceEnd);
    }

    public void invalidEnclosingType(Expression expression, TypeBinding type, ReferenceBinding enclosingType) {
        if (enclosingType.isAnonymousType()) {
            enclosingType = enclosingType.superclass();
        }
        int flag = 0x1000002;
        switch (type.problemId()) {
            case 1: {
                flag = 0x1000002;
                break;
            }
            case 2: {
                flag = 0x1000003;
                break;
            }
            case 3: {
                flag = 0x1000004;
                break;
            }
            case 4: {
                flag = 0x1000006;
                break;
            }
            default: {
                this.needImplementation();
            }
        }
        this.handle(flag, new String[]{String.valueOf(new String(enclosingType.readableName())) + "." + new String(type.readableName())}, new String[]{String.valueOf(new String(enclosingType.shortReadableName())) + "." + new String(type.shortReadableName())}, expression.sourceStart, expression.sourceEnd);
    }

    public void invalidExpressionAsStatement(Expression expression) {
        this.handle(1610612958, ProblemHandler.NoArgument, ProblemHandler.NoArgument, expression.sourceStart, expression.sourceEnd);
    }

    public void invalidField(FieldReference fieldRef, TypeBinding searchedType) {
        int id = 33554502;
        FieldBinding field = fieldRef.binding;
        switch (field.problemId()) {
            case 1: {
                id = 33554502;
                break;
            }
            case 2: {
                id = 33554503;
                break;
            }
            case 3: {
                id = 33554504;
                break;
            }
            case 7: {
                id = 33554506;
                break;
            }
            case 6: {
                id = 0x8000087;
                break;
            }
            case 5: {
                id = 33554628;
                break;
            }
            case 8: {
                this.handle(0x1000003, new String[]{new String(searchedType.leafComponentType().readableName())}, new String[]{new String(searchedType.leafComponentType().shortReadableName())}, fieldRef.receiver.sourceStart, fieldRef.receiver.sourceEnd);
                return;
            }
            default: {
                this.needImplementation();
            }
        }
        String[] arguments = new String[]{new String(field.readableName())};
        this.handle(id, arguments, arguments, fieldRef.sourceStart, fieldRef.sourceEnd);
    }

    public void invalidField(NameReference nameRef, FieldBinding field) {
        int id = 33554502;
        switch (field.problemId()) {
            case 1: {
                id = 33554502;
                break;
            }
            case 2: {
                id = 33554503;
                break;
            }
            case 3: {
                id = 33554504;
                break;
            }
            case 7: {
                id = 33554506;
                break;
            }
            case 6: {
                id = 0x8000087;
                break;
            }
            case 5: {
                id = 33554628;
                break;
            }
            case 8: {
                this.handle(0x1000003, new String[]{new String(field.declaringClass.leafComponentType().readableName())}, new String[]{new String(field.declaringClass.leafComponentType().shortReadableName())}, nameRef.sourceStart, nameRef.sourceEnd);
                return;
            }
            default: {
                this.needImplementation();
            }
        }
        String[] arguments = new String[]{new String(field.readableName())};
        this.handle(id, arguments, arguments, nameRef.sourceStart, nameRef.sourceEnd);
    }

    public void invalidField(QualifiedNameReference nameRef, FieldBinding field, int index, TypeBinding searchedType) {
        if (searchedType.isBaseType()) {
            this.handle(0x20000DD, new String[]{new String(searchedType.readableName()), CharOperation.toString(CharOperation.subarray(nameRef.tokens, 0, index)), new String(nameRef.tokens[index])}, new String[]{new String(searchedType.sourceName()), CharOperation.toString(CharOperation.subarray(nameRef.tokens, 0, index)), new String(nameRef.tokens[index])}, nameRef.sourceStart, (int)nameRef.sourcePositions[index]);
            return;
        }
        int id = 33554502;
        switch (field.problemId()) {
            case 1: {
                id = 33554502;
                break;
            }
            case 2: {
                id = 33554503;
                break;
            }
            case 3: {
                id = 33554504;
                break;
            }
            case 7: {
                id = 33554506;
                break;
            }
            case 6: {
                id = 0x8000087;
                break;
            }
            case 5: {
                id = 33554628;
                break;
            }
            case 8: {
                this.handle(0x1000003, new String[]{new String(searchedType.leafComponentType().readableName())}, new String[]{new String(searchedType.leafComponentType().shortReadableName())}, nameRef.sourceStart, nameRef.sourceEnd);
                return;
            }
            default: {
                this.needImplementation();
            }
        }
        String[] arguments = new String[]{CharOperation.toString(CharOperation.subarray(nameRef.tokens, 0, index + 1))};
        this.handle(id, arguments, arguments, nameRef.sourceStart, (int)nameRef.sourcePositions[index]);
    }

    public void invalidMethod(MessageSend messageSend, MethodBinding method) {
        int id = 0x4000064;
        switch (method.problemId()) {
            case 1: {
                id = 0x4000064;
                break;
            }
            case 2: {
                id = 67108965;
                break;
            }
            case 3: {
                id = 0x4000066;
                break;
            }
            case 5: {
                id = 67109059;
                break;
            }
            case 6: {
                id = 0x8000088;
                break;
            }
            case 7: {
                id = 603979977;
                break;
            }
            case 8: {
                this.handle(0x1000003, new String[]{new String(method.declaringClass.leafComponentType().readableName())}, new String[]{new String(method.declaringClass.leafComponentType().shortReadableName())}, messageSend.receiver.sourceStart, messageSend.receiver.sourceEnd);
                return;
            }
            default: {
                this.needImplementation();
            }
        }
        if (id == 0x4000064) {
            ProblemMethodBinding problemMethod = (ProblemMethodBinding)method;
            if (problemMethod.closestMatch != null) {
                String parameterTypeShortNames;
                String closestParameterTypeNames = this.parametersAsString(problemMethod.closestMatch);
                String parameterTypeNames = this.parametersAsString(method);
                String closestParameterTypeShortNames = this.parametersAsShortString(problemMethod.closestMatch);
                if (closestParameterTypeShortNames.equals(parameterTypeShortNames = this.parametersAsShortString(method))) {
                    closestParameterTypeShortNames = closestParameterTypeNames;
                    parameterTypeShortNames = parameterTypeNames;
                }
                id = 67108979;
                this.handle(id, new String[]{new String(problemMethod.closestMatch.declaringClass.readableName()), new String(problemMethod.closestMatch.selector), closestParameterTypeNames, parameterTypeNames}, new String[]{new String(problemMethod.closestMatch.declaringClass.shortReadableName()), new String(problemMethod.closestMatch.selector), closestParameterTypeShortNames, parameterTypeShortNames}, (int)(messageSend.nameSourcePosition >>> 32), (int)messageSend.nameSourcePosition);
                return;
            }
        }
        this.handle(id, new String[]{new String(method.declaringClass.readableName()), new String(method.selector), this.parametersAsString(method)}, new String[]{new String(method.declaringClass.shortReadableName()), new String(method.selector), this.parametersAsShortString(method)}, (int)(messageSend.nameSourcePosition >>> 32), (int)messageSend.nameSourcePosition);
    }

    public void invalidNullToSynchronize(Expression expression) {
        this.handle(0x200000B0, ProblemHandler.NoArgument, ProblemHandler.NoArgument, expression.sourceStart, expression.sourceEnd);
    }

    public void invalidOperator(BinaryExpression expression, TypeBinding leftType, TypeBinding rightType) {
        String rightShortName;
        String leftName = new String(leftType.readableName());
        String rightName = new String(rightType.readableName());
        String leftShortName = new String(leftType.shortReadableName());
        if (leftShortName.equals(rightShortName = new String(rightType.shortReadableName()))) {
            leftShortName = leftName;
            rightShortName = rightName;
        }
        this.handle(0x200000A0, new String[]{expression.operatorToString(), String.valueOf(leftName) + ", " + rightName}, new String[]{expression.operatorToString(), String.valueOf(leftShortName) + ", " + rightShortName}, expression.sourceStart, expression.sourceEnd);
    }

    public void invalidOperator(CompoundAssignment assign, TypeBinding leftType, TypeBinding rightType) {
        String rightShortName;
        String leftName = new String(leftType.readableName());
        String rightName = new String(rightType.readableName());
        String leftShortName = new String(leftType.shortReadableName());
        if (leftShortName.equals(rightShortName = new String(rightType.shortReadableName()))) {
            leftShortName = leftName;
            rightShortName = rightName;
        }
        this.handle(0x200000A0, new String[]{assign.operatorToString(), String.valueOf(leftName) + ", " + rightName}, new String[]{assign.operatorToString(), String.valueOf(leftShortName) + ", " + rightShortName}, assign.sourceStart, assign.sourceEnd);
    }

    public void invalidOperator(UnaryExpression expression, TypeBinding type) {
        this.handle(0x200000A0, new String[]{expression.operatorToString(), new String(type.readableName())}, new String[]{expression.operatorToString(), new String(type.shortReadableName())}, expression.sourceStart, expression.sourceEnd);
    }

    public void invalidParenthesizedExpression(ASTNode reference) {
        this.handle(1610612961, ProblemHandler.NoArgument, ProblemHandler.NoArgument, reference.sourceStart, reference.sourceEnd);
    }

    public void invalidSuperclass(SourceTypeBinding type, TypeReference superclassRef, ReferenceBinding expectedType) {
        int id;
        int problemId = expectedType.problemId();
        switch (problemId) {
            case 1: {
                id = 16777546;
                break;
            }
            case 2: {
                id = 16777547;
                break;
            }
            case 3: {
                id = 16777548;
                break;
            }
            case 4: {
                id = 16777549;
                break;
            }
            case 5: {
                id = 16777550;
                break;
            }
            default: {
                this.needImplementation();
                return;
            }
        }
        this.handle(id, new String[]{new String(expectedType.readableName()), new String(type.sourceName())}, new String[]{new String(expectedType.shortReadableName()), new String(type.sourceName())}, superclassRef.sourceStart, superclassRef.sourceEnd);
    }

    public void invalidSuperinterface(SourceTypeBinding type, TypeReference superinterfaceRef, ReferenceBinding expectedType) {
        int id;
        int problemId = expectedType.problemId();
        switch (problemId) {
            case 1: {
                id = 16777551;
                break;
            }
            case 2: {
                id = 0x1000150;
                break;
            }
            case 3: {
                id = 0x1000151;
                break;
            }
            case 4: {
                id = 16777554;
                break;
            }
            case 5: {
                id = 16777555;
                break;
            }
            default: {
                this.needImplementation();
                return;
            }
        }
        this.handle(id, new String[]{new String(expectedType.readableName()), new String(type.sourceName())}, new String[]{new String(expectedType.shortReadableName()), new String(type.sourceName())}, superinterfaceRef.sourceStart, superinterfaceRef.sourceEnd);
    }

    public void invalidType(ASTNode location, TypeBinding type) {
        int id = 0x1000002;
        switch (type.problemId()) {
            case 1: {
                id = 0x1000002;
                break;
            }
            case 2: {
                id = 0x1000003;
                break;
            }
            case 3: {
                id = 0x1000004;
                break;
            }
            case 4: {
                id = 0x1000006;
                break;
            }
            case 5: {
                id = 16777413;
                break;
            }
            default: {
                this.needImplementation();
            }
        }
        int end = location.sourceEnd;
        if (location instanceof QualifiedNameReference) {
            QualifiedNameReference ref = (QualifiedNameReference)location;
            if (ref.indexOfFirstFieldBinding >= 1) {
                end = (int)ref.sourcePositions[ref.indexOfFirstFieldBinding - 1];
            }
        }
        this.handle(id, new String[]{new String(type.readableName())}, new String[]{new String(type.shortReadableName())}, location.sourceStart, end);
    }

    public void invalidTypeReference(Expression expression) {
        this.handle(536871115, ProblemHandler.NoArgument, ProblemHandler.NoArgument, expression.sourceStart, expression.sourceEnd);
    }

    public void invalidTypeToSynchronize(Expression expression, TypeBinding type) {
        this.handle(536871087, new String[]{new String(type.readableName())}, new String[]{new String(type.shortReadableName())}, expression.sourceStart, expression.sourceEnd);
    }

    public void invalidUnaryExpression(Expression expression) {
        this.handle(1610612942, ProblemHandler.NoArgument, ProblemHandler.NoArgument, expression.sourceStart, expression.sourceEnd);
    }

    public void isClassPathCorrect(char[][] wellKnownTypeName, CompilationUnitDeclaration compUnitDecl) {
        this.referenceContext = compUnitDecl;
        String[] arguments = new String[]{CharOperation.toString(wellKnownTypeName)};
        this.handle(0x1000144, arguments, arguments, 3, compUnitDecl == null ? 0 : compUnitDecl.sourceStart, compUnitDecl == null ? 1 : compUnitDecl.sourceEnd);
    }

    public void javadocDuplicatedReturnTag(int sourceStart, int sourceEnd) {
        this.handle(-1610612260, ProblemHandler.NoArgument, ProblemHandler.NoArgument, sourceStart, sourceEnd);
    }

    public void javadocDeprecatedField(FieldBinding field, ASTNode location, int modifiers) {
        if (this.javadocVisibility(this.options.reportInvalidJavadocTagsVisibility, modifiers)) {
            this.handle(-2113929143, new String[]{new String(field.declaringClass.readableName()), new String(field.name)}, new String[]{new String(field.declaringClass.shortReadableName()), new String(field.name)}, location.sourceStart, location.sourceEnd);
        }
    }

    public void javadocDeprecatedMethod(MethodBinding method, ASTNode location, int modifiers) {
        if (this.javadocVisibility(this.options.reportInvalidJavadocTagsVisibility, modifiers)) {
            if (method.isConstructor()) {
                this.handle(-2013265787, new String[]{new String(method.declaringClass.readableName()), this.parametersAsString(method)}, new String[]{new String(method.declaringClass.shortReadableName()), this.parametersAsShortString(method)}, location.sourceStart, location.sourceEnd);
            } else {
                this.handle(-2080374681, new String[]{new String(method.declaringClass.readableName()), new String(method.selector), this.parametersAsString(method)}, new String[]{new String(method.declaringClass.shortReadableName()), new String(method.selector), this.parametersAsShortString(method)}, location.sourceStart, location.sourceEnd);
            }
        }
    }

    public void javadocDeprecatedType(TypeBinding type, ASTNode location, int modifiers) {
        if (location == null) {
            return;
        }
        if (this.javadocVisibility(this.options.reportInvalidJavadocTagsVisibility, modifiers)) {
            this.handle(-2130706427, new String[]{new String(type.readableName())}, new String[]{new String(type.shortReadableName())}, location.sourceStart, location.sourceEnd);
        }
    }

    public void javadocDuplicatedParamTag(JavadocSingleNameReference param, int modifiers) {
        if (this.javadocVisibility(this.options.reportInvalidJavadocTagsVisibility, modifiers)) {
            String[] arguments = new String[]{String.valueOf(param.token)};
            this.handle(-1610612263, arguments, arguments, param.sourceStart, param.sourceEnd);
        }
    }

    public void javadocDuplicatedThrowsClassName(TypeReference typeReference, int modifiers) {
        if (this.javadocVisibility(this.options.reportInvalidJavadocTagsVisibility, modifiers)) {
            String[] arguments = new String[]{String.valueOf(typeReference.resolvedType.sourceName())};
            this.handle(-1610612256, arguments, arguments, typeReference.sourceStart, typeReference.sourceEnd);
        }
    }

    public void javadocErrorNoMethodFor(MessageSend messageSend, TypeBinding recType, TypeBinding[] params, int modifiers) {
        int id;
        StringBuffer buffer = new StringBuffer();
        StringBuffer shortBuffer = new StringBuffer();
        int i = 0;
        int length = params.length;
        while (i < length) {
            if (i != 0) {
                buffer.append(", ");
                shortBuffer.append(", ");
            }
            buffer.append(new String(params[i].readableName()));
            shortBuffer.append(new String(params[i].shortReadableName()));
            ++i;
        }
        int n = id = recType.isArrayType() ? 0x4000074 : 67108978;
        if (this.javadocVisibility(this.options.reportInvalidJavadocTagsVisibility, modifiers)) {
            this.handle(id | Integer.MIN_VALUE, new String[]{new String(recType.readableName()), new String(messageSend.selector), buffer.toString()}, new String[]{new String(recType.shortReadableName()), new String(messageSend.selector), shortBuffer.toString()}, messageSend.sourceStart, messageSend.sourceEnd);
        }
    }

    public void javadocInvalidConstructor(Statement statement, MethodBinding targetConstructor, int modifiers) {
        if (!this.javadocVisibility(this.options.reportInvalidJavadocTagsVisibility, modifiers)) {
            return;
        }
        boolean insideDefaultConstructor = this.referenceContext instanceof ConstructorDeclaration && ((ConstructorDeclaration)this.referenceContext).isDefaultConstructor();
        boolean insideImplicitConstructorCall = statement instanceof ExplicitConstructorCall && ((ExplicitConstructorCall)statement).accessMode == 1;
        int id = 0x8000082;
        switch (targetConstructor.problemId()) {
            case 1: {
                if (insideDefaultConstructor) {
                    id = 0x800008C;
                    break;
                }
                if (insideImplicitConstructorCall) {
                    id = 0x800008F;
                    break;
                }
                id = 0x8000082;
                break;
            }
            case 2: {
                if (insideDefaultConstructor) {
                    id = 0x800008D;
                    break;
                }
                if (insideImplicitConstructorCall) {
                    id = 0x8000090;
                    break;
                }
                id = 0x8000083;
                break;
            }
            case 3: {
                if (insideDefaultConstructor) {
                    id = 0x800008E;
                    break;
                }
                if (insideImplicitConstructorCall) {
                    id = 134217873;
                    break;
                }
                id = 0x8000084;
                break;
            }
            default: {
                this.needImplementation();
            }
        }
        this.handle(id | Integer.MIN_VALUE, new String[]{new String(targetConstructor.declaringClass.readableName()), this.parametersAsString(targetConstructor)}, new String[]{new String(targetConstructor.declaringClass.shortReadableName()), this.parametersAsShortString(targetConstructor)}, statement.sourceStart, statement.sourceEnd);
    }

    public void javadocInvalidField(FieldReference fieldRef, TypeBinding searchedType, int modifiers) {
        int id = 33554502;
        FieldBinding field = fieldRef.binding;
        switch (field.problemId()) {
            case 1: {
                id = 33554502;
                break;
            }
            case 2: {
                id = 33554503;
                break;
            }
            case 3: {
                id = 33554504;
                break;
            }
            default: {
                this.needImplementation();
            }
        }
        if (this.javadocVisibility(this.options.reportInvalidJavadocTagsVisibility, modifiers)) {
            String[] arguments = new String[]{new String(field.readableName())};
            this.handle(id | Integer.MIN_VALUE, arguments, arguments, fieldRef.sourceStart, fieldRef.sourceEnd);
        }
    }

    public void javadocInvalidMethod(MessageSend messageSend, MethodBinding method, int modifiers) {
        if (!this.javadocVisibility(this.options.reportInvalidJavadocTagsVisibility, modifiers)) {
            return;
        }
        int id = 0x4000064;
        switch (method.problemId()) {
            case 1: {
                id = 0x4000064;
                break;
            }
            case 2: {
                id = 67108965;
                break;
            }
            case 3: {
                id = 0x4000066;
                break;
            }
            default: {
                this.needImplementation();
            }
        }
        if (id == 0x4000064) {
            ProblemMethodBinding problemMethod = (ProblemMethodBinding)method;
            if (problemMethod.closestMatch != null) {
                String parameterTypeShortNames;
                String closestParameterTypeNames = this.parametersAsString(problemMethod.closestMatch);
                String parameterTypeNames = this.parametersAsString(method);
                String closestParameterTypeShortNames = this.parametersAsShortString(problemMethod.closestMatch);
                if (closestParameterTypeShortNames.equals(parameterTypeShortNames = this.parametersAsShortString(method))) {
                    closestParameterTypeShortNames = closestParameterTypeNames;
                    parameterTypeShortNames = parameterTypeNames;
                }
                this.handle(-2080374669, new String[]{new String(problemMethod.closestMatch.declaringClass.readableName()), new String(problemMethod.closestMatch.selector), closestParameterTypeNames, parameterTypeNames}, new String[]{new String(problemMethod.closestMatch.declaringClass.shortReadableName()), new String(problemMethod.closestMatch.selector), closestParameterTypeShortNames, parameterTypeShortNames}, (int)(messageSend.nameSourcePosition >>> 32), (int)messageSend.nameSourcePosition);
                return;
            }
        }
        this.handle(id | Integer.MIN_VALUE, new String[]{new String(method.declaringClass.readableName()), new String(method.selector), this.parametersAsString(method)}, new String[]{new String(method.declaringClass.shortReadableName()), new String(method.selector), this.parametersAsShortString(method)}, (int)(messageSend.nameSourcePosition >>> 32), (int)messageSend.nameSourcePosition);
    }

    public void javadocInvalidParamName(JavadocSingleNameReference param, int modifiers) {
        if (this.javadocVisibility(this.options.reportInvalidJavadocTagsVisibility, modifiers)) {
            String[] arguments = new String[]{String.valueOf(param.token)};
            this.handle(-1610612262, arguments, arguments, param.sourceStart, param.sourceEnd);
        }
    }

    public void javadocInvalidSeeReference(int sourceStart, int sourceEnd) {
        this.handle(-1610612253, ProblemHandler.NoArgument, ProblemHandler.NoArgument, sourceStart, sourceEnd);
    }

    public void javadocInvalidSeeReferenceArgs(int sourceStart, int sourceEnd) {
        this.handle(-1610612251, ProblemHandler.NoArgument, ProblemHandler.NoArgument, sourceStart, sourceEnd);
    }

    public void javadocInvalidSeeUrlReference(int sourceStart, int sourceEnd) {
        this.handle(-1610612252, ProblemHandler.NoArgument, ProblemHandler.NoArgument, sourceStart, sourceEnd);
    }

    public void javadocInvalidThrowsClass(int sourceStart, int sourceEnd) {
        this.handle(-1610612257, ProblemHandler.NoArgument, ProblemHandler.NoArgument, sourceStart, sourceEnd);
    }

    public void javadocInvalidThrowsClassName(TypeReference typeReference, int modifiers) {
        if (this.javadocVisibility(this.options.reportInvalidJavadocTagsVisibility, modifiers)) {
            String[] arguments = new String[]{String.valueOf(typeReference.resolvedType.sourceName())};
            this.handle(-1610612255, arguments, arguments, typeReference.sourceStart, typeReference.sourceEnd);
        }
    }

    public void javadocInvalidType(ASTNode location, TypeBinding type, int modifiers) {
        if (this.javadocVisibility(this.options.reportInvalidJavadocTagsVisibility, modifiers)) {
            int id = 0x1000002;
            switch (type.problemId()) {
                case 1: {
                    id = 0x1000002;
                    break;
                }
                case 2: {
                    id = 0x1000003;
                    break;
                }
                case 3: {
                    id = 0x1000004;
                    break;
                }
                case 4: {
                    id = 0x1000006;
                    break;
                }
                default: {
                    this.needImplementation();
                }
            }
            this.handle(id | Integer.MIN_VALUE, new String[]{new String(type.readableName())}, new String[]{new String(type.shortReadableName())}, location.sourceStart, location.sourceEnd);
        }
    }

    public void javadocMissing(int sourceStart, int sourceEnd, int modifiers) {
        String arg;
        boolean report;
        boolean overriding = (modifiers & 0x30000000) != 0;
        boolean bl = report = this.options.getSeverity(0x10000000000L) != -1 && (!overriding || this.options.reportMissingJavadocCommentsOverriding);
        if (report && (arg = this.javadocVisibilityArgument(this.options.reportMissingJavadocCommentsVisibility, modifiers)) != null) {
            String[] arguments = new String[]{arg};
            this.handle(-1610612250, arguments, arguments, sourceStart, sourceEnd);
        }
    }

    public void javadocMissingParamName(int sourceStart, int sourceEnd) {
        this.handle(-1610612264, ProblemHandler.NoArgument, ProblemHandler.NoArgument, sourceStart, sourceEnd);
    }

    public void javadocMissingParamTag(Argument param, int modifiers) {
        boolean report;
        boolean overriding = (modifiers & 0x30000000) != 0;
        boolean bl = report = this.options.getSeverity(0x8000000000L) != -1 && (!overriding || this.options.reportMissingJavadocTagsOverriding);
        if (report && this.javadocVisibility(this.options.reportMissingJavadocTagsVisibility, modifiers)) {
            String[] arguments = new String[]{String.valueOf(param.name)};
            this.handle(-1610612265, arguments, arguments, param.sourceStart, param.sourceEnd);
        }
    }

    public void javadocMissingReturnTag(int sourceStart, int sourceEnd, int modifiers) {
        boolean report;
        boolean overriding = (modifiers & 0x30000000) != 0;
        boolean bl = report = this.options.getSeverity(0x8000000000L) != -1 && (!overriding || this.options.reportMissingJavadocTagsOverriding);
        if (report && this.javadocVisibility(this.options.reportMissingJavadocTagsVisibility, modifiers)) {
            this.handle(-1610612261, ProblemHandler.NoArgument, ProblemHandler.NoArgument, sourceStart, sourceEnd);
        }
    }

    public void javadocMissingSeeReference(int sourceStart, int sourceEnd) {
        this.handle(-1610612254, ProblemHandler.NoArgument, ProblemHandler.NoArgument, sourceStart, sourceEnd);
    }

    public void javadocMissingThrowsClassName(int sourceStart, int sourceEnd) {
        this.handle(-1610612258, ProblemHandler.NoArgument, ProblemHandler.NoArgument, sourceStart, sourceEnd);
    }

    public void javadocMissingThrowsTag(TypeReference typeRef, int modifiers) {
        boolean report;
        boolean overriding = (modifiers & 0x30000000) != 0;
        boolean bl = report = this.options.getSeverity(0x8000000000L) != -1 && (!overriding || this.options.reportMissingJavadocTagsOverriding);
        if (report && this.javadocVisibility(this.options.reportMissingJavadocTagsVisibility, modifiers)) {
            String[] arguments = new String[]{String.valueOf(typeRef.resolvedType.sourceName())};
            this.handle(-1610612259, arguments, arguments, typeRef.sourceStart, typeRef.sourceEnd);
        }
    }

    public void javadocUnexpectedTag(int sourceStart, int sourceEnd) {
        this.handle(-1610612266, ProblemHandler.NoArgument, ProblemHandler.NoArgument, sourceStart, sourceEnd);
    }

    private boolean javadocVisibility(int visibility, int modifiers) {
        switch (modifiers & 7) {
            case 1: {
                return true;
            }
            case 4: {
                return visibility != 1;
            }
            case 0: {
                return visibility == 0 || visibility == 2;
            }
            case 2: {
                return visibility == 2;
            }
        }
        return true;
    }

    private String javadocVisibilityArgument(int visibility, int modifiers) {
        String argument = null;
        switch (modifiers & 7) {
            case 1: {
                argument = "public";
                break;
            }
            case 4: {
                if (visibility == 1) break;
                argument = "protected";
                break;
            }
            case 0: {
                if (visibility != 0 && visibility != 2) break;
                argument = "default";
                break;
            }
            case 2: {
                if (visibility != 2) break;
                argument = "private";
            }
        }
        return argument;
    }

    public void localVariableHiding(LocalDeclaration local, Binding hiddenVariable, boolean isSpecialArgHidingField) {
        if (hiddenVariable instanceof LocalVariableBinding) {
            String[] arguments = new String[]{new String(local.name)};
            this.handle(local instanceof Argument ? 536871006 : 536871002, arguments, arguments, local.sourceStart, local.sourceEnd);
        } else if (hiddenVariable instanceof FieldBinding) {
            if (isSpecialArgHidingField && !this.options.reportSpecialParameterHidingField) {
                return;
            }
            FieldBinding field = (FieldBinding)hiddenVariable;
            this.handle(local instanceof Argument ? 536871007 : 570425435, new String[]{new String(local.name), new String(field.declaringClass.readableName())}, new String[]{new String(local.name), new String(field.declaringClass.shortReadableName())}, local.sourceStart, local.sourceEnd);
        }
    }

    public void methodNeedingAbstractModifier(MethodDeclaration methodDecl) {
        this.handle(603979883, ProblemHandler.NoArgument, ProblemHandler.NoArgument, methodDecl.sourceStart, methodDecl.sourceEnd);
    }

    public void methodNeedingNoBody(MethodDeclaration methodDecl) {
        this.handle((methodDecl.modifiers & 0x100) != 0 ? 603979888 : 603979889, ProblemHandler.NoArgument, ProblemHandler.NoArgument, methodDecl.sourceStart, methodDecl.sourceEnd);
    }

    public void methodWithConstructorName(MethodDeclaration methodDecl) {
        this.handle(67108974, ProblemHandler.NoArgument, ProblemHandler.NoArgument, methodDecl.sourceStart, methodDecl.sourceEnd);
    }

    public void missingReturnType(AbstractMethodDeclaration methodDecl) {
        this.handle(16777327, ProblemHandler.NoArgument, ProblemHandler.NoArgument, methodDecl.sourceStart, methodDecl.sourceEnd);
    }

    public void missingSemiColon(Expression expression) {
        this.handle(0x600000E0, ProblemHandler.NoArgument, ProblemHandler.NoArgument, expression.sourceStart, expression.sourceEnd);
    }

    public void mustDefineDimensionsOrInitializer(ArrayAllocationExpression expression) {
        this.handle(536871071, ProblemHandler.NoArgument, ProblemHandler.NoArgument, expression.sourceStart, expression.sourceEnd);
    }

    public void mustSpecifyPackage(CompilationUnitDeclaration compUnitDecl) {
        String[] arguments = new String[]{new String(compUnitDecl.getFileName())};
        this.handle(326, arguments, arguments, compUnitDecl.sourceStart, compUnitDecl.sourceStart + 1);
    }

    public void mustUseAStaticMethod(MessageSend messageSend, MethodBinding method) {
        this.handle(603979977, new String[]{new String(method.declaringClass.readableName()), new String(method.selector), this.parametersAsString(method)}, new String[]{new String(method.declaringClass.shortReadableName()), new String(method.selector), this.parametersAsShortString(method)}, messageSend.sourceStart, messageSend.sourceEnd);
    }

    public void nativeMethodsCannotBeStrictfp(ReferenceBinding type, AbstractMethodDeclaration methodDecl) {
        String[] arguments = new String[]{new String(type.sourceName()), new String(methodDecl.selector)};
        this.handle(67109231, arguments, arguments, methodDecl.sourceStart, methodDecl.sourceEnd);
    }

    public void needImplementation() {
        this.abortDueToInternalError(Util.bind("abort.missingCode"));
    }

    public void needToEmulateFieldReadAccess(FieldBinding field, ASTNode location) {
        this.handle(33554622, new String[]{new String(field.declaringClass.readableName()), new String(field.name)}, new String[]{new String(field.declaringClass.shortReadableName()), new String(field.name)}, location.sourceStart, location.sourceEnd);
    }

    public void needToEmulateFieldWriteAccess(FieldBinding field, ASTNode location) {
        this.handle(33554623, new String[]{new String(field.declaringClass.readableName()), new String(field.name)}, new String[]{new String(field.declaringClass.shortReadableName()), new String(field.name)}, location.sourceStart, location.sourceEnd);
    }

    public void needToEmulateMethodAccess(MethodBinding method, ASTNode location) {
        if (method.isConstructor()) {
            this.handle(67109057, new String[]{new String(method.declaringClass.readableName()), this.parametersAsString(method)}, new String[]{new String(method.declaringClass.shortReadableName()), this.parametersAsShortString(method)}, location.sourceStart, location.sourceEnd);
        } else {
            this.handle(0x40000C0, new String[]{new String(method.declaringClass.readableName()), new String(method.selector), this.parametersAsString(method)}, new String[]{new String(method.declaringClass.shortReadableName()), new String(method.selector), this.parametersAsShortString(method)}, location.sourceStart, location.sourceEnd);
        }
    }

    public void nestedClassCannotDeclareInterface(TypeDeclaration typeDecl) {
        String[] arguments = new String[]{new String(typeDecl.name)};
        this.handle(536870938, arguments, arguments, typeDecl.sourceStart, typeDecl.sourceEnd);
    }

    public void noMoreAvailableSpaceForArgument(LocalVariableBinding local, ASTNode location) {
        String[] arguments = new String[]{new String(local.name)};
        this.handle(local instanceof SyntheticArgumentBinding ? 536870979 : 536870977, arguments, arguments, 31, location.sourceStart, location.sourceEnd);
    }

    public void noMoreAvailableSpaceForLocal(LocalVariableBinding local, ASTNode location) {
        String[] arguments = new String[]{new String(local.name)};
        this.handle(0x20000042, arguments, arguments, 31, location.sourceStart, location.sourceEnd);
    }

    public void nonStaticAccessToStaticMethod(ASTNode location, MethodBinding method) {
        this.handle(603979893, new String[]{new String(method.declaringClass.readableName()), new String(method.selector), this.parametersAsString(method)}, new String[]{new String(method.declaringClass.shortReadableName()), new String(method.selector), this.parametersAsShortString(method)}, location.sourceStart, location.sourceEnd);
    }

    public void nonStaticAccessToStaticField(ASTNode location, FieldBinding field) {
        this.handle(570425420, new String[]{new String(field.declaringClass.readableName()), new String(field.name)}, new String[]{new String(field.declaringClass.shortReadableName()), new String(field.name)}, location.sourceStart, this.fieldLocation(field, location));
    }

    public void noSuchEnclosingInstance(TypeBinding targetType, ASTNode location, boolean isConstructorCall) {
        int id = isConstructorCall ? 536870940 : (location instanceof ExplicitConstructorCall && ((ExplicitConstructorCall)location).accessMode == 1 ? 0x1000014 : (location instanceof AllocationExpression && (((AllocationExpression)location).binding.declaringClass.isMemberType() || ((AllocationExpression)location).binding.declaringClass.isAnonymousType() && ((AllocationExpression)location).binding.declaringClass.superclass().isMemberType()) ? 0x1000015 : 0x1000016));
        this.handle(id, new String[]{new String(targetType.readableName())}, new String[]{new String(targetType.shortReadableName())}, location.sourceStart, location.sourceEnd);
    }

    public void notCompatibleTypesError(EqualExpression expression, TypeBinding leftType, TypeBinding rightType) {
        String rightShortName;
        String leftName = new String(leftType.readableName());
        String rightName = new String(rightType.readableName());
        String leftShortName = new String(leftType.shortReadableName());
        if (leftShortName.equals(rightShortName = new String(rightType.shortReadableName()))) {
            leftShortName = leftName;
            rightShortName = rightName;
        }
        this.handle(0x100000F, new String[]{leftName, rightName}, new String[]{leftShortName, rightShortName}, expression.sourceStart, expression.sourceEnd);
    }

    public void notCompatibleTypesError(InstanceOfExpression expression, TypeBinding leftType, TypeBinding rightType) {
        String rightShortName;
        String leftName = new String(leftType.readableName());
        String rightName = new String(rightType.readableName());
        String leftShortName = new String(leftType.shortReadableName());
        if (leftShortName.equals(rightShortName = new String(rightType.shortReadableName()))) {
            leftShortName = leftName;
            rightShortName = rightName;
        }
        this.handle(0x1000010, new String[]{leftName, rightName}, new String[]{leftShortName, rightShortName}, expression.sourceStart, expression.sourceEnd);
    }

    public void objectCannotHaveSuperTypes(SourceTypeBinding type) {
        this.handle(329, ProblemHandler.NoArgument, ProblemHandler.NoArgument, type.sourceStart(), type.sourceEnd());
    }

    public void operatorOnlyValidOnNumericType(CompoundAssignment assignment, TypeBinding leftType, TypeBinding rightType) {
        String rightShortName;
        String leftName = new String(leftType.readableName());
        String rightName = new String(rightType.readableName());
        String leftShortName = new String(leftType.shortReadableName());
        if (leftShortName.equals(rightShortName = new String(rightType.shortReadableName()))) {
            leftShortName = leftName;
            rightShortName = rightName;
        }
        this.handle(0x1000011, new String[]{leftName, rightName}, new String[]{leftShortName, rightShortName}, assignment.sourceStart, assignment.sourceEnd);
    }

    public void overridesDeprecatedMethod(MethodBinding localMethod, MethodBinding inheritedMethod) {
        this.handle(67109276, new String[]{new String(CharOperation.concat(localMethod.declaringClass.readableName(), localMethod.readableName(), '.')), new String(inheritedMethod.declaringClass.readableName())}, new String[]{new String(CharOperation.concat(localMethod.declaringClass.shortReadableName(), localMethod.shortReadableName(), '.')), new String(inheritedMethod.declaringClass.shortReadableName())}, localMethod.sourceStart(), localMethod.sourceEnd());
    }

    public void overridesPackageDefaultMethod(MethodBinding localMethod, MethodBinding inheritedMethod) {
        this.handle(67109274, new String[]{new String(CharOperation.concat(localMethod.declaringClass.readableName(), localMethod.readableName(), '.')), new String(inheritedMethod.declaringClass.readableName())}, new String[]{new String(CharOperation.concat(localMethod.declaringClass.shortReadableName(), localMethod.shortReadableName(), '.')), new String(inheritedMethod.declaringClass.shortReadableName())}, localMethod.sourceStart(), localMethod.sourceEnd());
    }

    public void packageCollidesWithType(CompilationUnitDeclaration compUnitDecl) {
        String[] arguments = new String[]{CharOperation.toString(compUnitDecl.currentPackage.tokens)};
        this.handle(0x1000141, arguments, arguments, compUnitDecl.currentPackage.sourceStart, compUnitDecl.currentPackage.sourceEnd);
    }

    public void packageIsNotExpectedPackage(CompilationUnitDeclaration compUnitDecl) {
        String[] arguments = new String[]{CharOperation.toString(compUnitDecl.compilationResult.compilationUnit.getPackageName())};
        this.handle(328, arguments, arguments, compUnitDecl.currentPackage == null ? 0 : compUnitDecl.currentPackage.sourceStart, compUnitDecl.currentPackage == null ? 0 : compUnitDecl.currentPackage.sourceEnd);
    }

    private String parametersAsString(MethodBinding method) {
        TypeBinding[] params = method.parameters;
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        int length = params.length;
        while (i < length) {
            if (i != 0) {
                buffer.append(", ");
            }
            buffer.append(new String(params[i].readableName()));
            ++i;
        }
        return buffer.toString();
    }

    private String parametersAsShortString(MethodBinding method) {
        TypeBinding[] params = method.parameters;
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        int length = params.length;
        while (i < length) {
            if (i != 0) {
                buffer.append(", ");
            }
            buffer.append(new String(params[i].shortReadableName()));
            ++i;
        }
        return buffer.toString();
    }

    public void parseError(int startPosition, int endPosition, int currentToken, char[] currentTokenSource, String errorTokenName, String[] possibleTokens) {
        if (possibleTokens.length == 0) {
            if (this.isKeyword(currentToken)) {
                String[] arguments = new String[]{new String(currentTokenSource)};
                this.handle(1610612946, arguments, arguments, startPosition, endPosition);
                return;
            }
            String[] arguments = new String[]{errorTokenName};
            this.handle(1610612941, arguments, arguments, startPosition, endPosition);
            return;
        }
        StringBuffer list = new StringBuffer(20);
        int i = 0;
        int max = possibleTokens.length;
        while (i < max) {
            if (i > 0) {
                list.append(", ");
            }
            list.append('\"');
            list.append(possibleTokens[i]);
            list.append('\"');
            ++i;
        }
        if (this.isKeyword(currentToken)) {
            String[] arguments = new String[]{new String(currentTokenSource), list.toString()};
            this.handle(1610612945, arguments, arguments, startPosition, endPosition);
            return;
        }
        if (this.isLiteral(currentToken) || this.isIdentifier(currentToken)) {
            errorTokenName = new String(currentTokenSource);
        }
        String[] arguments = new String[]{errorTokenName, list.toString()};
        this.handle(0x600000CC, arguments, arguments, startPosition, endPosition);
    }

    public void possibleAccidentalBooleanAssignment(Assignment assignment) {
        String[] arguments = new String[]{};
        this.handle(536871091, arguments, arguments, assignment.sourceStart, assignment.sourceEnd);
    }

    public void publicClassMustMatchFileName(CompilationUnitDeclaration compUnitDecl, TypeDeclaration typeDecl) {
        this.referenceContext = typeDecl;
        String[] arguments = new String[]{new String(compUnitDecl.getFileName()), new String(typeDecl.name)};
        this.handle(16777541, arguments, arguments, typeDecl.sourceStart, typeDecl.sourceEnd, compUnitDecl.compilationResult);
    }

    public void recursiveConstructorInvocation(ExplicitConstructorCall constructorCall) {
        this.handle(0x8000089, new String[]{new String(constructorCall.binding.declaringClass.readableName()), this.parametersAsString(constructorCall.binding)}, new String[]{new String(constructorCall.binding.declaringClass.shortReadableName()), this.parametersAsShortString(constructorCall.binding)}, constructorCall.sourceStart, constructorCall.sourceEnd);
    }

    public void redefineArgument(Argument arg) {
        String[] arguments = new String[]{new String(arg.name)};
        this.handle(536870968, arguments, arguments, arg.sourceStart, arg.sourceEnd);
    }

    public void redefineLocal(LocalDeclaration localDecl) {
        String[] arguments = new String[]{new String(localDecl.name)};
        this.handle(536870967, arguments, arguments, localDecl.sourceStart, localDecl.sourceEnd);
    }

    public void referenceMustBeArrayTypeAt(TypeBinding arrayType, ArrayReference arrayRef) {
        this.handle(536871062, new String[]{new String(arrayType.readableName())}, new String[]{new String(arrayType.shortReadableName())}, arrayRef.sourceStart, arrayRef.sourceEnd);
    }

    public void returnTypeCannotBeVoidArray(SourceTypeBinding type, MethodDeclaration methodDecl) {
        String[] arguments = new String[]{new String(methodDecl.selector)};
        this.handle(67109230, arguments, arguments, methodDecl.sourceStart, methodDecl.sourceEnd);
    }

    public void returnTypeProblem(SourceTypeBinding type, MethodDeclaration methodDecl, TypeBinding expectedType) {
        int id;
        int problemId = expectedType.problemId();
        switch (problemId) {
            case 1: {
                id = 67109244;
                break;
            }
            case 2: {
                id = 67109245;
                break;
            }
            case 3: {
                id = 67109246;
                break;
            }
            case 4: {
                id = 67109247;
                break;
            }
            case 5: {
                id = 67109248;
                break;
            }
            default: {
                this.needImplementation();
                return;
            }
        }
        this.handle(id, new String[]{new String(methodDecl.selector), new String(expectedType.readableName())}, new String[]{new String(methodDecl.selector), new String(expectedType.shortReadableName())}, methodDecl.returnType.sourceStart, methodDecl.returnType.sourceEnd);
    }

    public void scannerError(Parser parser, String errorTokenName) {
        String[] stringArray;
        Scanner scanner = parser.scanner;
        int flag = 1610612941;
        int startPos = scanner.startPosition;
        if (errorTokenName.equals("End_Of_Source")) {
            flag = 1610612986;
        } else if (errorTokenName.equals("Invalid_Hexa_Literal")) {
            flag = 1610612987;
        } else if (errorTokenName.equals("Invalid_Octal_Literal")) {
            flag = 1610612988;
        } else if (errorTokenName.equals("Invalid_Character_Constant")) {
            flag = 1610612989;
        } else if (errorTokenName.equals("Invalid_Escape")) {
            flag = 1610612990;
        } else if (errorTokenName.equals("Invalid_Unicode_Escape")) {
            flag = 0x60000100;
            int checkPos = scanner.currentPosition - 1;
            char[] source = scanner.source;
            if (checkPos >= source.length) {
                checkPos = source.length - 1;
            }
            while (checkPos >= startPos) {
                if (source[checkPos] == '\\') break;
                --checkPos;
            }
            startPos = checkPos;
        } else if (errorTokenName.equals("Invalid_Float_Literal")) {
            flag = 0x60000101;
        } else if (errorTokenName.equals("Unterminated_String")) {
            flag = 1610612995;
        } else if (errorTokenName.equals("Unterminated_Comment")) {
            flag = 1610612996;
        } else if (errorTokenName.equals("Invalid_Char_In_String")) {
            flag = 1610612995;
        }
        if (flag == 1610612941) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = errorTokenName;
        } else {
            stringArray = ProblemHandler.NoArgument;
        }
        String[] arguments = stringArray;
        this.handle(flag, arguments, arguments, startPos, scanner.currentPosition - 1, parser.compilationUnit.compilationResult);
    }

    public void shouldReturn(TypeBinding returnType, ASTNode location) {
        this.handle(603979884, new String[]{new String(returnType.readableName())}, new String[]{new String(returnType.shortReadableName())}, location.sourceStart, location.sourceEnd);
    }

    public void signalNoImplicitStringConversionForCharArrayExpression(Expression expression) {
        this.handle(536871063, ProblemHandler.NoArgument, ProblemHandler.NoArgument, expression.sourceStart, expression.sourceEnd);
    }

    public void staticAndInstanceConflict(MethodBinding currentMethod, MethodBinding inheritedMethod) {
        if (currentMethod.isStatic()) {
            this.handle(67109271, new String[]{new String(inheritedMethod.declaringClass.readableName())}, new String[]{new String(inheritedMethod.declaringClass.shortReadableName())}, currentMethod.sourceStart(), currentMethod.sourceEnd());
        } else {
            this.handle(67109270, new String[]{new String(inheritedMethod.declaringClass.readableName())}, new String[]{new String(inheritedMethod.declaringClass.shortReadableName())}, currentMethod.sourceStart(), currentMethod.sourceEnd());
        }
    }

    public void staticFieldAccessToNonStaticVariable(ASTNode location, FieldBinding field) {
        String[] arguments = new String[]{new String(field.readableName())};
        this.handle(33554506, arguments, arguments, location.sourceStart, this.fieldLocation(field, location));
    }

    public void staticInheritedMethodConflicts(SourceTypeBinding type, MethodBinding concreteMethod, MethodBinding[] abstractMethods) {
        this.handle(67109272, new String[]{new String(concreteMethod.readableName()), new String(abstractMethods[0].declaringClass.readableName())}, new String[]{new String(concreteMethod.readableName()), new String(abstractMethods[0].declaringClass.shortReadableName())}, type.sourceStart(), type.sourceEnd());
    }

    public void stringConstantIsExceedingUtf8Limit(ASTNode location) {
        this.handle(536871064, ProblemHandler.NoArgument, ProblemHandler.NoArgument, location.sourceStart, location.sourceEnd);
    }

    public void superclassMustBeAClass(SourceTypeBinding type, TypeReference superclassRef, ReferenceBinding superType) {
        this.handle(16777528, new String[]{new String(superType.readableName()), new String(type.sourceName())}, new String[]{new String(superType.shortReadableName()), new String(type.sourceName())}, superclassRef.sourceStart, superclassRef.sourceEnd);
    }

    public void superfluousSemicolon(int sourceStart, int sourceEnd) {
        this.handle(536871092, ProblemHandler.NoArgument, ProblemHandler.NoArgument, sourceStart, sourceEnd);
    }

    public void superinterfaceMustBeAnInterface(SourceTypeBinding type, TypeDeclaration typeDecl, ReferenceBinding superType) {
        this.handle(16777531, new String[]{new String(superType.readableName()), new String(type.sourceName())}, new String[]{new String(superType.shortReadableName()), new String(type.sourceName())}, typeDecl.sourceStart, typeDecl.sourceEnd);
    }

    public void task(String tag, String message, String priority, int start, int end) {
        this.handle(536871362, new String[]{tag, message, priority}, new String[]{tag, message, priority}, start, end);
    }

    public void tooManyDimensions(ASTNode expression) {
        this.handle(0x20000044, ProblemHandler.NoArgument, ProblemHandler.NoArgument, expression.sourceStart, expression.sourceEnd);
    }

    public void tooManyFields(TypeDeclaration typeDeclaration) {
        this.handle(536871344, new String[]{new String(typeDeclaration.binding.readableName())}, new String[]{new String(typeDeclaration.binding.shortReadableName())}, 31, typeDeclaration.sourceStart, typeDeclaration.sourceEnd);
    }

    public void tooManyMethods(TypeDeclaration typeDeclaration) {
        this.handle(536871345, new String[]{new String(typeDeclaration.binding.readableName())}, new String[]{new String(typeDeclaration.binding.shortReadableName())}, 31, typeDeclaration.sourceStart, typeDeclaration.sourceEnd);
    }

    public void typeCastError(CastExpression expression, TypeBinding leftType, TypeBinding rightType) {
        String rightShortName;
        String leftName = new String(leftType.readableName());
        String rightName = new String(rightType.readableName());
        String leftShortName = new String(leftType.shortReadableName());
        if (leftShortName.equals(rightShortName = new String(rightType.shortReadableName()))) {
            leftShortName = leftName;
            rightShortName = rightName;
        }
        this.handle(16777372, new String[]{rightName, leftName}, new String[]{rightShortName, leftShortName}, expression.sourceStart, expression.sourceEnd);
    }

    public void typeCollidesWithPackage(CompilationUnitDeclaration compUnitDecl, TypeDeclaration typeDecl) {
        this.referenceContext = typeDecl;
        String[] arguments = new String[]{new String(compUnitDecl.getFileName()), new String(typeDecl.name)};
        this.handle(16777538, arguments, arguments, typeDecl.sourceStart, typeDecl.sourceEnd, compUnitDecl.compilationResult);
    }

    public void typeMismatchError(TypeBinding resultType, TypeBinding expectedType, ASTNode location) {
        String expectedTypeShortName;
        String resultTypeName = new String(resultType.readableName());
        String expectedTypeName = new String(expectedType.readableName());
        String resultTypeShortName = new String(resultType.shortReadableName());
        if (resultTypeShortName.equals(expectedTypeShortName = new String(expectedType.shortReadableName()))) {
            resultTypeShortName = resultTypeName;
            expectedTypeShortName = expectedTypeName;
        }
        this.handle(0x1000011, new String[]{resultTypeName, expectedTypeName}, new String[]{resultTypeShortName, expectedTypeShortName}, location.sourceStart, location.sourceEnd);
    }

    public void typeMismatchErrorActualTypeExpectedType(Expression expression, TypeBinding constantType, TypeBinding expectedType) {
        String expectedTypeShortName;
        String constantTypeName = new String(constantType.readableName());
        String expectedTypeName = new String(expectedType.readableName());
        String constantTypeShortName = new String(constantType.shortReadableName());
        if (constantTypeShortName.equals(expectedTypeShortName = new String(expectedType.shortReadableName()))) {
            constantTypeShortName = constantTypeName;
            expectedTypeShortName = expectedTypeName;
        }
        this.handle(0x1000011, new String[]{constantTypeName, expectedTypeName}, new String[]{constantTypeShortName, expectedTypeShortName}, expression.sourceStart, expression.sourceEnd);
    }

    public void undefinedLabel(BranchStatement statement) {
        String[] arguments = new String[]{new String(statement.label)};
        this.handle(536871086, arguments, arguments, statement.sourceStart, statement.sourceEnd);
    }

    public void undocumentedEmptyBlock(int blockStart, int blockEnd) {
        String[] arguments = new String[]{};
        this.handle(536871372, arguments, arguments, blockStart, blockEnd);
    }

    public void unexpectedStaticModifierForField(SourceTypeBinding type, FieldDeclaration fieldDecl) {
        String[] arguments = new String[]{new String(fieldDecl.name)};
        this.handle(33554778, arguments, arguments, fieldDecl.sourceStart, fieldDecl.sourceEnd);
    }

    public void unexpectedStaticModifierForMethod(ReferenceBinding type, AbstractMethodDeclaration methodDecl) {
        String[] arguments = new String[]{new String(type.sourceName()), new String(methodDecl.selector)};
        this.handle(67109225, arguments, arguments, methodDecl.sourceStart, methodDecl.sourceEnd);
    }

    public void unhandledException(TypeBinding exceptionType, ASTNode location) {
        boolean insideImplicitConstructorCall;
        boolean insideDefaultConstructor = this.referenceContext instanceof ConstructorDeclaration && ((ConstructorDeclaration)this.referenceContext).isDefaultConstructor();
        boolean bl = insideImplicitConstructorCall = location instanceof ExplicitConstructorCall && ((ExplicitConstructorCall)location).accessMode == 1;
        this.handle(insideDefaultConstructor ? 16777362 : (insideImplicitConstructorCall ? 0x800008F : 16777384), new String[]{new String(exceptionType.readableName())}, new String[]{new String(exceptionType.shortReadableName())}, location.sourceStart, location.sourceEnd);
    }

    public void uninitializedBlankFinalField(FieldBinding binding, ASTNode location) {
        String[] arguments = new String[]{new String(binding.readableName())};
        this.handle(33554513, arguments, arguments, location.sourceStart, this.fieldLocation(binding, location));
    }

    public void uninitializedLocalVariable(LocalVariableBinding binding, ASTNode location) {
        String[] arguments = new String[]{new String(binding.readableName())};
        this.handle(0x20000033, arguments, arguments, location.sourceStart, location.sourceEnd);
    }

    public void unmatchedBracket(int position, ReferenceContext context, CompilationResult compilationResult) {
        this.handle(1610612956, ProblemHandler.NoArgument, ProblemHandler.NoArgument, position, position, context, compilationResult);
    }

    public void unnecessaryCast(CastExpression castExpression) {
        TypeBinding castedExpressionType = castExpression.expression.resolvedType;
        this.handle(553648309, new String[]{new String(castedExpressionType.readableName()), new String(castExpression.resolvedType.readableName())}, new String[]{new String(castedExpressionType.shortReadableName()), new String(castExpression.resolvedType.shortReadableName())}, castExpression.sourceStart, castExpression.sourceEnd);
    }

    public void unnecessaryCastForArgument(CastExpression castExpression, TypeBinding parameterType) {
        TypeBinding castedExpressionType = castExpression.expression.resolvedType;
        this.handle(553648310, new String[]{new String(castedExpressionType.readableName()), new String(castExpression.resolvedType.readableName()), new String(parameterType.readableName())}, new String[]{new String(castedExpressionType.shortReadableName()), new String(castExpression.resolvedType.shortReadableName()), new String(parameterType.shortReadableName())}, castExpression.sourceStart, castExpression.sourceEnd);
    }

    public void unnecessaryInstanceof(InstanceOfExpression instanceofExpression, TypeBinding checkType) {
        TypeBinding expressionType = instanceofExpression.expression.resolvedType;
        this.handle(553648311, new String[]{new String(expressionType.readableName()), new String(checkType.readableName())}, new String[]{new String(expressionType.shortReadableName()), new String(checkType.shortReadableName())}, instanceofExpression.sourceStart, instanceofExpression.sourceEnd);
    }

    public void unqualifiedFieldAccess(NameReference reference, FieldBinding field) {
        this.handle(570425423, new String[]{new String(field.declaringClass.readableName()), new String(field.name)}, new String[]{new String(field.declaringClass.shortReadableName()), new String(field.name)}, reference.sourceStart, reference.sourceEnd);
    }

    public void unnecessaryEnclosingInstanceSpecification(Expression expression, ReferenceBinding targetType) {
        this.handle(0x1000017, new String[]{new String(targetType.readableName())}, new String[]{new String(targetType.shortReadableName())}, expression.sourceStart, expression.sourceEnd);
    }

    public void unreachableCatchBlock(ReferenceBinding exceptionType, ASTNode location) {
        this.handle(83886247, new String[]{new String(exceptionType.readableName())}, new String[]{new String(exceptionType.shortReadableName())}, location.sourceStart, location.sourceEnd);
    }

    public void unreachableCode(Statement statement) {
        this.handle(536871073, ProblemHandler.NoArgument, ProblemHandler.NoArgument, statement.sourceStart, statement.sourceEnd);
    }

    public void unresolvableReference(NameReference nameRef, Binding binding) {
        int severity = 1;
        String[] arguments = new String[]{new String(binding.readableName())};
        int end = nameRef.sourceEnd;
        if (nameRef instanceof QualifiedNameReference) {
            QualifiedNameReference ref = (QualifiedNameReference)nameRef;
            if (ref.indexOfFirstFieldBinding >= 1) {
                end = (int)ref.sourcePositions[ref.indexOfFirstFieldBinding - 1];
            }
        }
        this.handle(50, arguments, arguments, severity, nameRef.sourceStart, end);
    }

    public void unusedArgument(LocalDeclaration localDecl) {
        String[] arguments = new String[]{new String(localDecl.name)};
        this.handle(536870974, arguments, arguments, localDecl.sourceStart, localDecl.sourceEnd);
    }

    public void unusedDeclaredThrownException(ReferenceBinding exceptionType, AbstractMethodDeclaration method, ASTNode location) {
        if (method.isConstructor()) {
            this.handle(536871098, new String[]{new String(method.binding.declaringClass.readableName()), this.parametersAsString(method.binding), new String(exceptionType.readableName())}, new String[]{new String(method.binding.declaringClass.shortReadableName()), this.parametersAsShortString(method.binding), new String(exceptionType.shortReadableName())}, location.sourceStart, location.sourceEnd);
        } else {
            this.handle(536871097, new String[]{new String(method.binding.declaringClass.readableName()), new String(method.selector), this.parametersAsString(method.binding), new String(exceptionType.readableName())}, new String[]{new String(method.binding.declaringClass.shortReadableName()), new String(method.selector), this.parametersAsShortString(method.binding), new String(exceptionType.shortReadableName())}, location.sourceStart, location.sourceEnd);
        }
    }

    public void unusedImport(ImportReference importRef) {
        String[] arguments = new String[]{CharOperation.toString(importRef.tokens)};
        this.handle(268435844, arguments, arguments, importRef.sourceStart, importRef.sourceEnd);
    }

    public void unusedLocalVariable(LocalDeclaration localDecl) {
        String[] arguments = new String[]{new String(localDecl.name)};
        this.handle(536870973, arguments, arguments, localDecl.sourceStart, localDecl.sourceEnd);
    }

    public void unusedPrivateConstructor(ConstructorDeclaration constructorDecl) {
        if (this.computeSeverity(603979910) == -1) {
            return;
        }
        if (constructorDecl.arguments == null || constructorDecl.arguments.length == 0) {
            return;
        }
        MethodBinding constructor = constructorDecl.binding;
        this.handle(603979910, new String[]{new String(constructor.declaringClass.readableName()), this.parametersAsString(constructor)}, new String[]{new String(constructor.declaringClass.shortReadableName()), this.parametersAsShortString(constructor)}, constructorDecl.sourceStart, constructorDecl.sourceEnd);
    }

    public void unusedPrivateField(FieldDeclaration fieldDecl) {
        if (this.computeSeverity(570425421) == -1) {
            return;
        }
        FieldBinding field = fieldDecl.binding;
        if (CharOperation.equals(TypeConstants.SERIALVERSIONUID, field.name) && field.isStatic() && field.isFinal() && BaseTypes.LongBinding == field.type) {
            return;
        }
        this.handle(570425421, new String[]{new String(field.declaringClass.readableName()), new String(field.name)}, new String[]{new String(field.declaringClass.shortReadableName()), new String(field.name)}, fieldDecl.sourceStart, fieldDecl.sourceEnd);
    }

    public void unusedPrivateMethod(AbstractMethodDeclaration methodDecl) {
        if (this.computeSeverity(603979894) == -1) {
            return;
        }
        MethodBinding method = methodDecl.binding;
        if (!method.isStatic() && BaseTypes.VoidBinding == method.returnType && method.parameters.length == 1 && method.parameters[0].dimensions() == 0 && CharOperation.equals(method.selector, TypeConstants.READOBJECT) && CharOperation.equals(TypeConstants.CharArray_JAVA_IO_OBJECTINPUTSTREAM, method.parameters[0].readableName())) {
            return;
        }
        if (!method.isStatic() && BaseTypes.VoidBinding == method.returnType && method.parameters.length == 1 && method.parameters[0].dimensions() == 0 && CharOperation.equals(method.selector, TypeConstants.WRITEOBJECT) && CharOperation.equals(TypeConstants.CharArray_JAVA_IO_OBJECTOUTPUTSTREAM, method.parameters[0].readableName())) {
            return;
        }
        if (!method.isStatic() && 1 == method.returnType.id && method.parameters.length == 0 && CharOperation.equals(method.selector, TypeConstants.READRESOLVE)) {
            return;
        }
        if (!method.isStatic() && 1 == method.returnType.id && method.parameters.length == 0 && CharOperation.equals(method.selector, TypeConstants.WRITEREPLACE)) {
            return;
        }
        this.handle(603979894, new String[]{new String(method.declaringClass.readableName()), new String(method.selector), this.parametersAsString(method)}, new String[]{new String(method.declaringClass.shortReadableName()), new String(method.selector), this.parametersAsShortString(method)}, methodDecl.sourceStart, methodDecl.sourceEnd);
    }

    public void unusedPrivateType(TypeDeclaration typeDecl) {
        if (this.computeSeverity(553648135) == -1) {
            return;
        }
        SourceTypeBinding type = typeDecl.binding;
        this.handle(553648135, new String[]{new String(type.readableName())}, new String[]{new String(type.shortReadableName())}, typeDecl.sourceStart, typeDecl.sourceEnd);
    }

    public void useAssertAsAnIdentifier(int sourceStart, int sourceEnd) {
        this.handle(536871352, ProblemHandler.NoArgument, ProblemHandler.NoArgument, sourceStart, sourceEnd);
    }

    public void variableTypeCannotBeVoid(AbstractVariableDeclaration varDecl) {
        String[] arguments = new String[]{new String(varDecl.name)};
        this.handle(536870964, arguments, arguments, varDecl.sourceStart, varDecl.sourceEnd);
    }

    public void variableTypeCannotBeVoidArray(AbstractVariableDeclaration varDecl) {
        String[] arguments = new String[]{new String(varDecl.name)};
        this.handle(536870965, arguments, arguments, varDecl.sourceStart, varDecl.sourceEnd);
    }

    public void visibilityConflict(MethodBinding currentMethod, MethodBinding inheritedMethod) {
        this.handle(67109273, new String[]{new String(inheritedMethod.declaringClass.readableName())}, new String[]{new String(inheritedMethod.declaringClass.shortReadableName())}, currentMethod.sourceStart(), currentMethod.sourceEnd());
    }

    public void nonExternalizedStringLiteral(ASTNode location) {
        this.handle(536871173, ProblemHandler.NoArgument, ProblemHandler.NoArgument, location.sourceStart, location.sourceEnd);
    }

    public void noMoreAvailableSpaceForConstant(TypeDeclaration typeDeclaration) {
        this.handle(536871343, new String[]{new String(typeDeclaration.binding.readableName())}, new String[]{new String(typeDeclaration.binding.shortReadableName())}, 31, typeDeclaration.sourceStart, typeDeclaration.sourceEnd);
    }

    public void noMoreAvailableSpaceInConstantPool(TypeDeclaration typeDeclaration) {
        this.handle(536871342, new String[]{new String(typeDeclaration.binding.readableName())}, new String[]{new String(typeDeclaration.binding.shortReadableName())}, 31, typeDeclaration.sourceStart, typeDeclaration.sourceEnd);
    }

    private boolean isKeyword(int token) {
        switch (token) {
            case 13: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 55: 
            case 57: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 91: 
            case 103: 
            case 104: {
                return true;
            }
        }
        return false;
    }

    private boolean isLiteral(int token) {
        switch (token) {
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: {
                return true;
            }
        }
        return false;
    }

    private boolean isIdentifier(int token) {
        return token == 28;
    }

    private void syntaxError(int id, int startPosition, int endPosition, int currentKind, char[] currentTokenSource, String errorTokenName, String expectedToken) {
        String eTokenName = this.isKeyword(currentKind) || this.isLiteral(currentKind) || this.isIdentifier(currentKind) ? new String(currentTokenSource) : errorTokenName;
        String[] arguments = expectedToken != null ? new String[]{eTokenName, expectedToken} : new String[]{eTokenName};
        this.handle(id, arguments, arguments, startPosition, endPosition);
    }

    public void parseErrorInsertBeforeToken(int start, int end, int currentKind, char[] errorTokenSource, String errorTokenName, String expectedToken) {
        this.syntaxError(0x600000E6, start, end, currentKind, errorTokenSource, errorTokenName, expectedToken);
    }

    public void parseErrorInsertAfterToken(int start, int end, int currentKind, char[] errorTokenSource, String errorTokenName, String expectedToken) {
        this.syntaxError(1610612967, start, end, currentKind, errorTokenSource, errorTokenName, expectedToken);
    }

    public void parseErrorDeleteToken(int start, int end, int currentKind, char[] errorTokenSource, String errorTokenName) {
        this.syntaxError(1610612968, start, end, currentKind, errorTokenSource, errorTokenName, null);
    }

    public void parseErrorReplaceToken(int start, int end, int currentKind, char[] errorTokenSource, String errorTokenName, String expectedToken) {
        this.syntaxError(0x600000CC, start, end, currentKind, errorTokenSource, errorTokenName, expectedToken);
    }

    public void parseErrorInvalidToken(int start, int end, int currentKind, char[] errorTokenSource, String errorTokenName, String expectedToken) {
        this.syntaxError(1610612971, start, end, currentKind, errorTokenSource, errorTokenName, expectedToken);
    }

    public void parseErrorUnexpectedEnd(int start, int end) {
        String[] arguments = this.referenceContext instanceof ConstructorDeclaration ? new String[]{Util.bind("parser.endOfConstructor")} : (this.referenceContext instanceof MethodDeclaration ? new String[]{Util.bind("parser.endOfMethod")} : (this.referenceContext instanceof TypeDeclaration ? new String[]{Util.bind("parser.endOfInitializer")} : new String[]{Util.bind("parser.endOfFile")}));
        this.handle(1610612975, arguments, arguments, start, end);
    }

    public void parseErrorMergeTokens(int start, int end, String expectedToken) {
        String[] arguments = new String[]{expectedToken};
        this.handle(1610612970, arguments, arguments, start, end);
    }

    public void parseErrorMisplacedConstruct(int start, int end) {
        this.handle(1610612972, ProblemHandler.NoArgument, ProblemHandler.NoArgument, start, end);
    }

    public void parseErrorNoSuggestion(int start, int end, int currentKind, char[] errorTokenSource, String errorTokenName) {
        this.syntaxError(1610612941, start, end, currentKind, errorTokenSource, errorTokenName, null);
    }

    public void parseErrorDeleteTokens(int start, int end) {
        this.handle(1610612969, ProblemHandler.NoArgument, ProblemHandler.NoArgument, start, end);
    }

    public void parseErrorNoSuggestionForTokens(int start, int end) {
        this.handle(0x600000EE, ProblemHandler.NoArgument, ProblemHandler.NoArgument, start, end);
    }

    public void parseErrorReplaceTokens(int start, int end, String expectedToken) {
        String[] arguments = new String[]{expectedToken};
        this.handle(1610612973, arguments, arguments, start, end);
    }

    public void parseErrorInsertToComplete(int start, int end, String inserted, String completed) {
        String[] arguments = new String[]{inserted, completed};
        this.handle(0x600000F0, arguments, arguments, start, end);
    }

    public void parseErrorInsertToCompleteScope(int start, int end, String inserted) {
        String[] arguments = new String[]{inserted};
        this.handle(1610612977, arguments, arguments, start, end);
    }

    public void parseErrorInsertToCompletePhrase(int start, int end, String inserted) {
        String[] arguments = new String[]{inserted};
        this.handle(1610612978, arguments, arguments, start, end);
    }

    public void wrongSequenceOfExceptionTypesError(TryStatement statement, TypeBinding exceptionType, int under, TypeBinding hidingExceptionType) {
        TypeReference typeRef = statement.catchArguments[under].type;
        this.handle(553648315, new String[]{new String(exceptionType.readableName()), new String(hidingExceptionType.readableName())}, new String[]{new String(exceptionType.shortReadableName()), new String(hidingExceptionType.shortReadableName())}, typeRef.sourceStart, typeRef.sourceEnd);
    }
}

