/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.problem;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblem;
import org.eclipse.jdt.internal.compiler.util.Util;

public class DefaultProblemFactory
implements IProblemFactory {
    public static final int MAX_MESSAGES = 500;
    public String[] messageTemplates;
    private Locale locale;
    private static String[] DEFAULT_LOCALE_TEMPLATES;
    private static final char[] DOUBLE_QUOTES;
    private static final char[] SINGLE_QUOTE;

    static {
        DOUBLE_QUOTES = "''".toCharArray();
        SINGLE_QUOTE = "'".toCharArray();
    }

    public DefaultProblemFactory() {
        this(Locale.getDefault());
    }

    public DefaultProblemFactory(Locale loc) {
        this.locale = loc;
        if (Locale.getDefault().equals(loc)) {
            if (DEFAULT_LOCALE_TEMPLATES == null) {
                DEFAULT_LOCALE_TEMPLATES = DefaultProblemFactory.loadMessageTemplates(loc);
            }
            this.messageTemplates = DEFAULT_LOCALE_TEMPLATES;
        } else {
            this.messageTemplates = DefaultProblemFactory.loadMessageTemplates(loc);
        }
    }

    public IProblem createProblem(char[] originatingFileName, int problemId, String[] problemArguments, String[] messageArguments, int severity, int startPosition, int endPosition, int lineNumber) {
        return new DefaultProblem(originatingFileName, this.getLocalizedMessage(problemId, messageArguments), problemId, problemArguments, severity, startPosition, endPosition, lineNumber);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public final String getLocalizedMessage(int id, String[] problemArguments) {
        StringBuffer output;
        block7: {
            String message;
            output = new StringBuffer(80);
            if ((id & Integer.MIN_VALUE) != 0) {
                output.append(this.messageTemplates[489]);
            }
            if ((message = this.messageTemplates[id & 0xFFFFFF]) == null) {
                return "Unable to retrieve the error message for problem id: " + (id & 0xFFFFFF) + ". Check compiler resources.";
            }
            char[] messageWithNoDoubleQuotes = CharOperation.replace(message.toCharArray(), DOUBLE_QUOTES, SINGLE_QUOTE);
            message = new String(messageWithNoDoubleQuotes);
            int length = message.length();
            int start = -1;
            int end = length;
            while ((end = message.indexOf(123, start)) > -1) {
                output.append(message.substring(start + 1, end));
                start = message.indexOf(125, end);
                if (start > -1) {
                    try {
                        output.append(problemArguments[Integer.parseInt(message.substring(end + 1, start))]);
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        output.append(message.substring(end + 1, start + 1));
                        continue;
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        return "Cannot bind message for problem (id: " + (id & 0xFFFFFF) + ") \"" + message + "\" with arguments: {" + Util.toString(problemArguments) + "}";
                    }
                }
                output.append(message.substring(end, length));
                break block7;
            }
            output.append(message.substring(start + 1, length));
        }
        return output.toString();
    }

    public final String localizedMessage(IProblem problem) {
        return this.getLocalizedMessage(problem.getID(), problem.getArguments());
    }

    public static String[] loadMessageTemplates(Locale loc) {
        ResourceBundle bundle = null;
        String bundleName = "org.eclipse.jdt.internal.compiler.problem.messages";
        try {
            bundle = ResourceBundle.getBundle(bundleName, loc);
        }
        catch (MissingResourceException e) {
            System.out.println("Missing resource : " + bundleName.replace('.', '/') + ".properties for locale " + loc);
            throw e;
        }
        String[] templates = new String[500];
        int i = 0;
        int max = templates.length;
        while (i < max) {
            try {
                templates[i] = bundle.getString(String.valueOf(i));
            }
            catch (MissingResourceException missingResourceException) {}
            ++i;
        }
        return templates;
    }
}

