/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.eclipse.jdt.internal.compiler.impl.ReferenceContext;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypes;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BindingIds;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.CompilerModifiers;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.ImportBinding;
import org.eclipse.jdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemFieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReasons;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TagBits;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.TypeIds;
import org.eclipse.jdt.internal.compiler.lookup.UpdatedMethodBinding;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.jdt.internal.compiler.util.HashtableOfObject;
import org.eclipse.jdt.internal.compiler.util.ObjectVector;

public abstract class Scope
implements BaseTypes,
BindingIds,
CompilerModifiers,
ProblemReasons,
TagBits,
TypeConstants,
TypeIds {
    public static final int BLOCK_SCOPE = 1;
    public static final int METHOD_SCOPE = 2;
    public static final int CLASS_SCOPE = 3;
    public static final int COMPILATION_UNIT_SCOPE = 4;
    public int kind;
    public Scope parent;

    protected Scope(int kind, Scope parent) {
        this.kind = kind;
        this.parent = parent;
    }

    public static int compareTypes(TypeBinding left, TypeBinding right) {
        if (left.isCompatibleWith(right)) {
            return -1;
        }
        if (right.isCompatibleWith(left)) {
            return 1;
        }
        return 0;
    }

    protected final boolean areParametersAssignable(TypeBinding[] parameters, TypeBinding[] arguments) {
        if (parameters == arguments) {
            return true;
        }
        int length = parameters.length;
        if (length != arguments.length) {
            return false;
        }
        int i = 0;
        while (i < length) {
            if (parameters[i] != arguments[i] && !arguments[i].isCompatibleWith(parameters[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int compareUncheckedException(ReferenceBinding type) {
        int comparison = Scope.compareTypes(type, this.getJavaLangRuntimeException());
        if (comparison != 0) {
            return comparison;
        }
        return Scope.compareTypes(type, this.getJavaLangError());
    }

    public final CompilationUnitScope compilationUnitScope() {
        Scope lastScope = null;
        Scope scope = this;
        do {
            lastScope = scope;
        } while ((scope = scope.parent) != null);
        return (CompilationUnitScope)lastScope;
    }

    public ArrayBinding createArray(TypeBinding type, int dimension) {
        if (type.isValidBinding()) {
            return this.environment().createArrayType(type, dimension);
        }
        return new ArrayBinding(type, dimension);
    }

    public final ClassScope enclosingClassScope() {
        Scope scope = this;
        while ((scope = scope.parent) != null) {
            if (!(scope instanceof ClassScope)) continue;
            return (ClassScope)scope;
        }
        return null;
    }

    public final MethodScope enclosingMethodScope() {
        Scope scope = this;
        while ((scope = scope.parent) != null) {
            if (!(scope instanceof MethodScope)) continue;
            return (MethodScope)scope;
        }
        return null;
    }

    public final SourceTypeBinding enclosingSourceType() {
        Scope scope = this;
        do {
            if (!(scope instanceof ClassScope)) continue;
            return ((ClassScope)scope).referenceContext.binding;
        } while ((scope = scope.parent) != null);
        return null;
    }

    public final LookupEnvironment environment() {
        Scope scope;
        Scope unitScope = this;
        while ((scope = unitScope.parent) != null) {
            unitScope = scope;
        }
        return ((CompilationUnitScope)unitScope).environment;
    }

    public MethodBinding findDefaultAbstractMethod(ReferenceBinding receiverType, char[] selector, TypeBinding[] argumentTypes, InvocationSite invocationSite, ReferenceBinding classHierarchyStart, MethodBinding matchingMethod, ObjectVector found) {
        int startFoundSize = found.size;
        ReferenceBinding currentType = classHierarchyStart;
        while (currentType != null) {
            matchingMethod = this.findMethodInSuperInterfaces(currentType, selector, found, matchingMethod);
            currentType = currentType.superclass();
        }
        int foundSize = found.size;
        if (foundSize == startFoundSize) {
            if (matchingMethod != null) {
                this.compilationUnitScope().recordTypeReferences(matchingMethod.thrownExceptions);
            }
            return matchingMethod;
        }
        MethodBinding[] candidates = new MethodBinding[foundSize - startFoundSize];
        int candidatesCount = 0;
        int i = startFoundSize;
        while (i < foundSize) {
            MethodBinding methodBinding = (MethodBinding)found.elementAt(i);
            if (this.areParametersAssignable(methodBinding.parameters, argumentTypes)) {
                candidates[candidatesCount++] = methodBinding;
            }
            ++i;
        }
        if (candidatesCount == 1) {
            this.compilationUnitScope().recordTypeReferences(candidates[0].thrownExceptions);
            return candidates[0];
        }
        if (candidatesCount == 0) {
            int argLength = argumentTypes.length;
            int i2 = 0;
            while (i2 < foundSize) {
                block11: {
                    MethodBinding methodBinding = (MethodBinding)found.elementAt(i2);
                    TypeBinding[] params = methodBinding.parameters;
                    int paramLength = params.length;
                    int a = 0;
                    block3: while (a < argLength) {
                        TypeBinding arg = argumentTypes[a];
                        int p = 0;
                        while (p < paramLength) {
                            if (params[p] != arg) {
                                ++p;
                                continue;
                            }
                            ++a;
                            continue block3;
                        }
                        break block11;
                    }
                    return methodBinding;
                }
                ++i2;
            }
            return (MethodBinding)found.elementAt(0);
        }
        return this.mostSpecificInterfaceMethodBinding(candidates, candidatesCount);
    }

    public ReferenceBinding findDirectMemberType(char[] typeName, ReferenceBinding enclosingType) {
        if ((enclosingType.tagBits & 0x4000) != 0) {
            return null;
        }
        SourceTypeBinding enclosingSourceType = this.enclosingSourceType();
        this.compilationUnitScope().recordReference(enclosingType.compoundName, typeName);
        ReferenceBinding memberType = enclosingType.getMemberType(typeName);
        if (memberType != null) {
            this.compilationUnitScope().recordTypeReference(memberType);
            if (enclosingSourceType == null ? memberType.canBeSeenBy(this.getCurrentPackage()) : memberType.canBeSeenBy(enclosingType, enclosingSourceType)) {
                return memberType;
            }
            return new ProblemReferenceBinding(typeName, memberType, 2);
        }
        return null;
    }

    public MethodBinding findExactMethod(ReferenceBinding receiverType, char[] selector, TypeBinding[] argumentTypes, InvocationSite invocationSite) {
        this.compilationUnitScope().recordTypeReference(receiverType);
        this.compilationUnitScope().recordTypeReferences(argumentTypes);
        MethodBinding exactMethod = receiverType.getExactMethod(selector, argumentTypes);
        if (exactMethod != null) {
            this.compilationUnitScope().recordTypeReferences(exactMethod.thrownExceptions);
            if (receiverType.isInterface() || exactMethod.canBeSeenBy(receiverType, invocationSite, this)) {
                return exactMethod;
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public FieldBinding findField(TypeBinding receiverType, char[] fieldName, InvocationSite invocationSite, boolean needResolve) {
        if (receiverType.isBaseType()) {
            return null;
        }
        if (receiverType.isArrayType()) {
            TypeBinding leafType = receiverType.leafComponentType();
            if (leafType instanceof ReferenceBinding && !((ReferenceBinding)leafType).canBeSeenBy(this)) {
                return new ProblemFieldBinding((ReferenceBinding)leafType, fieldName, 8);
            }
            if (CharOperation.equals(fieldName, TypeConstants.LENGTH)) {
                return ArrayBinding.ArrayLength;
            }
            return null;
        }
        this.compilationUnitScope().recordTypeReference(receiverType);
        ReferenceBinding currentType = (ReferenceBinding)receiverType;
        if (!currentType.canBeSeenBy(this)) {
            return new ProblemFieldBinding(currentType, fieldName, 8);
        }
        FieldBinding field = currentType.getField(fieldName, true);
        if (field != null) {
            if (field.canBeSeenBy(currentType, invocationSite, this)) {
                return field;
            }
            return new ProblemFieldBinding(field.declaringClass, fieldName, 2);
        }
        ReferenceBinding[][] interfacesToVisit = null;
        int lastPosition = -1;
        FieldBinding visibleField = null;
        boolean keepLooking = true;
        boolean notVisible = false;
        while (keepLooking) {
            ReferenceBinding[] itsInterfaces = currentType.superInterfaces();
            if (itsInterfaces != TypeConstants.NoSuperInterfaces) {
                if (interfacesToVisit == null) {
                    interfacesToVisit = new ReferenceBinding[5][];
                }
                if (++lastPosition == interfacesToVisit.length) {
                    ReferenceBinding[][] referenceBindingArray = interfacesToVisit;
                    interfacesToVisit = new ReferenceBinding[lastPosition * 2][];
                    System.arraycopy(referenceBindingArray, 0, interfacesToVisit, 0, lastPosition);
                }
                interfacesToVisit[lastPosition] = itsInterfaces;
            }
            if ((currentType = currentType.superclass()) == null) break;
            field = currentType.getField(fieldName, needResolve);
            if (field == null) continue;
            keepLooking = false;
            if (field.canBeSeenBy(receiverType, invocationSite, this)) {
                if (visibleField != null) {
                    return new ProblemFieldBinding(visibleField.declaringClass, fieldName, 3);
                }
                visibleField = field;
                continue;
            }
            notVisible = true;
        }
        if (interfacesToVisit != null) {
            int length;
            int j;
            ReferenceBinding[] interfaces;
            ProblemFieldBinding ambiguous = null;
            int i = 0;
            block1: while (i <= lastPosition) {
                interfaces = interfacesToVisit[i];
                j = 0;
                length = interfaces.length;
                while (j < length) {
                    block27: {
                        ReferenceBinding anInterface = interfaces[j];
                        if ((anInterface.tagBits & 0x800) == 0) {
                            anInterface.tagBits |= 0x800;
                            field = anInterface.getField(fieldName, true);
                            if (field != null) {
                                if (visibleField == null) {
                                    visibleField = field;
                                    break block27;
                                } else {
                                    ambiguous = new ProblemFieldBinding(visibleField.declaringClass, fieldName, 3);
                                    break block1;
                                }
                            }
                            ReferenceBinding[] itsInterfaces = anInterface.superInterfaces();
                            if (itsInterfaces != TypeConstants.NoSuperInterfaces) {
                                if (++lastPosition == interfacesToVisit.length) {
                                    ReferenceBinding[][] referenceBindingArray = interfacesToVisit;
                                    interfacesToVisit = new ReferenceBinding[lastPosition * 2][];
                                    System.arraycopy(referenceBindingArray, 0, interfacesToVisit, 0, lastPosition);
                                }
                                interfacesToVisit[lastPosition] = itsInterfaces;
                            }
                        }
                    }
                    ++j;
                }
                ++i;
            }
            i = 0;
            while (i <= lastPosition) {
                interfaces = interfacesToVisit[i];
                j = 0;
                length = interfaces.length;
                while (j < length) {
                    interfaces[j].tagBits &= 0xFFFFF7FF;
                    ++j;
                }
                ++i;
            }
            if (ambiguous != null) {
                return ambiguous;
            }
        }
        if (visibleField != null) {
            return visibleField;
        }
        if (notVisible) {
            return new ProblemFieldBinding(currentType, fieldName, 2);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public ReferenceBinding findMemberType(char[] typeName, ReferenceBinding enclosingType) {
        if ((enclosingType.tagBits & 0x4000) != 0) {
            return null;
        }
        SourceTypeBinding enclosingSourceType = this.enclosingSourceType();
        PackageBinding currentPackage = this.getCurrentPackage();
        this.compilationUnitScope().recordReference(enclosingType.compoundName, typeName);
        ReferenceBinding memberType = enclosingType.getMemberType(typeName);
        if (memberType != null) {
            this.compilationUnitScope().recordTypeReference(memberType);
            if (enclosingSourceType == null) {
                if (!memberType.canBeSeenBy(currentPackage)) return new ProblemReferenceBinding(typeName, memberType, 2);
                return memberType;
            }
            if (!memberType.canBeSeenBy(enclosingType, enclosingSourceType)) return new ProblemReferenceBinding(typeName, memberType, 2);
            return memberType;
        }
        ReferenceBinding currentType = enclosingType;
        ReferenceBinding[][] interfacesToVisit = null;
        int lastPosition = -1;
        ReferenceBinding visibleMemberType = null;
        boolean keepLooking = true;
        ReferenceBinding notVisible = null;
        while (keepLooking) {
            ReferenceBinding[] itsInterfaces = currentType.superInterfaces();
            if (itsInterfaces != TypeConstants.NoSuperInterfaces) {
                if (interfacesToVisit == null) {
                    interfacesToVisit = new ReferenceBinding[5][];
                }
                if (++lastPosition == interfacesToVisit.length) {
                    ReferenceBinding[][] referenceBindingArray = interfacesToVisit;
                    interfacesToVisit = new ReferenceBinding[lastPosition * 2][];
                    System.arraycopy(referenceBindingArray, 0, interfacesToVisit, 0, lastPosition);
                }
                interfacesToVisit[lastPosition] = itsInterfaces;
            }
            if ((currentType = currentType.superclass()) == null) break;
            this.compilationUnitScope().recordReference(currentType.compoundName, typeName);
            memberType = currentType.getMemberType(typeName);
            if (memberType == null) continue;
            this.compilationUnitScope().recordTypeReference(memberType);
            keepLooking = false;
            if (enclosingSourceType == null ? memberType.canBeSeenBy(currentPackage) : memberType.canBeSeenBy(enclosingType, enclosingSourceType)) {
                if (visibleMemberType != null) return new ProblemReferenceBinding(typeName, 3);
                visibleMemberType = memberType;
                continue;
            }
            notVisible = memberType;
        }
        if (interfacesToVisit != null) {
            int length;
            int j;
            ReferenceBinding[] interfaces;
            ProblemReferenceBinding ambiguous = null;
            int i = 0;
            block1: while (i <= lastPosition) {
                interfaces = interfacesToVisit[i];
                j = 0;
                length = interfaces.length;
                while (j < length) {
                    block21: {
                        ReferenceBinding anInterface = interfaces[j];
                        if ((anInterface.tagBits & 0x800) == 0) {
                            anInterface.tagBits |= 0x800;
                            this.compilationUnitScope().recordReference(anInterface.compoundName, typeName);
                            memberType = anInterface.getMemberType(typeName);
                            if (memberType != null) {
                                this.compilationUnitScope().recordTypeReference(memberType);
                                if (visibleMemberType == null) {
                                    visibleMemberType = memberType;
                                    break block21;
                                } else {
                                    ambiguous = new ProblemReferenceBinding(typeName, 3);
                                    break block1;
                                }
                            }
                            ReferenceBinding[] itsInterfaces = anInterface.superInterfaces();
                            if (itsInterfaces != TypeConstants.NoSuperInterfaces) {
                                if (++lastPosition == interfacesToVisit.length) {
                                    ReferenceBinding[][] referenceBindingArray = interfacesToVisit;
                                    interfacesToVisit = new ReferenceBinding[lastPosition * 2][];
                                    System.arraycopy(referenceBindingArray, 0, interfacesToVisit, 0, lastPosition);
                                }
                                interfacesToVisit[lastPosition] = itsInterfaces;
                            }
                        }
                    }
                    ++j;
                }
                ++i;
            }
            i = 0;
            while (i <= lastPosition) {
                interfaces = interfacesToVisit[i];
                j = 0;
                length = interfaces.length;
                while (j < length) {
                    interfaces[j].tagBits &= 0xFFFFF7FF;
                    ++j;
                }
                ++i;
            }
            if (ambiguous != null) {
                return ambiguous;
            }
        }
        if (visibleMemberType != null) {
            return visibleMemberType;
        }
        if (notVisible == null) return null;
        return new ProblemReferenceBinding(typeName, notVisible, 2);
    }

    public MethodBinding findMethod(ReferenceBinding receiverType, char[] selector, TypeBinding[] argumentTypes, InvocationSite invocationSite) {
        ReferenceBinding currentType = receiverType;
        MethodBinding matchingMethod = null;
        ObjectVector found = new ObjectVector();
        this.compilationUnitScope().recordTypeReference(receiverType);
        this.compilationUnitScope().recordTypeReferences(argumentTypes);
        if (currentType.isInterface()) {
            Object[] currentMethods = currentType.getMethods(selector);
            int currentLength = currentMethods.length;
            if (currentLength == 1) {
                matchingMethod = currentMethods[0];
            } else if (currentLength > 1) {
                found.addAll(currentMethods);
            }
            matchingMethod = this.findMethodInSuperInterfaces(currentType, selector, found, matchingMethod);
            currentType = this.getJavaLangObject();
        }
        boolean isCompliant14 = this.compilationUnitScope().environment.options.complianceLevel >= 0x300000L;
        ReferenceBinding classHierarchyStart = currentType;
        while (currentType != null) {
            Object[] currentMethods = currentType.getMethods(selector);
            int currentLength = currentMethods.length;
            if (isCompliant14) {
                int i = 0;
                while (i < currentLength) {
                    MethodBinding currentMethod = currentMethods[i];
                    if ((currentMethod.modifiers & 4) != 0) {
                        if (matchingMethod != null) {
                            if (currentMethod.areParametersEqual(matchingMethod)) {
                                --currentLength;
                                currentMethods[i] = null;
                            }
                        } else {
                            int j = 0;
                            int max = found.size;
                            while (j < max) {
                                if (((MethodBinding)found.elementAt(j)).areParametersEqual(currentMethod)) {
                                    --currentLength;
                                    currentMethods[i] = null;
                                    break;
                                }
                                ++j;
                            }
                        }
                    }
                    ++i;
                }
            }
            if (currentLength == 1 && matchingMethod == null && found.size == 0) {
                matchingMethod = currentMethods[0];
            } else if (currentLength > 0) {
                int maxMethod;
                if (matchingMethod != null) {
                    found.add(matchingMethod);
                    matchingMethod = null;
                }
                if ((maxMethod = currentMethods.length) == currentLength) {
                    found.addAll(currentMethods);
                } else {
                    int i = 0;
                    int max = currentMethods.length;
                    while (i < max) {
                        Object currentMethod = currentMethods[i];
                        if (currentMethod != null) {
                            found.add(currentMethod);
                        }
                        ++i;
                    }
                }
            }
            currentType = currentType.superclass();
        }
        int foundSize = found.size;
        MethodBinding[] candidates = null;
        int candidatesCount = 0;
        boolean checkedMatchingMethod = false;
        if (foundSize > 0) {
            int i = 0;
            while (i < foundSize) {
                MethodBinding methodBinding = (MethodBinding)found.elementAt(i);
                if (this.areParametersAssignable(methodBinding.parameters, argumentTypes)) {
                    switch (candidatesCount) {
                        case 0: {
                            matchingMethod = methodBinding;
                            checkedMatchingMethod = true;
                            break;
                        }
                        case 1: {
                            candidates = new MethodBinding[foundSize];
                            candidates[0] = matchingMethod;
                            matchingMethod = null;
                        }
                        default: {
                            candidates[candidatesCount] = methodBinding;
                        }
                    }
                    ++candidatesCount;
                }
                ++i;
            }
        }
        if (matchingMethod != null) {
            if ((checkedMatchingMethod || this.areParametersAssignable(matchingMethod.parameters, argumentTypes)) && !matchingMethod.canBeSeenBy(receiverType, invocationSite, this)) {
                MethodBinding interfaceMethod = this.findDefaultAbstractMethod(receiverType, selector, argumentTypes, invocationSite, classHierarchyStart, null, found);
                if (interfaceMethod != null) {
                    return interfaceMethod;
                }
                this.compilationUnitScope().recordTypeReferences(matchingMethod.thrownExceptions);
                return matchingMethod;
            }
            return this.findDefaultAbstractMethod(receiverType, selector, argumentTypes, invocationSite, classHierarchyStart, matchingMethod, found);
        }
        if (candidatesCount == 0) {
            MethodBinding interfaceMethod = this.findDefaultAbstractMethod(receiverType, selector, argumentTypes, invocationSite, classHierarchyStart, matchingMethod, found);
            if (interfaceMethod != null) {
                return interfaceMethod;
            }
            int argLength = argumentTypes.length;
            foundSize = found.size;
            int i = 0;
            while (i < foundSize) {
                block44: {
                    MethodBinding methodBinding = (MethodBinding)found.elementAt(i);
                    TypeBinding[] params = methodBinding.parameters;
                    int paramLength = params.length;
                    int a = 0;
                    block10: while (a < argLength) {
                        TypeBinding arg = argumentTypes[a];
                        int p = 0;
                        while (p < paramLength) {
                            if (params[p] != arg) {
                                ++p;
                                continue;
                            }
                            ++a;
                            continue block10;
                        }
                        break block44;
                    }
                    return methodBinding;
                }
                ++i;
            }
            return (MethodBinding)found.elementAt(0);
        }
        int visiblesCount = 0;
        int i = 0;
        while (i < candidatesCount) {
            MethodBinding methodBinding = candidates[i];
            if (methodBinding.canBeSeenBy(receiverType, invocationSite, this)) {
                if (visiblesCount != i) {
                    candidates[i] = null;
                    candidates[visiblesCount] = methodBinding;
                }
                ++visiblesCount;
            }
            ++i;
        }
        if (visiblesCount == 1) {
            this.compilationUnitScope().recordTypeReferences(candidates[0].thrownExceptions);
            return candidates[0];
        }
        if (visiblesCount == 0) {
            MethodBinding interfaceMethod = this.findDefaultAbstractMethod(receiverType, selector, argumentTypes, invocationSite, classHierarchyStart, matchingMethod, found);
            if (interfaceMethod != null) {
                return interfaceMethod;
            }
            return new ProblemMethodBinding(candidates[0], candidates[0].selector, candidates[0].parameters, 2);
        }
        if (candidates[0].declaringClass.isClass()) {
            return this.mostSpecificClassMethodBinding(candidates, visiblesCount);
        }
        return this.mostSpecificInterfaceMethodBinding(candidates, visiblesCount);
    }

    public MethodBinding findMethodForArray(ArrayBinding receiverType, char[] selector, TypeBinding[] argumentTypes, InvocationSite invocationSite) {
        TypeBinding leafType = receiverType.leafComponentType();
        if (leafType instanceof ReferenceBinding && !((ReferenceBinding)leafType).canBeSeenBy(this)) {
            return new ProblemMethodBinding(selector, TypeConstants.NoParameters, (ReferenceBinding)leafType, 8);
        }
        ReferenceBinding object = this.getJavaLangObject();
        MethodBinding methodBinding = object.getExactMethod(selector, argumentTypes);
        if (methodBinding != null) {
            if (argumentTypes == TypeConstants.NoParameters && CharOperation.equals(selector, TypeConstants.CLONE)) {
                return new UpdatedMethodBinding(this.environment().options.targetJDK >= 0x300000L ? receiverType : object, methodBinding.modifiers ^ 4 | 1, TypeConstants.CLONE, methodBinding.returnType, argumentTypes, null, object);
            }
            if (methodBinding.canBeSeenBy(receiverType, invocationSite, this)) {
                return methodBinding;
            }
        }
        if ((methodBinding = this.findMethod(object, selector, argumentTypes, invocationSite)) == null) {
            return new ProblemMethodBinding(selector, argumentTypes, 1);
        }
        if (methodBinding.isValidBinding()) {
            if (!this.areParametersAssignable(methodBinding.parameters, argumentTypes)) {
                return new ProblemMethodBinding(methodBinding, selector, argumentTypes, 1);
            }
            if (!methodBinding.canBeSeenBy(receiverType, invocationSite, this)) {
                return new ProblemMethodBinding(methodBinding, selector, methodBinding.parameters, 2);
            }
        }
        return methodBinding;
    }

    public MethodBinding findMethodInSuperInterfaces(ReferenceBinding currentType, char[] selector, ObjectVector found, MethodBinding matchingMethod) {
        ReferenceBinding[] itsInterfaces = currentType.superInterfaces();
        if (itsInterfaces != TypeConstants.NoSuperInterfaces) {
            int length;
            int j;
            ReferenceBinding[] interfaces;
            ReferenceBinding[][] interfacesToVisit = new ReferenceBinding[5][];
            int lastPosition = -1;
            if (++lastPosition == interfacesToVisit.length) {
                ReferenceBinding[][] referenceBindingArray = interfacesToVisit;
                interfacesToVisit = new ReferenceBinding[lastPosition * 2][];
                System.arraycopy(referenceBindingArray, 0, interfacesToVisit, 0, lastPosition);
            }
            interfacesToVisit[lastPosition] = itsInterfaces;
            int i = 0;
            while (i <= lastPosition) {
                interfaces = interfacesToVisit[i];
                j = 0;
                length = interfaces.length;
                while (j < length) {
                    currentType = interfaces[j];
                    if ((currentType.tagBits & 0x800) == 0) {
                        currentType.tagBits |= 0x800;
                        Object[] currentMethods = currentType.getMethods(selector);
                        int currentLength = currentMethods.length;
                        if (currentLength == 1 && matchingMethod == null && found.size == 0) {
                            matchingMethod = currentMethods[0];
                        } else if (currentLength > 0) {
                            if (matchingMethod != null) {
                                found.add(matchingMethod);
                                matchingMethod = null;
                            }
                            found.addAll(currentMethods);
                        }
                        itsInterfaces = currentType.superInterfaces();
                        if (itsInterfaces != TypeConstants.NoSuperInterfaces) {
                            if (++lastPosition == interfacesToVisit.length) {
                                ReferenceBinding[][] referenceBindingArray = interfacesToVisit;
                                interfacesToVisit = new ReferenceBinding[lastPosition * 2][];
                                System.arraycopy(referenceBindingArray, 0, interfacesToVisit, 0, lastPosition);
                            }
                            interfacesToVisit[lastPosition] = itsInterfaces;
                        }
                    }
                    ++j;
                }
                ++i;
            }
            i = 0;
            while (i <= lastPosition) {
                interfaces = interfacesToVisit[i];
                j = 0;
                length = interfaces.length;
                while (j < length) {
                    interfaces[j].tagBits &= 0xFFFFF7FF;
                    ++j;
                }
                ++i;
            }
        }
        return matchingMethod;
    }

    public ReferenceBinding findType(char[] typeName, PackageBinding declarationPackage, PackageBinding invocationPackage) {
        this.compilationUnitScope().recordReference(declarationPackage.compoundName, typeName);
        ReferenceBinding typeBinding = declarationPackage.getType(typeName);
        if (typeBinding == null) {
            return null;
        }
        if (typeBinding.isValidBinding() && declarationPackage != invocationPackage && !typeBinding.canBeSeenBy(invocationPackage)) {
            return new ProblemReferenceBinding(typeName, typeBinding, 2);
        }
        return typeBinding;
    }

    public LocalVariableBinding findVariable(char[] variable) {
        return null;
    }

    public TypeBinding getBaseType(char[] name) {
        int length = name.length;
        if (length > 2 && length < 8) {
            switch (name[0]) {
                case 'i': {
                    if (length != 3 || name[1] != 'n' || name[2] != 't') break;
                    return BaseTypes.IntBinding;
                }
                case 'v': {
                    if (length != 4 || name[1] != 'o' || name[2] != 'i' || name[3] != 'd') break;
                    return BaseTypes.VoidBinding;
                }
                case 'b': {
                    if (length == 7 && name[1] == 'o' && name[2] == 'o' && name[3] == 'l' && name[4] == 'e' && name[5] == 'a' && name[6] == 'n') {
                        return BaseTypes.BooleanBinding;
                    }
                    if (length != 4 || name[1] != 'y' || name[2] != 't' || name[3] != 'e') break;
                    return BaseTypes.ByteBinding;
                }
                case 'c': {
                    if (length != 4 || name[1] != 'h' || name[2] != 'a' || name[3] != 'r') break;
                    return BaseTypes.CharBinding;
                }
                case 'd': {
                    if (length != 6 || name[1] != 'o' || name[2] != 'u' || name[3] != 'b' || name[4] != 'l' || name[5] != 'e') break;
                    return BaseTypes.DoubleBinding;
                }
                case 'f': {
                    if (length != 5 || name[1] != 'l' || name[2] != 'o' || name[3] != 'a' || name[4] != 't') break;
                    return BaseTypes.FloatBinding;
                }
                case 'l': {
                    if (length != 4 || name[1] != 'o' || name[2] != 'n' || name[3] != 'g') break;
                    return BaseTypes.LongBinding;
                }
                case 's': {
                    if (length != 5 || name[1] != 'h' || name[2] != 'o' || name[3] != 'r' || name[4] != 't') break;
                    return BaseTypes.ShortBinding;
                }
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Binding getBinding(char[] name, int mask, InvocationSite invocationSite, boolean needResolve) {
        Binding binding = null;
        Binding problemField = null;
        if ((mask & 3) != 0) {
            boolean insideStaticContext = false;
            boolean insideConstructorCall = false;
            Binding foundField = null;
            ProblemFieldBinding foundInsideProblem = null;
            Scope scope = this;
            int depth = 0;
            int foundDepth = 0;
            SourceTypeBinding foundActualReceiverType = null;
            block6: while (true) {
                switch (scope.kind) {
                    case 2: {
                        MethodScope methodScope = (MethodScope)scope;
                        insideStaticContext |= methodScope.isStatic;
                        insideConstructorCall |= methodScope.isConstructorCall;
                    }
                    case 1: {
                        LocalVariableBinding variableBinding = scope.findVariable(name);
                        if (variableBinding == null) break;
                        if (foundField != null && foundField.isValidBinding()) {
                            return new ProblemFieldBinding(((FieldBinding)foundField).declaringClass, name, 5);
                        }
                        if (depth <= 0) return variableBinding;
                        invocationSite.setDepth(depth);
                        return variableBinding;
                    }
                    case 3: {
                        ClassScope classScope = (ClassScope)scope;
                        SourceTypeBinding enclosingType = classScope.referenceContext.binding;
                        FieldBinding fieldBinding = classScope.findField(enclosingType, name, invocationSite, needResolve);
                        if (fieldBinding != null) {
                            if (fieldBinding.problemId() == 3) {
                                if (foundField == null) return fieldBinding;
                                if (foundField.problemId() != 2) return new ProblemFieldBinding(fieldBinding.declaringClass, name, 5);
                                return fieldBinding;
                            }
                            ProblemFieldBinding insideProblem = null;
                            if (fieldBinding.isValidBinding()) {
                                if (!fieldBinding.isStatic()) {
                                    if (insideConstructorCall) {
                                        insideProblem = new ProblemFieldBinding(fieldBinding.declaringClass, name, 6);
                                    } else if (insideStaticContext) {
                                        insideProblem = new ProblemFieldBinding(fieldBinding.declaringClass, name, 7);
                                    }
                                }
                                if (enclosingType == fieldBinding.declaringClass || this.environment().options.complianceLevel >= 0x300000L) {
                                    if (foundField == null) {
                                        FieldBinding fieldBinding2;
                                        if (depth > 0) {
                                            invocationSite.setDepth(depth);
                                            invocationSite.setActualReceiverType(enclosingType);
                                        }
                                        if (insideProblem == null) {
                                            fieldBinding2 = fieldBinding;
                                            return fieldBinding2;
                                        }
                                        fieldBinding2 = insideProblem;
                                        return fieldBinding2;
                                    }
                                    if (foundField.isValidBinding() && ((FieldBinding)foundField).declaringClass != fieldBinding.declaringClass) {
                                        return new ProblemFieldBinding(fieldBinding.declaringClass, name, 5);
                                    }
                                }
                            }
                            if (foundField == null || foundField.problemId() == 2 && fieldBinding.problemId() != 2) {
                                foundDepth = depth;
                                foundActualReceiverType = enclosingType;
                                foundInsideProblem = insideProblem;
                                foundField = fieldBinding;
                            }
                        }
                        ++depth;
                        insideStaticContext |= enclosingType.isStatic();
                        MethodScope enclosingMethodScope = scope.methodScope();
                        insideConstructorCall = enclosingMethodScope == null ? false : enclosingMethodScope.isConstructorCall;
                        break;
                    }
                    case 4: {
                        break block6;
                    }
                }
                scope = scope.parent;
            }
            if (foundInsideProblem != null) {
                return foundInsideProblem;
            }
            if (foundField != null) {
                if (foundField.isValidBinding()) {
                    if (foundDepth <= 0) return foundField;
                    invocationSite.setDepth(foundDepth);
                    invocationSite.setActualReceiverType(foundActualReceiverType);
                    return foundField;
                }
                problemField = foundField;
            }
        }
        if ((mask & 4) != 0) {
            binding = this.getBaseType(name);
            if (binding != null) {
                return binding;
            }
            binding = this.getTypeOrPackage(name, (mask & 0x10) == 0 ? 4 : 20);
            if (binding.isValidBinding()) return binding;
            if (mask == 4) {
                return binding;
            }
        } else if ((mask & 0x10) != 0) {
            this.compilationUnitScope().recordSimpleReference(name);
            binding = this.environment().getTopLevelPackage(name);
            if (binding != null) {
                return binding;
            }
        }
        if (problemField == null) return new ProblemBinding(name, (ReferenceBinding)this.enclosingSourceType(), 1);
        return problemField;
    }

    public MethodBinding getConstructor(ReferenceBinding receiverType, TypeBinding[] argumentTypes, InvocationSite invocationSite) {
        this.compilationUnitScope().recordTypeReference(receiverType);
        this.compilationUnitScope().recordTypeReferences(argumentTypes);
        MethodBinding methodBinding = receiverType.getExactConstructor(argumentTypes);
        if (methodBinding != null && methodBinding.canBeSeenBy(invocationSite, this)) {
            return methodBinding;
        }
        MethodBinding[] methods = receiverType.getMethods(ConstructorDeclaration.ConstantPoolName);
        if (methods == TypeConstants.NoMethods) {
            return new ProblemMethodBinding(ConstructorDeclaration.ConstantPoolName, argumentTypes, 1);
        }
        MethodBinding[] compatible = new MethodBinding[methods.length];
        int compatibleIndex = 0;
        int i = 0;
        int length = methods.length;
        while (i < length) {
            if (this.areParametersAssignable(methods[i].parameters, argumentTypes)) {
                compatible[compatibleIndex++] = methods[i];
            }
            ++i;
        }
        if (compatibleIndex == 0) {
            return new ProblemMethodBinding(ConstructorDeclaration.ConstantPoolName, argumentTypes, 1);
        }
        MethodBinding[] visible = new MethodBinding[compatibleIndex];
        int visibleIndex = 0;
        int i2 = 0;
        while (i2 < compatibleIndex) {
            MethodBinding method = compatible[i2];
            if (method.canBeSeenBy(invocationSite, this)) {
                visible[visibleIndex++] = method;
            }
            ++i2;
        }
        if (visibleIndex == 1) {
            return visible[0];
        }
        if (visibleIndex == 0) {
            return new ProblemMethodBinding(compatible[0], ConstructorDeclaration.ConstantPoolName, compatible[0].parameters, 2);
        }
        return this.mostSpecificClassMethodBinding(visible, visibleIndex);
    }

    public final PackageBinding getCurrentPackage() {
        Scope scope;
        Scope unitScope = this;
        while ((scope = unitScope.parent) != null) {
            unitScope = scope;
        }
        return ((CompilationUnitScope)unitScope).fPackage;
    }

    public int getDeclarationModifiers() {
        switch (this.kind) {
            case 1: 
            case 2: {
                MethodScope methodScope = this.methodScope();
                if (!methodScope.isInsideInitializer()) {
                    MethodBinding context = ((AbstractMethodDeclaration)methodScope.referenceContext).binding;
                    if (context == null) break;
                    return context.modifiers;
                }
                SourceTypeBinding type = ((BlockScope)this).referenceType().binding;
                if (methodScope.initializedField != null) {
                    return methodScope.initializedField.modifiers;
                }
                if (type == null) break;
                return type.modifiers;
            }
            case 3: {
                SourceTypeBinding context = ((ClassScope)this).referenceType().binding;
                if (context == null) break;
                return context.modifiers;
            }
        }
        return -1;
    }

    public FieldBinding getField(TypeBinding receiverType, char[] fieldName, InvocationSite invocationSite) {
        FieldBinding field = this.findField(receiverType, fieldName, invocationSite, true);
        if (field != null) {
            return field;
        }
        return new ProblemFieldBinding(receiverType instanceof ReferenceBinding ? (ReferenceBinding)receiverType : null, fieldName, 1);
    }

    public final ReferenceBinding getJavaIoSerializable() {
        this.compilationUnitScope().recordQualifiedReference(TypeConstants.JAVA_IO_SERIALIZABLE);
        ReferenceBinding type = this.environment().getType(TypeConstants.JAVA_IO_SERIALIZABLE);
        if (type != null) {
            return type;
        }
        this.problemReporter().isClassPathCorrect(TypeConstants.JAVA_IO_SERIALIZABLE, this.referenceCompilationUnit());
        return null;
    }

    public final ReferenceBinding getJavaLangAssertionError() {
        this.compilationUnitScope().recordQualifiedReference(TypeConstants.JAVA_LANG_ASSERTIONERROR);
        ReferenceBinding type = this.environment().getType(TypeConstants.JAVA_LANG_ASSERTIONERROR);
        if (type != null) {
            return type;
        }
        this.problemReporter().isClassPathCorrect(TypeConstants.JAVA_LANG_ASSERTIONERROR, this.referenceCompilationUnit());
        return null;
    }

    public final ReferenceBinding getJavaLangClass() {
        this.compilationUnitScope().recordQualifiedReference(TypeConstants.JAVA_LANG_CLASS);
        ReferenceBinding type = this.environment().getType(TypeConstants.JAVA_LANG_CLASS);
        if (type != null) {
            return type;
        }
        this.problemReporter().isClassPathCorrect(TypeConstants.JAVA_LANG_CLASS, this.referenceCompilationUnit());
        return null;
    }

    public final ReferenceBinding getJavaLangCloneable() {
        this.compilationUnitScope().recordQualifiedReference(TypeConstants.JAVA_LANG_CLONEABLE);
        ReferenceBinding type = this.environment().getType(TypeConstants.JAVA_LANG_CLONEABLE);
        if (type != null) {
            return type;
        }
        this.problemReporter().isClassPathCorrect(TypeConstants.JAVA_LANG_CLONEABLE, this.referenceCompilationUnit());
        return null;
    }

    public final ReferenceBinding getJavaLangError() {
        this.compilationUnitScope().recordQualifiedReference(TypeConstants.JAVA_LANG_ERROR);
        ReferenceBinding type = this.environment().getType(TypeConstants.JAVA_LANG_ERROR);
        if (type != null) {
            return type;
        }
        this.problemReporter().isClassPathCorrect(TypeConstants.JAVA_LANG_ERROR, this.referenceCompilationUnit());
        return null;
    }

    public final ReferenceBinding getJavaLangObject() {
        this.compilationUnitScope().recordQualifiedReference(TypeConstants.JAVA_LANG_OBJECT);
        ReferenceBinding type = this.environment().getType(TypeConstants.JAVA_LANG_OBJECT);
        if (type != null) {
            return type;
        }
        this.problemReporter().isClassPathCorrect(TypeConstants.JAVA_LANG_OBJECT, this.referenceCompilationUnit());
        return null;
    }

    public final ReferenceBinding getJavaLangRuntimeException() {
        this.compilationUnitScope().recordQualifiedReference(TypeConstants.JAVA_LANG_RUNTIMEEXCEPTION);
        ReferenceBinding type = this.environment().getType(TypeConstants.JAVA_LANG_RUNTIMEEXCEPTION);
        if (type != null) {
            return type;
        }
        this.problemReporter().isClassPathCorrect(TypeConstants.JAVA_LANG_RUNTIMEEXCEPTION, this.referenceCompilationUnit());
        return null;
    }

    public final ReferenceBinding getJavaLangString() {
        this.compilationUnitScope().recordQualifiedReference(TypeConstants.JAVA_LANG_STRING);
        ReferenceBinding type = this.environment().getType(TypeConstants.JAVA_LANG_STRING);
        if (type != null) {
            return type;
        }
        this.problemReporter().isClassPathCorrect(TypeConstants.JAVA_LANG_STRING, this.referenceCompilationUnit());
        return null;
    }

    public final ReferenceBinding getJavaLangThrowable() {
        this.compilationUnitScope().recordQualifiedReference(TypeConstants.JAVA_LANG_THROWABLE);
        ReferenceBinding type = this.environment().getType(TypeConstants.JAVA_LANG_THROWABLE);
        if (type != null) {
            return type;
        }
        this.problemReporter().isClassPathCorrect(TypeConstants.JAVA_LANG_THROWABLE, this.referenceCompilationUnit());
        return null;
    }

    public final ReferenceBinding getMemberType(char[] typeName, ReferenceBinding enclosingType) {
        ReferenceBinding memberType = this.findMemberType(typeName, enclosingType);
        if (memberType != null) {
            return memberType;
        }
        return new ProblemReferenceBinding(typeName, 1);
    }

    public MethodBinding getMethod(TypeBinding receiverType, char[] selector, TypeBinding[] argumentTypes, InvocationSite invocationSite) {
        if (receiverType.isArrayType()) {
            return this.findMethodForArray((ArrayBinding)receiverType, selector, argumentTypes, invocationSite);
        }
        if (receiverType.isBaseType()) {
            return new ProblemMethodBinding(selector, argumentTypes, 1);
        }
        ReferenceBinding currentType = (ReferenceBinding)receiverType;
        if (!currentType.canBeSeenBy(this)) {
            return new ProblemMethodBinding(selector, argumentTypes, 8);
        }
        MethodBinding methodBinding = this.findExactMethod(currentType, selector, argumentTypes, invocationSite);
        if (methodBinding != null) {
            return methodBinding;
        }
        methodBinding = this.findMethod(currentType, selector, argumentTypes, invocationSite);
        if (methodBinding == null) {
            return new ProblemMethodBinding(selector, argumentTypes, 1);
        }
        if (methodBinding.isValidBinding()) {
            if (!this.areParametersAssignable(methodBinding.parameters, argumentTypes)) {
                return new ProblemMethodBinding(methodBinding, selector, argumentTypes, 1);
            }
            if (!methodBinding.canBeSeenBy(currentType, invocationSite, this)) {
                return new ProblemMethodBinding(methodBinding, selector, methodBinding.parameters, 2);
            }
        }
        return methodBinding;
    }

    public final TypeBinding getType(char[] name) {
        TypeBinding binding = this.getBaseType(name);
        if (binding != null) {
            return binding;
        }
        return (ReferenceBinding)this.getTypeOrPackage(name, 4);
    }

    /*
     * Unable to fully structure code
     */
    public final TypeBinding getType(char[][] compoundName) {
        typeNameLength = compoundName.length;
        if (typeNameLength == 1 && (binding = this.getBaseType(compoundName[0])) != null) {
            return binding;
        }
        this.compilationUnitScope().recordQualifiedReference(compoundName);
        binding = this.getTypeOrPackage(compoundName[0], typeNameLength == 1 ? 4 : 20);
        if (binding == null) {
            return new ProblemReferenceBinding(compoundName[0], 1);
        }
        if (!binding.isValidBinding()) {
            return (ReferenceBinding)binding;
        }
        currentIndex = 1;
        checkVisibility = false;
        if (binding instanceof PackageBinding) {
            packageBinding = (PackageBinding)binding;
            while (currentIndex < typeNameLength) {
                if ((binding = packageBinding.getTypeOrPackage(compoundName[currentIndex++])) == null) {
                    return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, currentIndex), 1);
                }
                if (!binding.isValidBinding()) {
                    return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, currentIndex), binding.problemId());
                }
                if (!(binding instanceof PackageBinding)) break;
                packageBinding = (PackageBinding)binding;
            }
            if (binding instanceof PackageBinding) {
                return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, currentIndex), 1);
            }
            checkVisibility = true;
        }
        typeBinding = (ReferenceBinding)binding;
        this.compilationUnitScope().recordTypeReference(typeBinding);
        if (!checkVisibility || typeBinding.canBeSeenBy(this)) ** GOTO lbl31
        return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, currentIndex), typeBinding, 2);
lbl-1000:
        // 1 sources

        {
            if ((typeBinding = this.getMemberType(compoundName[currentIndex++], typeBinding)).isValidBinding()) continue;
            return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, currentIndex), typeBinding.problemId());
lbl31:
            // 2 sources

            ** while (currentIndex < typeNameLength)
        }
lbl32:
        // 1 sources

        return typeBinding;
    }

    /*
     * Enabled aggressive block sorting
     */
    final Binding getTypeOrPackage(char[] name, int mask) {
        PackageBinding packageBinding;
        Scope scope = this;
        Binding foundType = null;
        if ((mask & 4) == 0) {
            Scope next = scope;
            while ((next = scope.parent) != null) {
                scope = next;
            }
        } else {
            block6: while (true) {
                switch (scope.kind) {
                    case 1: 
                    case 2: {
                        ReferenceBinding localType = ((BlockScope)scope).findLocalType(name);
                        if (localType == null) break;
                        if (foundType != null && foundType != localType) {
                            return new ProblemReferenceBinding(name, 5);
                        }
                        return localType;
                    }
                    case 3: {
                        SourceTypeBinding sourceType = ((ClassScope)scope).referenceContext.binding;
                        ReferenceBinding memberType = this.findMemberType(name, sourceType);
                        if (memberType != null) {
                            if (memberType.problemId() == 3) {
                                if (foundType != null && foundType.problemId() != 2) {
                                    return new ProblemReferenceBinding(name, 5);
                                }
                                return memberType;
                            }
                            if (memberType.isValidBinding() && (sourceType == memberType.enclosingType() || this.environment().options.complianceLevel >= 0x300000L)) {
                                if (foundType == null) {
                                    return memberType;
                                }
                                if (foundType.isValidBinding() && foundType != memberType) {
                                    return new ProblemReferenceBinding(name, 5);
                                }
                            }
                            if (foundType == null || foundType.problemId() == 2 && memberType.problemId() != 2) {
                                foundType = memberType;
                            }
                        }
                        if (!CharOperation.equals(sourceType.sourceName, name)) break;
                        if (foundType != null && foundType != sourceType && foundType.problemId() != 2) {
                            return new ProblemReferenceBinding(name, 5);
                        }
                        return sourceType;
                    }
                    case 4: {
                        break block6;
                    }
                }
                scope = scope.parent;
            }
            if (foundType != null && foundType.problemId() != 2) {
                return foundType;
            }
        }
        CompilationUnitScope unitScope = (CompilationUnitScope)scope;
        PackageBinding currentPackage = unitScope.fPackage;
        if ((mask & 4) != 0) {
            ImportBinding[] imports = unitScope.imports;
            if (imports != null) {
                HashtableOfObject typeImports = unitScope.resolvedSingeTypeImports;
                if (typeImports != null) {
                    ImportBinding typeImport = (ImportBinding)typeImports.get(name);
                    if (typeImport != null) {
                        ImportReference importReference = typeImport.reference;
                        if (importReference != null) {
                            importReference.used = true;
                        }
                        return typeImport.resolvedImport;
                    }
                } else {
                    int i = 0;
                    int length = imports.length;
                    while (i < length) {
                        ImportBinding typeImport = imports[i];
                        if (!typeImport.onDemand && CharOperation.equals(typeImport.compoundName[typeImport.compoundName.length - 1], name) && unitScope.resolveSingleTypeImport(typeImport) != null) {
                            ImportReference importReference = typeImport.reference;
                            if (importReference != null) {
                                importReference.used = true;
                            }
                            return typeImport.resolvedImport;
                        }
                        ++i;
                    }
                }
            }
            unitScope.recordReference(currentPackage.compoundName, name);
            Binding binding = currentPackage.getTypeOrPackage(name);
            if (binding instanceof ReferenceBinding) {
                return binding;
            }
            if (imports != null) {
                boolean foundInImport = false;
                ReferenceBinding type = null;
                int i = 0;
                int length = imports.length;
                while (i < length) {
                    ImportBinding someImport = imports[i];
                    if (someImport.onDemand) {
                        ReferenceBinding temp;
                        Binding resolvedImport = someImport.resolvedImport;
                        ReferenceBinding referenceBinding = temp = resolvedImport instanceof PackageBinding ? this.findType(name, (PackageBinding)resolvedImport, currentPackage) : this.findDirectMemberType(name, (ReferenceBinding)resolvedImport);
                        if (temp != null) {
                            if (temp.isValidBinding()) {
                                ImportReference importReference = someImport.reference;
                                if (importReference != null) {
                                    importReference.used = true;
                                }
                                if (foundInImport) {
                                    return new ProblemReferenceBinding(name, 3);
                                }
                                type = temp;
                                foundInImport = true;
                            } else if (foundType == null) {
                                foundType = temp;
                            }
                        }
                    }
                    ++i;
                }
                if (type != null) {
                    return type;
                }
            }
        }
        unitScope.recordSimpleReference(name);
        if ((mask & 0x10) != 0 && (packageBinding = unitScope.environment.getTopLevelPackage(name)) != null) {
            return packageBinding;
        }
        if (foundType != null) {
            return foundType;
        }
        return new ProblemReferenceBinding(name, 1);
    }

    /*
     * Unable to fully structure code
     */
    public final Binding getTypeOrPackage(char[][] compoundName) {
        nameLength = compoundName.length;
        if (nameLength == 1 && (binding = this.getBaseType(compoundName[0])) != null) {
            return binding;
        }
        binding = this.getTypeOrPackage(compoundName[0], 20);
        if (!binding.isValidBinding()) {
            return binding;
        }
        currentIndex = 1;
        checkVisibility = false;
        if (binding instanceof PackageBinding) {
            packageBinding = (PackageBinding)binding;
            while (currentIndex < nameLength) {
                if ((binding = packageBinding.getTypeOrPackage(compoundName[currentIndex++])) == null) {
                    return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, currentIndex), 1);
                }
                if (!binding.isValidBinding()) {
                    return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, currentIndex), binding.problemId());
                }
                if (!(binding instanceof PackageBinding)) break;
                packageBinding = (PackageBinding)binding;
            }
            if (binding instanceof PackageBinding) {
                return binding;
            }
            checkVisibility = true;
        }
        typeBinding = (ReferenceBinding)binding;
        if (!checkVisibility || typeBinding.canBeSeenBy(this)) ** GOTO lbl27
        return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, currentIndex), typeBinding, 2);
lbl-1000:
        // 1 sources

        {
            if ((typeBinding = this.getMemberType(compoundName[currentIndex++], typeBinding)).isValidBinding()) continue;
            return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, currentIndex), typeBinding.problemId());
lbl27:
            // 2 sources

            ** while (currentIndex < nameLength)
        }
lbl28:
        // 1 sources

        return typeBinding;
    }

    public final boolean isDefinedInField(FieldBinding field) {
        Scope scope = this;
        do {
            if (!(scope instanceof MethodScope)) continue;
            MethodScope methodScope = (MethodScope)scope;
            if (methodScope.initializedField != field) continue;
            return true;
        } while ((scope = scope.parent) != null);
        return false;
    }

    public final boolean isDefinedInMethod(MethodBinding method) {
        Scope scope = this;
        do {
            ReferenceContext refContext;
            if (!(scope instanceof MethodScope) || !((refContext = ((MethodScope)scope).referenceContext) instanceof AbstractMethodDeclaration) || ((AbstractMethodDeclaration)refContext).binding != method) continue;
            return true;
        } while ((scope = scope.parent) != null);
        return false;
    }

    public final boolean isDefinedInSameUnit(ReferenceBinding type) {
        Scope scope;
        ReferenceBinding enclosingType = type;
        while ((type = enclosingType.enclosingType()) != null) {
            enclosingType = type;
        }
        Scope unitScope = this;
        while ((scope = unitScope.parent) != null) {
            unitScope = scope;
        }
        SourceTypeBinding[] topLevelTypes = ((CompilationUnitScope)unitScope).topLevelTypes;
        int i = topLevelTypes.length;
        while (--i >= 0) {
            if (topLevelTypes[i] != enclosingType) continue;
            return true;
        }
        return false;
    }

    public final boolean isDefinedInType(ReferenceBinding type) {
        Scope scope = this;
        do {
            if (!(scope instanceof ClassScope) || ((ClassScope)scope).referenceContext.binding != type) continue;
            return true;
        } while ((scope = scope.parent) != null);
        return false;
    }

    public boolean isInsideDeprecatedCode() {
        switch (this.kind) {
            case 1: 
            case 2: {
                MethodScope methodScope = this.methodScope();
                if (!methodScope.isInsideInitializer()) {
                    MethodBinding context = ((AbstractMethodDeclaration)methodScope.referenceContext).binding;
                    if (context == null || !context.isViewedAsDeprecated()) break;
                    return true;
                }
                SourceTypeBinding type = ((BlockScope)this).referenceType().binding;
                if (methodScope.initializedField != null && methodScope.initializedField.isViewedAsDeprecated()) {
                    return true;
                }
                if (type == null || !type.isViewedAsDeprecated()) break;
                return true;
            }
            case 3: {
                SourceTypeBinding context = ((ClassScope)this).referenceType().binding;
                if (context == null || !context.isViewedAsDeprecated()) break;
                return true;
            }
        }
        return false;
    }

    public final boolean isJavaIoSerializable(TypeBinding tb) {
        return tb == this.getJavaIoSerializable();
    }

    public final boolean isJavaLangCloneable(TypeBinding tb) {
        return tb == this.getJavaLangCloneable();
    }

    public final boolean isJavaLangObject(TypeBinding type) {
        return type.id == 1;
    }

    public final MethodScope methodScope() {
        Scope scope = this;
        do {
            if (!(scope instanceof MethodScope)) continue;
            return (MethodScope)scope;
        } while ((scope = scope.parent) != null);
        return null;
    }

    protected final MethodBinding mostSpecificClassMethodBinding(MethodBinding[] visible, int visibleSize) {
        MethodBinding method = null;
        MethodBinding previous = null;
        int i = 0;
        while (i < visibleSize) {
            block4: {
                method = visible[i];
                if (previous != null && method.declaringClass != previous.declaringClass) break;
                previous = method;
                int j = 0;
                while (j < visibleSize) {
                    if (i != j) {
                        MethodBinding next = visible[j];
                        if (!this.areParametersAssignable(next.parameters, method.parameters)) break block4;
                    }
                    ++j;
                }
                this.compilationUnitScope().recordTypeReferences(method.thrownExceptions);
                return method;
            }
            ++i;
        }
        return new ProblemMethodBinding(visible[0].selector, visible[0].parameters, 3);
    }

    protected final MethodBinding mostSpecificInterfaceMethodBinding(MethodBinding[] visible, int visibleSize) {
        MethodBinding method = null;
        int i = 0;
        while (i < visibleSize) {
            block4: {
                method = visible[i];
                int j = 0;
                while (j < visibleSize) {
                    if (i != j) {
                        MethodBinding next = visible[j];
                        if (!this.areParametersAssignable(next.parameters, method.parameters)) break block4;
                    }
                    ++j;
                }
                this.compilationUnitScope().recordTypeReferences(method.thrownExceptions);
                return method;
            }
            ++i;
        }
        return new ProblemMethodBinding(visible[0].selector, visible[0].parameters, 3);
    }

    public final ClassScope outerMostClassScope() {
        ClassScope lastClassScope = null;
        Scope scope = this;
        do {
            if (!(scope instanceof ClassScope)) continue;
            lastClassScope = (ClassScope)scope;
        } while ((scope = scope.parent) != null);
        return lastClassScope;
    }

    public final MethodScope outerMostMethodScope() {
        MethodScope lastMethodScope = null;
        Scope scope = this;
        do {
            if (!(scope instanceof MethodScope)) continue;
            lastMethodScope = (MethodScope)scope;
        } while ((scope = scope.parent) != null);
        return lastMethodScope;
    }

    public abstract ProblemReporter problemReporter();

    public final CompilationUnitDeclaration referenceCompilationUnit() {
        Scope scope;
        Scope unitScope = this;
        while ((scope = unitScope.parent) != null) {
            unitScope = scope;
        }
        return ((CompilationUnitScope)unitScope).referenceContext;
    }

    int startIndex() {
        return 0;
    }
}

