/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.batch;

import java.io.File;
import java.io.IOException;
import java.util.zip.ZipFile;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.batch.ClasspathDirectory;
import org.eclipse.jdt.internal.compiler.batch.ClasspathJar;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.jdt.internal.compiler.util.SuffixConstants;

public class FileSystem
implements INameEnvironment,
SuffixConstants {
    Classpath[] classpaths;
    String[] knownFileNames;

    public FileSystem(String[] classpathNames, String[] initialFileNames, String encoding) {
        this(classpathNames, initialFileNames, encoding, null);
    }

    public FileSystem(String[] classpathNames, String[] initialFileNames, String encoding, int[] classpathDirectoryModes) {
        int classpathSize = classpathNames.length;
        this.classpaths = new Classpath[classpathSize];
        String[] pathNames = new String[classpathSize];
        int problemsOccured = 0;
        int i = 0;
        while (i < classpathSize) {
            try {
                File file = new File(this.convertPathSeparators(classpathNames[i]));
                if (file.isDirectory()) {
                    if (file.exists()) {
                        this.classpaths[i] = classpathDirectoryModes == null ? new ClasspathDirectory(file, encoding) : new ClasspathDirectory(file, encoding, classpathDirectoryModes[i]);
                        pathNames[i] = ((ClasspathDirectory)this.classpaths[i]).path;
                    }
                } else if (classpathNames[i].endsWith(".jar") | classpathNames[i].endsWith(".zip")) {
                    this.classpaths[i] = this.getClasspathJar(file);
                    pathNames[i] = classpathNames[i].substring(0, classpathNames[i].lastIndexOf(46));
                }
            }
            catch (IOException iOException) {
                this.classpaths[i] = null;
            }
            if (this.classpaths[i] == null) {
                ++problemsOccured;
            }
            ++i;
        }
        if (problemsOccured > 0) {
            Classpath[] newPaths = new Classpath[classpathSize - problemsOccured];
            String[] newNames = new String[classpathSize - problemsOccured];
            int i2 = 0;
            int current = 0;
            while (i2 < classpathSize) {
                if (this.classpaths[i2] != null) {
                    newPaths[current] = this.classpaths[i2];
                    newNames[current++] = pathNames[i2];
                }
                ++i2;
            }
            classpathSize = newPaths.length;
            this.classpaths = newPaths;
            pathNames = newNames;
        }
        this.knownFileNames = new String[initialFileNames.length];
        i = initialFileNames.length;
        while (--i >= 0) {
            String fileName = initialFileNames[i];
            String matchingPathName = null;
            if (fileName.lastIndexOf(".") != -1) {
                fileName = fileName.substring(0, fileName.lastIndexOf(46));
            }
            fileName = this.convertPathSeparators(fileName);
            int j = 0;
            while (j < classpathSize) {
                if (fileName.startsWith(pathNames[j])) {
                    matchingPathName = pathNames[j];
                }
                ++j;
            }
            this.knownFileNames[i] = matchingPathName == null ? fileName : fileName.substring(matchingPathName.length());
        }
    }

    public void cleanup() {
        int i = 0;
        int max = this.classpaths.length;
        while (i < max) {
            this.classpaths[i].reset();
            ++i;
        }
    }

    private String convertPathSeparators(String path) {
        return File.separatorChar == '/' ? path.replace('\\', '/') : path.replace('/', '\\');
    }

    private NameEnvironmentAnswer findClass(String qualifiedTypeName, char[] typeName) {
        String qp2;
        int i = 0;
        int length = this.knownFileNames.length;
        while (i < length) {
            if (qualifiedTypeName.equals(this.knownFileNames[i])) {
                return null;
            }
            ++i;
        }
        String qualifiedBinaryFileName = String.valueOf(qualifiedTypeName) + ".class";
        String qualifiedPackageName = qualifiedTypeName.length() == typeName.length ? "" : qualifiedBinaryFileName.substring(0, qualifiedTypeName.length() - typeName.length - 1);
        String string = qp2 = File.separatorChar == '/' ? qualifiedPackageName : qualifiedPackageName.replace('/', File.separatorChar);
        if (qualifiedPackageName == qp2) {
            int i2 = 0;
            int length2 = this.classpaths.length;
            while (i2 < length2) {
                NameEnvironmentAnswer answer = this.classpaths[i2].findClass(typeName, qualifiedPackageName, qualifiedBinaryFileName);
                if (answer != null) {
                    return answer;
                }
                ++i2;
            }
        } else {
            String qb2 = qualifiedBinaryFileName.replace('/', File.separatorChar);
            int i3 = 0;
            int length3 = this.classpaths.length;
            while (i3 < length3) {
                NameEnvironmentAnswer answer;
                Classpath p = this.classpaths[i3];
                NameEnvironmentAnswer nameEnvironmentAnswer = answer = p instanceof ClasspathJar ? p.findClass(typeName, qualifiedPackageName, qualifiedBinaryFileName) : p.findClass(typeName, qp2, qb2);
                if (answer != null) {
                    return answer;
                }
                ++i3;
            }
        }
        return null;
    }

    public NameEnvironmentAnswer findType(char[][] compoundName) {
        if (compoundName != null) {
            return this.findClass(new String(CharOperation.concatWith(compoundName, '/')), compoundName[compoundName.length - 1]);
        }
        return null;
    }

    public NameEnvironmentAnswer findType(char[] typeName, char[][] packageName) {
        if (typeName != null) {
            return this.findClass(new String(CharOperation.concatWith(packageName, typeName, '/')), typeName);
        }
        return null;
    }

    public ClasspathJar getClasspathJar(File file) throws IOException {
        return new ClasspathJar(new ZipFile(file), true);
    }

    public boolean isPackage(char[][] compoundName, char[] packageName) {
        String qp2;
        String qualifiedPackageName = new String(CharOperation.concatWith(compoundName, packageName, '/'));
        String string = qp2 = File.separatorChar == '/' ? qualifiedPackageName : qualifiedPackageName.replace('/', File.separatorChar);
        if (qualifiedPackageName == qp2) {
            int i = 0;
            int length = this.classpaths.length;
            while (i < length) {
                if (this.classpaths[i].isPackage(qualifiedPackageName)) {
                    return true;
                }
                ++i;
            }
        } else {
            int i = 0;
            int length = this.classpaths.length;
            while (i < length) {
                Classpath p = this.classpaths[i];
                if (p instanceof ClasspathJar ? p.isPackage(qualifiedPackageName) : p.isPackage(qp2)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    interface Classpath {
        public NameEnvironmentAnswer findClass(char[] var1, String var2, String var3);

        public boolean isPackage(String var1);

        public void reset();
    }
}

