/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom;

import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTMatcher;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.internal.compiler.parser.Scanner;

public class SimpleName
extends Name {
    private static final String MISSING_IDENTIFIER = "MISSING";
    private String identifier = "MISSING";

    SimpleName(AST ast) {
        super(ast);
    }

    public int getNodeType() {
        return 42;
    }

    ASTNode clone(AST target) {
        SimpleName result = new SimpleName(target);
        result.setSourceRange(this.getStartPosition(), this.getLength());
        result.setIdentifier(this.getIdentifier());
        return result;
    }

    public boolean subtreeMatch(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    void accept0(ASTVisitor visitor) {
        visitor.visit(this);
        visitor.endVisit(this);
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        if (identifier == null) {
            throw new IllegalArgumentException();
        }
        Scanner scanner = this.getAST().scanner;
        char[] source = identifier.toCharArray();
        scanner.setSource(source);
        scanner.resetTo(0, source.length);
        try {
            int tokenType = scanner.getNextToken();
            switch (tokenType) {
                case 28: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }
        catch (InvalidInputException invalidInputException) {
            throw new IllegalArgumentException();
        }
        this.modifying();
        this.identifier = identifier;
    }

    public boolean isDeclaration() {
        ASTNode parent = this.getParent();
        if (parent == null) {
            return false;
        }
        if (parent instanceof TypeDeclaration) {
            return true;
        }
        if (parent instanceof MethodDeclaration) {
            MethodDeclaration p = (MethodDeclaration)parent;
            return !p.isConstructor();
        }
        if (parent instanceof SingleVariableDeclaration) {
            SingleVariableDeclaration p = (SingleVariableDeclaration)parent;
            return p.getName() == this;
        }
        if (parent instanceof VariableDeclarationFragment) {
            VariableDeclarationFragment p = (VariableDeclarationFragment)parent;
            return p.getName() == this;
        }
        return false;
    }

    int memSize() {
        int size = 48;
        if (this.identifier != null) {
            size += 28;
            size += 12 + 2 * this.identifier.length();
        }
        return size;
    }

    int treeSize() {
        return this.memSize();
    }
}

