/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom;

import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTMatcher;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.internal.compiler.parser.Scanner;

public class Javadoc
extends ASTNode {
    private String comment = "/** */";

    Javadoc(AST ast) {
        super(ast);
    }

    public int getNodeType() {
        return 29;
    }

    ASTNode clone(AST target) {
        Javadoc result = new Javadoc(target);
        result.setSourceRange(this.getStartPosition(), this.getLength());
        result.setComment(this.getComment());
        return result;
    }

    public boolean subtreeMatch(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    void accept0(ASTVisitor visitor) {
        visitor.visit(this);
        visitor.endVisit(this);
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String javadocComment) {
        if (javadocComment == null) {
            throw new IllegalArgumentException();
        }
        char[] source = javadocComment.toCharArray();
        Scanner scanner = this.getAST().scanner;
        scanner.resetTo(0, source.length);
        scanner.setSource(source);
        try {
            int token;
            boolean onlyOneComment = false;
            while ((token = scanner.getNextToken()) != 54) {
                switch (token) {
                    case 1003: {
                        if (onlyOneComment) {
                            throw new IllegalArgumentException();
                        }
                        onlyOneComment = true;
                        break;
                    }
                    default: {
                        onlyOneComment = false;
                    }
                }
            }
            if (!onlyOneComment) {
                throw new IllegalArgumentException();
            }
        }
        catch (InvalidInputException invalidInputException) {
            throw new IllegalArgumentException();
        }
        this.modifying();
        this.comment = javadocComment;
    }

    int memSize() {
        int size = 44;
        return size += 32 + 2 * this.comment.length();
    }

    int treeSize() {
        return this.memSize();
    }
}

