/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTMatcher;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.NaiveASTFlattener;

public abstract class ASTNode {
    public static final int ANONYMOUS_CLASS_DECLARATION = 1;
    public static final int ARRAY_ACCESS = 2;
    public static final int ARRAY_CREATION = 3;
    public static final int ARRAY_INITIALIZER = 4;
    public static final int ARRAY_TYPE = 5;
    public static final int ASSERT_STATEMENT = 6;
    public static final int ASSIGNMENT = 7;
    public static final int BLOCK = 8;
    public static final int BOOLEAN_LITERAL = 9;
    public static final int BREAK_STATEMENT = 10;
    public static final int CAST_EXPRESSION = 11;
    public static final int CATCH_CLAUSE = 12;
    public static final int CHARACTER_LITERAL = 13;
    public static final int CLASS_INSTANCE_CREATION = 14;
    public static final int COMPILATION_UNIT = 15;
    public static final int CONDITIONAL_EXPRESSION = 16;
    public static final int CONSTRUCTOR_INVOCATION = 17;
    public static final int CONTINUE_STATEMENT = 18;
    public static final int DO_STATEMENT = 19;
    public static final int EMPTY_STATEMENT = 20;
    public static final int EXPRESSION_STATEMENT = 21;
    public static final int FIELD_ACCESS = 22;
    public static final int FIELD_DECLARATION = 23;
    public static final int FOR_STATEMENT = 24;
    public static final int IF_STATEMENT = 25;
    public static final int IMPORT_DECLARATION = 26;
    public static final int INFIX_EXPRESSION = 27;
    public static final int INITIALIZER = 28;
    public static final int JAVADOC = 29;
    public static final int LABELED_STATEMENT = 30;
    public static final int METHOD_DECLARATION = 31;
    public static final int METHOD_INVOCATION = 32;
    public static final int NULL_LITERAL = 33;
    public static final int NUMBER_LITERAL = 34;
    public static final int PACKAGE_DECLARATION = 35;
    public static final int PARENTHESIZED_EXPRESSION = 36;
    public static final int POSTFIX_EXPRESSION = 37;
    public static final int PREFIX_EXPRESSION = 38;
    public static final int PRIMITIVE_TYPE = 39;
    public static final int QUALIFIED_NAME = 40;
    public static final int RETURN_STATEMENT = 41;
    public static final int SIMPLE_NAME = 42;
    public static final int SIMPLE_TYPE = 43;
    public static final int SINGLE_VARIABLE_DECLARATION = 44;
    public static final int STRING_LITERAL = 45;
    public static final int SUPER_CONSTRUCTOR_INVOCATION = 46;
    public static final int SUPER_FIELD_ACCESS = 47;
    public static final int SUPER_METHOD_INVOCATION = 48;
    public static final int SWITCH_CASE = 49;
    public static final int SWITCH_STATEMENT = 50;
    public static final int SYNCHRONIZED_STATEMENT = 51;
    public static final int THIS_EXPRESSION = 52;
    public static final int THROW_STATEMENT = 53;
    public static final int TRY_STATEMENT = 54;
    public static final int TYPE_DECLARATION = 55;
    public static final int TYPE_DECLARATION_STATEMENT = 56;
    public static final int TYPE_LITERAL = 57;
    public static final int VARIABLE_DECLARATION_EXPRESSION = 58;
    public static final int VARIABLE_DECLARATION_FRAGMENT = 59;
    public static final int VARIABLE_DECLARATION_STATEMENT = 60;
    public static final int WHILE_STATEMENT = 61;
    public static final int INSTANCEOF_EXPRESSION = 62;
    private final AST owner;
    private ASTNode parent = null;
    private static Map UNMODIFIABLE_EMPTY_MAP = Collections.unmodifiableMap(new HashMap(1));
    private Object property1 = null;
    private Object property2 = null;
    private int startPosition = -1;
    private int length = 0;
    public static final int MALFORMED = 1;
    private int flags = 0;
    static final int HEADERS = 12;
    static final int BASE_NODE_SIZE = 40;

    ASTNode(AST ast) {
        if (ast == null) {
            throw new IllegalArgumentException();
        }
        this.owner = ast;
        this.modifying();
    }

    public AST getAST() {
        return this.owner;
    }

    public ASTNode getParent() {
        return this.parent;
    }

    public ASTNode getRoot() {
        ASTNode candidate = this;
        ASTNode p;
        while ((p = candidate.getParent()) != null) {
            candidate = p;
        }
        return candidate;
    }

    void modifying() {
        this.getAST().modifying();
    }

    void setParent(ASTNode parent) {
        this.modifying();
        this.parent = parent;
    }

    void replaceChild(ASTNode oldChild, ASTNode newChild, boolean cycleCheck) {
        if (newChild != null) {
            ASTNode.checkNewChild(this, newChild, cycleCheck, null);
        }
        if (oldChild != null) {
            oldChild.setParent(null);
        }
        if (newChild != null) {
            newChild.setParent(this);
        }
    }

    static void checkNewChild(ASTNode node, ASTNode newChild, boolean cycleCheck, Class nodeType) {
        AST ast = node.getAST();
        if (newChild.getAST() != ast) {
            throw new IllegalArgumentException();
        }
        if (newChild.getParent() != null) {
            throw new IllegalArgumentException();
        }
        if (cycleCheck && newChild == node.getRoot()) {
            throw new IllegalArgumentException();
        }
        Class<?> childClass = newChild.getClass();
        if (nodeType != null && !nodeType.isAssignableFrom(childClass)) {
            throw new IllegalArgumentException();
        }
    }

    public Object getProperty(String propertyName) {
        if (propertyName == null) {
            throw new IllegalArgumentException();
        }
        if (this.property1 == null) {
            return null;
        }
        if (this.property1 instanceof String) {
            if (propertyName.equals(this.property1)) {
                return this.property2;
            }
            return null;
        }
        Map m = (Map)this.property1;
        return m.get(propertyName);
    }

    public void setProperty(String propertyName, Object data) {
        if (propertyName == null) {
            throw new IllegalArgumentException();
        }
        if (this.property1 == null) {
            if (data == null) {
                return;
            }
            this.property1 = propertyName;
            this.property2 = data;
            return;
        }
        if (this.property1 instanceof String) {
            if (propertyName.equals(this.property1)) {
                this.property2 = data;
                if (data == null) {
                    this.property1 = null;
                    this.property2 = null;
                }
                return;
            }
            if (data == null) {
                return;
            }
            HashMap<Object, Object> m = new HashMap<Object, Object>(2);
            m.put(this.property1, this.property2);
            m.put(propertyName, data);
            this.property1 = m;
            this.property2 = null;
            return;
        }
        HashMap m = (HashMap)this.property1;
        if (data == null) {
            m.remove(propertyName);
            if (m.size() == 1) {
                Map.Entry[] entries = m.entrySet().toArray(new Map.Entry[1]);
                this.property1 = entries[0].getKey();
                this.property2 = entries[0].getValue();
            }
            return;
        }
        m.put(propertyName, data);
    }

    public Map properties() {
        if (this.property1 == null) {
            return UNMODIFIABLE_EMPTY_MAP;
        }
        if (this.property1 instanceof String) {
            return Collections.singletonMap(this.property1, this.property2);
        }
        if (this.property2 == null) {
            this.property2 = Collections.unmodifiableMap((Map)this.property1);
        }
        return (Map)this.property2;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.modifying();
        this.flags = flags;
    }

    public abstract int getNodeType();

    public final boolean equals(Object obj) {
        return this == obj;
    }

    public abstract boolean subtreeMatch(ASTMatcher var1, Object var2);

    public static ASTNode copySubtree(AST target, ASTNode node) {
        if (node == null) {
            return null;
        }
        ASTNode newNode = node.clone(target);
        return newNode;
    }

    public static List copySubtrees(AST target, List nodes) {
        ArrayList<ASTNode> result = new ArrayList<ASTNode>(nodes.size());
        Iterator it = nodes.iterator();
        while (it.hasNext()) {
            ASTNode oldNode = (ASTNode)it.next();
            ASTNode newNode = oldNode.clone(target);
            result.add(newNode);
        }
        return result;
    }

    abstract ASTNode clone(AST var1);

    public final void accept(ASTVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException();
        }
        visitor.preVisit(this);
        this.accept0(visitor);
        visitor.postVisit(this);
    }

    abstract void accept0(ASTVisitor var1);

    final void acceptChild(ASTVisitor visitor, ASTNode child) {
        if (child == null) {
            return;
        }
        child.accept(visitor);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final void acceptChildren(ASTVisitor visitor, NodeList children) {
        NodeList.Cursor cursor = children.newCursor();
        try {
            while (cursor.hasNext()) {
                ASTNode child = (ASTNode)cursor.next();
                child.accept(visitor);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            children.releaseCursor(cursor);
            throw throwable;
        }
        {
            Object var5_7 = null;
            children.releaseCursor(cursor);
            return;
        }
    }

    public int getStartPosition() {
        return this.startPosition;
    }

    public int getLength() {
        return this.length;
    }

    public void setSourceRange(int startPosition, int length) {
        if (startPosition >= 0 && length < 0) {
            throw new IllegalArgumentException();
        }
        if (startPosition < 0 && length != 0) {
            throw new IllegalArgumentException();
        }
        this.modifying();
        this.startPosition = startPosition;
        this.length = length;
    }

    public final String toString() {
        StringBuffer buffer = new StringBuffer();
        int p = buffer.length();
        try {
            this.appendDebugString(buffer);
        }
        catch (RuntimeException runtimeException) {
            buffer.setLength(p);
            buffer.append("!");
            buffer.append(this.standardToString());
        }
        return buffer.toString();
    }

    final String standardToString() {
        return super.toString();
    }

    void appendDebugString(StringBuffer buffer) {
        this.appendPrintString(buffer);
    }

    final void appendPrintString(StringBuffer buffer) {
        NaiveASTFlattener printer = new NaiveASTFlattener();
        this.accept(printer);
        buffer.append(printer.getResult());
    }

    public final int subtreeBytes() {
        return this.treeSize();
    }

    abstract int treeSize();

    abstract int memSize();

    class NodeList
    extends AbstractList {
        ArrayList store = new ArrayList(0);
        private boolean cycleCheck;
        private Class nodeType;
        private List cursors = null;

        NodeList(boolean cycleCheck, Class nodeType) {
            this.cycleCheck = cycleCheck;
            this.nodeType = nodeType;
        }

        public int size() {
            return this.store.size();
        }

        public Object get(int index) {
            return this.store.get(index);
        }

        public Object set(int index, Object element) {
            ASTNode newChild = (ASTNode)element;
            ASTNode oldChild = (ASTNode)this.store.get(index);
            if (oldChild == newChild) {
                return oldChild;
            }
            ASTNode.checkNewChild(ASTNode.this, newChild, this.cycleCheck, this.nodeType);
            ASTNode result = this.store.set(index, newChild);
            oldChild.setParent(null);
            newChild.setParent(ASTNode.this);
            return result;
        }

        public void add(int index, Object element) {
            ASTNode newChild = (ASTNode)element;
            ASTNode.checkNewChild(ASTNode.this, newChild, this.cycleCheck, this.nodeType);
            this.store.add(index, element);
            this.updateCursors(index, 1);
            newChild.setParent(ASTNode.this);
        }

        public Object remove(int index) {
            ASTNode oldChild = (ASTNode)this.store.get(index);
            oldChild.setParent(null);
            Object result = this.store.remove(index);
            this.updateCursors(index, -1);
            return result;
        }

        Cursor newCursor() {
            if (this.cursors == null) {
                this.cursors = new ArrayList(1);
            }
            Cursor result = new Cursor();
            this.cursors.add(result);
            return result;
        }

        void releaseCursor(Cursor cursor) {
            this.cursors.remove(cursor);
            if (this.cursors.isEmpty()) {
                this.cursors = null;
            }
        }

        private void updateCursors(int index, int delta) {
            if (this.cursors == null) {
                return;
            }
            Iterator it = this.cursors.iterator();
            while (it.hasNext()) {
                Cursor c = (Cursor)it.next();
                c.update(index, delta);
            }
        }

        int memSize() {
            int result = 32;
            result += 20;
            return result += 12 + 4 * this.size();
        }

        int listSize() {
            int result = this.memSize();
            Iterator it = this.iterator();
            while (it.hasNext()) {
                ASTNode child = (ASTNode)it.next();
                result += child.treeSize();
            }
            return result;
        }

        class Cursor
        implements Iterator {
            private int position = 0;

            Cursor() {
            }

            public boolean hasNext() {
                return this.position < NodeList.this.store.size();
            }

            public Object next() {
                Object result = NodeList.this.store.get(this.position);
                ++this.position;
                return result;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }

            void update(int index, int delta) {
                if (this.position > index) {
                    this.position += delta;
                }
            }
        }
    }
}

