/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom;

import java.util.Map;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.dom.ASTConverter;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ArrayAccess;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.AssertStatement;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.BindingResolver;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BooleanLiteral;
import org.eclipse.jdt.core.dom.BreakStatement;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.CharacterLiteral;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.CompilationUnitResolver;
import org.eclipse.jdt.core.dom.ConditionalExpression;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.ContinueStatement;
import org.eclipse.jdt.core.dom.DefaultBindingResolver;
import org.eclipse.jdt.core.dom.DoStatement;
import org.eclipse.jdt.core.dom.EmptyStatement;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.InstanceofExpression;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.LabeledStatement;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NodeSearcher;
import org.eclipse.jdt.core.dom.NullLiteral;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.PostfixExpression;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.SwitchCase;
import org.eclipse.jdt.core.dom.SwitchStatement;
import org.eclipse.jdt.core.dom.SynchronizedStatement;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.ThrowStatement;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclarationStatement;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.WhileStatement;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.parser.Scanner;
import org.eclipse.jdt.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.NameLookup;

public final class AST {
    private long modCount = 0L;
    Scanner scanner;
    private BindingResolver resolver = new BindingResolver();

    public AST() {
        this(JavaCore.getDefaultOptions());
    }

    public AST(Map options) {
        this.scanner = new Scanner(true, true, false, "1.4".equals(options.get("org.eclipse.jdt.core.compiler.source")) ? 0x300000L : 0x2F0000L, null, null);
    }

    public long modificationCount() {
        return this.modCount;
    }

    void setModificationCount(long value) {
        this.modCount = value;
    }

    void modifying() {
        ++this.modCount;
    }

    public static CompilationUnit parseCompilationUnit(ICompilationUnit unit, boolean resolveBindings) {
        return AST.parseCompilationUnit(unit, resolveBindings, (WorkingCopyOwner)DefaultWorkingCopyOwner.PRIMARY);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CompilationUnit parseCompilationUnit(ICompilationUnit unit, boolean resolveBindings, WorkingCopyOwner owner) {
        if (unit == null) {
            throw new IllegalArgumentException();
        }
        if (owner == null) {
            throw new IllegalArgumentException();
        }
        char[] source = null;
        try {
            source = unit.getSource().toCharArray();
        }
        catch (JavaModelException javaModelException) {
            throw new IllegalArgumentException();
        }
        if (!resolveBindings) {
            return AST.parseCompilationUnit(source);
        }
        NameLookup lookup = null;
        CompilationUnitDeclaration compilationUnitDeclaration = null;
        try {
            try {
                lookup = ((JavaProject)unit.getJavaProject()).getNameLookup();
                JavaModelManager manager = JavaModelManager.getJavaModelManager();
                ICompilationUnit[] workingCopies = manager.getWorkingCopies(owner, true);
                lookup.setUnitsToLookInside(workingCopies);
                compilationUnitDeclaration = CompilationUnitResolver.resolve(unit, false, source);
                ASTConverter converter = new ASTConverter(unit.getJavaProject().getOptions(true), true);
                AST ast = new AST();
                DefaultBindingResolver resolver = new DefaultBindingResolver(compilationUnitDeclaration.scope);
                ast.setBindingResolver(resolver);
                converter.setAST(ast);
                CompilationUnit cu = converter.convert(compilationUnitDeclaration, source);
                cu.setLineEndTable(compilationUnitDeclaration.compilationResult.lineSeparatorPositions);
                resolver.storeModificationCount(ast.modificationCount());
                CompilationUnit compilationUnit = cu;
                Object var12_14 = null;
                if (compilationUnitDeclaration != null) {
                    compilationUnitDeclaration.cleanUp();
                }
                if (lookup != null) {
                    lookup.setUnitsToLookInside(null);
                }
                return compilationUnit;
            }
            catch (JavaModelException javaModelException) {
                CompilationUnit compilationUnit = AST.parseCompilationUnit(source);
                Object var12_15 = null;
                if (compilationUnitDeclaration != null) {
                    compilationUnitDeclaration.cleanUp();
                }
                if (lookup != null) {
                    lookup.setUnitsToLookInside(null);
                }
                return compilationUnit;
            }
        }
        catch (Throwable throwable) {
            Object var12_16 = null;
            if (compilationUnitDeclaration != null) {
                compilationUnitDeclaration.cleanUp();
            }
            if (lookup != null) {
                lookup.setUnitsToLookInside(null);
            }
            throw throwable;
        }
    }

    public static CompilationUnit parseCompilationUnit(IClassFile classFile, boolean resolveBindings) {
        return AST.parseCompilationUnit(classFile, resolveBindings, (WorkingCopyOwner)DefaultWorkingCopyOwner.PRIMARY);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CompilationUnit parseCompilationUnit(IClassFile classFile, boolean resolveBindings, WorkingCopyOwner owner) {
        if (classFile == null) {
            throw new IllegalArgumentException();
        }
        if (owner == null) {
            throw new IllegalArgumentException();
        }
        char[] source = null;
        String sourceString = null;
        try {
            sourceString = classFile.getSource();
        }
        catch (JavaModelException javaModelException) {
            throw new IllegalArgumentException();
        }
        if (sourceString == null) {
            throw new IllegalArgumentException();
        }
        source = sourceString.toCharArray();
        if (!resolveBindings) {
            return AST.parseCompilationUnit(source);
        }
        StringBuffer buffer = new StringBuffer(".java");
        String classFileName = classFile.getElementName();
        buffer.insert(0, classFileName.toCharArray(), 0, classFileName.indexOf(46));
        IJavaProject project = classFile.getJavaProject();
        NameLookup lookup = null;
        CompilationUnitDeclaration compilationUnitDeclaration = null;
        try {
            try {
                lookup = ((JavaProject)project).getNameLookup();
                JavaModelManager manager = JavaModelManager.getJavaModelManager();
                ICompilationUnit[] workingCopies = manager.getWorkingCopies(owner, true);
                lookup.setUnitsToLookInside(workingCopies);
                compilationUnitDeclaration = CompilationUnitResolver.resolve(source, CharOperation.splitOn('.', classFile.getType().getPackageFragment().getElementName().toCharArray()), buffer.toString(), project, false);
                ASTConverter converter = new ASTConverter(project.getOptions(true), true);
                AST ast = new AST();
                DefaultBindingResolver resolver = new DefaultBindingResolver(compilationUnitDeclaration.scope);
                ast.setBindingResolver(resolver);
                converter.setAST(ast);
                CompilationUnit cu = converter.convert(compilationUnitDeclaration, source);
                cu.setLineEndTable(compilationUnitDeclaration.compilationResult.lineSeparatorPositions);
                resolver.storeModificationCount(ast.modificationCount());
                CompilationUnit compilationUnit = cu;
                Object var16_18 = null;
                if (compilationUnitDeclaration != null) {
                    compilationUnitDeclaration.cleanUp();
                }
                if (lookup == null) return compilationUnit;
                lookup.setUnitsToLookInside(null);
                return compilationUnit;
            }
            catch (JavaModelException javaModelException) {
                CompilationUnit compilationUnit = AST.parseCompilationUnit(source);
                Object var16_19 = null;
                if (compilationUnitDeclaration != null) {
                    compilationUnitDeclaration.cleanUp();
                }
                if (lookup == null) return compilationUnit;
                lookup.setUnitsToLookInside(null);
                return compilationUnit;
            }
        }
        catch (Throwable throwable) {
            Object var16_20 = null;
            if (compilationUnitDeclaration != null) {
                compilationUnitDeclaration.cleanUp();
            }
            if (lookup == null) throw throwable;
            lookup.setUnitsToLookInside(null);
            throw throwable;
        }
    }

    public static CompilationUnit parseCompilationUnit(char[] source, String unitName, IJavaProject project) {
        return AST.parseCompilationUnit(source, unitName, project, DefaultWorkingCopyOwner.PRIMARY);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CompilationUnit parseCompilationUnit(char[] source, String unitName, IJavaProject project, WorkingCopyOwner owner) {
        if (source == null) {
            throw new IllegalArgumentException();
        }
        if (unitName == null && project != null) {
            throw new IllegalArgumentException();
        }
        if (project == null) {
            return AST.parseCompilationUnit(source);
        }
        if (owner == null) {
            throw new IllegalArgumentException();
        }
        NameLookup lookup = null;
        CompilationUnitDeclaration compilationUnitDeclaration = null;
        try {
            try {
                lookup = ((JavaProject)project).getNameLookup();
                JavaModelManager manager = JavaModelManager.getJavaModelManager();
                ICompilationUnit[] workingCopies = manager.getWorkingCopies(owner, true);
                lookup.setUnitsToLookInside(workingCopies);
                compilationUnitDeclaration = CompilationUnitResolver.resolve(source, unitName, project, false);
                ASTConverter converter = new ASTConverter(project.getOptions(true), true);
                AST ast = new AST();
                DefaultBindingResolver resolver = new DefaultBindingResolver(compilationUnitDeclaration.scope);
                ast.setBindingResolver(resolver);
                converter.setAST(ast);
                CompilationUnit cu = converter.convert(compilationUnitDeclaration, source);
                cu.setLineEndTable(compilationUnitDeclaration.compilationResult.lineSeparatorPositions);
                resolver.storeModificationCount(ast.modificationCount());
                CompilationUnit compilationUnit = cu;
                Object var12_14 = null;
                if (compilationUnitDeclaration != null) {
                    compilationUnitDeclaration.cleanUp();
                }
                if (lookup == null) return compilationUnit;
                lookup.setUnitsToLookInside(null);
                return compilationUnit;
            }
            catch (JavaModelException javaModelException) {
                CompilationUnit compilationUnit = AST.parseCompilationUnit(source);
                Object var12_15 = null;
                if (compilationUnitDeclaration != null) {
                    compilationUnitDeclaration.cleanUp();
                }
                if (lookup == null) return compilationUnit;
                lookup.setUnitsToLookInside(null);
                return compilationUnit;
            }
        }
        catch (Throwable throwable) {
            Object var12_16 = null;
            if (compilationUnitDeclaration != null) {
                compilationUnitDeclaration.cleanUp();
            }
            if (lookup == null) throw throwable;
            lookup.setUnitsToLookInside(null);
            throw throwable;
        }
    }

    public static CompilationUnit parseCompilationUnit(char[] source) {
        if (source == null) {
            throw new IllegalArgumentException();
        }
        CompilationUnitDeclaration compilationUnitDeclaration = CompilationUnitResolver.parse(source, JavaCore.getOptions());
        ASTConverter converter = new ASTConverter(JavaCore.getOptions(), false);
        AST ast = new AST();
        ast.setBindingResolver(new BindingResolver());
        converter.setAST(ast);
        CompilationUnit cu = converter.convert(compilationUnitDeclaration, source);
        cu.setLineEndTable(compilationUnitDeclaration.compilationResult.lineSeparatorPositions);
        return cu;
    }

    public static CompilationUnit parsePartialCompilationUnit(ICompilationUnit unit, int position, boolean resolveBindings) {
        return AST.parsePartialCompilationUnit(unit, position, resolveBindings, DefaultWorkingCopyOwner.PRIMARY);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CompilationUnit parsePartialCompilationUnit(ICompilationUnit unit, int position, boolean resolveBindings, WorkingCopyOwner owner) {
        if (unit == null) {
            throw new IllegalArgumentException();
        }
        if (owner == null) {
            throw new IllegalArgumentException();
        }
        char[] source = null;
        try {
            source = unit.getSource().toCharArray();
        }
        catch (JavaModelException javaModelException) {
            throw new IllegalArgumentException();
        }
        NodeSearcher searcher = new NodeSearcher(position);
        Map options = unit.getJavaProject().getOptions(true);
        if (!resolveBindings) {
            CompilationUnitDeclaration compilationUnitDeclaration = CompilationUnitResolver.parse(source, searcher, options);
            ASTConverter converter = new ASTConverter(options, false);
            AST ast = new AST();
            BindingResolver resolver = new BindingResolver();
            ast.setBindingResolver(resolver);
            converter.setAST(ast);
            CompilationUnit compilationUnit = converter.convert(compilationUnitDeclaration, source);
            compilationUnit.setLineEndTable(compilationUnitDeclaration.compilationResult.lineSeparatorPositions);
            resolver.storeModificationCount(ast.modificationCount());
            return compilationUnit;
        }
        NameLookup lookup = null;
        CompilationUnitDeclaration compilationUnitDeclaration = null;
        try {
            try {
                lookup = ((JavaProject)unit.getJavaProject()).getNameLookup();
                JavaModelManager manager = JavaModelManager.getJavaModelManager();
                ICompilationUnit[] workingCopies = manager.getWorkingCopies(owner, true);
                lookup.setUnitsToLookInside(workingCopies);
                compilationUnitDeclaration = CompilationUnitResolver.resolve(unit, searcher, false, source);
                ASTConverter converter = new ASTConverter(options, true);
                AST ast = new AST();
                DefaultBindingResolver resolver = new DefaultBindingResolver(compilationUnitDeclaration.scope);
                ast.setBindingResolver(resolver);
                converter.setAST(ast);
                CompilationUnit compilationUnit = converter.convert(compilationUnitDeclaration, source);
                compilationUnit.setLineEndTable(compilationUnitDeclaration.compilationResult.lineSeparatorPositions);
                resolver.storeModificationCount(ast.modificationCount());
                CompilationUnit compilationUnit2 = compilationUnit;
                Object var15_27 = null;
                if (compilationUnitDeclaration != null) {
                    compilationUnitDeclaration.cleanUp();
                }
                if (lookup != null) {
                    lookup.setUnitsToLookInside(null);
                }
                return compilationUnit2;
            }
            catch (JavaModelException javaModelException) {
                CompilationUnitDeclaration compilationUnitDeclaration2 = CompilationUnitResolver.parse(source, searcher, options);
                ASTConverter converter = new ASTConverter(options, false);
                AST ast = new AST();
                BindingResolver resolver = new BindingResolver();
                ast.setBindingResolver(resolver);
                converter.setAST(ast);
                CompilationUnit compilationUnit = converter.convert(compilationUnitDeclaration2, source);
                compilationUnit.setLineEndTable(compilationUnitDeclaration2.compilationResult.lineSeparatorPositions);
                resolver.storeModificationCount(ast.modificationCount());
                CompilationUnit compilationUnit3 = compilationUnit;
                Object var15_28 = null;
                if (compilationUnitDeclaration != null) {
                    compilationUnitDeclaration.cleanUp();
                }
                if (lookup != null) {
                    lookup.setUnitsToLookInside(null);
                }
                return compilationUnit3;
            }
        }
        catch (Throwable throwable) {
            Object var15_29 = null;
            if (compilationUnitDeclaration != null) {
                compilationUnitDeclaration.cleanUp();
            }
            if (lookup != null) {
                lookup.setUnitsToLookInside(null);
            }
            throw throwable;
        }
    }

    BindingResolver getBindingResolver() {
        return this.resolver;
    }

    public ITypeBinding resolveWellKnownType(String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        return this.getBindingResolver().resolveWellKnownType(name);
    }

    void setBindingResolver(BindingResolver resolver) {
        if (resolver == null) {
            throw new IllegalArgumentException();
        }
        this.resolver = resolver;
    }

    public SimpleName newSimpleName(String identifier) {
        if (identifier == null) {
            throw new IllegalArgumentException();
        }
        SimpleName result = new SimpleName(this);
        result.setIdentifier(identifier);
        return result;
    }

    public QualifiedName newQualifiedName(Name qualifier, SimpleName name) {
        QualifiedName result = new QualifiedName(this);
        result.setQualifier(qualifier);
        result.setName(name);
        return result;
    }

    public Name newName(String[] identifiers) {
        int count = identifiers.length;
        if (count == 0) {
            throw new IllegalArgumentException();
        }
        Name result = this.newSimpleName(identifiers[0]);
        int i = 1;
        while (i < count) {
            SimpleName name = this.newSimpleName(identifiers[i]);
            result = this.newQualifiedName(result, name);
            ++i;
        }
        return result;
    }

    public SimpleType newSimpleType(Name typeName) {
        SimpleType result = new SimpleType(this);
        result.setName(typeName);
        return result;
    }

    public ArrayType newArrayType(Type componentType) {
        ArrayType result = new ArrayType(this);
        result.setComponentType(componentType);
        return result;
    }

    public ArrayType newArrayType(Type elementType, int dimensions) {
        if (elementType == null || elementType.isArrayType()) {
            throw new IllegalArgumentException();
        }
        if (dimensions < 1 || dimensions > 1000) {
            throw new IllegalArgumentException();
        }
        ArrayType result = new ArrayType(this);
        result.setComponentType(elementType);
        int i = 2;
        while (i <= dimensions) {
            result = this.newArrayType(result);
            ++i;
        }
        return result;
    }

    public PrimitiveType newPrimitiveType(PrimitiveType.Code typeCode) {
        PrimitiveType result = new PrimitiveType(this);
        result.setPrimitiveTypeCode(typeCode);
        return result;
    }

    public CompilationUnit newCompilationUnit() {
        return new CompilationUnit(this);
    }

    public PackageDeclaration newPackageDeclaration() {
        PackageDeclaration result = new PackageDeclaration(this);
        return result;
    }

    public ImportDeclaration newImportDeclaration() {
        ImportDeclaration result = new ImportDeclaration(this);
        return result;
    }

    public TypeDeclaration newTypeDeclaration() {
        TypeDeclaration result = new TypeDeclaration(this);
        result.setInterface(false);
        return result;
    }

    public MethodDeclaration newMethodDeclaration() {
        MethodDeclaration result = new MethodDeclaration(this);
        result.setConstructor(false);
        return result;
    }

    public SingleVariableDeclaration newSingleVariableDeclaration() {
        SingleVariableDeclaration result = new SingleVariableDeclaration(this);
        return result;
    }

    public VariableDeclarationFragment newVariableDeclarationFragment() {
        VariableDeclarationFragment result = new VariableDeclarationFragment(this);
        return result;
    }

    public Initializer newInitializer() {
        Initializer result = new Initializer(this);
        return result;
    }

    public Javadoc newJavadoc() {
        Javadoc result = new Javadoc(this);
        return result;
    }

    public VariableDeclarationStatement newVariableDeclarationStatement(VariableDeclarationFragment fragment) {
        if (fragment == null) {
            throw new IllegalArgumentException();
        }
        VariableDeclarationStatement result = new VariableDeclarationStatement(this);
        result.fragments().add(fragment);
        return result;
    }

    public TypeDeclarationStatement newTypeDeclarationStatement(TypeDeclaration decl) {
        TypeDeclarationStatement result = new TypeDeclarationStatement(this);
        result.setTypeDeclaration(decl);
        return result;
    }

    public Block newBlock() {
        return new Block(this);
    }

    public ContinueStatement newContinueStatement() {
        return new ContinueStatement(this);
    }

    public BreakStatement newBreakStatement() {
        return new BreakStatement(this);
    }

    public ExpressionStatement newExpressionStatement(Expression expression) {
        ExpressionStatement result = new ExpressionStatement(this);
        result.setExpression(expression);
        return result;
    }

    public IfStatement newIfStatement() {
        return new IfStatement(this);
    }

    public WhileStatement newWhileStatement() {
        return new WhileStatement(this);
    }

    public DoStatement newDoStatement() {
        return new DoStatement(this);
    }

    public TryStatement newTryStatement() {
        return new TryStatement(this);
    }

    public CatchClause newCatchClause() {
        return new CatchClause(this);
    }

    public ReturnStatement newReturnStatement() {
        return new ReturnStatement(this);
    }

    public ThrowStatement newThrowStatement() {
        return new ThrowStatement(this);
    }

    public AssertStatement newAssertStatement() {
        return new AssertStatement(this);
    }

    public EmptyStatement newEmptyStatement() {
        return new EmptyStatement(this);
    }

    public LabeledStatement newLabeledStatement() {
        return new LabeledStatement(this);
    }

    public SwitchStatement newSwitchStatement() {
        return new SwitchStatement(this);
    }

    public SwitchCase newSwitchCase() {
        return new SwitchCase(this);
    }

    public SynchronizedStatement newSynchronizedStatement() {
        return new SynchronizedStatement(this);
    }

    public ForStatement newForStatement() {
        return new ForStatement(this);
    }

    public StringLiteral newStringLiteral() {
        return new StringLiteral(this);
    }

    public CharacterLiteral newCharacterLiteral() {
        return new CharacterLiteral(this);
    }

    public NumberLiteral newNumberLiteral(String literal) {
        if (literal == null) {
            throw new IllegalArgumentException();
        }
        NumberLiteral result = new NumberLiteral(this);
        result.setToken(literal);
        return result;
    }

    public NumberLiteral newNumberLiteral() {
        NumberLiteral result = new NumberLiteral(this);
        return result;
    }

    public NullLiteral newNullLiteral() {
        return new NullLiteral(this);
    }

    public BooleanLiteral newBooleanLiteral(boolean value) {
        BooleanLiteral result = new BooleanLiteral(this);
        result.setBooleanValue(value);
        return result;
    }

    public Assignment newAssignment() {
        Assignment result = new Assignment(this);
        return result;
    }

    public MethodInvocation newMethodInvocation() {
        MethodInvocation result = new MethodInvocation(this);
        return result;
    }

    public SuperMethodInvocation newSuperMethodInvocation() {
        SuperMethodInvocation result = new SuperMethodInvocation(this);
        return result;
    }

    public ConstructorInvocation newConstructorInvocation() {
        ConstructorInvocation result = new ConstructorInvocation(this);
        return result;
    }

    public SuperConstructorInvocation newSuperConstructorInvocation() {
        SuperConstructorInvocation result = new SuperConstructorInvocation(this);
        return result;
    }

    public VariableDeclarationExpression newVariableDeclarationExpression(VariableDeclarationFragment fragment) {
        if (fragment == null) {
            throw new IllegalArgumentException();
        }
        VariableDeclarationExpression result = new VariableDeclarationExpression(this);
        result.fragments().add(fragment);
        return result;
    }

    public FieldDeclaration newFieldDeclaration(VariableDeclarationFragment fragment) {
        if (fragment == null) {
            throw new IllegalArgumentException();
        }
        FieldDeclaration result = new FieldDeclaration(this);
        result.fragments().add(fragment);
        return result;
    }

    public ThisExpression newThisExpression() {
        ThisExpression result = new ThisExpression(this);
        return result;
    }

    public FieldAccess newFieldAccess() {
        FieldAccess result = new FieldAccess(this);
        return result;
    }

    public SuperFieldAccess newSuperFieldAccess() {
        SuperFieldAccess result = new SuperFieldAccess(this);
        return result;
    }

    public TypeLiteral newTypeLiteral() {
        TypeLiteral result = new TypeLiteral(this);
        return result;
    }

    public CastExpression newCastExpression() {
        CastExpression result = new CastExpression(this);
        return result;
    }

    public ParenthesizedExpression newParenthesizedExpression() {
        ParenthesizedExpression result = new ParenthesizedExpression(this);
        return result;
    }

    public InfixExpression newInfixExpression() {
        InfixExpression result = new InfixExpression(this);
        return result;
    }

    public InstanceofExpression newInstanceofExpression() {
        InstanceofExpression result = new InstanceofExpression(this);
        return result;
    }

    public PostfixExpression newPostfixExpression() {
        PostfixExpression result = new PostfixExpression(this);
        return result;
    }

    public PrefixExpression newPrefixExpression() {
        PrefixExpression result = new PrefixExpression(this);
        return result;
    }

    public ArrayAccess newArrayAccess() {
        ArrayAccess result = new ArrayAccess(this);
        return result;
    }

    public ArrayCreation newArrayCreation() {
        ArrayCreation result = new ArrayCreation(this);
        return result;
    }

    public ClassInstanceCreation newClassInstanceCreation() {
        ClassInstanceCreation result = new ClassInstanceCreation(this);
        return result;
    }

    public AnonymousClassDeclaration newAnonymousClassDeclaration() {
        AnonymousClassDeclaration result = new AnonymousClassDeclaration(this);
        return result;
    }

    public ArrayInitializer newArrayInitializer() {
        ArrayInitializer result = new ArrayInitializer(this);
        return result;
    }

    public ConditionalExpression newConditionalExpression() {
        ConditionalExpression result = new ConditionalExpression(this);
        return result;
    }
}

