/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.templates;

import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginModelFactory;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.wizards.templates.PDETemplateSection;
import org.eclipse.pde.ui.templates.BooleanOption;
import org.eclipse.pde.ui.templates.TemplateOption;

public class HelpTemplate
extends PDETemplateSection {
    public static final String KEY_TOC_LABEL = "tocLabel";
    public static final String KEY_IS_PRIMARY = "isPrimary";
    public static final String KEY_GEN_TEST = "generateTest";
    public static final String KEY_GET_STARTED = "gettingStarted";
    public static final String KEY_CONCEPTS = "concepts";
    public static final String KEY_TASKS = "tasks";
    public static final String KEY_REFERENCE = "reference";
    public static final String KEY_SAMPLES = "samples";
    private static final String NL_TOC_LABEL = "HelpTemplate.tocLabel";
    private static final String NL_IS_PRIMARY = "HelpTemplate.isPrimary";
    private static final String NL_GEN_TEST = "HelpTemplate.generateTest";
    private static final String NL_GET_STARTED = "HelpTemplate.gettingStarted";
    private static final String NL_CONCEPTS = "HelpTemplate.concepts";
    private static final String NL_TASKS = "HelpTemplate.tasks";
    private static final String NL_REFERENCE = "HelpTemplate.reference";
    private static final String NL_SAMPLES = "HelpTemplate.samples";
    private static final String NL_DESC = "HelpTemplate.desc";
    private static final String NL_TITLE = "HelpTemplate.title";
    private TemplateOption tocLabelOption;
    private BooleanOption primaryOption;
    private BooleanOption genTestOption;
    private BooleanOption gettingStartedOption;
    private BooleanOption conceptsOption;
    private BooleanOption tasksOption;
    private BooleanOption referenceOption;
    private BooleanOption samplesOption;

    public HelpTemplate() {
        this.setPageCount(1);
        this.createOptions();
        this.alterOptionStates();
    }

    public void addPages(Wizard wizard) {
        WizardPage page = this.createPage(0, "org.eclipse.pde.doc.user.template_help");
        page.setTitle(PDEPlugin.getResourceString(NL_TITLE));
        page.setDescription(PDEPlugin.getResourceString(NL_DESC));
        wizard.addPage((IWizardPage)page);
        this.markPagesAdded();
    }

    private void alterOptionStates() {
        this.genTestOption.setEnabled(!this.primaryOption.isSelected());
        this.gettingStartedOption.setEnabled(this.primaryOption.isSelected());
        this.conceptsOption.setEnabled(this.primaryOption.isSelected());
        this.tasksOption.setEnabled(this.primaryOption.isSelected());
        this.referenceOption.setEnabled(this.primaryOption.isSelected());
        this.samplesOption.setEnabled(this.primaryOption.isSelected());
    }

    private void createOptions() {
        this.tocLabelOption = this.addOption(KEY_TOC_LABEL, PDEPlugin.getResourceString(NL_TOC_LABEL), "Sample Table of Contents", 0);
        this.primaryOption = (BooleanOption)this.addOption(KEY_IS_PRIMARY, PDEPlugin.getResourceString(NL_IS_PRIMARY), false, 0);
        this.genTestOption = (BooleanOption)this.addOption(KEY_GEN_TEST, PDEPlugin.getResourceString(NL_GEN_TEST), true, 0);
        this.gettingStartedOption = (BooleanOption)this.addOption(KEY_GET_STARTED, PDEPlugin.getResourceString(NL_GET_STARTED), true, 0);
        this.conceptsOption = (BooleanOption)this.addOption(KEY_CONCEPTS, PDEPlugin.getResourceString(NL_CONCEPTS), true, 0);
        this.tasksOption = (BooleanOption)this.addOption(KEY_TASKS, PDEPlugin.getResourceString(NL_TASKS), true, 0);
        this.referenceOption = (BooleanOption)this.addOption(KEY_REFERENCE, PDEPlugin.getResourceString(NL_REFERENCE), true, 0);
        this.samplesOption = (BooleanOption)this.addOption(KEY_SAMPLES, PDEPlugin.getResourceString(NL_SAMPLES), true, 0);
    }

    public String getSectionId() {
        return "help";
    }

    protected boolean isOkToCreateFolder(File sourceFolder) {
        boolean isOk = true;
        String folderName = sourceFolder.getName();
        if (folderName.equals(KEY_CONCEPTS)) {
            isOk = this.conceptsOption.isEnabled() && this.conceptsOption.isSelected();
        } else if (folderName.equals("gettingstarted")) {
            isOk = this.gettingStartedOption.isEnabled() && this.gettingStartedOption.isSelected();
        } else if (folderName.equals(KEY_REFERENCE)) {
            isOk = this.referenceOption.isEnabled() && this.referenceOption.isSelected();
        } else if (folderName.equals(KEY_SAMPLES)) {
            isOk = this.samplesOption.isEnabled() && this.samplesOption.isSelected();
        } else if (folderName.equals(KEY_TASKS)) {
            isOk = this.tasksOption.isEnabled() && this.tasksOption.isSelected();
        }
        return isOk;
    }

    protected boolean isOkToCreateFile(File sourceFile) {
        boolean isOk = true;
        String fileName = sourceFile.getName();
        if (fileName.equals("testToc.xml")) {
            isOk = this.genTestOption.isEnabled() && this.genTestOption.isSelected();
        } else if (fileName.equals("tocconcepts.xml")) {
            isOk = this.conceptsOption.isEnabled() && this.conceptsOption.isSelected();
        } else if (fileName.equals("tocgettingstarted.xml")) {
            isOk = this.gettingStartedOption.isEnabled() && this.gettingStartedOption.isSelected();
        } else if (fileName.equals("tocreference.xml")) {
            isOk = this.referenceOption.isEnabled() && this.referenceOption.isSelected();
        } else if (fileName.equals("tocsamples.xml")) {
            isOk = this.samplesOption.isEnabled() && this.samplesOption.isSelected();
        } else if (fileName.equals("toctasks.xml")) {
            isOk = this.tasksOption.isEnabled() && this.tasksOption.isSelected();
        } else if ((fileName.equals("maintopic.html") || fileName.equals("subtopic.html")) && sourceFile.getParentFile().getName().equals("html")) {
            isOk = !this.primaryOption.isSelected() || this.primaryOption.isSelected() && !this.gettingStartedOption.isSelected() && !this.conceptsOption.isSelected() && !this.tasksOption.isSelected() && !this.referenceOption.isSelected() && !this.samplesOption.isSelected();
        }
        return isOk;
    }

    public void validateOptions(TemplateOption changed) {
        if (changed == this.tocLabelOption) {
            if (changed.isEmpty()) {
                this.flagMissingRequiredOption(changed);
            } else {
                this.resetPageState();
            }
        } else if (changed == this.primaryOption) {
            this.alterOptionStates();
        }
    }

    protected void updateModel(IProgressMonitor monitor) throws CoreException {
        IPluginBase plugin = this.model.getPluginBase();
        IPluginExtension extension = this.createExtension(this.getUsedExtensionPoint(), true);
        IPluginModelFactory factory = this.model.getPluginFactory();
        IPluginElement tocElement = factory.createElement((IPluginObject)extension);
        tocElement.setName("toc");
        tocElement.setAttribute("file", "toc.xml");
        if (this.primaryOption.isSelected()) {
            tocElement.setAttribute("primary", "true");
        }
        extension.add((IPluginObject)tocElement);
        if (this.genTestOption.isSelected() && this.genTestOption.isEnabled()) {
            IPluginElement testTocElement = factory.createElement((IPluginObject)extension);
            testTocElement.setName("toc");
            testTocElement.setAttribute("file", "testToc.xml");
            testTocElement.setAttribute("primary", "true");
            extension.add((IPluginObject)testTocElement);
        }
        this.addNonPrimaryTopic(this.conceptsOption, "tocconcepts.xml", extension);
        this.addNonPrimaryTopic(this.gettingStartedOption, "tocgettingstarted.xml", extension);
        this.addNonPrimaryTopic(this.referenceOption, "tocreference.xml", extension);
        this.addNonPrimaryTopic(this.samplesOption, "tocsamples.xml", extension);
        this.addNonPrimaryTopic(this.tasksOption, "toctasks.xml", extension);
        if (!extension.isInTheModel()) {
            plugin.add(extension);
        }
    }

    private void addNonPrimaryTopic(BooleanOption option, String file, IPluginExtension extension) throws CoreException {
        if (option.isEnabled() && option.isSelected()) {
            IPluginElement tocElement = extension.getPluginModel().getPluginFactory().createElement((IPluginObject)extension);
            tocElement.setName("toc");
            tocElement.setAttribute("file", file);
            extension.add((IPluginObject)tocElement);
        }
    }

    public String getUsedExtensionPoint() {
        return "org.eclipse.help.toc";
    }
}

