/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.project;

import java.lang.reflect.InvocationTargetException;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.internal.core.CoreUtility;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.build.WorkspaceBuildModel;
import org.eclipse.pde.internal.core.plugin.WorkspaceFragmentModel;
import org.eclipse.pde.internal.core.plugin.WorkspacePluginModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.ui.IPluginStructureData;
import org.eclipse.pde.ui.IProjectProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.ide.IDE;

public class ProjectStructurePage
extends WizardPage {
    private static final String KEY_TITLE = "ProjectStructurePage.title";
    private static final String KEY_OUTPUT = "ProjectStructurePage.output";
    private static final String KEY_FID = "ProjectStructurePage.fid";
    private static final String KEY_ID = "ProjectStructurePage.id";
    private static final String KEY_INVALID_ID = "WizardIdProjectCreationPage.invalidId";
    private static final String KEY_EMPTY_ID = "WizardIdProjectCreationPage.emptyId";
    private static final String KEY_FLIBRARY = "ProjectStructurePage.flibrary";
    private static final String KEY_LIBRARY = "ProjectStructurePage.library";
    private static final String KEY_CREATING = "ProjectStructurePage.creating";
    private static final String KEY_SOURCE = "ProjectStructurePage.source";
    private static final String KEY_R21 = "ProjectStructurePage.r21";
    private static final String KEY_FTITLE = "ProjectStructurePage.ftitle";
    private static final String KEY_DESC = "ProjectStructurePage.desc";
    private static final String KEY_FDESC = "ProjectStructurePage.fdesc";
    private static final String KEY_JAVA_PROJECT = "ProjectStructurePage.javaProject";
    private static final String KEY_SIMPLE_PROJECT = "ProjectStructurePage.simpleProject";
    private IProjectProvider provider;
    private boolean fragment;
    private Text idText;
    private Text buildOutputText;
    private Text sourceText;
    private Text libraryText;
    private Composite bottomContainer;
    private Button simpleChoice;
    private Button r21Check;
    private StructureData data;
    private String projectName;
    private Label libraryLabel;
    private Label sourceLabel;
    private Label buildOutputLabel;

    public ProjectStructurePage(IProjectProvider provider, boolean fragment) {
        super("projectStructure");
        this.fragment = fragment;
        this.provider = provider;
        this.setTitle(PDEPlugin.getResourceString(fragment ? KEY_FTITLE : KEY_TITLE));
        this.setDescription(PDEPlugin.getResourceString(fragment ? KEY_FDESC : KEY_DESC));
    }

    public static void createProject(IProject project, IProjectProvider provider, IPluginStructureData data, IProgressMonitor monitor) throws CoreException {
        if (!project.exists()) {
            CoreUtility.createProject((IProject)project, (IPath)provider.getLocationPath(), (IProgressMonitor)monitor);
            project.open(monitor);
        }
        if (!project.hasNature("org.eclipse.pde.PluginNature")) {
            CoreUtility.addNatureToProject((IProject)project, (String)"org.eclipse.pde.PluginNature", (IProgressMonitor)monitor);
        }
        if (!project.hasNature("org.eclipse.jdt.core.javanature") && data.getRuntimeLibraryName() != null) {
            CoreUtility.addNatureToProject((IProject)project, (String)"org.eclipse.jdt.core.javanature", (IProgressMonitor)monitor);
            JavaCore.create((IProject)project).setOutputLocation(project.getFullPath().append(data.getJavaBuildFolderName()), monitor);
        }
    }

    public static void createBuildProperties(IProject project, IPluginStructureData data, boolean fragment, IProgressMonitor monitor) throws CoreException {
        ProjectStructurePage.createBuildProperties(project, data.getRuntimeLibraryName(), data.getSourceFolderName(), fragment);
    }

    public static void createBuildProperties(IProject project, String library, String source, boolean fragment) throws CoreException {
        String fileName = "build.properties";
        IPath path = project.getFullPath().append(fileName);
        IFile file = project.getWorkspace().getRoot().getFile(path);
        if (!file.exists()) {
            WorkspaceBuildModel model = new WorkspaceBuildModel(file);
            IBuildEntry ientry = model.getFactory().createEntry("bin.includes");
            if (fragment) {
                ientry.addToken("fragment.xml");
            } else {
                ientry.addToken("plugin.xml");
            }
            if (library != null && source != null) {
                IBuildEntry entry = model.getFactory().createEntry("source." + library);
                if (!source.endsWith("/")) {
                    source = String.valueOf(source) + "/";
                }
                entry.addToken(source);
                ientry.addToken("*.jar");
                ientry.addToken(library);
                model.getBuild().add(entry);
            }
            model.getBuild().add(ientry);
            model.save();
        }
        IDE.setDefaultEditor((IFile)file, (String)"org.eclipse.pde.ui.buildEditor");
    }

    private void addTopSection(Composite container) {
        Composite topContainer = new Composite(container, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        topContainer.setLayout((Layout)layout);
        topContainer.setLayoutData((Object)new GridData(768));
        Label label = new Label(topContainer, 0);
        label.setText(PDEPlugin.getResourceString(this.fragment ? KEY_FID : KEY_ID));
        this.idText = new Text(topContainer, 2052);
        this.idText.setLayoutData((Object)new GridData(768));
        this.idText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ProjectStructurePage.this.verifyId(ProjectStructurePage.this.idText.getText());
            }
        });
        Label spacer = new Label(topContainer, 0);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        spacer.setLayoutData((Object)gd);
    }

    private void addMiddleSection(Composite container) {
        Composite middleContainer = new Composite(container, 0);
        GridLayout layout = new GridLayout();
        middleContainer.setLayout((Layout)layout);
        middleContainer.setLayoutData((Object)new GridData(768));
        this.simpleChoice = new Button(middleContainer, 16);
        this.simpleChoice.setText(PDEPlugin.getResourceString(KEY_SIMPLE_PROJECT));
        this.simpleChoice.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean isSelected = ((Button)e.widget).getSelection();
                ProjectStructurePage.this.libraryText.setEnabled(!isSelected);
                ProjectStructurePage.this.sourceText.setEnabled(!isSelected);
                ProjectStructurePage.this.buildOutputText.setEnabled(!isSelected);
                ProjectStructurePage.this.libraryLabel.setEnabled(!isSelected);
                ProjectStructurePage.this.sourceLabel.setEnabled(!isSelected);
                ProjectStructurePage.this.buildOutputLabel.setEnabled(!isSelected);
                ProjectStructurePage.this.getContainer().updateButtons();
            }
        });
        Button button = new Button(middleContainer, 16);
        button.setText(PDEPlugin.getResourceString(KEY_JAVA_PROJECT));
        button.setSelection(true);
    }

    private void addBottomSection(Composite container) {
        this.bottomContainer = new Composite(container, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.verticalSpacing = 9;
        this.bottomContainer.setLayout((Layout)layout);
        this.bottomContainer.setLayoutData((Object)new GridData(768));
        this.libraryLabel = new Label(this.bottomContainer, 0);
        this.libraryLabel.setText(PDEPlugin.getResourceString(this.fragment ? KEY_FLIBRARY : KEY_LIBRARY));
        GridData gd = new GridData();
        gd.horizontalIndent = 25;
        this.libraryLabel.setLayoutData((Object)gd);
        this.libraryText = new Text(this.bottomContainer, 2052);
        this.libraryText.setLayoutData((Object)new GridData(768));
        this.sourceLabel = new Label(this.bottomContainer, 0);
        this.sourceLabel.setText(PDEPlugin.getResourceString(KEY_SOURCE));
        gd = new GridData();
        gd.horizontalIndent = 25;
        this.sourceLabel.setLayoutData((Object)gd);
        this.sourceText = new Text(this.bottomContainer, 2052);
        this.sourceText.setLayoutData((Object)new GridData(768));
        this.buildOutputLabel = new Label(this.bottomContainer, 0);
        this.buildOutputLabel.setText(PDEPlugin.getResourceString(KEY_OUTPUT));
        gd = new GridData();
        gd.horizontalIndent = 25;
        this.buildOutputLabel.setLayoutData((Object)gd);
        this.buildOutputText = new Text(this.bottomContainer, 2052);
        this.buildOutputText.setLayoutData((Object)new GridData(768));
        Label spacer = new Label(this.bottomContainer, 0);
        gd = new GridData();
        gd.horizontalSpan = 2;
        spacer.setLayoutData((Object)gd);
        this.r21Check = new Button(this.bottomContainer, 32);
        this.r21Check.setText(PDEPlugin.getResourceString(KEY_R21));
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.r21Check.setLayoutData((Object)gd);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 0;
        container.setLayout((Layout)layout);
        this.addTopSection(container);
        this.addMiddleSection(container);
        this.addBottomSection(container);
        this.initialize();
        this.r21Check.setSelection(!PDECore.getDefault().getModelManager().isOSGiRuntime());
        this.setControl((Control)container);
        Dialog.applyDialogFont((Control)container);
        if (this.fragment) {
            WorkbenchHelp.setHelp((Control)container, (String)"org.eclipse.pde.doc.user.new_fragment_structure_page");
        } else {
            WorkbenchHelp.setHelp((Control)container, (String)"org.eclipse.pde.doc.user.new_project_structure_page");
        }
    }

    private boolean verifyId(String id) {
        String error = id.length() == 0 ? PDEPlugin.getResourceString(KEY_EMPTY_ID) : this.verifyIdRules(id);
        this.setErrorMessage(error);
        this.setPageComplete(error == null);
        return error == null;
    }

    private String verifyIdRules(String id) {
        String problemText = PDEPlugin.getResourceString(KEY_INVALID_ID);
        StringTokenizer stok = new StringTokenizer(id, ".");
        while (stok.hasMoreTokens()) {
            String token = stok.nextToken();
            int i = 0;
            while (i < token.length()) {
                if (!Character.isLetterOrDigit(token.charAt(i))) {
                    return problemText;
                }
                ++i;
            }
        }
        return null;
    }

    private void createBlankManifest(IProject project, IProgressMonitor monitor) throws CoreException {
        IPath path = project.getFullPath().append(this.fragment ? "fragment.xml" : "plugin.xml");
        IFile file = project.getWorkspace().getRoot().getFile(path);
        Object model = null;
        model = this.fragment ? new WorkspaceFragmentModel(file) : new WorkspacePluginModel(file);
        model.load();
        if (!file.exists()) {
            IPluginBase pluginBase = model.getPluginBase();
            pluginBase.setId(this.idText.getText());
            pluginBase.setVersion("1.0.0");
            pluginBase.setName(this.idText.getText());
            if (!this.r21Check.getSelection()) {
                pluginBase.setSchemaVersion("3.0");
            }
            model.save();
        }
    }

    public boolean finish() {
        final IProject project = this.provider.getProject();
        final IPluginStructureData data = this.getStructureData();
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void execute(IProgressMonitor monitor) {
                try {
                    try {
                        String message = PDEPlugin.getResourceString(ProjectStructurePage.KEY_CREATING);
                        monitor.beginTask(message, 1);
                        ProjectStructurePage.createProject(project, ProjectStructurePage.this.provider, data, monitor);
                        ProjectStructurePage.createBuildProperties(project, data, ProjectStructurePage.this.fragment, monitor);
                        if (ProjectStructurePage.this.simpleChoice.getSelection()) {
                            ProjectStructurePage.this.createBlankManifest(project, monitor);
                        }
                        monitor.worked(1);
                    }
                    catch (CoreException e) {
                        PDEPlugin.logException(e);
                    }
                }
                catch (Throwable throwable) {
                    Object var3_5 = null;
                    monitor.done();
                    throw throwable;
                }
                {
                    Object var3_6 = null;
                }
                monitor.done();
            }
        };
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)operation);
        }
        catch (InvocationTargetException e) {
            PDEPlugin.logException(e);
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        return true;
    }

    private IPath[] getJRESourceAnnotation() {
        IPath source = JavaCore.getClasspathVariable((String)"JRE_SRC");
        IPath prefix = JavaCore.getClasspathVariable((String)"JRE_SRCROOT");
        return new IPath[]{source, prefix};
    }

    public IPluginStructureData getStructureData() {
        this.data = new StructureData();
        this.data.pluginId = this.idText.getText();
        this.data.buildOutput = this.simpleChoice.getSelection() ? null : this.buildOutputText.getText();
        this.data.library = this.simpleChoice.getSelection() ? null : this.libraryText.getText();
        this.data.source = this.simpleChoice.getSelection() ? null : this.sourceText.getText();
        this.data.jrePath = this.simpleChoice.getSelection() ? null : JavaCore.getClasspathVariable((String)"JRE_SRC");
        this.data.jreSourceAnnotation = this.simpleChoice.getSelection() ? null : this.getJRESourceAnnotation();
        this.data.r3Compatible = !this.r21Check.getSelection();
        return this.data;
    }

    private void initialize() {
        if (this.idText.getText().equals("")) {
            this.projectName = this.provider.getProjectName();
            this.idText.setText(this.setInitialId(this.provider.getProjectName()));
        }
        if (this.buildOutputText.getText().equals("")) {
            this.buildOutputText.setText("bin");
        }
        if (this.libraryText.getText().equals("") || this.libraryText.getText().equals(".jar")) {
            String lastSegment = this.setInitialId(this.provider.getProjectName());
            int loc = lastSegment.lastIndexOf(46);
            if (loc != -1) {
                lastSegment = lastSegment.substring(loc + 1);
            }
            this.libraryText.setText(String.valueOf(lastSegment) + ".jar");
        }
        if (this.sourceText.getText().equals("")) {
            this.sourceText.setText("src");
        }
    }

    private String setInitialId(String projectName) {
        StringBuffer buffer = new StringBuffer();
        StringTokenizer stok = new StringTokenizer(projectName, ".");
        while (stok.hasMoreTokens()) {
            String token = stok.nextToken();
            int i = 0;
            while (i < token.length()) {
                if (Character.isLetterOrDigit(token.charAt(i))) {
                    buffer.append(token.charAt(i));
                }
                ++i;
            }
            if (!stok.hasMoreTokens() || buffer.charAt(buffer.length() - 1) == '.') continue;
            buffer.append(".");
        }
        return buffer.toString();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.initialize();
            this.idText.setFocus();
        }
    }

    public boolean isStructureDataChanged() {
        if (this.data == null || this.projectName == null) {
            return false;
        }
        StructureData oldData = this.data;
        StructureData newData = (StructureData)this.getStructureData();
        boolean structureChange = !oldData.pluginId.equals(newData.pluginId) || !oldData.buildOutput.equals(newData.buildOutput) || !oldData.library.equals(newData.library) || !oldData.source.equals(newData.source) || oldData.r3Compatible != newData.r3Compatible || !this.projectName.equals(this.provider.getProjectName());
        this.projectName = this.provider.getProjectName();
        return structureChange;
    }

    public IWizardPage getNextPage() {
        if (!this.fragment && this.simpleChoice.getSelection()) {
            return null;
        }
        return super.getNextPage();
    }

    public String getSchemaVersion() {
        return this.r21Check.getSelection() ? null : "3.0";
    }

    class StructureData
    implements IPluginStructureData {
        String pluginId;
        String buildOutput;
        String library;
        String source;
        IPath jrePath;
        IPath[] jreSourceAnnotation;
        boolean r3Compatible;

        StructureData() {
        }

        public String getPluginId() {
            return this.pluginId;
        }

        public IPath getJREPath() {
            return this.jrePath;
        }

        public IPath[] getJRESourceAnnotation() {
            return this.jreSourceAnnotation;
        }

        public String getJavaBuildFolderName() {
            return this.buildOutput;
        }

        public String getSourceFolderName() {
            return this.source;
        }

        public String getRuntimeLibraryName() {
            return this.library;
        }

        public boolean isR3Compatible() {
            return this.r3Compatible;
        }
    }
}

