/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.project;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.ControlEnableState;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardNode;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginLibrary;
import org.eclipse.pde.internal.core.CoreUtility;
import org.eclipse.pde.internal.core.plugin.WorkspaceFragmentModel;
import org.eclipse.pde.internal.core.plugin.WorkspacePluginModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.elements.ElementList;
import org.eclipse.pde.internal.ui.wizards.WizardElement;
import org.eclipse.pde.internal.ui.wizards.WizardListSelectionPage;
import org.eclipse.pde.internal.ui.wizards.WizardNode;
import org.eclipse.pde.internal.ui.wizards.project.ProjectStructurePage;
import org.eclipse.pde.ui.ClasspathUtil;
import org.eclipse.pde.ui.IBasePluginWizard;
import org.eclipse.pde.ui.IPluginContentWizard;
import org.eclipse.pde.ui.IPluginStructureData;
import org.eclipse.pde.ui.IProjectProvider;
import org.eclipse.pde.ui.templates.AbstractNewPluginTemplateWizard;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;

public class ProjectCodeGeneratorsPage
extends WizardListSelectionPage {
    private Button blankPageRadio;
    private Button noUIRadio;
    private Button templateRadio;
    private Control wizardList;
    private ControlEnableState wizardListEnableState;
    private boolean fragment;
    private IProjectProvider provider;
    private boolean firstTime = true;
    private static final String KEY_TITLE = "NewProjectWizard.ProjectCodeGeneratorsPage.title";
    private static final String KEY_BLANK_LABEL = "NewProjectWizard.ProjectCodeGeneratorsPage.blankLabel";
    private static final String KEY_BLANK_FLABEL = "NewProjectWizard.ProjectCodeGeneratorsPage.blankFLabel";
    private static final String KEY_TEMPLATE_LABEL = "NewProjectWizard.ProjectCodeGeneratorsPage.templateLabel";
    private static final String KEY_TEMPLATE_FLABEL = "NewProjectWizard.ProjectCodeGeneratorsPage.templateFLabel";
    private static final String KEY_NOUI_FLABEL = "NewProjectWizard.ProjectCodeGeneratorsPage.noUIFLabel";
    private static final String KEY_NOUI_LABEL = "NewProjectWizard.ProjectCodeGeneratorsPage.noUILabel";
    private static final String KEY_DESC = "NewProjectWizard.ProjectCodeGeneratorsPage.desc";
    private static final String KEY_FTITLE = "NewProjectWizard.ProjectCodeGeneratorsPage.ftitle";
    private static final String KEY_FDESC = "NewProjectWizard.ProjectCodeGeneratorsPage.fdesc";
    private ProjectStructurePage projectStructurePage;
    private IConfigurationElement config;

    public ProjectCodeGeneratorsPage(IProjectProvider provider, ProjectStructurePage projectStructurePage, ElementList wizardElements, String message, boolean fragment, IConfigurationElement config) {
        super(wizardElements, message);
        this.fragment = fragment;
        this.provider = provider;
        this.projectStructurePage = projectStructurePage;
        this.config = config;
        this.setTitle(PDEPlugin.getResourceString(fragment ? KEY_FTITLE : KEY_TITLE));
        this.setDescription(PDEPlugin.getResourceString(fragment ? KEY_FDESC : KEY_DESC));
    }

    public void createControl(Composite parent) {
        Composite outerContainer = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 9;
        outerContainer.setLayout((Layout)layout);
        this.blankPageRadio = new Button(outerContainer, 16400);
        this.blankPageRadio.setText(PDEPlugin.getResourceString(this.fragment ? KEY_BLANK_FLABEL : KEY_BLANK_LABEL));
        this.blankPageRadio.setSelection(false);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 1;
        gd.grabExcessHorizontalSpace = true;
        this.blankPageRadio.setLayoutData((Object)gd);
        this.blankPageRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectCodeGeneratorsPage.this.setWizardListEnabled(!ProjectCodeGeneratorsPage.this.blankPageRadio.getSelection());
                ProjectCodeGeneratorsPage.this.getContainer().updateButtons();
            }
        });
        this.noUIRadio = new Button(outerContainer, 16400);
        this.noUIRadio.setText(PDEPlugin.getResourceString(this.fragment ? KEY_NOUI_FLABEL : KEY_NOUI_LABEL));
        this.noUIRadio.setSelection(false);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 1;
        gd.grabExcessHorizontalSpace = true;
        this.noUIRadio.setLayoutData((Object)gd);
        this.noUIRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectCodeGeneratorsPage.this.setWizardListEnabled(!ProjectCodeGeneratorsPage.this.noUIRadio.getSelection());
                ProjectCodeGeneratorsPage.this.getContainer().updateButtons();
            }
        });
        this.templateRadio = new Button(outerContainer, 16400);
        this.templateRadio.setText(PDEPlugin.getResourceString(this.fragment ? KEY_TEMPLATE_FLABEL : KEY_TEMPLATE_LABEL));
        this.templateRadio.setSelection(true);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 1;
        gd.grabExcessHorizontalSpace = true;
        this.templateRadio.setLayoutData((Object)gd);
        super.createControl(outerContainer);
        this.wizardList = this.wizardSelectionViewer.getControl();
        gd = new GridData(1808);
        gd.widthHint = 450;
        this.getControl().setLayoutData((Object)gd);
        this.setControl((Control)outerContainer);
        Dialog.applyDialogFont((Control)outerContainer);
        if (this.fragment) {
            WorkbenchHelp.setHelp((Control)outerContainer, (String)"org.eclipse.pde.doc.user.new_fragment_code_gen_page");
        } else {
            WorkbenchHelp.setHelp((Control)outerContainer, (String)"org.eclipse.pde.doc.user.new_project_code_gen_page");
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && this.firstTime) {
            if (this.blankPageRadio.getSelection()) {
                this.blankPageRadio.setFocus();
            } else {
                this.focusAndSelectFirst();
            }
            this.firstTime = false;
        }
    }

    protected IWizardNode createWizardNode(WizardElement element) {
        return new WizardNode(this, element){

            public IBasePluginWizard createWizard() throws CoreException {
                IPluginContentWizard wizard = (IPluginContentWizard)this.wizardElement.createExecutableExtension();
                wizard.init(ProjectCodeGeneratorsPage.this.provider, ProjectCodeGeneratorsPage.this.projectStructurePage.getStructureData(), ProjectCodeGeneratorsPage.this.fragment, ProjectCodeGeneratorsPage.this.config);
                ((AbstractNewPluginTemplateWizard)wizard).setShowTemplatePages(!ProjectCodeGeneratorsPage.this.noUIRadio.getSelection());
                return wizard;
            }
        };
    }

    public boolean finish() {
        if (this.blankPageRadio.getSelection()) {
            if (this.projectStructurePage.getStructureData().getRuntimeLibraryName() != null) {
                this.runJavaSettingsOperation();
            } else {
                this.runSimpleManifestOperation();
            }
        }
        return true;
    }

    public boolean canFlipToNextPage() {
        return !this.blankPageRadio.getSelection();
    }

    public IWizardPage getNextPage() {
        return this.blankPageRadio.getSelection() ? null : super.getNextPage(this.projectStructurePage.isStructureDataChanged());
    }

    public boolean isPageComplete() {
        if (this.blankPageRadio != null && this.blankPageRadio.getSelection()) {
            return true;
        }
        return super.isPageComplete();
    }

    public void runSimpleManifestOperation() {
        final IPluginStructureData structureData = this.projectStructurePage.getStructureData();
        final IProject project = this.provider.getProject();
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void execute(IProgressMonitor monitor) {
                try {
                    try {
                        ProjectCodeGeneratorsPage.this.createBlankManifest(project, structureData, monitor);
                        ProjectStructurePage.createBuildProperties(project, structureData, ProjectCodeGeneratorsPage.this.fragment, monitor);
                    }
                    catch (CoreException e) {
                        PDEPlugin.logException(e);
                    }
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    monitor.done();
                    throw throwable;
                }
                {
                    Object var3_5 = null;
                }
                monitor.done();
            }
        };
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)operation);
        }
        catch (InvocationTargetException e) {
            PDEPlugin.logException(e);
        }
        catch (InterruptedException interruptedException) {}
    }

    private void runJavaSettingsOperation() {
        final IPluginStructureData structureData = this.projectStructurePage.getStructureData();
        final IProject project = this.provider.getProject();
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void execute(IProgressMonitor monitor) {
                try {
                    try {
                        boolean exists = ProjectCodeGeneratorsPage.this.createBlankManifest(project, structureData, monitor);
                        ProjectCodeGeneratorsPage.this.setJavaSettings(project, structureData, !exists, monitor);
                        BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)ProjectCodeGeneratorsPage.this.config);
                    }
                    catch (JavaModelException e) {
                        PDEPlugin.logException(e);
                    }
                    catch (CoreException e) {
                        PDEPlugin.logException(e);
                    }
                }
                catch (Throwable throwable) {
                    Object var3_6 = null;
                    monitor.done();
                    throw throwable;
                }
                {
                    Object var3_7 = null;
                }
                monitor.done();
            }
        };
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)operation);
        }
        catch (InvocationTargetException e) {
            PDEPlugin.logException(e);
        }
        catch (InterruptedException interruptedException) {}
    }

    private void setJavaSettings(IProject project, IPluginStructureData structureData, boolean setBuildpath, IProgressMonitor monitor) throws JavaModelException, CoreException {
        if (!project.exists()) {
            IProjectDescription desc = project.getWorkspace().newProjectDescription(project.getName());
            desc.setLocation(this.provider.getLocationPath());
            project.create(desc, monitor);
            project.open(monitor);
        }
        if (!project.hasNature("org.eclipse.jdt.core.javanature")) {
            CoreUtility.addNatureToProject((IProject)project, (String)"org.eclipse.jdt.core.javanature", (IProgressMonitor)monitor);
        }
        if (!project.hasNature("org.eclipse.pde.PluginNature")) {
            CoreUtility.addNatureToProject((IProject)project, (String)"org.eclipse.pde.PluginNature", (IProgressMonitor)monitor);
        }
        JavaCore.create((IProject)project);
        if (setBuildpath) {
            ClasspathUtil.setClasspath(project, structureData, this.projectStructurePage.getSchemaVersion(), new IClasspathEntry[0], monitor);
        }
    }

    private boolean createBlankManifest(IProject project, IPluginStructureData structureData, IProgressMonitor monitor) throws CoreException {
        IPath path = project.getFullPath().append(this.fragment ? "fragment.xml" : "plugin.xml");
        IFile file = project.getWorkspace().getRoot().getFile(path);
        Object model = null;
        model = this.fragment ? new WorkspaceFragmentModel(file) : new WorkspacePluginModel(file);
        model.load();
        if (!file.exists()) {
            IPluginBase pluginBase = model.getPluginBase();
            pluginBase.setId(structureData.getPluginId());
            pluginBase.setVersion("1.0.0");
            pluginBase.setName(structureData.getPluginId());
            if (structureData.getRuntimeLibraryName() != null) {
                IPluginLibrary library = model.getPluginFactory().createLibrary();
                library.setName(structureData.getRuntimeLibraryName());
                library.setExported(true);
                model.getPluginBase().add(library);
            }
            model.save();
        }
        return !file.exists();
    }

    private void setWizardListEnabled(boolean enabled) {
        if (!enabled) {
            this.wizardListEnableState = ControlEnableState.disable((Control)this.wizardList);
        } else {
            if (this.wizardListEnableState != null) {
                this.wizardListEnableState.restore();
            }
            this.wizardSelectionViewer.getControl().setEnabled(true);
            this.wizardList.setFocus();
        }
    }
}

