/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.project;

import java.util.Vector;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.pde.core.IExternalModelManager;
import org.eclipse.pde.core.IWorkspaceModelManager;
import org.eclipse.pde.core.plugin.IPluginModel;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.elements.DefaultContentProvider;
import org.eclipse.pde.internal.ui.elements.NamedElement;
import org.eclipse.pde.internal.ui.wizards.ListUtil;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.help.WorkbenchHelp;

public class PluginSelectionDialog
extends ElementTreeSelectionDialog {
    private TreeViewer treeViewer;
    private static NamedElement workspacePlugins;
    private static NamedElement externalPlugins;

    public PluginSelectionDialog(Shell parentShell) {
        super(parentShell, (ILabelProvider)PDEPlugin.getDefault().getLabelProvider(), (ITreeContentProvider)new PluginContentProvider());
        this.setTitle(PDEPlugin.getResourceString("PluginSelectionDialog.title"));
        this.setMessage(PDEPlugin.getResourceString("PluginSelectionDialog.message"));
        PDEPlugin.getDefault().getLabelProvider().connect((Object)this);
    }

    public boolean close() {
        PDEPlugin.getDefault().getLabelProvider().disconnect((Object)this);
        return super.close();
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(1808));
        this.createMessageArea(container);
        this.initialize();
        Image pluginsImage = PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_REQ_PLUGINS_OBJ);
        workspacePlugins = new NamedElement(PDEPlugin.getResourceString("PluginSelectionDialog.workspacePlugins"), pluginsImage);
        externalPlugins = new NamedElement(PDEPlugin.getResourceString("PluginSelectionDialog.externalPlugins"), pluginsImage);
        Control tree = this.createTree(container);
        tree.setLayoutData((Object)new GridData(1808));
        WorkbenchHelp.setHelp((Control)container, (String)"org.eclipse.pde.doc.user.fragment_add_target");
        Dialog.applyDialogFont((Control)container);
        return container;
    }

    private void initialize() {
        this.addFilter(new ViewerFilter(){

            public boolean select(Viewer v, Object parent, Object object) {
                if (object instanceof IPluginModel) {
                    return ((IPluginModel)object).isEnabled();
                }
                return true;
            }
        });
        this.setSorter(new ListUtil.PluginSorter(){

            public int category(Object obj) {
                if (obj == workspacePlugins) {
                    return -1;
                }
                if (obj == externalPlugins) {
                    return 1;
                }
                return 0;
            }
        });
        this.setAllowMultiple(false);
        this.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                if (selection != null && selection.length > 0 && selection[0] instanceof IPluginModel) {
                    return new Status(0, PDEPlugin.getPluginId(), 0, ((LabelProvider)PluginSelectionDialog.this.treeViewer.getLabelProvider()).getText(selection[0]), null);
                }
                return new Status(4, PDEPlugin.getPluginId(), 4, "", null);
            }
        });
    }

    private Control createTree(Composite container) {
        this.createTreeViewer(container);
        this.treeViewer = this.getTreeViewer();
        this.treeViewer.setAutoExpandLevel(2);
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                Object item = ((IStructuredSelection)e.getSelection()).getFirstElement();
                if (item instanceof IPluginModel) {
                    PluginSelectionDialog.this.pluginSelected((IPluginModel)item);
                } else {
                    PluginSelectionDialog.this.pluginSelected(null);
                }
            }
        });
        this.treeViewer.setInput((Object)PDEPlugin.getDefault());
        this.treeViewer.reveal((Object)workspacePlugins);
        return this.getTreeViewer().getTree();
    }

    private void pluginSelected(IPluginModel model) {
        if (model != null) {
            Vector<IPluginModel> result = new Vector<IPluginModel>();
            result.add(model);
            this.setResult(result);
        } else {
            this.setResult(null);
        }
    }

    private static class PluginContentProvider
    extends DefaultContentProvider
    implements ITreeContentProvider {
        PluginContentProvider() {
        }

        public boolean hasChildren(Object parent) {
            return !(parent instanceof IPluginModel);
        }

        public Object[] getChildren(Object parent) {
            if (parent == externalPlugins) {
                IExternalModelManager manager = PDECore.getDefault().getExternalModelManager();
                return manager.getPluginModels();
            }
            if (parent == workspacePlugins) {
                IWorkspaceModelManager manager = PDECore.getDefault().getWorkspaceModelManager();
                return manager.getPluginModels();
            }
            return new Object[0];
        }

        public Object getParent(Object child) {
            if (child instanceof IPluginModel) {
                IPluginModel model = (IPluginModel)child;
                if (model.getUnderlyingResource() != null) {
                    return workspacePlugins;
                }
                return externalPlugins;
            }
            return null;
        }

        public Object[] getElements(Object input) {
            return new Object[]{workspacePlugins, externalPlugins};
        }
    }
}

