/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.project;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.elements.ElementList;
import org.eclipse.pde.internal.ui.wizards.NewWizard;
import org.eclipse.pde.internal.ui.wizards.WizardElement;
import org.eclipse.pde.internal.ui.wizards.project.ProjectCodeGeneratorsPage;
import org.eclipse.pde.internal.ui.wizards.project.ProjectStructurePage;
import org.eclipse.pde.ui.IProjectProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;

public class NewProjectWizard
extends NewWizard
implements IExecutableExtension {
    private WizardNewProjectCreationPage mainPage;
    private ProjectStructurePage structurePage;
    private ProjectCodeGeneratorsPage codegenPage;
    private IConfigurationElement config;
    public static final String PLUGIN_POINT = "projectGenerators";
    public static final String TAG_DESCRIPTION = "description";
    public static final String KEY_TITLE = "NewProjectWizard.MainPage.title";
    public static final String KEY_FTITLE = "NewProjectWizard.MainPage.ftitle";
    public static final String KEY_DESC = "NewProjectWizard.MainPage.desc";
    public static final String KEY_FDESC = "NewProjectWizard.MainPage.fdesc";
    public static final String TAG_WIZARD = "wizard";
    public static final String ATT_CATEGORY = "category";
    public static final String KEY_CODEGEN_MESSAGE = "NewProjectWizard.ProjectCodeGeneratorsPage.message";
    private static final String KEY_WTITLE = "NewProjectWizard.title";

    public NewProjectWizard() {
        this.setDefaultPageImageDescriptor(PDEPluginImages.DESC_NEWPPRJ_WIZ);
        this.setDialogSettings(PDEPlugin.getDefault().getDialogSettings());
        this.setWindowTitle(PDEPlugin.getResourceString(KEY_WTITLE));
        this.setNeedsProgressMonitor(true);
        PDEPlugin.getDefault().getLabelProvider().connect((Object)this);
    }

    public void addPages() {
        super.addPages();
        this.mainPage = new WizardNewProjectCreationPage("main");
        if (this.isFragmentWizard()) {
            this.mainPage.setTitle(PDEPlugin.getResourceString(KEY_FTITLE));
            this.mainPage.setDescription(PDEPlugin.getResourceString(KEY_FDESC));
        } else {
            this.mainPage.setTitle(PDEPlugin.getResourceString(KEY_TITLE));
            this.mainPage.setDescription(PDEPlugin.getResourceString(KEY_DESC));
        }
        this.addPage((IWizardPage)this.mainPage);
        IProjectProvider provider = new IProjectProvider(){

            public String getProjectName() {
                return NewProjectWizard.this.mainPage.getProjectName();
            }

            public IProject getProject() {
                return NewProjectWizard.this.mainPage.getProjectHandle();
            }

            public IPath getLocationPath() {
                return NewProjectWizard.this.mainPage.getLocationPath();
            }
        };
        this.structurePage = new ProjectStructurePage(provider, this.isFragmentWizard());
        this.addPage((IWizardPage)this.structurePage);
        this.codegenPage = new ProjectCodeGeneratorsPage(provider, this.structurePage, this.getAvailableCodegenWizards(), PDEPlugin.getResourceString(KEY_CODEGEN_MESSAGE), this.isFragmentWizard(), this.config);
        this.addPage((IWizardPage)this.codegenPage);
    }

    public boolean canFinish() {
        IWizardPage page = this.getContainer().getCurrentPage();
        if (page == this.mainPage) {
            return false;
        }
        if (page == this.structurePage && page.getNextPage() == null && page.isPageComplete()) {
            return true;
        }
        return super.canFinish();
    }

    protected WizardElement createWizardElement(IConfigurationElement config) {
        String name = config.getAttribute("name");
        String id = config.getAttribute("id");
        String className = config.getAttribute("class");
        if (name == null || id == null || className == null) {
            return null;
        }
        WizardElement element = new WizardElement(config);
        String imageName = config.getAttribute("icon");
        if (imageName != null) {
            IPluginDescriptor pd = config.getDeclaringExtension().getDeclaringPluginDescriptor();
            Image image = PDEPlugin.getDefault().getLabelProvider().getImageFromPlugin(pd, imageName);
            element.setImage(image);
        }
        return element;
    }

    public void dispose() {
        super.dispose();
        PDEPlugin.getDefault().getLabelProvider().disconnect((Object)this);
    }

    public ElementList getAvailableCodegenWizards() {
        ElementList wizards = new ElementList("CodegenWizards");
        IPluginRegistry registry = Platform.getPluginRegistry();
        IExtensionPoint point = registry.getExtensionPoint(PDEPlugin.getPluginId(), PLUGIN_POINT);
        if (point == null) {
            return wizards;
        }
        IExtension[] extensions = point.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                WizardElement element;
                if (elements[j].getName().equals(TAG_WIZARD) && (element = this.createWizardElement(elements[j])) != null) {
                    boolean fragmentWizard;
                    String categoryAtt = element.getConfigurationElement().getAttribute(ATT_CATEGORY);
                    boolean bl = fragmentWizard = categoryAtt != null && categoryAtt.equalsIgnoreCase("fragment");
                    if ((fragmentWizard || categoryAtt == null) && fragmentWizard == this.isFragmentWizard()) {
                        wizards.add(element);
                    }
                }
                ++j;
            }
            ++i;
        }
        return wizards;
    }

    public boolean isFragmentWizard() {
        return false;
    }

    public boolean performFinish() {
        if (this.structurePage.finish()) {
            boolean hasCodegen;
            boolean bl = hasCodegen = this.structurePage.getNextPage() != null;
            if (!hasCodegen || this.codegenPage.finish()) {
                this.revealSelection(this.mainPage.getProjectHandle());
                return true;
            }
        }
        return false;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.config = config;
    }
}

