/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.project;

import java.util.Vector;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.elements.DefaultContentProvider;
import org.eclipse.pde.internal.ui.parts.WizardCheckboxTablePart;
import org.eclipse.pde.internal.ui.wizards.ListUtil;
import org.eclipse.pde.internal.ui.wizards.StatusWizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.update.ui.forms.internal.FormWidgetFactory;

public class MigratePluginWizardPage
extends StatusWizardPage {
    private IPluginModelBase[] fSelected;
    private CheckboxTableViewer fPluginListViewer;
    private TablePart fTablePart;
    private Button fUpdateClasspathButton;
    private String S_UPDATE_CLASSATH = "updateClasspath";

    public MigratePluginWizardPage(IPluginModelBase[] selected) {
        super("MigrateWizardPage", true);
        this.setTitle(PDEPlugin.getResourceString("MigrationWizard.title"));
        this.setDescription(PDEPlugin.getResourceString("MigrationWizardPage.desc"));
        this.fSelected = selected;
        this.fTablePart = new TablePart(PDEPlugin.getResourceString("MigrationWizardPage.label"));
        PDEPlugin.getDefault().getLabelProvider().connect((Object)this);
    }

    public void dispose() {
        super.dispose();
        PDEPlugin.getDefault().getLabelProvider().disconnect((Object)this);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 5;
        layout.verticalSpacing = 10;
        container.setLayout((Layout)layout);
        this.fTablePart.createControl(container);
        this.fPluginListViewer = this.fTablePart.getTableViewer();
        this.fPluginListViewer.setContentProvider((IContentProvider)new ContentProvider());
        this.fPluginListViewer.setLabelProvider((IBaseLabelProvider)PDEPlugin.getDefault().getLabelProvider());
        GridData gd = (GridData)this.fTablePart.getControl().getLayoutData();
        gd.heightHint = 300;
        gd.widthHint = 300;
        this.fPluginListViewer.setInput((Object)PDEPlugin.getDefault());
        this.fTablePart.setSelection(this.fSelected);
        this.fUpdateClasspathButton = new Button(container, 32);
        this.fUpdateClasspathButton.setText(PDEPlugin.getResourceString("MigrationWizard.update"));
        gd = new GridData(256);
        gd.horizontalSpan = 2;
        this.fUpdateClasspathButton.setLayoutData((Object)gd);
        this.fUpdateClasspathButton.setSelection(this.getDialogSettings().getBoolean(this.S_UPDATE_CLASSATH));
        this.setControl((Control)container);
        Dialog.applyDialogFont((Control)container);
    }

    public IPluginModelBase[] getSelected() {
        Object[] objects = this.fTablePart.getSelection();
        IPluginModelBase[] models = new IPluginModelBase[objects.length];
        System.arraycopy(objects, 0, models, 0, objects.length);
        return models;
    }

    private void dialogChanged() {
        this.setPageComplete(this.fTablePart.getSelectionCount() > 0);
    }

    public boolean isPageComplete() {
        return this.fTablePart.getSelectionCount() > 0;
    }

    private Object[] getModels() {
        Vector<IPluginModelBase> result = new Vector<IPluginModelBase>();
        IPluginModelBase[] models = PDECore.getDefault().getWorkspaceModelManager().getAllModels();
        int i = 0;
        while (i < models.length) {
            if (!models[i].getUnderlyingResource().isLinked() && models[i].isLoaded() && models[i].getPluginBase().getSchemaVersion() == null) {
                result.add(models[i]);
            }
            ++i;
        }
        return result.toArray();
    }

    public void storeSettings() {
        IDialogSettings settings = this.getDialogSettings();
        settings.put(this.S_UPDATE_CLASSATH, this.fUpdateClasspathButton.getSelection());
    }

    public boolean isUpdateClasspathRequested() {
        return this.fUpdateClasspathButton.getSelection();
    }

    public class ContentProvider
    extends DefaultContentProvider
    implements IStructuredContentProvider {
        public Object[] getElements(Object parent) {
            return MigratePluginWizardPage.this.getModels();
        }
    }

    class TablePart
    extends WizardCheckboxTablePart {
        public TablePart(String mainLabel) {
            super(mainLabel);
        }

        public void updateCounter(int count) {
            super.updateCounter(count);
            MigratePluginWizardPage.this.dialogChanged();
        }

        protected StructuredViewer createStructuredViewer(Composite parent, int style, FormWidgetFactory factory) {
            StructuredViewer viewer = super.createStructuredViewer(parent, style, factory);
            viewer.setSorter(ListUtil.PLUGIN_SORTER);
            return viewer;
        }
    }
}

