/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.project;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.wizards.imports.UpdateClasspathAction;
import org.eclipse.pde.internal.ui.wizards.project.ExtensionPointMappings;
import org.eclipse.pde.internal.ui.wizards.project.MigratePluginWizardPage;

public class MigratePluginWizard
extends Wizard {
    private MigratePluginWizardPage page1;
    private IPluginModelBase[] selected;
    private static final String STORE_SECTION = "MigrationWizard";

    public MigratePluginWizard(IPluginModelBase[] selected) {
        IDialogSettings masterSettings = PDEPlugin.getDefault().getDialogSettings();
        this.setDialogSettings(this.getSettingsSection(masterSettings));
        this.setDefaultPageImageDescriptor(PDEPluginImages.DESC_MIGRATE_30_WIZ);
        this.setWindowTitle(PDEPlugin.getResourceString("MigrationWizard.title"));
        this.setNeedsProgressMonitor(true);
        this.selected = selected;
    }

    public boolean performFinish() {
        final IPluginModelBase[] models = this.page1.getSelected();
        this.page1.storeSettings();
        final boolean doUpdateClasspath = this.page1.isUpdateClasspathRequested();
        IRunnableWithProgress operation = new IRunnableWithProgress(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                int numUnits = doUpdateClasspath ? models.length * 2 : models.length;
                monitor.beginTask(PDEPlugin.getResourceString("MigrationWizard.progress"), numUnits);
                try {
                    try {
                        int i = 0;
                        while (true) {
                            block7: {
                                if (i < models.length) break block7;
                                if (doUpdateClasspath) {
                                    UpdateClasspathAction.doUpdateClasspath((IProgressMonitor)new SubProgressMonitor(monitor, models.length), models);
                                }
                                break;
                            }
                            monitor.subTask(models[i].getPluginBase().getId());
                            MigratePluginWizard.this.transform(models[i]);
                            models[i].getUnderlyingResource().refreshLocal(0, null);
                            monitor.worked(1);
                            ++i;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    monitor.done();
                    throw throwable;
                }
                {
                    Object var4_7 = null;
                }
                monitor.done();
            }
        };
        try {
            this.getContainer().run(true, false, operation);
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException interruptedException) {}
        return true;
    }

    private IDialogSettings getSettingsSection(IDialogSettings master) {
        IDialogSettings setting = master.getSection(STORE_SECTION);
        if (setting == null) {
            setting = master.addNewSection(STORE_SECTION);
        }
        return setting;
    }

    public void addPages() {
        this.page1 = new MigratePluginWizardPage(this.selected);
        this.addPage((IWizardPage)this.page1);
    }

    private void transform(IPluginModelBase model) throws Exception {
        IResource file = model.getUnderlyingResource();
        IDocument document = this.createDocument(file);
        FindReplaceDocumentAdapter findAdapter = new FindReplaceDocumentAdapter(document);
        this.addEclipseProcessingInstruction(document, findAdapter);
        this.updateExtensions(document, findAdapter);
        this.addNewImports(document, findAdapter, this.getAdditionalImports(model));
        this.writeFile(document, file);
    }

    private IDocument createDocument(IResource file) throws Exception {
        BufferedReader reader = new BufferedReader(new FileReader(file.getLocation().toOSString()));
        StringBuffer buffer = new StringBuffer();
        while (reader.ready()) {
            buffer.append((char)reader.read());
        }
        reader.close();
        return new Document(buffer.toString());
    }

    private void writeFile(IDocument document, IResource file) throws Exception {
        PrintWriter writer = new PrintWriter(new FileWriter(file.getLocation().toOSString()));
        writer.write(document.get());
        writer.close();
    }

    private void addEclipseProcessingInstruction(IDocument document, FindReplaceDocumentAdapter adapter) {
        try {
            IRegion region = adapter.search(-1, "<\\?xml.*\\?>", true, true, false, true);
            if (region != null) {
                String text = document.get(region.getOffset(), region.getLength());
                adapter.replace(String.valueOf(text) + System.getProperty("line.separator") + "<?eclipse version=\"3.0\"?>", false);
            }
        }
        catch (BadLocationException badLocationException) {}
    }

    private void updateExtensions(IDocument document, FindReplaceDocumentAdapter adapter) {
        int start = 0;
        while (true) {
            try {
                String point;
                IRegion region = this.findNextExtension(adapter, start);
                if (region == null) break;
                IRegion idRegion = this.findPointAttributeRegion(adapter, region);
                if (idRegion != null && ExtensionPointMappings.isDeprecated((point = document.get(idRegion.getOffset(), idRegion.getLength())).trim())) {
                    adapter.replace(ExtensionPointMappings.getNewId(point.trim()), false);
                }
                start = region.getOffset() + region.getLength();
            }
            catch (BadLocationException badLocationException) {}
        }
    }

    private IRegion findPointAttributeRegion(FindReplaceDocumentAdapter adapter, IRegion parentRegion) {
        try {
            IRegion region = adapter.search(parentRegion.getOffset(), "\\s+point\\s*=\\s*\"", true, true, false, true);
            if (region != null && region.getOffset() + region.getLength() <= parentRegion.getOffset() + parentRegion.getLength() && (region = adapter.search(region.getOffset() + region.getLength(), "[^\"]*", true, true, false, true)) != null && region.getOffset() + region.getLength() < parentRegion.getOffset() + parentRegion.getLength()) {
                return region;
            }
        }
        catch (BadLocationException badLocationException) {}
        return null;
    }

    private IRegion findNextExtension(FindReplaceDocumentAdapter adapter, int start) {
        int offset = -1;
        int length = -1;
        try {
            IRegion region = adapter.search(start, "<extension\\s+", true, true, false, true);
            if (region != null && (region = adapter.search(offset = region.getOffset(), ">", true, true, false, false)) != null) {
                length = region.getOffset() - offset + 1;
            }
        }
        catch (BadLocationException badLocationException) {}
        return offset != -1 && length != -1 ? new Region(offset, length) : null;
    }

    private String[] getAdditionalImports(IPluginModelBase model) {
        ArrayList<String> result = new ArrayList<String>();
        result.add("org.eclipse.core.runtime.compatibility");
        IPluginImport uiImport = this.findImport(model, "org.eclipse.ui");
        if (uiImport != null) {
            ArrayList<String> list = new ArrayList<String>();
            list.add("org.eclipse.ui.ide");
            list.add("org.eclipse.ui.views");
            list.add("org.eclipse.jface.text");
            list.add("org.eclipse.ui.workbench.texteditor");
            list.add("org.eclipse.ui.editors");
            IPluginImport[] imports = model.getPluginBase().getImports();
            int i = 0;
            while (i < imports.length) {
                if (list.contains(imports[i].getId())) {
                    list.remove(imports[i].getId());
                }
                ++i;
            }
            i = 0;
            while (i < list.size()) {
                StringBuffer buffer = new StringBuffer("<import plugin=\"");
                buffer.append(list.get(i) + "\"");
                if (uiImport.isReexported()) {
                    buffer.append(" export=\"true\"");
                }
                if (uiImport.isOptional()) {
                    buffer.append(" optional=\"true\"");
                }
                buffer.append("/>");
                result.add(buffer.toString());
                ++i;
            }
        } else if (this.needsAdditionalUIImport(model)) {
            result.add("<import plugin=\"org.eclipse.ui\"/>");
        }
        if (this.needsHelpBaseImport(model)) {
            result.add("<import plugin=\"org.eclipse.help.base\"/>");
        }
        return result.toArray(new String[result.size()]);
    }

    private void addNewImports(IDocument document, FindReplaceDocumentAdapter adapter, String[] imports) {
        try {
            IRegion spacerRegion;
            if (imports.length == 0) {
                return;
            }
            String space = "";
            IRegion requiresRegion = adapter.search(0, "<requires>", true, false, false, false);
            if (requiresRegion != null && (spacerRegion = adapter.search(requiresRegion.getOffset() + requiresRegion.getLength(), "\\s*", true, true, false, true)) != null) {
                space = document.get(spacerRegion.getOffset(), spacerRegion.getLength());
            }
            StringBuffer buffer = new StringBuffer(space);
            int i = 0;
            while (i < imports.length) {
                buffer.append(String.valueOf(imports[i]) + space);
                ++i;
            }
            adapter.replace(buffer.toString(), false);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    private boolean needsAdditionalUIImport(IPluginModelBase model) {
        IPluginExtension[] extensions = model.getPluginBase().getExtensions();
        int i = 0;
        while (i < extensions.length) {
            if (ExtensionPointMappings.hasMovedFromHelpToUI(extensions[i].getPoint()) && this.findImport(model, "org.eclipse.ui") == null) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean needsHelpBaseImport(IPluginModelBase model) {
        IPluginExtension[] extensions = model.getPluginBase().getExtensions();
        int i = 0;
        while (i < extensions.length) {
            if (ExtensionPointMappings.hasMovedFromHelpToBase(extensions[i].getPoint()) && this.findImport(model, "org.eclipse.help.base") == null) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private IPluginImport findImport(IPluginModelBase model, String importID) {
        IPluginImport[] imports = model.getPluginBase().getImports();
        int i = 0;
        while (i < imports.length) {
            if (imports[i].getId().equals(importID)) {
                return imports[i];
            }
            ++i;
        }
        return null;
    }
}

