/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.imports;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.pde.core.plugin.IPluginLibrary;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.TargetPlatform;
import org.eclipse.pde.internal.ui.wizards.imports.UpdateClasspathAction;

public class UpdateClasspathOperation
implements IRunnableWithProgress {
    private IPluginModelBase[] models;

    public UpdateClasspathOperation(IPluginModelBase[] models) {
        this.models = models;
    }

    private static IPath getSourceAttachmentPath(IProject project, IPath jarPath) {
        IPath sourcePath = UpdateClasspathOperation.getSourcePath(jarPath);
        if (sourcePath == null) {
            return null;
        }
        IWorkspaceRoot root = project.getWorkspace().getRoot();
        if (root.findMember(sourcePath) != null) {
            return sourcePath;
        }
        return null;
    }

    static IPath getExpandedPath(IPath path) {
        String first = path.segment(0);
        if (first != null) {
            IPath rest = path.removeFirstSegments(1);
            if (first.equals("$ws$")) {
                path = new Path("ws").append(TargetPlatform.getWS()).append(rest);
            } else if (first.equals("$os$")) {
                path = new Path("os").append(TargetPlatform.getOS()).append(rest);
            } else if (first.equals("$nl$")) {
                path = new Path("nl").append(TargetPlatform.getNL()).append(rest);
            } else if (first.equals("$arch$")) {
                path = new Path("arch").append(TargetPlatform.getOSArch()).append(rest);
            }
        }
        return path;
    }

    static IPath getSourcePath(IPath jarPath) {
        int idx;
        String libName = (jarPath = UpdateClasspathOperation.getExpandedPath(jarPath)).lastSegment();
        if (libName != null && (idx = libName.lastIndexOf(46)) != -1) {
            String srcName = String.valueOf(libName.substring(0, idx)) + "src.zip";
            IPath path = jarPath.removeLastSegments(1).append(srcName);
            return path;
        }
        return null;
    }

    private static IPath getLibraryPath(IProject project, String libraryName) {
        Path path = new Path(libraryName);
        path = UpdateClasspathOperation.getExpandedPath((IPath)path);
        return project.getFullPath().append((IPath)path);
    }

    public static IClasspathEntry getLibraryEntry(IProject project, IPluginLibrary library, boolean exported) {
        return UpdateClasspathOperation.getLibraryEntry(project, library.getName(), exported);
    }

    private static IClasspathEntry getLibraryEntry(IProject project, String libraryName, boolean exported) {
        IPath jarPath = UpdateClasspathOperation.getLibraryPath(project, libraryName);
        IPath srcAttach = UpdateClasspathOperation.getSourceAttachmentPath(project, jarPath);
        Path srcRoot = srcAttach != null ? Path.EMPTY : null;
        return JavaCore.newLibraryEntry((IPath)jarPath, (IPath)srcAttach, (IPath)srcRoot, (boolean)exported);
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            UpdateClasspathAction.doUpdateClasspath(monitor, this.models);
        }
        catch (CoreException coreException) {}
    }
}

