/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.imports;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.WorkspaceModelManager;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.elements.DefaultContentProvider;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.pde.internal.ui.wizards.ListUtil;
import org.eclipse.pde.internal.ui.wizards.imports.BaseImportWizardSecondPage;
import org.eclipse.pde.internal.ui.wizards.imports.PluginImportWizardFirstPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class PluginImportWizardDetailedPage
extends BaseImportWizardSecondPage {
    private Label countLabel;
    private TableViewer availableListViewer;

    public PluginImportWizardDetailedPage(String pageName, PluginImportWizardFirstPage firstPage) {
        super(pageName, firstPage);
        this.setTitle(PDEPlugin.getResourceString("ImportWizard.DetailedPage.title"));
        this.setMessage(PDEPlugin.getResourceString("ImportWizard.DetailedPage.desc"));
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.horizontalSpacing = 5;
        layout.verticalSpacing = 10;
        container.setLayout((Layout)layout);
        this.createAvailableList(container).setLayoutData((Object)new GridData(1808));
        this.createButtonArea(container);
        this.createImportList(container).setLayoutData((Object)new GridData(1808));
        this.updateCount();
        Composite options = this.createComputationsOption(container);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 3;
        options.setLayoutData((Object)gd);
        this.addViewerListeners();
        this.setPageComplete(false);
        this.setControl((Control)container);
        Dialog.applyDialogFont((Control)container);
    }

    private void addViewerListeners() {
        this.availableListViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                PluginImportWizardDetailedPage.this.handleAdd();
            }
        });
        this.importListViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                PluginImportWizardDetailedPage.this.handleRemove();
            }
        });
    }

    private Composite createAvailableList(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(1808));
        Label label = new Label(container, 0);
        label.setText(PDEPlugin.getResourceString("ImportWizard.DetailedPage.availableList"));
        Table table = new Table(container, 2562);
        GridData gd = new GridData(1808);
        gd.widthHint = 180;
        gd.heightHint = 250;
        table.setLayoutData((Object)gd);
        this.availableListViewer = new TableViewer(table);
        this.availableListViewer.setLabelProvider((IBaseLabelProvider)PDEPlugin.getDefault().getLabelProvider());
        this.availableListViewer.setContentProvider((IContentProvider)new ContentProvider());
        this.availableListViewer.setInput((Object)PDECore.getDefault().getExternalModelManager());
        this.availableListViewer.setSorter(ListUtil.PLUGIN_SORTER);
        return container;
    }

    private Composite createButtonArea(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        comp.setLayout((Layout)layout);
        comp.setLayoutData((Object)new GridData(1040));
        Composite container = new Composite(comp, 0);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 30;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(1808));
        Button button = new Button(container, 8);
        button.setText(PDEPlugin.getResourceString("ImportWizard.DetailedPage.existing"));
        button.setLayoutData((Object)new GridData(768));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PluginImportWizardDetailedPage.this.handleExistingProjects();
            }
        });
        SWTUtil.setButtonDimensionHint(button);
        button = new Button(container, 8);
        button.setText(PDEPlugin.getResourceString("ImportWizard.DetailedPage.existingUnshared"));
        button.setLayoutData((Object)new GridData(768));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PluginImportWizardDetailedPage.this.handleExistingUnshared();
            }
        });
        SWTUtil.setButtonDimensionHint(button);
        new Label(container, 0);
        button = new Button(container, 8);
        button.setText(PDEPlugin.getResourceString("ImportWizard.DetailedPage.add"));
        button.setLayoutData((Object)new GridData(768));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PluginImportWizardDetailedPage.this.handleAdd();
            }
        });
        SWTUtil.setButtonDimensionHint(button);
        button = new Button(container, 8);
        button.setText(PDEPlugin.getResourceString("ImportWizard.DetailedPage.addAll"));
        button.setLayoutData((Object)new GridData(768));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PluginImportWizardDetailedPage.this.handleAddAll();
            }
        });
        SWTUtil.setButtonDimensionHint(button);
        button = new Button(container, 8);
        button.setText(PDEPlugin.getResourceString("ImportWizard.DetailedPage.remove"));
        button.setLayoutData((Object)new GridData(768));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PluginImportWizardDetailedPage.this.handleRemove();
            }
        });
        SWTUtil.setButtonDimensionHint(button);
        button = new Button(container, 8);
        button.setText(PDEPlugin.getResourceString("ImportWizard.DetailedPage.removeAll"));
        button.setLayoutData((Object)new GridData(768));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PluginImportWizardDetailedPage.this.handleRemoveAll();
            }
        });
        SWTUtil.setButtonDimensionHint(button);
        button = new Button(container, 8);
        button.setText(PDEPlugin.getResourceString("ImportWizard.DetailedPage.swap"));
        button.setLayoutData((Object)new GridData(768));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PluginImportWizardDetailedPage.this.handleSwap();
            }
        });
        SWTUtil.setButtonDimensionHint(button);
        button = new Button(container, 8);
        button.setText(PDEPlugin.getResourceString("ImportWizard.DetailedPage.addRequired"));
        button.setLayoutData((Object)new GridData(768));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PluginImportWizardDetailedPage.this.handleAddRequiredPlugins();
            }
        });
        SWTUtil.setButtonDimensionHint(button);
        this.countLabel = new Label(comp, 0);
        this.countLabel.setLayoutData((Object)new GridData(64));
        return container;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.setPageComplete(visible && this.importListViewer.getTable().getItemCount() > 0);
    }

    protected void refreshPage() {
        this.availableListViewer.refresh();
        this.importListViewer.getTable().removeAll();
        this.pageChanged();
    }

    protected void pageChanged() {
        this.updateCount();
        this.setPageComplete(this.importListViewer.getTable().getItemCount() > 0);
    }

    private void updateCount() {
        this.countLabel.setText(PDEPlugin.getFormattedMessage("ImportWizard.DetailedPage.count", new String[]{new Integer(this.importListViewer.getTable().getItemCount()).toString(), new Integer(this.models.length).toString()}));
        this.countLabel.getParent().layout();
    }

    private void handleAdd() {
        IStructuredSelection ssel = (IStructuredSelection)this.availableListViewer.getSelection();
        if (ssel.size() > 0) {
            Table table = this.availableListViewer.getTable();
            int index = table.getSelectionIndices()[0];
            this.availableListViewer.remove(ssel.toArray());
            this.importListViewer.add(ssel.toArray());
            table.setSelection(index < table.getItemCount() ? index : table.getItemCount() - 1);
            this.pageChanged();
        }
    }

    private void handleAddAll() {
        TableItem[] items = this.availableListViewer.getTable().getItems();
        ArrayList<Object> data = new ArrayList<Object>();
        int i = 0;
        while (i < items.length) {
            data.add(items[i].getData());
            ++i;
        }
        if (data.size() > 0) {
            this.importListViewer.add(data.toArray());
            this.availableListViewer.remove(data.toArray());
            this.pageChanged();
        }
    }

    private void handleRemove() {
        IStructuredSelection ssel = (IStructuredSelection)this.importListViewer.getSelection();
        if (ssel.size() > 0) {
            Table table = this.importListViewer.getTable();
            int index = table.getSelectionIndices()[0];
            this.importListViewer.remove(ssel.toArray());
            this.availableListViewer.add(ssel.toArray());
            table.setSelection(index < table.getItemCount() ? index : table.getItemCount() - 1);
            this.pageChanged();
        }
    }

    private void handleRemoveAll() {
        this.handleRemoveAll(true);
    }

    private void handleRemoveAll(boolean refresh) {
        TableItem[] items = this.importListViewer.getTable().getItems();
        ArrayList<Object> data = new ArrayList<Object>();
        int i = 0;
        while (i < items.length) {
            data.add(items[i].getData());
            ++i;
        }
        if (data.size() > 0) {
            this.availableListViewer.add(data.toArray());
            this.importListViewer.remove(data.toArray());
            this.pageChanged();
        }
    }

    private void handleSwap() {
        TableItem[] aItems = this.availableListViewer.getTable().getItems();
        TableItem[] iItems = this.importListViewer.getTable().getItems();
        ArrayList<Object> data = new ArrayList<Object>();
        int i = 0;
        while (i < iItems.length) {
            data.add(iItems[i].getData());
            ++i;
        }
        if (data.size() > 0) {
            this.availableListViewer.add(data.toArray());
            this.importListViewer.remove(data.toArray());
        }
        data.clear();
        i = 0;
        while (i < aItems.length) {
            data.add(aItems[i].getData());
            ++i;
        }
        if (data.size() > 0) {
            this.importListViewer.add(data.toArray());
            this.availableListViewer.remove(data.toArray());
        }
        this.pageChanged();
    }

    private void handleExistingProjects() {
        this.handleRemoveAll(false);
        ArrayList<IPluginModelBase> result = new ArrayList<IPluginModelBase>();
        int i = 0;
        while (i < this.models.length) {
            String id = this.models[i].getPluginBase().getId();
            IProject project = (IProject)PDEPlugin.getWorkspace().getRoot().findMember(id);
            if (project != null && project.isOpen() && WorkspaceModelManager.isPluginProject((IProject)project)) {
                result.add(this.models[i]);
            }
            ++i;
        }
        if (result.size() > 0) {
            this.importListViewer.add(result.toArray());
            this.availableListViewer.remove(result.toArray());
        }
        this.pageChanged();
    }

    private void handleExistingUnshared() {
        this.handleRemoveAll(false);
        ArrayList<IPluginModelBase> result = new ArrayList<IPluginModelBase>();
        int i = 0;
        while (i < this.models.length) {
            String id = this.models[i].getPluginBase().getId();
            IProject project = (IProject)PDEPlugin.getWorkspace().getRoot().findMember(id);
            if (project != null && project.isOpen() && WorkspaceModelManager.isUnsharedPluginProject((IProject)project)) {
                result.add(this.models[i]);
            }
            ++i;
        }
        if (result.size() > 0) {
            this.importListViewer.add(result.toArray());
            this.availableListViewer.remove(result.toArray());
        }
        this.pageChanged();
    }

    private void handleAddRequiredPlugins() {
        IPluginModelBase model;
        TableItem[] items = this.importListViewer.getTable().getItems();
        if (items.length == 0) {
            return;
        }
        if (items.length == 1 && (model = (IPluginModelBase)items[0].getData()).getPluginBase().getId().equals("org.eclipse.core.boot")) {
            return;
        }
        ArrayList result = new ArrayList();
        int i = 0;
        while (i < items.length) {
            this.addPluginAndDependencies((IPluginModelBase)items[i].getData(), result, this.addFragmentsButton.getSelection());
            ++i;
        }
        this.handleRemoveAll(false);
        this.importListViewer.add(result.toArray());
        this.availableListViewer.remove(result.toArray());
        this.pageChanged();
    }

    class ContentProvider
    extends DefaultContentProvider
    implements IStructuredContentProvider {
        ContentProvider() {
        }

        public Object[] getElements(Object element) {
            return PluginImportWizardDetailedPage.this.models;
        }
    }
}

