/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.imports;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.pde.core.build.IBuild;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.core.plugin.IFragment;
import org.eclipse.pde.core.plugin.IFragmentModel;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginLibrary;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.ModelEntry;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PluginModelManager;
import org.eclipse.pde.internal.core.SourceLocationManager;
import org.eclipse.pde.internal.core.build.WorkspaceBuildModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.wizards.imports.UpdateClasspathOperation;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.wizards.datatransfer.FileSystemStructureProvider;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;
import org.eclipse.ui.wizards.datatransfer.ZipFileStructureProvider;

public class PluginImportOperation
implements IWorkspaceRunnable {
    public static final int IMPORT_BINARY = 1;
    public static final int IMPORT_BINARY_WITH_LINKS = 2;
    public static final int IMPORT_WITH_SOURCE = 3;
    private IPluginModelBase[] fModels;
    private ArrayList fModelIds;
    private int fImportType;
    private IReplaceQuery fReplaceQuery;

    public PluginImportOperation(IPluginModelBase[] models, ArrayList modelIds, int importType, IReplaceQuery replaceQuery) {
        this.fModels = models;
        this.fModelIds = modelIds;
        this.fImportType = importType;
        this.fReplaceQuery = replaceQuery;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(PDEPlugin.getResourceString("ImportWizard.operation.creating"), this.fModels.length);
        try {
            MultiStatus multiStatus = new MultiStatus(PDEPlugin.getPluginId(), 0, PDEPlugin.getResourceString("ImportWizard.operation.multiProblem"), null);
            int i = 0;
            while (true) {
                if (i >= this.fModels.length) {
                    if (multiStatus.isOK()) break;
                    throw new CoreException((IStatus)multiStatus);
                }
                try {
                    this.importPlugin(this.fModels[i], (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                }
                catch (CoreException e) {
                    multiStatus.merge(e.getStatus());
                }
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        monitor.done();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void importPlugin(IPluginModelBase model, IProgressMonitor monitor) throws CoreException {
        block13: {
            block12: {
                String id = model.getPluginBase().getId();
                String task = PDEPlugin.getFormattedMessage("ImportWizard.operation.creating2", id);
                monitor.beginTask(task, 6);
                try {
                    IProject project = this.findProject(model.getPluginBase().getId());
                    if (project.exists()) {
                        if (!this.queryReplace(project)) {
                            Object var6_6 = null;
                            break block12;
                        }
                        this.deleteProject(project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    }
                    this.createProject(project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    switch (this.fImportType) {
                        case 1: {
                            this.importAsBinary(project, model, (IProgressMonitor)new SubProgressMonitor(monitor, 4));
                            break;
                        }
                        case 2: {
                            this.importAsBinaryWithLinks(project, model, (IProgressMonitor)new SubProgressMonitor(monitor, 4));
                            break;
                        }
                        case 3: {
                            if (id.equals("org.apache.ant") || id.startsWith("org.eclipse.osgi")) {
                                this.importAsBinary(project, model, (IProgressMonitor)new SubProgressMonitor(monitor, 4));
                                break;
                            }
                            this.importWithSource(project, model, (IProgressMonitor)new SubProgressMonitor(monitor, 4));
                            break;
                        }
                    }
                    this.setProjectDescription(project, model);
                    if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                        this.resetClasspath(project, model);
                    }
                    break block13;
                }
                catch (Throwable throwable) {
                    Object var6_7 = null;
                    monitor.done();
                    throw throwable;
                }
            }
            monitor.done();
            return;
        }
        Object var6_8 = null;
        monitor.done();
    }

    private IProject findProject(String id) {
        IPluginModelBase model;
        PluginModelManager manager = PDECore.getDefault().getModelManager();
        ModelEntry entry = manager.findEntry(id);
        if (entry != null && (model = entry.getWorkspaceModel()) != null) {
            return model.getUnderlyingResource().getProject();
        }
        return PDEPlugin.getWorkspace().getRoot().getProject(id);
    }

    private void deleteProject(IProject project, IProgressMonitor monitor) throws CoreException {
        project.delete(true, true, monitor);
        try {
            RepositoryProvider.unmap((IProject)project);
        }
        catch (TeamException teamException) {}
    }

    private void createProject(IProject project, IProgressMonitor monitor) throws CoreException {
        project.create(monitor);
        if (!project.isOpen()) {
            project.open(null);
        }
    }

    private void importAsBinary(IProject project, IPluginModelBase model, IProgressMonitor monitor) throws CoreException {
        this.importPluginContent(project, model, monitor);
        project.setPersistentProperty(PDECore.EXTERNAL_PROJECT_PROPERTY, "binary");
    }

    private void importAsBinaryWithLinks(IProject project, IPluginModelBase model, IProgressMonitor monitor) throws CoreException {
        File[] items = new File(model.getInstallLocation()).listFiles();
        monitor.beginTask("Linking content...", items.length);
        int i = 0;
        while (i < items.length) {
            File sourceFile = items[i];
            if (sourceFile.isDirectory()) {
                IFolder folder = project.getFolder(sourceFile.getName());
                folder.createLink((IPath)new Path(sourceFile.getPath()), 0, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            } else {
                String fileName = sourceFile.getName();
                if (!fileName.equals(".classpath") && !fileName.equals(".project")) {
                    IFile file = project.getFile(fileName);
                    file.createLink((IPath)new Path(sourceFile.getPath()), 0, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                }
            }
            ++i;
        }
        try {
            RepositoryProvider.map((IProject)project, (String)"org.eclipse.pde.core.BinaryRepositoryProvider");
        }
        catch (TeamException teamException) {}
    }

    private void importWithSource(IProject project, IPluginModelBase model, IProgressMonitor monitor) throws CoreException {
        IFragment swtFragment;
        monitor.beginTask("", 3);
        this.importPluginContent(project, model, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
        boolean isSWTPlugin = model.getPluginBase().getId().equals("org.eclipse.swt");
        if (isSWTPlugin && (swtFragment = this.getSWTFragment(model)) != null) {
            String libraryName = model.getPluginBase().getLibraries()[0].getName();
            this.importSWTJar(project, swtFragment, libraryName);
            this.importSWTSource(project, swtFragment, libraryName);
        }
        WorkspaceBuildModel buildModel = this.configureBinIncludes(project, model);
        IPluginLibrary[] libraries = model.getPluginBase().getLibraries();
        boolean sourceFound = false;
        int i = 0;
        while (i < libraries.length) {
            IPath libraryPath = UpdateClasspathOperation.getExpandedPath((IPath)new Path(libraries[i].getName()));
            IResource jarFile = project.findMember(libraryPath);
            if (jarFile != null) {
                IPath srcPath = UpdateClasspathOperation.getSourcePath(libraryPath);
                IResource srcZip = jarFile.getProject().findMember(srcPath);
                if (srcZip != null) {
                    String jarName = libraryPath.removeFileExtension().lastSegment();
                    IFolder dest = jarFile.getProject().getFolder("src-" + jarName);
                    IBuildEntry entry = buildModel.getFactory().createEntry("source." + libraries[i].getName());
                    entry.addToken(String.valueOf(dest.getName()) + "/");
                    buildModel.getBuild().add(entry);
                    if (!dest.exists()) {
                        dest.create(true, true, null);
                    }
                    this.extractZipFile(srcZip, dest, monitor);
                    this.extractResources(jarFile, dest, monitor);
                    srcZip.delete(true, null);
                    jarFile.delete(true, null);
                    sourceFound = true;
                }
            }
            ++i;
        }
        buildModel.save();
        if (!sourceFound) {
            project.setPersistentProperty(PDECore.EXTERNAL_PROJECT_PROPERTY, "binary");
        }
        monitor.done();
    }

    private WorkspaceBuildModel configureBinIncludes(IProject project, IPluginModelBase model) {
        WorkspaceBuildModel buildModel = new WorkspaceBuildModel(project.getFile("build.properties"));
        IBuild build = buildModel.getBuild(true);
        IBuildEntry entry = buildModel.getFactory().createEntry("bin.includes");
        File[] files = new File(model.getInstallLocation()).listFiles();
        try {
            int i = 0;
            while (i < files.length) {
                String token = files[i].getName();
                if (files[i].isDirectory()) {
                    token = String.valueOf(token) + "/";
                }
                entry.addToken(token);
                ++i;
            }
            build.add(entry);
            buildModel.save();
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
        return buildModel;
    }

    private void importPluginContent(IProject project, IPluginModelBase model, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("", 2);
        this.importContent(new File(model.getInstallLocation()), project.getFullPath(), (IImportStructureProvider)FileSystemStructureProvider.INSTANCE, null, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        this.importSource(project, model.getPluginBase(), (IPath)new Path(model.getInstallLocation()), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
    }

    private void importContent(Object source, IPath destPath, IImportStructureProvider provider, List filesToImport, IProgressMonitor monitor) throws CoreException {
        IOverwriteQuery query = new IOverwriteQuery(){

            public String queryOverwrite(String file) {
                return "ALL";
            }
        };
        ImportOperation op = new ImportOperation(destPath, source, provider, query);
        op.setCreateContainerStructure(false);
        if (filesToImport != null) {
            op.setFilesToImport(filesToImport);
        }
        try {
            op.run(monitor);
        }
        catch (InvocationTargetException e) {
            Status status = new Status(4, PDEPlugin.getPluginId(), 4, e.getMessage(), (Throwable)e);
            throw new CoreException((IStatus)status);
        }
        catch (InterruptedException e) {
            throw new OperationCanceledException(e.getMessage());
        }
    }

    private void importSource(IProject project, IPluginBase plugin, IPath pluginPath, IProgressMonitor monitor) throws CoreException {
        SourceLocationManager manager = PDECore.getDefault().getSourceLocationManager();
        IPluginLibrary[] libraries = plugin.getLibraries();
        monitor.beginTask(PDEPlugin.getResourceString("ImportWizard.operation.copyingSource"), libraries.length);
        int i = 0;
        while (i < libraries.length) {
            File srcZip;
            Path libPath = new Path(libraries[i].getName());
            IPath srcPath = UpdateClasspathOperation.getSourcePath((IPath)libPath);
            if (srcPath != null && !project.getFile(srcPath).exists() && (srcZip = manager.findSourceFile(plugin, srcPath)) != null) {
                this.importArchive(project, srcZip, srcPath);
            }
            monitor.worked(1);
            ++i;
        }
    }

    private void importArchive(IProject project, File archive, IPath destPath) throws CoreException {
        try {
            if (destPath.segmentCount() > 2) {
                int i = 1;
                while (i < destPath.segmentCount()) {
                    IFolder folder = project.getFolder(destPath.uptoSegment(i));
                    if (!folder.exists()) {
                        folder.create(true, true, null);
                    }
                    ++i;
                }
            }
            IFile file = project.getFile(destPath);
            FileInputStream fstream = new FileInputStream(archive);
            if (file.exists()) {
                file.setContents((InputStream)fstream, true, false, null);
            } else {
                file.create((InputStream)fstream, true, null);
            }
            fstream.close();
        }
        catch (IOException e) {
            Status status = new Status(4, PDEPlugin.getPluginId(), 0, e.getMessage(), (Throwable)e);
            throw new CoreException((IStatus)status);
        }
    }

    /*
     * Exception decompiling
     */
    private void extractZipFile(IResource res, IFolder dest, IProgressMonitor monitor) throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 115->119)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private void extractResources(IResource res, IFolder dest, IProgressMonitor monitor) throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 138->142)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void collectResources(ZipFileStructureProvider provider, Object element, ArrayList collected) {
        List children = provider.getChildren(element);
        if (children != null && !children.isEmpty()) {
            int i = 0;
            while (i < children.size()) {
                Object curr = children.get(i);
                if (provider.isFolder(curr)) {
                    if (!provider.getLabel(curr).equals("META-INF")) {
                        this.collectResources(provider, curr, collected);
                    }
                } else if (!provider.getLabel(curr).endsWith(".class")) {
                    collected.add(curr);
                }
                ++i;
            }
        }
    }

    private boolean queryReplace(IProject project) throws OperationCanceledException {
        switch (this.fReplaceQuery.doQuery(project)) {
            case 0: {
                throw new OperationCanceledException();
            }
            case 1: {
                return false;
            }
        }
        return true;
    }

    private void setProjectDescription(IProject project, IPluginModelBase model) throws CoreException {
        IProjectDescription desc = project.getDescription();
        if (this.needsJavaNature(project, model)) {
            desc.setNatureIds(new String[]{"org.eclipse.jdt.core.javanature", "org.eclipse.pde.PluginNature"});
        } else {
            desc.setNatureIds(new String[]{"org.eclipse.pde.PluginNature"});
        }
        project.setDescription(desc, null);
    }

    private void resetClasspath(IProject project, IPluginModelBase model) throws JavaModelException {
        IJavaProject jProject = JavaCore.create((IProject)project);
        jProject.setRawClasspath(new IClasspathEntry[0], jProject.getOutputLocation(), null);
        this.fModelIds.add(model.getPluginBase().getId());
    }

    private boolean needsJavaNature(IProject project, IPluginModelBase model) {
        boolean isJavaProject;
        boolean bl = isJavaProject = model.getPluginBase().getLibraries().length > 0;
        if (!isJavaProject) {
            IPluginImport[] imports = model.getPluginBase().getImports();
            int i = 0;
            while (i < imports.length) {
                if (imports[i].isReexported()) {
                    isJavaProject = true;
                    break;
                }
                ++i;
            }
        }
        return isJavaProject;
    }

    private IFragment getSWTFragment(IPluginModelBase model) {
        int i = 0;
        while (i < this.fModels.length) {
            if (this.fModels[i] instanceof IFragmentModel) {
                IFragment fragment = ((IFragmentModel)this.fModels[i]).getFragment();
                if (PDECore.compare((String)model.getPluginBase().getId(), (String)model.getPluginBase().getVersion(), (String)fragment.getPluginId(), (String)fragment.getVersion(), (int)fragment.getRule()) && fragment.getLibraries().length == 0) {
                    return fragment;
                }
            }
            ++i;
        }
        return null;
    }

    private void importSWTJar(IProject project, IFragment fragment, String name) throws CoreException {
        IPath jarPath = UpdateClasspathOperation.getExpandedPath((IPath)new Path(name));
        File swtJar = new File(fragment.getModel().getInstallLocation(), jarPath.toString());
        if (swtJar.exists()) {
            this.importArchive(project, swtJar, jarPath);
        }
    }

    private void importSWTSource(IProject project, IFragment fragment, String name) throws CoreException {
        IPath jarPath = UpdateClasspathOperation.getExpandedPath((IPath)new Path(name));
        IPath srcPath = UpdateClasspathOperation.getSourcePath(jarPath);
        SourceLocationManager manager = PDECore.getDefault().getSourceLocationManager();
        File srcFile = manager.findSourceFile((IPluginBase)fragment, srcPath);
        if (srcFile != null) {
            this.importArchive(project, srcFile, srcPath);
        }
    }

    public interface IReplaceQuery {
        public static final int CANCEL = 0;
        public static final int NO = 1;
        public static final int YES = 2;

        public int doQuery(IProject var1);
    }
}

